/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Strings;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Preconditions {
    private Preconditions() {
    }

    private static String badElementIndex(int n2, int n3, @NullableDecl String charSequence) {
        if (n2 < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", charSequence, n2);
        }
        if (n3 >= 0) {
            return Strings.lenientFormat("%s (%s) must be less than size (%s)", charSequence, n2, n3);
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("negative size: ");
        ((StringBuilder)charSequence).append(n3);
        throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
    }

    private static String badPositionIndex(int n2, int n3, @NullableDecl String charSequence) {
        if (n2 < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", charSequence, n2);
        }
        if (n3 >= 0) {
            return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", charSequence, n2, n3);
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("negative size: ");
        ((StringBuilder)charSequence).append(n3);
        throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
    }

    private static String badPositionIndexes(int n2, int n3, int n4) {
        if (n2 >= 0 && n2 <= n4) {
            if (n3 >= 0 && n3 <= n4) {
                return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", n3, n2);
            }
            return Preconditions.badPositionIndex(n3, n4, "end index");
        }
        return Preconditions.badPositionIndex(n2, n4, "start index");
    }

    public static void checkArgument(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void checkArgument(boolean bl, @NullableDecl Object object) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, char c2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, Character.valueOf(c2)));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, char c2, char c3) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, Character.valueOf(c2), Character.valueOf(c3)));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, char c2, int n2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, Character.valueOf(c2), n2));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, char c2, long l2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, Character.valueOf(c2), l2));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, char c2, @NullableDecl Object object) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, Character.valueOf(c2), object));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, int n2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, n2));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, int n2, char c2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, n2, Character.valueOf(c2)));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, int n2, int n3) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, n2, n3));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, int n2, long l2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, n2, l2));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, int n2, @NullableDecl Object object) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, n2, object));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, long l2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, l2));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, long l2, char c2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, l2, Character.valueOf(c2)));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, long l2, int n2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, l2, n2));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, long l2, long l3) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, l2, l3));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, long l2, @NullableDecl Object object) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, l2, object));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, object));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, char c2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, object, Character.valueOf(c2)));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, int n2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, object, n2));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, long l2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, object, l2));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, object, object2));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, object, object2, object3));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3, @NullableDecl Object object4) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, object, object2, object3, object4));
    }

    public static void checkArgument(boolean bl, @NullableDecl String string2, Object ... objectArray) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(Strings.lenientFormat(string2, objectArray));
    }

    public static int checkElementIndex(int n2, int n3) {
        return Preconditions.checkElementIndex(n2, n3, "index");
    }

    public static int checkElementIndex(int n2, int n3, @NullableDecl String string2) {
        if (n2 >= 0 && n2 < n3) {
            return n2;
        }
        throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n2, n3, string2));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException();
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl Object object) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(String.valueOf(object));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, char c2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, Character.valueOf(c2)));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, char c2, char c3) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, Character.valueOf(c2), Character.valueOf(c3)));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, char c2, int n2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, Character.valueOf(c2), n2));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, char c2, long l2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, Character.valueOf(c2), l2));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, char c2, @NullableDecl Object object) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, Character.valueOf(c2), object));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, int n2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, n2));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, int n2, char c2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, n2, Character.valueOf(c2)));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, int n2, int n3) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, n2, n3));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, int n2, long l2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, n2, l2));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, int n2, @NullableDecl Object object) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, n2, object));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, long l2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, l2));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, long l2, char c2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, l2, Character.valueOf(c2)));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, long l2, int n2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, l2, n2));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, long l2, long l3) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, l2, l3));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, long l2, @NullableDecl Object object) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, l2, object));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, object));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, char c2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, object, Character.valueOf(c2)));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, int n2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, object, n2));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, long l2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, object, l2));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, object, object2));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, object, object2, object3));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3, @NullableDecl Object object4) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, object, object2, object3, object4));
    }

    @NonNullDecl
    public static <T> T checkNotNull(@NonNullDecl T t2, @NullableDecl String string2, Object ... objectArray) {
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException(Strings.lenientFormat(string2, objectArray));
    }

    public static int checkPositionIndex(int n2, int n3) {
        return Preconditions.checkPositionIndex(n2, n3, "index");
    }

    public static int checkPositionIndex(int n2, int n3, @NullableDecl String string2) {
        if (n2 >= 0 && n2 <= n3) {
            return n2;
        }
        throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(n2, n3, string2));
    }

    public static void checkPositionIndexes(int n2, int n3, int n4) {
        if (n2 >= 0 && n3 >= n2 && n3 <= n4) {
            return;
        }
        throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n2, n3, n4));
    }

    public static void checkState(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalStateException();
    }

    public static void checkState(boolean bl, @NullableDecl Object object) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(String.valueOf(object));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, char c2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, Character.valueOf(c2)));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, char c2, char c3) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, Character.valueOf(c2), Character.valueOf(c3)));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, char c2, int n2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, Character.valueOf(c2), n2));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, char c2, long l2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, Character.valueOf(c2), l2));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, char c2, @NullableDecl Object object) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, Character.valueOf(c2), object));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, int n2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, n2));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, int n2, char c2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, n2, Character.valueOf(c2)));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, int n2, int n3) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, n2, n3));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, int n2, long l2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, n2, l2));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, int n2, @NullableDecl Object object) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, n2, object));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, long l2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, l2));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, long l2, char c2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, l2, Character.valueOf(c2)));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, long l2, int n2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, l2, n2));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, long l2, long l3) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, l2, l3));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, long l2, @NullableDecl Object object) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, l2, object));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, object));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, char c2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, object, Character.valueOf(c2)));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, int n2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, object, n2));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, long l2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, object, l2));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, object, object2));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, object, object2, object3));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, @NullableDecl Object object, @NullableDecl Object object2, @NullableDecl Object object3, @NullableDecl Object object4) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, object, object2, object3, object4));
    }

    public static void checkState(boolean bl, @NullableDecl String string2, Object ... objectArray) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(Strings.lenientFormat(string2, objectArray));
    }
}

