/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.CharMatcher;
import com.google.common.base.CommonPattern;
import com.google.common.base.Enums;
import com.google.common.base.JdkPattern;
import com.google.common.base.Optional;
import com.google.common.base.PatternCompiler;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class Platform {
    private static final Logger logger = Logger.getLogger(Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    private Platform() {
    }

    static CommonPattern compilePattern(String string2) {
        Preconditions.checkNotNull(string2);
        return patternCompiler.compile(string2);
    }

    static String emptyToNull(@NullableDecl String string2) {
        String string3 = string2;
        if (Platform.stringIsNullOrEmpty(string2)) {
            string3 = null;
        }
        return string3;
    }

    static String formatCompact4Digits(double d2) {
        return String.format(Locale.ROOT, "%.4g", d2);
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> serializable, String weakReference) {
        weakReference = Enums.getEnumConstants(serializable).get(weakReference);
        serializable = weakReference == null ? Optional.absent() : Optional.of(serializable.cast(weakReference.get()));
        return serializable;
    }

    private static PatternCompiler loadPatternCompiler() {
        return new JdkPatternCompiler();
    }

    private static void logPatternCompilerError(ServiceConfigurationError serviceConfigurationError) {
        logger.log(Level.WARNING, "Error loading regex compiler, falling back to next option", serviceConfigurationError);
    }

    static String nullToEmpty(@NullableDecl String string2) {
        String string3 = string2;
        if (string2 == null) {
            string3 = "";
        }
        return string3;
    }

    static boolean patternCompilerIsPcreLike() {
        return patternCompiler.isPcreLike();
    }

    static CharMatcher precomputeCharMatcher(CharMatcher charMatcher) {
        return charMatcher.precomputedInternal();
    }

    static boolean stringIsNullOrEmpty(@NullableDecl String string2) {
        boolean bl = string2 == null || string2.isEmpty();
        return bl;
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    private static final class JdkPatternCompiler
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }

        public CommonPattern compile(String string2) {
            return new JdkPattern(Pattern.compile(string2));
        }

        public boolean isPcreLike() {
            return true;
        }
    }
}

