/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class MoreObjects {
    private MoreObjects() {
    }

    public static <T> T firstNonNull(@NullableDecl T t2, @NullableDecl T t3) {
        if (t2 != null) {
            return t2;
        }
        if (t3 != null) {
            return t3;
        }
        throw new NullPointerException("Both parameters are null");
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(clazz.getSimpleName());
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(object.getClass().getSimpleName());
    }

    public static ToStringHelper toStringHelper(String string2) {
        return new ToStringHelper(string2);
    }

    public static final class ToStringHelper {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;

        private ToStringHelper(String string2) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.className = Preconditions.checkNotNull(string2);
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail.next = valueHolder = new ValueHolder();
            this.holderTail = valueHolder;
            return valueHolder;
        }

        private ToStringHelper addHolder(@NullableDecl Object object) {
            this.addHolder().value = object;
            return this;
        }

        private ToStringHelper addHolder(String string2, @NullableDecl Object object) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = object;
            valueHolder.name = Preconditions.checkNotNull(string2);
            return this;
        }

        public ToStringHelper add(String string2, char c2) {
            return this.addHolder(string2, String.valueOf(c2));
        }

        public ToStringHelper add(String string2, double d2) {
            return this.addHolder(string2, String.valueOf(d2));
        }

        public ToStringHelper add(String string2, float f2) {
            return this.addHolder(string2, String.valueOf(f2));
        }

        public ToStringHelper add(String string2, int n2) {
            return this.addHolder(string2, String.valueOf(n2));
        }

        public ToStringHelper add(String string2, long l2) {
            return this.addHolder(string2, String.valueOf(l2));
        }

        public ToStringHelper add(String string2, @NullableDecl Object object) {
            return this.addHolder(string2, object);
        }

        public ToStringHelper add(String string2, boolean bl) {
            return this.addHolder(string2, String.valueOf(bl));
        }

        public ToStringHelper addValue(char c2) {
            return this.addHolder(String.valueOf(c2));
        }

        public ToStringHelper addValue(double d2) {
            return this.addHolder(String.valueOf(d2));
        }

        public ToStringHelper addValue(float f2) {
            return this.addHolder(String.valueOf(f2));
        }

        public ToStringHelper addValue(int n2) {
            return this.addHolder(String.valueOf(n2));
        }

        public ToStringHelper addValue(long l2) {
            return this.addHolder(String.valueOf(l2));
        }

        public ToStringHelper addValue(@NullableDecl Object object) {
            return this.addHolder(object);
        }

        public ToStringHelper addValue(boolean bl) {
            return this.addHolder(String.valueOf(bl));
        }

        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        public String toString() {
            boolean bl = this.omitNullValues;
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append(this.className);
            stringBuilder.append('{');
            ValueHolder valueHolder = this.holderHead.next;
            String string2 = "";
            while (valueHolder != null) {
                String string3;
                block8: {
                    Object object;
                    block7: {
                        object = valueHolder.value;
                        if (!bl) break block7;
                        string3 = string2;
                        if (object == null) break block8;
                    }
                    stringBuilder.append(string2);
                    if (valueHolder.name != null) {
                        stringBuilder.append(valueHolder.name);
                        stringBuilder.append('=');
                    }
                    if (object != null && object.getClass().isArray()) {
                        string3 = Arrays.deepToString(new Object[]{object});
                        stringBuilder.append(string3, 1, string3.length() - 1);
                    } else {
                        stringBuilder.append(object);
                    }
                    string3 = ", ";
                }
                valueHolder = valueHolder.next;
                string2 = string3;
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        private static final class ValueHolder {
            @NullableDecl
            String name;
            @NullableDecl
            ValueHolder next;
            @NullableDecl
            Object value;

            private ValueHolder() {
            }
        }
    }
}

