/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class Joiner {
    private final String separator;

    private Joiner(Joiner joiner) {
        this.separator = joiner.separator;
    }

    private Joiner(String string2) {
        this.separator = Preconditions.checkNotNull(string2);
    }

    private static Iterable<Object> iterable(final Object object, final Object object2, final Object[] objectArray) {
        Preconditions.checkNotNull(objectArray);
        return new AbstractList<Object>(){

            @Override
            public Object get(int n2) {
                if (n2 != 0) {
                    if (n2 != 1) {
                        return objectArray[n2 - 2];
                    }
                    return object2;
                }
                return object;
            }

            @Override
            public int size() {
                return objectArray.length + 2;
            }
        };
    }

    public static Joiner on(char c2) {
        return new Joiner(String.valueOf(c2));
    }

    public static Joiner on(String string2) {
        return new Joiner(string2);
    }

    public <A extends Appendable> A appendTo(A a2, Iterable<?> iterable) throws IOException {
        return this.appendTo(a2, iterable.iterator());
    }

    public final <A extends Appendable> A appendTo(A a2, @NullableDecl Object object, @NullableDecl Object object2, Object ... objectArray) throws IOException {
        return this.appendTo(a2, Joiner.iterable(object, object2, objectArray));
    }

    public <A extends Appendable> A appendTo(A a2, Iterator<?> iterator2) throws IOException {
        Preconditions.checkNotNull(a2);
        if (iterator2.hasNext()) {
            a2.append(this.toString(iterator2.next()));
            while (iterator2.hasNext()) {
                a2.append(this.separator);
                a2.append(this.toString(iterator2.next()));
            }
        }
        return a2;
    }

    public final <A extends Appendable> A appendTo(A a2, Object[] objectArray) throws IOException {
        return this.appendTo(a2, Arrays.asList(objectArray));
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Iterable<?> iterable) {
        return this.appendTo(stringBuilder, iterable.iterator());
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, @NullableDecl Object object, @NullableDecl Object object2, Object ... objectArray) {
        return this.appendTo(stringBuilder, Joiner.iterable(object, object2, objectArray));
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Iterator<?> iterator2) {
        try {
            this.appendTo((Appendable)stringBuilder, iterator2);
            return stringBuilder;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Object[] objectArray) {
        return this.appendTo(stringBuilder, (Iterable<?>)Arrays.asList(objectArray));
    }

    public final String join(Iterable<?> iterable) {
        return this.join(iterable.iterator());
    }

    public final String join(@NullableDecl Object object, @NullableDecl Object object2, Object ... objectArray) {
        return this.join(Joiner.iterable(object, object2, objectArray));
    }

    public final String join(Iterator<?> iterator2) {
        return this.appendTo(new StringBuilder(), iterator2).toString();
    }

    public final String join(Object[] objectArray) {
        return this.join(Arrays.asList(objectArray));
    }

    public Joiner skipNulls() {
        return new Joiner(this){

            @Override
            public <A extends Appendable> A appendTo(A a2, Iterator<?> iterator2) throws IOException {
                Object obj;
                Preconditions.checkNotNull(a2, "appendable");
                Preconditions.checkNotNull(iterator2, "parts");
                while (iterator2.hasNext()) {
                    obj = iterator2.next();
                    if (obj == null) continue;
                    a2.append(Joiner.this.toString(obj));
                    break;
                }
                while (iterator2.hasNext()) {
                    obj = iterator2.next();
                    if (obj == null) continue;
                    a2.append(Joiner.this.separator);
                    a2.append(Joiner.this.toString(obj));
                }
                return a2;
            }

            @Override
            public Joiner useForNull(String string2) {
                throw new UnsupportedOperationException("already specified skipNulls");
            }

            @Override
            public MapJoiner withKeyValueSeparator(String string2) {
                throw new UnsupportedOperationException("can't use .skipNulls() with maps");
            }
        };
    }

    CharSequence toString(Object object) {
        Preconditions.checkNotNull(object);
        object = object instanceof CharSequence ? (CharSequence)object : object.toString();
        return object;
    }

    public Joiner useForNull(final String string2) {
        Preconditions.checkNotNull(string2);
        return new Joiner(this){

            @Override
            public Joiner skipNulls() {
                throw new UnsupportedOperationException("already specified useForNull");
            }

            @Override
            CharSequence toString(@NullableDecl Object object) {
                object = object == null ? string2 : Joiner.this.toString(object);
                return object;
            }

            @Override
            public Joiner useForNull(String string22) {
                throw new UnsupportedOperationException("already specified useForNull");
            }
        };
    }

    public MapJoiner withKeyValueSeparator(char c2) {
        return this.withKeyValueSeparator(String.valueOf(c2));
    }

    public MapJoiner withKeyValueSeparator(String string2) {
        return new MapJoiner(this, string2);
    }

    public static final class MapJoiner {
        private final Joiner joiner;
        private final String keyValueSeparator;

        private MapJoiner(Joiner joiner, String string2) {
            this.joiner = joiner;
            this.keyValueSeparator = Preconditions.checkNotNull(string2);
        }

        public <A extends Appendable> A appendTo(A a2, Iterable<? extends Map.Entry<?, ?>> iterable) throws IOException {
            return this.appendTo(a2, iterable.iterator());
        }

        public <A extends Appendable> A appendTo(A a2, Iterator<? extends Map.Entry<?, ?>> iterator2) throws IOException {
            Preconditions.checkNotNull(a2);
            if (iterator2.hasNext()) {
                Map.Entry<?, ?> entry = iterator2.next();
                a2.append(this.joiner.toString(entry.getKey()));
                a2.append(this.keyValueSeparator);
                a2.append(this.joiner.toString(entry.getValue()));
                while (iterator2.hasNext()) {
                    a2.append(this.joiner.separator);
                    entry = iterator2.next();
                    a2.append(this.joiner.toString(entry.getKey()));
                    a2.append(this.keyValueSeparator);
                    a2.append(this.joiner.toString(entry.getValue()));
                }
            }
            return a2;
        }

        public <A extends Appendable> A appendTo(A a2, Map<?, ?> map) throws IOException {
            return this.appendTo(a2, map.entrySet());
        }

        public StringBuilder appendTo(StringBuilder stringBuilder, Iterable<? extends Map.Entry<?, ?>> iterable) {
            return this.appendTo(stringBuilder, iterable.iterator());
        }

        public StringBuilder appendTo(StringBuilder stringBuilder, Iterator<? extends Map.Entry<?, ?>> iterator2) {
            try {
                this.appendTo((Appendable)stringBuilder, iterator2);
                return stringBuilder;
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        public StringBuilder appendTo(StringBuilder stringBuilder, Map<?, ?> map) {
            return this.appendTo(stringBuilder, (Iterable<? extends Map.Entry<?, ?>>)map.entrySet());
        }

        public String join(Iterable<? extends Map.Entry<?, ?>> iterable) {
            return this.join(iterable.iterator());
        }

        public String join(Iterator<? extends Map.Entry<?, ?>> iterator2) {
            return this.appendTo(new StringBuilder(), iterator2).toString();
        }

        public String join(Map<?, ?> map) {
            return this.join(map.entrySet());
        }

        public MapJoiner useForNull(String string2) {
            return new MapJoiner(this.joiner.useForNull(string2), this.keyValueSeparator);
        }
    }
}

