/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Converter;
import com.google.common.base.Optional;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Enums {
    private static final Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> enumConstantCache = new WeakHashMap();

    private Enums() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T extends Enum<T>> Map<String, WeakReference<? extends Enum<?>>> getEnumConstants(Class<T> clazz) {
        Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> map = enumConstantCache;
        synchronized (map) {
            Map<String, WeakReference<Enum<?>>> map2;
            Map<String, WeakReference<Enum<?>>> map3 = map2 = enumConstantCache.get(clazz);
            if (map2 != null) return map3;
            return Enums.populateCache(clazz);
        }
    }

    public static Field getField(Enum<?> object) {
        Class<?> clazz = ((Enum)object).getDeclaringClass();
        try {
            object = clazz.getDeclaredField(((Enum)object).name());
            return object;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError((Object)noSuchFieldException);
        }
    }

    public static <T extends Enum<T>> Optional<T> getIfPresent(Class<T> clazz, String string2) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(string2);
        return Platform.getEnumIfPresent(clazz, string2);
    }

    private static <T extends Enum<T>> Map<String, WeakReference<? extends Enum<?>>> populateCache(Class<T> clazz) {
        HashMap hashMap = new HashMap();
        for (Enum enum_ : EnumSet.allOf(clazz)) {
            hashMap.put(enum_.name(), new WeakReference<Enum>(enum_));
        }
        enumConstantCache.put(clazz, hashMap);
        return hashMap;
    }

    public static <T extends Enum<T>> Converter<String, T> stringConverter(Class<T> clazz) {
        return new StringConverter<T>(clazz);
    }

    private static final class StringConverter<T extends Enum<T>>
    extends Converter<String, T>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Class<T> enumClass;

        StringConverter(Class<T> clazz) {
            this.enumClass = Preconditions.checkNotNull(clazz);
        }

        @Override
        protected String doBackward(T t2) {
            return ((Enum)t2).name();
        }

        @Override
        protected T doForward(String string2) {
            return Enum.valueOf(this.enumClass, string2);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof StringConverter) {
                object = (StringConverter)object;
                return this.enumClass.equals(((StringConverter)object).enumClass);
            }
            return false;
        }

        public int hashCode() {
            return this.enumClass.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Enums.stringConverter(");
            stringBuilder.append(this.enumClass.getName());
            stringBuilder.append(".class)");
            return stringBuilder.toString();
        }
    }
}

