/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.Iterator;
import org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class Converter<A, B>
implements Function<A, B> {
    private final boolean handleNullAutomatically;
    @LazyInit
    @MonotonicNonNullDecl
    private transient Converter<B, A> reverse;

    protected Converter() {
        this(true);
    }

    Converter(boolean bl) {
        this.handleNullAutomatically = bl;
    }

    public static <A, B> Converter<A, B> from(Function<? super A, ? extends B> function, Function<? super B, ? extends A> function2) {
        return new FunctionBasedConverter(function, function2);
    }

    public static <T> Converter<T, T> identity() {
        return IdentityConverter.INSTANCE;
    }

    public final <C> Converter<A, C> andThen(Converter<B, C> converter) {
        return this.doAndThen(converter);
    }

    @Override
    @Deprecated
    @NullableDecl
    public final B apply(@NullableDecl A a2) {
        return this.convert(a2);
    }

    @NullableDecl
    public final B convert(@NullableDecl A a2) {
        return this.correctedDoForward(a2);
    }

    public Iterable<B> convertAll(final Iterable<? extends A> iterable) {
        Preconditions.checkNotNull(iterable, "fromIterable");
        return new Iterable<B>(){

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(){
                    private final Iterator<? extends A> fromIterator;
                    {
                        this.fromIterator = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.fromIterator.hasNext();
                    }

                    @Override
                    public B next() {
                        return Converter.this.convert(this.fromIterator.next());
                    }

                    @Override
                    public void remove() {
                        this.fromIterator.remove();
                    }
                };
            }
        };
    }

    @NullableDecl
    A correctedDoBackward(@NullableDecl B object) {
        if (this.handleNullAutomatically) {
            object = object == null ? null : Preconditions.checkNotNull(this.doBackward(object));
            return (A)object;
        }
        return this.doBackward(object);
    }

    @NullableDecl
    B correctedDoForward(@NullableDecl A object) {
        if (this.handleNullAutomatically) {
            object = object == null ? null : Preconditions.checkNotNull(this.doForward(object));
            return (B)object;
        }
        return this.doForward(object);
    }

    <C> Converter<A, C> doAndThen(Converter<B, C> converter) {
        return new ConverterComposition(this, Preconditions.checkNotNull(converter));
    }

    protected abstract A doBackward(B var1);

    protected abstract B doForward(A var1);

    @Override
    public boolean equals(@NullableDecl Object object) {
        return super.equals(object);
    }

    public Converter<B, A> reverse() {
        Converter<A, B> converter;
        Converter<A, B> converter2 = converter = this.reverse;
        if (converter == null) {
            converter2 = new ReverseConverter(this);
            this.reverse = converter2;
        }
        return converter2;
    }

    private static final class ConverterComposition<A, B, C>
    extends Converter<A, C>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Converter<A, B> first;
        final Converter<B, C> second;

        ConverterComposition(Converter<A, B> converter, Converter<B, C> converter2) {
            this.first = converter;
            this.second = converter2;
        }

        @Override
        @NullableDecl
        A correctedDoBackward(@NullableDecl C c2) {
            return this.first.correctedDoBackward(this.second.correctedDoBackward(c2));
        }

        @Override
        @NullableDecl
        C correctedDoForward(@NullableDecl A a2) {
            return this.second.correctedDoForward(this.first.correctedDoForward(a2));
        }

        @Override
        protected A doBackward(C c2) {
            throw new AssertionError();
        }

        @Override
        protected C doForward(A a2) {
            throw new AssertionError();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof ConverterComposition;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (ConverterComposition)object;
                bl3 = bl;
                if (this.first.equals(((ConverterComposition)object).first)) {
                    bl3 = bl;
                    if (this.second.equals(((ConverterComposition)object).second)) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.first.hashCode() * 31 + this.second.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.first);
            stringBuilder.append(".andThen(");
            stringBuilder.append(this.second);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static final class FunctionBasedConverter<A, B>
    extends Converter<A, B>
    implements Serializable {
        private final Function<? super B, ? extends A> backwardFunction;
        private final Function<? super A, ? extends B> forwardFunction;

        private FunctionBasedConverter(Function<? super A, ? extends B> function, Function<? super B, ? extends A> function2) {
            this.forwardFunction = Preconditions.checkNotNull(function);
            this.backwardFunction = Preconditions.checkNotNull(function2);
        }

        @Override
        protected A doBackward(B b2) {
            return this.backwardFunction.apply(b2);
        }

        @Override
        protected B doForward(A a2) {
            return this.forwardFunction.apply(a2);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof FunctionBasedConverter;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (FunctionBasedConverter)object;
                bl3 = bl;
                if (this.forwardFunction.equals(((FunctionBasedConverter)object).forwardFunction)) {
                    bl3 = bl;
                    if (this.backwardFunction.equals(((FunctionBasedConverter)object).backwardFunction)) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.forwardFunction.hashCode() * 31 + this.backwardFunction.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Converter.from(");
            stringBuilder.append(this.forwardFunction);
            stringBuilder.append(", ");
            stringBuilder.append(this.backwardFunction);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static final class IdentityConverter<T>
    extends Converter<T, T>
    implements Serializable {
        static final IdentityConverter INSTANCE = new IdentityConverter();
        private static final long serialVersionUID = 0L;

        private IdentityConverter() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        <S> Converter<T, S> doAndThen(Converter<T, S> converter) {
            return Preconditions.checkNotNull(converter, "otherConverter");
        }

        @Override
        protected T doBackward(T t2) {
            return t2;
        }

        @Override
        protected T doForward(T t2) {
            return t2;
        }

        public IdentityConverter<T> reverse() {
            return this;
        }

        public String toString() {
            return "Converter.identity()";
        }
    }

    private static final class ReverseConverter<A, B>
    extends Converter<B, A>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Converter<A, B> original;

        ReverseConverter(Converter<A, B> converter) {
            this.original = converter;
        }

        @Override
        @NullableDecl
        B correctedDoBackward(@NullableDecl A a2) {
            return this.original.correctedDoForward(a2);
        }

        @Override
        @NullableDecl
        A correctedDoForward(@NullableDecl B b2) {
            return this.original.correctedDoBackward(b2);
        }

        @Override
        protected B doBackward(A a2) {
            throw new AssertionError();
        }

        @Override
        protected A doForward(B b2) {
            throw new AssertionError();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof ReverseConverter) {
                object = (ReverseConverter)object;
                return this.original.equals(((ReverseConverter)object).original);
            }
            return false;
        }

        public int hashCode() {
            return ~this.original.hashCode();
        }

        @Override
        public Converter<A, B> reverse() {
            return this.original;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.original);
            stringBuilder.append(".reverse()");
            return stringBuilder.toString();
        }
    }
}

