/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.SmallCharMatcher;
import java.util.Arrays;
import java.util.BitSet;

public abstract class CharMatcher
implements Predicate<Character> {
    private static final int DISTINCT_CHARS = 65536;

    protected CharMatcher() {
    }

    public static CharMatcher any() {
        return Any.INSTANCE;
    }

    public static CharMatcher anyOf(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return new AnyOf(charSequence);
                }
                return CharMatcher.isEither(charSequence.charAt(0), charSequence.charAt(1));
            }
            return CharMatcher.is(charSequence.charAt(0));
        }
        return CharMatcher.none();
    }

    public static CharMatcher ascii() {
        return Ascii.INSTANCE;
    }

    public static CharMatcher breakingWhitespace() {
        return BreakingWhitespace.INSTANCE;
    }

    @Deprecated
    public static CharMatcher digit() {
        return Digit.INSTANCE;
    }

    private String finishCollapseFrom(CharSequence charSequence, int n2, int n3, char c2, StringBuilder stringBuilder, boolean bl) {
        boolean bl2 = bl;
        while (n2 < n3) {
            char c3 = charSequence.charAt(n2);
            if (this.matches(c3)) {
                bl = bl2;
                if (!bl2) {
                    stringBuilder.append(c2);
                    bl = true;
                }
            } else {
                stringBuilder.append(c3);
                bl = false;
            }
            ++n2;
            bl2 = bl;
        }
        return stringBuilder.toString();
    }

    public static CharMatcher forPredicate(Predicate<? super Character> charMatcher) {
        charMatcher = charMatcher instanceof CharMatcher ? (CharMatcher)charMatcher : new ForPredicate(charMatcher);
        return charMatcher;
    }

    public static CharMatcher inRange(char c2, char c3) {
        return new InRange(c2, c3);
    }

    @Deprecated
    public static CharMatcher invisible() {
        return Invisible.INSTANCE;
    }

    public static CharMatcher is(char c2) {
        return new Is(c2);
    }

    private static IsEither isEither(char c2, char c3) {
        return new IsEither(c2, c3);
    }

    public static CharMatcher isNot(char c2) {
        return new IsNot(c2);
    }

    private static boolean isSmall(int n2, int n3) {
        boolean bl = n2 <= 1023 && n3 > n2 * 4 * 16;
        return bl;
    }

    @Deprecated
    public static CharMatcher javaDigit() {
        return JavaDigit.INSTANCE;
    }

    public static CharMatcher javaIsoControl() {
        return JavaIsoControl.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLetter() {
        return JavaLetter.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLetterOrDigit() {
        return JavaLetterOrDigit.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLowerCase() {
        return JavaLowerCase.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaUpperCase() {
        return JavaUpperCase.INSTANCE;
    }

    public static CharMatcher none() {
        return None.INSTANCE;
    }

    public static CharMatcher noneOf(CharSequence charSequence) {
        return CharMatcher.anyOf(charSequence).negate();
    }

    private static CharMatcher precomputedPositive(int n2, BitSet object, String string2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    object = CharMatcher.isSmall(n2, ((BitSet)object).length()) ? SmallCharMatcher.from((BitSet)object, (String)string2) : new BitSetMatcher((BitSet)object, string2);
                    return object;
                }
                char c2 = (char)((BitSet)object).nextSetBit(0);
                return CharMatcher.isEither(c2, (char)((BitSet)object).nextSetBit(c2 + '\u0001'));
            }
            return CharMatcher.is((char)((BitSet)object).nextSetBit(0));
        }
        return CharMatcher.none();
    }

    private static String showCharacter(char c2) {
        char[] cArray;
        char[] cArray2 = cArray = new char[6];
        cArray[0] = 92;
        cArray2[1] = 117;
        cArray2[2] = 0;
        cArray2[3] = 0;
        cArray2[4] = 0;
        cArray2[5] = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            cArray[5 - i2] = "0123456789ABCDEF".charAt(c2 & 0xF);
            c2 = (char)(c2 >> 4);
        }
        return String.copyValueOf(cArray);
    }

    @Deprecated
    public static CharMatcher singleWidth() {
        return SingleWidth.INSTANCE;
    }

    public static CharMatcher whitespace() {
        return Whitespace.INSTANCE;
    }

    public CharMatcher and(CharMatcher charMatcher) {
        return new And(this, charMatcher);
    }

    @Override
    @Deprecated
    public boolean apply(Character c2) {
        return this.matches(c2.charValue());
    }

    public String collapseFrom(CharSequence charSequence, char c2) {
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            char c3 = charSequence.charAt(n3);
            int n4 = n3;
            if (this.matches(c3)) {
                if (!(c3 != c2 || n3 != n2 - 1 && this.matches(charSequence.charAt(n3 + 1)))) {
                    n4 = n3 + 1;
                } else {
                    StringBuilder stringBuilder = new StringBuilder(n2);
                    stringBuilder.append(charSequence, 0, n3);
                    stringBuilder.append(c2);
                    return this.finishCollapseFrom(charSequence, n3 + 1, n2, c2, stringBuilder, true);
                }
            }
            n3 = n4 + 1;
        }
        return charSequence.toString();
    }

    public int countIn(CharSequence charSequence) {
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            int n3 = n2;
            if (this.matches(charSequence.charAt(i2))) {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    public int indexIn(CharSequence charSequence) {
        return this.indexIn(charSequence, 0);
    }

    public int indexIn(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        Preconditions.checkPositionIndex(n2, n3);
        while (n2 < n3) {
            if (this.matches(charSequence.charAt(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence charSequence) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (!this.matches(charSequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public abstract boolean matches(char var1);

    public boolean matchesAllOf(CharSequence charSequence) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesAnyOf(CharSequence charSequence) {
        return this.matchesNoneOf(charSequence) ^ true;
    }

    public boolean matchesNoneOf(CharSequence charSequence) {
        boolean bl = this.indexIn(charSequence) == -1;
        return bl;
    }

    public CharMatcher negate() {
        return new Negated(this);
    }

    public CharMatcher or(CharMatcher charMatcher) {
        return new Or(this, charMatcher);
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    CharMatcher precomputedInternal() {
        CharSequence charSequence;
        BitSet bitSet = new BitSet();
        this.setBits(bitSet);
        int n2 = bitSet.cardinality();
        if (n2 * 2 <= 65536) {
            return CharMatcher.precomputedPositive(n2, bitSet, this.toString());
        }
        bitSet.flip(0, 65536);
        final String string2 = this.toString();
        if (string2.endsWith(".negate()")) {
            charSequence = string2.substring(0, string2.length() - 9);
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(".negate()");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return new NegatedFastMatcher(CharMatcher.precomputedPositive(65536 - n2, bitSet, (String)charSequence)){

            @Override
            public String toString() {
                return string2;
            }
        };
    }

    public String removeFrom(CharSequence object) {
        int n2 = this.indexIn((CharSequence)(object = object.toString()));
        if (n2 == -1) {
            return object;
        }
        object = ((String)object).toCharArray();
        int n3 = 1;
        block0: while (true) {
            ++n2;
            while (true) {
                if (n2 == ((Object)object).length) {
                    return new String((char[])object, 0, n2 - n3);
                }
                if (this.matches((char)object[n2])) {
                    ++n3;
                    continue block0;
                }
                object[n2 - n3] = object[n2];
                ++n2;
            }
            break;
        }
    }

    public String replaceFrom(CharSequence object, char c2) {
        int n2;
        int n3 = this.indexIn((CharSequence)(object = object.toString()));
        if (n3 == -1) {
            return object;
        }
        object = ((String)object).toCharArray();
        object[n3] = c2;
        while ((n2 = n3 + 1) < ((Object)object).length) {
            n3 = n2;
            if (!this.matches((char)object[n2])) continue;
            object[n2] = c2;
            n3 = n2;
        }
        return new String((char[])object);
    }

    public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        int n3;
        int n4 = charSequence2.length();
        if (n4 == 0) {
            return this.removeFrom(charSequence);
        }
        int n5 = 0;
        if (n4 == 1) {
            return this.replaceFrom(charSequence, charSequence2.charAt(0));
        }
        n4 = this.indexIn(charSequence = charSequence.toString());
        if (n4 == -1) {
            return charSequence;
        }
        int n6 = ((String)charSequence).length();
        StringBuilder stringBuilder = new StringBuilder(n6 * 3 / 2 + 16);
        do {
            stringBuilder.append(charSequence, n5, n4);
            stringBuilder.append(charSequence2);
            n2 = n4 + 1;
            n4 = n3 = this.indexIn(charSequence, n2);
            n5 = n2;
        } while (n3 != -1);
        stringBuilder.append(charSequence, n2, n6);
        return stringBuilder.toString();
    }

    public String retainFrom(CharSequence charSequence) {
        return this.negate().removeFrom(charSequence);
    }

    void setBits(BitSet bitSet) {
        for (int i2 = 65535; i2 >= 0; --i2) {
            if (!this.matches((char)i2)) continue;
            bitSet.set(i2);
        }
    }

    public String toString() {
        return super.toString();
    }

    public String trimAndCollapseFrom(CharSequence charSequence, char c2) {
        int n2;
        int n3 = charSequence.length();
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n3 && this.matches(charSequence.charAt(n2)); ++n2) {
        }
        for (n3 = n4; n3 > n2 && this.matches(charSequence.charAt(n3)); --n3) {
        }
        charSequence = n2 == 0 && n3 == n4 ? this.collapseFrom(charSequence, c2) : this.finishCollapseFrom(charSequence, n2, ++n3, c2, new StringBuilder(n3 - n2), false);
        return charSequence;
    }

    public String trimFrom(CharSequence charSequence) {
        int n2;
        int n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && this.matches(charSequence.charAt(n2)); ++n2) {
        }
        --n3;
        while (n3 > n2 && this.matches(charSequence.charAt(n3))) {
            --n3;
        }
        return charSequence.subSequence(n2, n3 + 1).toString();
    }

    public String trimLeadingFrom(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return charSequence.subSequence(i2, n2).toString();
        }
        return "";
    }

    public String trimTrailingFrom(CharSequence charSequence) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return charSequence.subSequence(0, i2 + 1).toString();
        }
        return "";
    }

    private static final class And
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        And(CharMatcher charMatcher, CharMatcher charMatcher2) {
            this.first = Preconditions.checkNotNull(charMatcher);
            this.second = Preconditions.checkNotNull(charMatcher2);
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = this.first.matches(c2) && this.second.matches(c2);
            return bl;
        }

        @Override
        void setBits(BitSet bitSet) {
            BitSet bitSet2 = new BitSet();
            this.first.setBits(bitSet2);
            BitSet bitSet3 = new BitSet();
            this.second.setBits(bitSet3);
            bitSet2.and(bitSet3);
            bitSet.or(bitSet2);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CharMatcher.and(");
            stringBuilder.append(this.first);
            stringBuilder.append(", ");
            stringBuilder.append(this.second);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static final class Any
    extends NamedFastMatcher {
        static final Any INSTANCE = new Any();

        private Any() {
            super("CharMatcher.any()");
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            return Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public String collapseFrom(CharSequence charSequence, char c2) {
            charSequence = charSequence.length() == 0 ? "" : String.valueOf(c2);
            return charSequence;
        }

        @Override
        public int countIn(CharSequence charSequence) {
            return charSequence.length();
        }

        @Override
        public int indexIn(CharSequence charSequence) {
            int n2 = charSequence.length() == 0 ? -1 : 0;
            return n2;
        }

        @Override
        public int indexIn(CharSequence charSequence, int n2) {
            int n3 = charSequence.length();
            Preconditions.checkPositionIndex(n2, n3);
            int n4 = n2;
            if (n2 == n3) {
                n4 = -1;
            }
            return n4;
        }

        @Override
        public int lastIndexIn(CharSequence charSequence) {
            return charSequence.length() - 1;
        }

        @Override
        public boolean matches(char c2) {
            return true;
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return true;
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            boolean bl = charSequence.length() == 0;
            return bl;
        }

        @Override
        public CharMatcher negate() {
            return Any.none();
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            Preconditions.checkNotNull(charMatcher);
            return this;
        }

        @Override
        public String removeFrom(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return "";
        }

        @Override
        public String replaceFrom(CharSequence object, char c2) {
            object = new char[object.length()];
            Arrays.fill((char[])object, c2);
            return new String((char[])object);
        }

        @Override
        public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
            StringBuilder stringBuilder = new StringBuilder(charSequence.length() * charSequence2.length());
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                stringBuilder.append(charSequence2);
            }
            return stringBuilder.toString();
        }

        @Override
        public String trimFrom(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return "";
        }
    }

    private static final class AnyOf
    extends CharMatcher {
        private final char[] chars;

        public AnyOf(CharSequence charSequence) {
            this.chars = charSequence.toString().toCharArray();
            Arrays.sort(this.chars);
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = Arrays.binarySearch(this.chars, c2) >= 0;
            return bl;
        }

        @Override
        void setBits(BitSet bitSet) {
            char[] cArray = this.chars;
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                bitSet.set(cArray[i2]);
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("CharMatcher.anyOf(\"");
            char[] cArray = this.chars;
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(CharMatcher.showCharacter(cArray[i2]));
            }
            stringBuilder.append("\")");
            return stringBuilder.toString();
        }
    }

    private static final class Ascii
    extends NamedFastMatcher {
        static final Ascii INSTANCE = new Ascii();

        Ascii() {
            super("CharMatcher.ascii()");
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = c2 <= '\u007f';
            return bl;
        }
    }

    private static final class BitSetMatcher
    extends NamedFastMatcher {
        private final BitSet table;

        private BitSetMatcher(BitSet bitSet, String object) {
            super((String)object);
            object = bitSet;
            if (bitSet.length() + 64 < bitSet.size()) {
                object = (BitSet)bitSet.clone();
            }
            this.table = object;
        }

        @Override
        public boolean matches(char c2) {
            return this.table.get(c2);
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.or(this.table);
        }
    }

    private static final class BreakingWhitespace
    extends CharMatcher {
        static final CharMatcher INSTANCE = new BreakingWhitespace();

        private BreakingWhitespace() {
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = true;
            if (c2 != ' ' && c2 != '\u0085' && c2 != '\u1680') {
                if (c2 != '\u2007') {
                    if (c2 != '\u205f' && c2 != '\u3000' && c2 != '\u2028' && c2 != '\u2029') {
                        switch (c2) {
                            default: {
                                if (c2 < '\u2000' || c2 > '\u200a') {
                                    bl = false;
                                }
                                return bl;
                            }
                            case '\t': 
                            case '\n': 
                            case '\u000b': 
                            case '\f': 
                            case '\r': {
                                return true;
                            }
                        }
                    }
                } else {
                    return false;
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return "CharMatcher.breakingWhitespace()";
        }
    }

    private static final class Digit
    extends RangesMatcher {
        static final Digit INSTANCE = new Digit();
        private static final String ZEROES = "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uff10";

        private Digit() {
            super("CharMatcher.digit()", Digit.zeroes(), Digit.nines());
        }

        private static char[] nines() {
            char[] cArray = new char[37];
            for (int i2 = 0; i2 < 37; ++i2) {
                cArray[i2] = (char)(ZEROES.charAt(i2) + 9);
            }
            return cArray;
        }

        private static char[] zeroes() {
            return ZEROES.toCharArray();
        }
    }

    static abstract class FastMatcher
    extends CharMatcher {
        FastMatcher() {
        }

        @Override
        public CharMatcher negate() {
            return new NegatedFastMatcher(this);
        }

        @Override
        public final CharMatcher precomputed() {
            return this;
        }
    }

    private static final class ForPredicate
    extends CharMatcher {
        private final Predicate<? super Character> predicate;

        ForPredicate(Predicate<? super Character> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(Character c2) {
            return this.predicate.apply(Preconditions.checkNotNull(c2));
        }

        @Override
        public boolean matches(char c2) {
            return this.predicate.apply(Character.valueOf(c2));
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CharMatcher.forPredicate(");
            stringBuilder.append(this.predicate);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static final class InRange
    extends FastMatcher {
        private final char endInclusive;
        private final char startInclusive;

        InRange(char c2, char c3) {
            boolean bl = c3 >= c2;
            Preconditions.checkArgument(bl);
            this.startInclusive = c2;
            this.endInclusive = c3;
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = this.startInclusive <= c2 && c2 <= this.endInclusive;
            return bl;
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set((int)this.startInclusive, this.endInclusive + '\u0001');
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CharMatcher.inRange('");
            stringBuilder.append(CharMatcher.showCharacter(this.startInclusive));
            stringBuilder.append("', '");
            stringBuilder.append(CharMatcher.showCharacter(this.endInclusive));
            stringBuilder.append("')");
            return stringBuilder.toString();
        }
    }

    private static final class Invisible
    extends RangesMatcher {
        static final Invisible INSTANCE = new Invisible();
        private static final String RANGE_ENDS = " \u00a0\u00ad\u0605\u061c\u06dd\u070f\u08e2\u1680\u180e\u200f\u202f\u2064\u206f\u3000\uf8ff\ufeff\ufffb";
        private static final String RANGE_STARTS = "\u0000\u007f\u00ad\u0600\u061c\u06dd\u070f\u08e2\u1680\u180e\u2000\u2028\u205f\u2066\u3000\ud800\ufeff\ufff9";

        private Invisible() {
            super("CharMatcher.invisible()", RANGE_STARTS.toCharArray(), RANGE_ENDS.toCharArray());
        }
    }

    private static final class Is
    extends FastMatcher {
        private final char match;

        Is(char c2) {
            this.match = c2;
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            charMatcher = charMatcher.matches(this.match) ? this : Is.none();
            return charMatcher;
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = c2 == this.match;
            return bl;
        }

        @Override
        public CharMatcher negate() {
            return Is.isNot(this.match);
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            if (!charMatcher.matches(this.match)) {
                charMatcher = super.or(charMatcher);
            }
            return charMatcher;
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            return charSequence.toString().replace(this.match, c2);
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set(this.match);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CharMatcher.is('");
            stringBuilder.append(CharMatcher.showCharacter(this.match));
            stringBuilder.append("')");
            return stringBuilder.toString();
        }
    }

    private static final class IsEither
    extends FastMatcher {
        private final char match1;
        private final char match2;

        IsEither(char c2, char c3) {
            this.match1 = c2;
            this.match2 = c3;
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = c2 == this.match1 || c2 == this.match2;
            return bl;
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set(this.match1);
            bitSet.set(this.match2);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CharMatcher.anyOf(\"");
            stringBuilder.append(CharMatcher.showCharacter(this.match1));
            stringBuilder.append(CharMatcher.showCharacter(this.match2));
            stringBuilder.append("\")");
            return stringBuilder.toString();
        }
    }

    private static final class IsNot
    extends FastMatcher {
        private final char match;

        IsNot(char c2) {
            this.match = c2;
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            CharMatcher charMatcher2 = charMatcher;
            if (charMatcher.matches(this.match)) {
                charMatcher2 = super.and(charMatcher);
            }
            return charMatcher2;
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = c2 != this.match;
            return bl;
        }

        @Override
        public CharMatcher negate() {
            return IsNot.is(this.match);
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            charMatcher = charMatcher.matches(this.match) ? IsNot.any() : this;
            return charMatcher;
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.set(0, this.match);
            bitSet.set(this.match + '\u0001', 65536);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CharMatcher.isNot('");
            stringBuilder.append(CharMatcher.showCharacter(this.match));
            stringBuilder.append("')");
            return stringBuilder.toString();
        }
    }

    private static final class JavaDigit
    extends CharMatcher {
        static final JavaDigit INSTANCE = new JavaDigit();

        private JavaDigit() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isDigit(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaDigit()";
        }
    }

    private static final class JavaIsoControl
    extends NamedFastMatcher {
        static final JavaIsoControl INSTANCE = new JavaIsoControl();

        private JavaIsoControl() {
            super("CharMatcher.javaIsoControl()");
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f';
            return bl;
        }
    }

    private static final class JavaLetter
    extends CharMatcher {
        static final JavaLetter INSTANCE = new JavaLetter();

        private JavaLetter() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLetter(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLetter()";
        }
    }

    private static final class JavaLetterOrDigit
    extends CharMatcher {
        static final JavaLetterOrDigit INSTANCE = new JavaLetterOrDigit();

        private JavaLetterOrDigit() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLetterOrDigit(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLetterOrDigit()";
        }
    }

    private static final class JavaLowerCase
    extends CharMatcher {
        static final JavaLowerCase INSTANCE = new JavaLowerCase();

        private JavaLowerCase() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLowerCase(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLowerCase()";
        }
    }

    private static final class JavaUpperCase
    extends CharMatcher {
        static final JavaUpperCase INSTANCE = new JavaUpperCase();

        private JavaUpperCase() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isUpperCase(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaUpperCase()";
        }
    }

    static abstract class NamedFastMatcher
    extends FastMatcher {
        private final String description;

        NamedFastMatcher(String string2) {
            this.description = Preconditions.checkNotNull(string2);
        }

        @Override
        public final String toString() {
            return this.description;
        }
    }

    private static class Negated
    extends CharMatcher {
        final CharMatcher original;

        Negated(CharMatcher charMatcher) {
            this.original = Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public int countIn(CharSequence charSequence) {
            return charSequence.length() - this.original.countIn(charSequence);
        }

        @Override
        public boolean matches(char c2) {
            return this.original.matches(c2) ^ true;
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            return this.original.matchesNoneOf(charSequence);
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            return this.original.matchesAllOf(charSequence);
        }

        @Override
        public CharMatcher negate() {
            return this.original;
        }

        @Override
        void setBits(BitSet bitSet) {
            BitSet bitSet2 = new BitSet();
            this.original.setBits(bitSet2);
            bitSet2.flip(0, 65536);
            bitSet.or(bitSet2);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.original);
            stringBuilder.append(".negate()");
            return stringBuilder.toString();
        }
    }

    static class NegatedFastMatcher
    extends Negated {
        NegatedFastMatcher(CharMatcher charMatcher) {
            super(charMatcher);
        }

        @Override
        public final CharMatcher precomputed() {
            return this;
        }
    }

    private static final class None
    extends NamedFastMatcher {
        static final None INSTANCE = new None();

        private None() {
            super("CharMatcher.none()");
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            Preconditions.checkNotNull(charMatcher);
            return this;
        }

        @Override
        public String collapseFrom(CharSequence charSequence, char c2) {
            return charSequence.toString();
        }

        @Override
        public int countIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return 0;
        }

        @Override
        public int indexIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return -1;
        }

        @Override
        public int indexIn(CharSequence charSequence, int n2) {
            Preconditions.checkPositionIndex(n2, charSequence.length());
            return -1;
        }

        @Override
        public int lastIndexIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return -1;
        }

        @Override
        public boolean matches(char c2) {
            return false;
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            boolean bl = charSequence.length() == 0;
            return bl;
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return true;
        }

        @Override
        public CharMatcher negate() {
            return None.any();
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            return Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public String removeFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            return charSequence.toString();
        }

        @Override
        public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
            Preconditions.checkNotNull(charSequence2);
            return charSequence.toString();
        }

        @Override
        public String trimFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String trimLeadingFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String trimTrailingFrom(CharSequence charSequence) {
            return charSequence.toString();
        }
    }

    private static final class Or
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        Or(CharMatcher charMatcher, CharMatcher charMatcher2) {
            this.first = Preconditions.checkNotNull(charMatcher);
            this.second = Preconditions.checkNotNull(charMatcher2);
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = this.first.matches(c2) || this.second.matches(c2);
            return bl;
        }

        @Override
        void setBits(BitSet bitSet) {
            this.first.setBits(bitSet);
            this.second.setBits(bitSet);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CharMatcher.or(");
            stringBuilder.append(this.first);
            stringBuilder.append(", ");
            stringBuilder.append(this.second);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class RangesMatcher
    extends CharMatcher {
        private final String description;
        private final char[] rangeEnds;
        private final char[] rangeStarts;

        RangesMatcher(String string2, char[] cArray, char[] cArray2) {
            this.description = string2;
            this.rangeStarts = cArray;
            this.rangeEnds = cArray2;
            boolean bl = cArray.length == cArray2.length;
            Preconditions.checkArgument(bl);
            int n2 = 0;
            while (n2 < cArray.length) {
                bl = cArray[n2] <= cArray2[n2];
                Preconditions.checkArgument(bl);
                int n3 = n2 + 1;
                if (n3 < cArray.length) {
                    bl = cArray2[n2] < cArray[n3];
                    Preconditions.checkArgument(bl);
                }
                n2 = n3;
            }
        }

        @Override
        public boolean matches(char c2) {
            int n2 = Arrays.binarySearch(this.rangeStarts, c2);
            boolean bl = true;
            if (n2 >= 0) {
                return true;
            }
            if ((n2 = ~n2 - 1) < 0 || c2 > this.rangeEnds[n2]) {
                bl = false;
            }
            return bl;
        }

        @Override
        public String toString() {
            return this.description;
        }
    }

    private static final class SingleWidth
    extends RangesMatcher {
        static final SingleWidth INSTANCE = new SingleWidth();

        private SingleWidth() {
            super("CharMatcher.singleWidth()", "\u0000\u05be\u05d0\u05f3\u0600\u0750\u0e00\u1e00\u2100\ufb50\ufe70\uff61".toCharArray(), "\u04f9\u05be\u05ea\u05f4\u06ff\u077f\u0e7f\u20af\u213a\ufdff\ufeff\uffdc".toCharArray());
        }
    }

    static final class Whitespace
    extends NamedFastMatcher {
        static final Whitespace INSTANCE;
        static final int MULTIPLIER = 1682554634;
        static final int SHIFT;
        static final String TABLE = "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000";

        static {
            SHIFT = Integer.numberOfLeadingZeros(31);
            INSTANCE = new Whitespace();
        }

        Whitespace() {
            super("CharMatcher.whitespace()");
        }

        @Override
        public boolean matches(char c2) {
            boolean bl = TABLE.charAt(1682554634 * c2 >>> SHIFT) == c2;
            return bl;
        }

        @Override
        void setBits(BitSet bitSet) {
            for (int i2 = 0; i2 < 32; ++i2) {
                bitSet.set(TABLE.charAt(i2));
            }
        }
    }
}

