/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"){

        @Override
        String convert(CaseFormat caseFormat, String string2) {
            if (caseFormat == LOWER_UNDERSCORE) {
                return string2.replace('-', '_');
            }
            if (caseFormat == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase((String)string2.replace('-', '_'));
            }
            return super.convert(caseFormat, string2);
        }

        @Override
        String normalizeWord(String string2) {
            return Ascii.toLowerCase((String)string2);
        }
    }
    ,
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"){

        @Override
        String convert(CaseFormat caseFormat, String string2) {
            if (caseFormat == LOWER_HYPHEN) {
                return string2.replace('_', '-');
            }
            if (caseFormat == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase((String)string2);
            }
            return super.convert(caseFormat, string2);
        }

        @Override
        String normalizeWord(String string2) {
            return Ascii.toLowerCase((String)string2);
        }
    }
    ,
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""){

        @Override
        String normalizeWord(String string2) {
            return CaseFormat.firstCharOnlyToUpper(string2);
        }
    }
    ,
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""){

        @Override
        String normalizeWord(String string2) {
            return CaseFormat.firstCharOnlyToUpper(string2);
        }
    }
    ,
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_"){

        @Override
        String convert(CaseFormat caseFormat, String string2) {
            if (caseFormat == LOWER_HYPHEN) {
                return Ascii.toLowerCase((String)string2.replace('_', '-'));
            }
            if (caseFormat == LOWER_UNDERSCORE) {
                return Ascii.toLowerCase((String)string2);
            }
            return super.convert(caseFormat, string2);
        }

        @Override
        String normalizeWord(String string2) {
            return Ascii.toUpperCase((String)string2);
        }
    };

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    private CaseFormat(CharMatcher charMatcher, String string3) {
        this.wordBoundary = charMatcher;
        this.wordSeparator = string3;
    }

    private static String firstCharOnlyToUpper(String string2) {
        if (!string2.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Ascii.toUpperCase((char)string2.charAt(0)));
            stringBuilder.append(Ascii.toLowerCase((String)string2.substring(1)));
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    private String normalizeFirstWord(String string2) {
        string2 = this == LOWER_CAMEL ? Ascii.toLowerCase((String)string2) : this.normalizeWord(string2);
        return string2;
    }

    String convert(CaseFormat object, String string2) {
        int n2 = 0;
        StringBuilder stringBuilder = null;
        int n3 = -1;
        while ((n3 = this.wordBoundary.indexIn(string2, n3 + 1)) != -1) {
            if (n2 == 0) {
                stringBuilder = new StringBuilder(string2.length() + this.wordSeparator.length() * 4);
                stringBuilder.append(((CaseFormat)((Object)object)).normalizeFirstWord(string2.substring(n2, n3)));
            } else {
                stringBuilder.append(((CaseFormat)((Object)object)).normalizeWord(string2.substring(n2, n3)));
            }
            stringBuilder.append(((CaseFormat)((Object)object)).wordSeparator);
            n2 = this.wordSeparator.length() + n3;
        }
        if (n2 == 0) {
            object = ((CaseFormat)((Object)object)).normalizeFirstWord(string2);
        } else {
            stringBuilder.append(((CaseFormat)((Object)object)).normalizeWord(string2.substring(n2)));
            object = stringBuilder.toString();
        }
        return object;
    }

    public Converter<String, String> converterTo(CaseFormat caseFormat) {
        return new StringConverter(this, caseFormat);
    }

    abstract String normalizeWord(String var1);

    public final String to(CaseFormat caseFormat, String string2) {
        Preconditions.checkNotNull(caseFormat);
        Preconditions.checkNotNull(string2);
        if (caseFormat != this) {
            string2 = this.convert(caseFormat, string2);
        }
        return string2;
    }

    private static final class StringConverter
    extends Converter<String, String>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final CaseFormat sourceFormat;
        private final CaseFormat targetFormat;

        StringConverter(CaseFormat caseFormat, CaseFormat caseFormat2) {
            this.sourceFormat = Preconditions.checkNotNull(caseFormat);
            this.targetFormat = Preconditions.checkNotNull(caseFormat2);
        }

        @Override
        protected String doBackward(String string2) {
            return this.targetFormat.to(this.sourceFormat, string2);
        }

        @Override
        protected String doForward(String string2) {
            return this.sourceFormat.to(this.targetFormat, string2);
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            boolean bl;
            boolean bl2 = object instanceof StringConverter;
            boolean bl3 = bl = false;
            if (bl2) {
                object = (StringConverter)object;
                bl3 = bl;
                if (this.sourceFormat.equals((Object)((StringConverter)object).sourceFormat)) {
                    bl3 = bl;
                    if (this.targetFormat.equals((Object)((StringConverter)object).targetFormat)) {
                        bl3 = true;
                    }
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.sourceFormat.hashCode() ^ this.targetFormat.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)this.sourceFormat);
            stringBuilder.append(".converterTo(");
            stringBuilder.append((Object)this.targetFormat);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }
}

