/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class AbstractIterator<T>
implements Iterator<T> {
    @NullableDecl
    private T next;
    private State state = State.NOT_READY;

    protected AbstractIterator() {
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    protected abstract T computeNext();

    @NullableDecl
    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        boolean bl = this.state != State.FAILED;
        Preconditions.checkState(bl);
        int n2 = 1.$SwitchMap$com$google$common$base$AbstractIterator$State[this.state.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                return this.tryToComputeNext();
            }
            return false;
        }
        return true;
    }

    @Override
    public final T next() {
        if (this.hasNext()) {
            this.state = State.NOT_READY;
            T t2 = this.next;
            this.next = null;
            return t2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }
}

