/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzaa;
import com.google.android.gms.tasks.zzu;
import com.google.android.gms.tasks.zzy;
import com.google.android.gms.tasks.zzz;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    private Tasks() {
    }

    public static <TResult> TResult await(Task<TResult> task2) throws ExecutionException, InterruptedException {
        Preconditions.checkNotMainThread();
        Preconditions.checkNotNull(task2, "Task must not be null");
        if (task2.isComplete()) {
            return Tasks.zza(task2);
        }
        zzb zzb2 = new zzb(null);
        Tasks.zza(task2, zzb2);
        zzb2.zza();
        return Tasks.zza(task2);
    }

    public static <TResult> TResult await(Task<TResult> task2, long l2, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        Preconditions.checkNotMainThread();
        Preconditions.checkNotNull(task2, "Task must not be null");
        Preconditions.checkNotNull(timeUnit, "TimeUnit must not be null");
        if (task2.isComplete()) {
            return Tasks.zza(task2);
        }
        zzb zzb2 = new zzb(null);
        Tasks.zza(task2, zzb2);
        if (zzb2.zza(l2, timeUnit)) {
            return Tasks.zza(task2);
        }
        throw new TimeoutException("Timed out waiting for Task");
    }

    @Deprecated
    public static <TResult> Task<TResult> call(Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    @Deprecated
    public static <TResult> Task<TResult> call(Executor executor, Callable<TResult> callable) {
        Preconditions.checkNotNull(executor, "Executor must not be null");
        Preconditions.checkNotNull(callable, "Callback must not be null");
        zzu zzu2 = new zzu();
        executor.execute((Runnable)new zzy(zzu2, callable));
        return zzu2;
    }

    public static <TResult> Task<TResult> forCanceled() {
        zzu zzu2 = new zzu();
        zzu2.zza();
        return zzu2;
    }

    public static <TResult> Task<TResult> forException(Exception exception) {
        zzu zzu2 = new zzu();
        zzu2.zza(exception);
        return zzu2;
    }

    public static <TResult> Task<TResult> forResult(TResult TResult) {
        zzu zzu2 = new zzu();
        zzu2.zza(TResult);
        return zzu2;
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> object) {
        if (object != null && !object.isEmpty()) {
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                if (object2.next() != null) continue;
                throw new NullPointerException("null tasks are not accepted");
            }
            zzu zzu2 = new zzu();
            object2 = new zzc(object.size(), (zzu<Void>)zzu2);
            object = object.iterator();
            while (object.hasNext()) {
                Tasks.zza((Task)object.next(), object2);
            }
            return zzu2;
        }
        return Tasks.forResult(null);
    }

    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray != null && taskArray.length != 0) {
            return Tasks.whenAll(Arrays.asList(taskArray));
        }
        return Tasks.forResult(null);
    }

    public static Task<List<Task<?>>> whenAllComplete(Collection<? extends Task<?>> collection) {
        if (collection != null && !collection.isEmpty()) {
            return Tasks.whenAll(collection).continueWithTask((Continuation)new zzz(collection));
        }
        return Tasks.forResult(Collections.emptyList());
    }

    public static Task<List<Task<?>>> whenAllComplete(Task<?> ... taskArray) {
        if (taskArray != null && taskArray.length != 0) {
            return Tasks.whenAllComplete(Arrays.asList(taskArray));
        }
        return Tasks.forResult(Collections.emptyList());
    }

    public static <TResult> Task<List<TResult>> whenAllSuccess(Collection<? extends Task<?>> collection) {
        if (collection != null && !collection.isEmpty()) {
            return Tasks.whenAll(collection).continueWith((Continuation)new zzaa(collection));
        }
        return Tasks.forResult(Collections.emptyList());
    }

    public static <TResult> Task<List<TResult>> whenAllSuccess(Task<?> ... taskArray) {
        if (taskArray != null && taskArray.length != 0) {
            return Tasks.whenAllSuccess(Arrays.asList(taskArray));
        }
        return Tasks.forResult(Collections.emptyList());
    }

    private static <TResult> TResult zza(Task<TResult> task2) throws ExecutionException {
        if (task2.isSuccessful()) {
            return (TResult)task2.getResult();
        }
        if (task2.isCanceled()) {
            throw new CancellationException("Task is already canceled");
        }
        throw new ExecutionException(task2.getException());
    }

    private static <T> void zza(Task<T> task2, zza<? super T> zza2) {
        task2.addOnSuccessListener(TaskExecutors.zza, zza2);
        task2.addOnFailureListener(TaskExecutors.zza, zza2);
        task2.addOnCanceledListener(TaskExecutors.zza, zza2);
    }

    static interface zza<T>
    extends OnCanceledListener,
    OnFailureListener,
    OnSuccessListener<T> {
    }

    private static final class zzb
    implements zza {
        private final CountDownLatch zza = new CountDownLatch(1);

        private zzb() {
        }

        /* synthetic */ zzb(zzy zzy2) {
            this();
        }

        public final void onCanceled() {
            this.zza.countDown();
        }

        public final void onFailure(Exception exception) {
            this.zza.countDown();
        }

        public final void onSuccess(Object object) {
            this.zza.countDown();
        }

        public final void zza() throws InterruptedException {
            this.zza.await();
        }

        public final boolean zza(long l2, TimeUnit timeUnit) throws InterruptedException {
            return this.zza.await(l2, timeUnit);
        }
    }

    private static final class zzc
    implements zza {
        private final Object zza = new Object();
        private final int zzb;
        private final zzu<Void> zzc;
        private int zzd;
        private int zze;
        private int zzf;
        private Exception zzg;
        private boolean zzh;

        public zzc(int n2, zzu<Void> zzu2) {
            this.zzb = n2;
            this.zzc = zzu2;
        }

        private final void zza() {
            int n2 = this.zzd;
            int n3 = this.zze;
            int n4 = this.zzf;
            int n5 = this.zzb;
            if (n2 + n3 + n4 == n5) {
                if (this.zzg != null) {
                    zzu<Void> zzu2 = this.zzc;
                    StringBuilder stringBuilder = new StringBuilder(54);
                    stringBuilder.append(n3);
                    stringBuilder.append(" out of ");
                    stringBuilder.append(n5);
                    stringBuilder.append(" underlying tasks failed");
                    zzu2.zza((Exception)new ExecutionException(stringBuilder.toString(), this.zzg));
                    return;
                }
                if (this.zzh) {
                    this.zzc.zza();
                    return;
                }
                this.zzc.zza(null);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void onCanceled() {
            Object object = this.zza;
            synchronized (object) {
                ++this.zzf;
                this.zzh = true;
                this.zza();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void onFailure(Exception exception) {
            Object object = this.zza;
            synchronized (object) {
                ++this.zze;
                this.zzg = exception;
                this.zza();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void onSuccess(Object object) {
            object = this.zza;
            synchronized (object) {
                ++this.zzd;
                this.zza();
                return;
            }
        }
    }
}

