/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.drive;

import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.metadata.internal.zzk;
import com.google.android.gms.internal.drive.zzaw;
import com.google.android.gms.internal.drive.zzbi;
import com.google.android.gms.internal.drive.zzbs;
import com.google.android.gms.internal.drive.zzeo;
import com.google.android.gms.internal.drive.zzeq;
import com.google.android.gms.internal.drive.zzhj;
import com.google.android.gms.internal.drive.zzw;
import com.google.android.gms.tasks.TaskCompletionSource;

final class zzdh
extends TaskApiCall<zzaw, DriveFile> {
    private final DriveFolder zzfj;
    private final MetadataChangeSet zzgc;
    private ExecutionOptions zzgd;
    private String zzge;
    private zzk zzgf;
    private final DriveContents zzo;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    zzdh(DriveFolder driveFolder, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions, String string2) {
        this.zzfj = driveFolder;
        this.zzgc = metadataChangeSet;
        this.zzo = driveContents;
        this.zzgd = executionOptions;
        this.zzge = null;
        Preconditions.checkNotNull(driveFolder, "DriveFolder must not be null");
        Preconditions.checkNotNull(driveFolder.getDriveId(), "Folder's DriveId must not be null");
        Preconditions.checkNotNull(metadataChangeSet, "MetadataChangeSet must not be null");
        Preconditions.checkNotNull(executionOptions, "ExecutionOptions must not be null");
        this.zzgf = zzk.zzg((String)metadataChangeSet.getMimeType());
        driveFolder = this.zzgf;
        if (driveFolder != null && driveFolder.isFolder()) {
            throw new IllegalArgumentException("May not create folders using this method. Use DriveFolderManagerClient#createFolder() instead of mime type application/vnd.google-apps.folder");
        }
        if (driveContents == null) return;
        if (!(driveContents instanceof zzbi)) throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
        if (driveContents.getDriveId() != null) throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
        if (!driveContents.zzk()) return;
        throw new IllegalArgumentException("DriveContents are already closed.");
    }

    protected final /* synthetic */ void doExecute(Api.AnyClient anyClient, TaskCompletionSource taskCompletionSource) throws RemoteException {
        anyClient = (zzaw)anyClient;
        this.zzgd.zza((zzaw)anyClient);
        MetadataChangeSet metadataChangeSet = this.zzgc;
        metadataChangeSet.zzq().zza(anyClient.getContext());
        int n2 = zzbs.zza(this.zzo, this.zzgf);
        zzk zzk2 = this.zzgf;
        int n3 = zzk2 != null && zzk2.zzbh() ? 1 : 0;
        metadataChangeSet = new zzw(this.zzfj.getDriveId(), metadataChangeSet.zzq(), n2, n3, this.zzgd);
        ((zzeo)anyClient.getService()).zza((zzw)metadataChangeSet, (zzeq)new zzhj(taskCompletionSource));
    }
}

