/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.drive;

import android.app.Activity;
import android.content.Context;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.DriveResource;
import com.google.android.gms.drive.DriveResourceClient;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.Metadata;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ListenerToken;
import com.google.android.gms.drive.events.OnChangeListener;
import com.google.android.gms.drive.events.OpenFileCallback;
import com.google.android.gms.drive.events.zzj;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.zzn;
import com.google.android.gms.drive.zzp;
import com.google.android.gms.internal.drive.zzbs;
import com.google.android.gms.internal.drive.zzci;
import com.google.android.gms.internal.drive.zzcj;
import com.google.android.gms.internal.drive.zzck;
import com.google.android.gms.internal.drive.zzcl;
import com.google.android.gms.internal.drive.zzcm;
import com.google.android.gms.internal.drive.zzcn;
import com.google.android.gms.internal.drive.zzco;
import com.google.android.gms.internal.drive.zzcp;
import com.google.android.gms.internal.drive.zzcq;
import com.google.android.gms.internal.drive.zzcr;
import com.google.android.gms.internal.drive.zzcs;
import com.google.android.gms.internal.drive.zzct;
import com.google.android.gms.internal.drive.zzcu;
import com.google.android.gms.internal.drive.zzcv;
import com.google.android.gms.internal.drive.zzcw;
import com.google.android.gms.internal.drive.zzcx;
import com.google.android.gms.internal.drive.zzcy;
import com.google.android.gms.internal.drive.zzcz;
import com.google.android.gms.internal.drive.zzda;
import com.google.android.gms.internal.drive.zzdb;
import com.google.android.gms.internal.drive.zzdc;
import com.google.android.gms.internal.drive.zzdd;
import com.google.android.gms.internal.drive.zzde;
import com.google.android.gms.internal.drive.zzdf;
import com.google.android.gms.internal.drive.zzdh;
import com.google.android.gms.internal.drive.zzdi;
import com.google.android.gms.internal.drive.zzg;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzch
extends DriveResourceClient {
    private static final AtomicInteger zzfn = new AtomicInteger();

    public zzch(Activity activity, Drive.zza zza2) {
        super(activity, zza2);
    }

    public zzch(Context context, Drive.zza zza2) {
        super(context, zza2);
    }

    static final /* synthetic */ ListenerToken zza(ListenerHolder listenerHolder, Task task2) throws Exception {
        if (task2.isSuccessful()) {
            return new zzg(listenerHolder.getListenerKey());
        }
        throw task2.getException();
    }

    static final /* synthetic */ ListenerToken zza(zzg zzg2, Task task2) throws Exception {
        if (task2.isSuccessful()) {
            return zzg2;
        }
        throw task2.getException();
    }

    private static void zze(int n2) {
        if (n2 != 0x10000000 && n2 != 0x20000000 && n2 != 0x30000000) {
            throw new IllegalArgumentException("Invalid openMode provided");
        }
    }

    public final Task<ListenerToken> addChangeListener(DriveResource driveResource, OnChangeListener object) {
        Preconditions.checkNotNull(driveResource.getDriveId());
        Preconditions.checkNotNull(object, "listener");
        object = new zzdi(this, (OnChangeListener)object, driveResource.getDriveId());
        int n2 = zzfn.incrementAndGet();
        StringBuilder stringBuilder = new StringBuilder(27);
        stringBuilder.append("OnChangeListener");
        stringBuilder.append(n2);
        stringBuilder = this.registerListener(object, stringBuilder.toString());
        return this.doRegisterEventListener(new zzcp(this, (ListenerHolder)stringBuilder, driveResource, (zzdi)object), (UnregisterListenerMethod)new zzcq(this, stringBuilder.getListenerKey(), driveResource, (zzdi)object)).continueWith((Continuation)new zzci((ListenerHolder)stringBuilder));
    }

    public final Task<Void> addChangeSubscription(DriveResource driveResource) {
        Preconditions.checkNotNull(driveResource.getDriveId());
        Preconditions.checkArgument(zzj.zza(1, driveResource.getDriveId()));
        return this.doWrite((TaskApiCall)new zzcr(this, driveResource));
    }

    public final Task<Boolean> cancelOpenFileCallback(ListenerToken listenerToken) {
        if (listenerToken instanceof zzg) {
            return this.doUnregisterEventListener(((zzg)listenerToken).zzad());
        }
        throw new IllegalArgumentException("Unrecognized ListenerToken");
    }

    public final Task<Void> commitContents(DriveContents driveContents, MetadataChangeSet metadataChangeSet) {
        return this.commitContents(driveContents, metadataChangeSet, (ExecutionOptions)((zzn)new zzp().build()));
    }

    public final Task<Void> commitContents(DriveContents driveContents, MetadataChangeSet metadataChangeSet, ExecutionOptions executionOptions) {
        Preconditions.checkNotNull(executionOptions, "Execution options cannot be null.");
        boolean bl = driveContents.zzk();
        boolean bl2 = true;
        Preconditions.checkArgument(bl ^ true, "DriveContents is already closed");
        if (driveContents.getMode() == 0x10000000) {
            bl2 = false;
        }
        Preconditions.checkArgument(bl2, "Cannot commit contents opened in MODE_READ_ONLY.");
        Preconditions.checkNotNull(driveContents.getDriveId(), "Only DriveContents obtained through DriveFile.open can be committed.");
        zzn zzn2 = zzn.zza((ExecutionOptions)executionOptions);
        if (ExecutionOptions.zza(zzn2.zzn()) && !driveContents.zzi().zzb()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        executionOptions = metadataChangeSet;
        if (metadataChangeSet == null) {
            executionOptions = MetadataChangeSet.zzax;
        }
        return this.doWrite(new zzcy(this, zzn2, driveContents, (MetadataChangeSet)executionOptions));
    }

    public final Task<DriveContents> createContents() {
        Preconditions.checkArgument(true, "Contents can only be created in MODE_WRITE_ONLY or MODE_READ_WRITE.");
        return this.doWrite((TaskApiCall)new zzcw(this, 0x20000000));
    }

    public final Task<DriveFile> createFile(DriveFolder driveFolder, MetadataChangeSet metadataChangeSet, DriveContents driveContents) {
        return this.createFile(driveFolder, metadataChangeSet, driveContents, new ExecutionOptions.Builder().build());
    }

    public final Task<DriveFile> createFile(DriveFolder driveFolder, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        zzbs.zzb(metadataChangeSet);
        return this.doWrite(new zzdh(driveFolder, metadataChangeSet, driveContents, executionOptions, null));
    }

    public final Task<DriveFolder> createFolder(DriveFolder driveFolder, MetadataChangeSet metadataChangeSet) {
        Preconditions.checkNotNull(metadataChangeSet, "MetadataChangeSet must be provided.");
        if (metadataChangeSet.getMimeType() != null && !metadataChangeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
            throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
        }
        return this.doWrite(new zzdb(this, metadataChangeSet, driveFolder));
    }

    public final Task<Void> delete(DriveResource driveResource) {
        Preconditions.checkNotNull(driveResource.getDriveId());
        return this.doWrite(new zzcl(this, driveResource));
    }

    public final Task<Void> discardContents(DriveContents driveContents) {
        Preconditions.checkArgument(driveContents.zzk() ^ true, "DriveContents is already closed");
        driveContents.zzj();
        return this.doWrite(new zzda(this, driveContents));
    }

    public final Task<DriveFolder> getAppFolder() {
        return this.doRead(new zzco(this));
    }

    public final Task<Metadata> getMetadata(DriveResource driveResource) {
        Preconditions.checkNotNull(driveResource, "DriveResource must not be null");
        Preconditions.checkNotNull(driveResource.getDriveId(), "Resource's DriveId must not be null");
        return this.doRead(new zzdc(this, driveResource, false));
    }

    public final Task<DriveFolder> getRootFolder() {
        return this.doRead(new zzck(this));
    }

    public final Task<MetadataBuffer> listChildren(DriveFolder driveFolder) {
        Preconditions.checkNotNull(driveFolder, "folder cannot be null.");
        return this.query(zzbs.zza(null, driveFolder.getDriveId()));
    }

    public final Task<MetadataBuffer> listParents(DriveResource driveResource) {
        Preconditions.checkNotNull(driveResource.getDriveId());
        return this.doRead(new zzde(this, driveResource));
    }

    public final Task<DriveContents> openFile(DriveFile driveFile, int n2) {
        zzch.zze(n2);
        return this.doRead((TaskApiCall)new zzct(this, driveFile, n2));
    }

    public final Task<ListenerToken> openFile(DriveFile driveFile, int n2, OpenFileCallback openFileCallback) {
        zzch.zze(n2);
        int n3 = zzfn.incrementAndGet();
        StringBuilder stringBuilder = new StringBuilder(27);
        stringBuilder.append("OpenFileCallback");
        stringBuilder.append(n3);
        openFileCallback = this.registerListener(openFileCallback, stringBuilder.toString());
        stringBuilder = openFileCallback.getListenerKey();
        zzg zzg2 = new zzg((ListenerHolder.ListenerKey)stringBuilder);
        return this.doRegisterEventListener((RegisterListenerMethod)new zzcu(this, (ListenerHolder)openFileCallback, driveFile, n2, zzg2, (ListenerHolder)openFileCallback), new zzcv(this, (ListenerHolder.ListenerKey)stringBuilder, zzg2)).continueWith((Continuation)new zzcj(zzg2));
    }

    public final Task<MetadataBuffer> query(Query query) {
        Preconditions.checkNotNull(query, "query cannot be null.");
        return this.doRead(new zzcz(this, query));
    }

    public final Task<MetadataBuffer> queryChildren(DriveFolder driveFolder, Query query) {
        Preconditions.checkNotNull(driveFolder, "folder cannot be null.");
        Preconditions.checkNotNull(query, "query cannot be null.");
        return this.query(zzbs.zza(query, driveFolder.getDriveId()));
    }

    public final Task<Boolean> removeChangeListener(ListenerToken listenerToken) {
        Preconditions.checkNotNull(listenerToken, "Token is required to unregister listener.");
        if (listenerToken instanceof zzg) {
            return this.doUnregisterEventListener(((zzg)listenerToken).zzad());
        }
        throw new IllegalStateException("Could not recover key from ListenerToken");
    }

    public final Task<Void> removeChangeSubscription(DriveResource driveResource) {
        Preconditions.checkNotNull(driveResource.getDriveId());
        Preconditions.checkArgument(zzj.zza(1, driveResource.getDriveId()));
        return this.doWrite((TaskApiCall)new zzcs(this, driveResource));
    }

    public final Task<DriveContents> reopenContentsForWrite(DriveContents driveContents) {
        boolean bl = driveContents.zzk();
        boolean bl2 = true;
        Preconditions.checkArgument(bl ^ true, "DriveContents is already closed");
        if (driveContents.getMode() != 0x10000000) {
            bl2 = false;
        }
        Preconditions.checkArgument(bl2, "This method can only be called on contents that are currently opened in MODE_READ_ONLY.");
        driveContents.zzj();
        return this.doRead((TaskApiCall)new zzcx(this, driveContents));
    }

    public final Task<Void> setParents(DriveResource driveResource, Set<DriveId> set) {
        Preconditions.checkNotNull(driveResource.getDriveId());
        Preconditions.checkNotNull(set);
        return this.doWrite(new zzdf(this, driveResource, new ArrayList<DriveId>(set)));
    }

    public final Task<Void> trash(DriveResource driveResource) {
        Preconditions.checkNotNull(driveResource.getDriveId());
        return this.doWrite(new zzcm(this, driveResource));
    }

    public final Task<Void> untrash(DriveResource driveResource) {
        Preconditions.checkNotNull(driveResource.getDriveId());
        return this.doWrite(new zzcn(this, driveResource));
    }

    public final Task<Metadata> updateMetadata(DriveResource driveResource, MetadataChangeSet metadataChangeSet) {
        Preconditions.checkNotNull(driveResource.getDriveId());
        Preconditions.checkNotNull(metadataChangeSet);
        return this.doWrite(new zzdd(this, metadataChangeSet, driveResource));
    }
}

