/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.drive;

import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.metadata.internal.zzk;
import com.google.android.gms.drive.query.Filters;
import com.google.android.gms.drive.query.Query;
import com.google.android.gms.drive.query.SearchableField;
import com.google.android.gms.internal.drive.zzaf;
import com.google.android.gms.internal.drive.zzbi;
import com.google.android.gms.internal.drive.zzbt;
import com.google.android.gms.internal.drive.zzbu;
import com.google.android.gms.internal.drive.zzdp;

public final class zzbs
extends zzdp
implements DriveFolder {
    public zzbs(DriveId driveId) {
        super(driveId);
    }

    static int zza(DriveContents driveContents, zzk zzk2) {
        int n2;
        if (driveContents == null) {
            n2 = zzk2 != null && zzk2.zzbh() ? 0 : 1;
        } else {
            n2 = driveContents.zzi().getRequestId();
            driveContents.zzj();
        }
        return n2;
    }

    static Query zza(Query query, DriveId driveId) {
        driveId = new Query.Builder().addFilter(Filters.in(SearchableField.PARENTS, driveId));
        if (query != null) {
            if (query.getFilter() != null) {
                driveId.addFilter(query.getFilter());
            }
            driveId.setPageToken(query.getPageToken());
            driveId.setSortOrder(query.getSortOrder());
        }
        return driveId.build();
    }

    static void zzb(MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet != null) {
            boolean bl;
            if ((metadataChangeSet = com.google.android.gms.drive.metadata.internal.zzk.zzg((String)metadataChangeSet.getMimeType())) != null && !(bl = !metadataChangeSet.zzbh() && !metadataChangeSet.isFolder())) {
                throw new IllegalArgumentException("May not create shortcut files using this method. Use DriveFolder.createShortcutFile() instead.");
            }
            return;
        }
        throw new IllegalArgumentException("MetadataChangeSet must be provided.");
    }

    public final PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents) {
        return this.createFile(googleApiClient, metadataChangeSet, driveContents, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final PendingResult<DriveFolder.DriveFileResult> createFile(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet, DriveContents driveContents, ExecutionOptions executionOptions) {
        ExecutionOptions executionOptions2 = executionOptions;
        if (executionOptions == null) {
            executionOptions2 = new ExecutionOptions.Builder().build();
        }
        if (executionOptions2.zzn() != 0) throw new IllegalStateException("May not set a conflict strategy for new file creation.");
        if (metadataChangeSet == null) throw new IllegalArgumentException("MetadataChangeSet must be provided.");
        executionOptions = com.google.android.gms.drive.metadata.internal.zzk.zzg((String)metadataChangeSet.getMimeType());
        if (executionOptions != null && executionOptions.isFolder()) {
            throw new IllegalArgumentException("May not create folders using this method. Use DriveFolder.createFolder() instead of mime type application/vnd.google-apps.folder");
        }
        if (executionOptions2 == null) throw new IllegalArgumentException("ExecutionOptions must be provided");
        executionOptions2.zza(googleApiClient);
        if (driveContents != null) {
            if (!(driveContents instanceof zzbi)) throw new IllegalArgumentException("Only DriveContents obtained from the Drive API are accepted.");
            if (driveContents.getDriveId() != null) throw new IllegalArgumentException("Only DriveContents obtained through DriveApi.newDriveContents are accepted for file creation.");
            if (driveContents.zzk()) {
                throw new IllegalArgumentException("DriveContents are already closed.");
            }
        }
        zzbs.zzb(metadataChangeSet);
        int n2 = zzbs.zza(driveContents, com.google.android.gms.drive.metadata.internal.zzk.zzg((String)metadataChangeSet.getMimeType()));
        driveContents = com.google.android.gms.drive.metadata.internal.zzk.zzg((String)metadataChangeSet.getMimeType());
        int n3 = driveContents != null && driveContents.zzbh() ? 1 : 0;
        return googleApiClient.execute(new zzbt(this, googleApiClient, metadataChangeSet, n2, n3, executionOptions2));
    }

    public final PendingResult<DriveFolder.DriveFolderResult> createFolder(GoogleApiClient googleApiClient, MetadataChangeSet metadataChangeSet) {
        if (metadataChangeSet != null) {
            if (metadataChangeSet.getMimeType() != null && !metadataChangeSet.getMimeType().equals("application/vnd.google-apps.folder")) {
                throw new IllegalArgumentException("The mimetype must be of type application/vnd.google-apps.folder");
            }
            return googleApiClient.execute(new zzbu(this, googleApiClient, metadataChangeSet));
        }
        throw new IllegalArgumentException("MetadataChangeSet must be provided.");
    }

    public final PendingResult<DriveApi.MetadataBufferResult> listChildren(GoogleApiClient googleApiClient) {
        return this.queryChildren(googleApiClient, null);
    }

    public final PendingResult<DriveApi.MetadataBufferResult> queryChildren(GoogleApiClient googleApiClient, Query query) {
        return new zzaf().query(googleApiClient, zzbs.zza(query, this.getDriveId()));
    }
}

