/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.webkit.WebView;
import com.google.android.gms.ads.AdInspectorError;
import com.google.android.gms.ads.OnAdInspectorClosedListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzben;
import com.google.android.gms.internal.ads.zzbev;
import com.google.android.gms.internal.ads.zzbex;
import com.google.android.gms.internal.ads.zzbgi;
import com.google.android.gms.internal.ads.zzbgu;
import com.google.android.gms.internal.ads.zzbhq;
import com.google.android.gms.internal.ads.zzbhr;
import com.google.android.gms.internal.ads.zzbht;
import com.google.android.gms.internal.ads.zzbhu;
import com.google.android.gms.internal.ads.zzbip;
import com.google.android.gms.internal.ads.zzbjn;
import com.google.android.gms.internal.ads.zzbrm;
import com.google.android.gms.internal.ads.zzbrt;
import com.google.android.gms.internal.ads.zzbru;
import com.google.android.gms.internal.ads.zzbrv;
import com.google.android.gms.internal.ads.zzbva;
import com.google.android.gms.internal.ads.zzbve;
import com.google.android.gms.internal.ads.zzbvh;
import com.google.android.gms.internal.ads.zzcai;
import com.google.android.gms.internal.ads.zzcfo;
import com.google.android.gms.internal.ads.zzcgl;
import com.google.android.gms.internal.ads.zzcgs;
import com.google.android.gms.internal.ads.zzfkm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;

public final class zzbhv {
    private static zzbhv zzc;
    private final ArrayList<OnInitializationCompleteListener> zza;
    private final Object zzb = new Object();
    private zzbgi zzd;
    private boolean zze = false;
    private boolean zzf = false;
    @Nullable
    private OnAdInspectorClosedListener zzg = null;
    private RequestConfiguration zzh = new RequestConfiguration.Builder().build();
    private InitializationStatus zzi;

    private zzbhv() {
        this.zza = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzbhv zza() {
        synchronized (zzbhv.class) {
            zzbhv zzbhv2;
            if (zzc != null) return zzc;
            zzc = zzbhv2 = new zzbhv();
            return zzc;
        }
    }

    static /* synthetic */ boolean zzq(zzbhv zzbhv2, boolean bl) {
        zzbhv2.zze = false;
        return false;
    }

    static /* synthetic */ boolean zzr(zzbhv zzbhv2, boolean bl) {
        zzbhv2.zzf = true;
        return true;
    }

    static /* synthetic */ InitializationStatus zzs(zzbhv zzbhv2, List list) {
        return zzbhv.zzx(list);
    }

    static /* synthetic */ ArrayList zzt(zzbhv zzbhv2) {
        return zzbhv2.zza;
    }

    static /* synthetic */ OnAdInspectorClosedListener zzu(zzbhv zzbhv2) {
        return zzbhv2.zzg;
    }

    private final void zzv(RequestConfiguration requestConfiguration) {
        try {
            zzbgi zzbgi2 = this.zzd;
            zzbip zzbip2 = new zzbip(requestConfiguration);
            zzbgi2.zzr(zzbip2);
            return;
        }
        catch (RemoteException remoteException) {
            zzcgs.zzg((String)"Unable to set request configuration parcel.", (Throwable)remoteException);
            return;
        }
    }

    private final void zzw(Context context) {
        if (this.zzd == null) {
            this.zzd = (zzbgi)new zzben(zzbev.zzb(), context).zzd(context, false);
        }
    }

    private static final InitializationStatus zzx(List<zzbrm> state) {
        HashMap<String, zzbru> hashMap = new HashMap<String, zzbru>();
        for (zzbrm zzbrm2 : state) {
            String string2 = zzbrm2.zza;
            state = zzbrm2.zzb ? AdapterStatus.State.READY : AdapterStatus.State.NOT_READY;
            hashMap.put(string2, new zzbru(state, zzbrm2.zzd, zzbrm2.zzc));
        }
        return new zzbrv(hashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb(Context object, @Nullable String object2, @Nullable OnInitializationCompleteListener onInitializationCompleteListener) {
        object2 = this.zzb;
        synchronized (object2) {
            block13: {
                if (this.zze) {
                    if (onInitializationCompleteListener != null) {
                        zzbhv.zza().zza.add(onInitializationCompleteListener);
                    }
                    return;
                }
                if (this.zzf) {
                    if (onInitializationCompleteListener != null) {
                        onInitializationCompleteListener.onInitializationComplete(this.zzj());
                    }
                    return;
                }
                this.zze = true;
                if (onInitializationCompleteListener != null) {
                    zzbhv.zza().zza.add(onInitializationCompleteListener);
                }
                if (object == null) {
                    object = new IllegalArgumentException("Context cannot be null.");
                    throw object;
                }
                try {
                    zzbgi zzbgi2;
                    zzbgi zzbgi3;
                    zzbva.zza().zzb(object, null);
                    this.zzw((Context)object);
                    if (onInitializationCompleteListener != null) {
                        zzbgi3 = this.zzd;
                        zzbgi2 = new zzbhu(this, null);
                        zzbgi3.zzp((zzbrt)zzbgi2);
                    }
                    zzbgi2 = this.zzd;
                    zzbgi3 = new zzbve();
                    zzbgi2.zzo((zzbvh)zzbgi3);
                    this.zzd.zze();
                    this.zzd.zzj(null, ObjectWrapper.wrap(null));
                    if (this.zzh.getTagForChildDirectedTreatment() != -1 || this.zzh.getTagForUnderAgeOfConsent() != -1) {
                        this.zzv(this.zzh);
                    }
                    zzbjn.zza((Context)object);
                    object = zzbjn.zzdH;
                    if (((Boolean)zzbex.zzc().zzb(object)).booleanValue() || this.zzh().endsWith("0")) break block13;
                    zzcgs.zzf((String)"Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.");
                    object = new zzbhr(this);
                    this.zzi = object;
                    if (onInitializationCompleteListener != null) {
                        zzbgi2 = zzcgl.zza;
                        object = new zzbhq(this, onInitializationCompleteListener);
                        zzbgi2.post((Runnable)object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzcgs.zzj((String)"MobileAdsSettingManager initialization failed", (Throwable)remoteException);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc(float f2) {
        boolean bl = true;
        boolean bl2 = !(f2 < 0.0f) && f2 <= 1.0f;
        Preconditions.checkArgument(bl2, "The app volume must be a value between 0 and 1 inclusive.");
        Object object = this.zzb;
        synchronized (object) {
            bl2 = this.zzd != null ? bl : false;
            Preconditions.checkState(bl2, "MobileAds.initialize() must be called prior to setting the app volume.");
            try {
                this.zzd.zzf(f2);
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to set app volume.", (Throwable)remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final float zzd() {
        Object object = this.zzb;
        synchronized (object) {
            zzbgi zzbgi2 = this.zzd;
            float f2 = 1.0f;
            if (zzbgi2 == null) {
                return 1.0f;
            }
            try {
                float f3 = zzbgi2.zzk();
                return f3;
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to get app volume.", (Throwable)remoteException);
            }
            return f2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze(boolean bl) {
        Object object = this.zzb;
        synchronized (object) {
            boolean bl2 = this.zzd != null;
            Preconditions.checkState(bl2, "MobileAds.initialize() must be called prior to setting app muted state.");
            try {
                this.zzd.zzh(bl);
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to set app mute state.", (Throwable)remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean zzf() {
        Object object = this.zzb;
        synchronized (object) {
            zzbgi zzbgi2 = this.zzd;
            boolean bl = false;
            if (zzbgi2 == null) {
                return false;
            }
            try {
                boolean bl2 = zzbgi2.zzl();
                return bl2;
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to get app mute state.", (Throwable)remoteException);
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzg(Context context, String string2) {
        Object object = this.zzb;
        synchronized (object) {
            boolean bl = this.zzd != null;
            Preconditions.checkState(bl, "MobileAds.initialize() must be called prior to opening debug menu.");
            try {
                this.zzd.zzi(ObjectWrapper.wrap((Object)context), string2);
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to open debug menu.", (Throwable)remoteException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String zzh() {
        Object object = this.zzb;
        synchronized (object) {
            boolean bl = this.zzd != null;
            Preconditions.checkState(bl, "MobileAds.initialize() must be called prior to getting version string.");
            try {
                return zzfkm.zza(this.zzd.zzm());
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to get version string.", (Throwable)remoteException);
                return "";
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzi(Class<? extends RtbAdapter> clazz) {
        Object object = this.zzb;
        synchronized (object) {
            Throwable throwable2;
            block5: {
                try {
                    try {
                        this.zzd.zzn(clazz.getCanonicalName());
                    }
                    catch (RemoteException remoteException) {
                        zzcgs.zzg((String)"Unable to register RtbAdapter", (Throwable)remoteException);
                    }
                }
                catch (Throwable throwable2) {
                    break block5;
                }
                return;
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InitializationStatus zzj() {
        Object object = this.zzb;
        synchronized (object) {
            InitializationStatus initializationStatus;
            boolean bl = this.zzd != null;
            Preconditions.checkState(bl, "MobileAds.initialize() must be called prior to getting initialization status.");
            try {
                initializationStatus = this.zzi;
                if (initializationStatus == null) return zzbhv.zzx(this.zzd.zzq());
            }
            catch (RemoteException remoteException) {
                zzcgs.zzf((String)"Unable to get Initialization status.");
                return new zzbhr(this);
            }
            return initializationStatus;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzk(Context context) {
        Object object = this.zzb;
        synchronized (object) {
            this.zzw(context);
            try {
                this.zzd.zzs();
            }
            catch (RemoteException remoteException) {
                zzcgs.zzf((String)"Unable to disable mediation adapter initialization.");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzl(Context context, OnAdInspectorClosedListener onAdInspectorClosedListener) {
        Object object = this.zzb;
        synchronized (object) {
            block4: {
                this.zzw(context);
                zzbhv.zza().zzg = onAdInspectorClosedListener;
                try {
                    context = this.zzd;
                    zzbht zzbht2 = new zzbht(null);
                    context.zzt((zzbgu)zzbht2);
                }
                catch (RemoteException remoteException) {
                    zzcgs.zzf((String)"Unable to open the ad inspector.");
                    if (onAdInspectorClosedListener == null) break block4;
                    AdInspectorError adInspectorError = new AdInspectorError(0, "Ad inspector had an internal error.", "com.google.android.gms.ads");
                    onAdInspectorClosedListener.onAdInspectorClosed(adInspectorError);
                }
            }
            return;
        }
    }

    public final RequestConfiguration zzm() {
        return this.zzh;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzn(RequestConfiguration requestConfiguration) {
        boolean bl = requestConfiguration != null;
        Preconditions.checkArgument(bl, "Null passed to setRequestConfiguration.");
        Object object = this.zzb;
        synchronized (object) {
            RequestConfiguration requestConfiguration2 = this.zzh;
            this.zzh = requestConfiguration;
            if (this.zzd == null) {
                return;
            }
            if (requestConfiguration2.getTagForChildDirectedTreatment() != requestConfiguration.getTagForChildDirectedTreatment() || requestConfiguration2.getTagForUnderAgeOfConsent() != requestConfiguration.getTagForUnderAgeOfConsent()) {
                this.zzv(requestConfiguration);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzo(WebView webView) {
        Preconditions.checkMainThread("#008 Must be called on the main UI thread.");
        Object object = this.zzb;
        synchronized (object) {
            if (webView == null) {
                zzcgs.zzf((String)"The webview to be registered cannot be null.");
                return;
            }
            zzcfo zzcfo2 = zzcai.zza((Context)webView.getContext());
            if (zzcfo2 == null) {
                zzcgs.zzi((String)"Internal error, query info generator is null.");
                return;
            }
            try {
                zzcfo2.zzj(ObjectWrapper.wrap((Object)webView));
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"", (Throwable)remoteException);
            }
            return;
        }
    }

    final /* synthetic */ void zzp(OnInitializationCompleteListener onInitializationCompleteListener) {
        onInitializationCompleteListener.onInitializationComplete(this.zzi);
    }
}

