/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzawp;
import com.google.android.gms.internal.ads.zzawu;
import com.google.android.gms.internal.ads.zzaww;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzbex;
import com.google.android.gms.internal.ads.zzbjn;
import com.google.android.gms.internal.ads.zzbku;
import com.google.android.gms.internal.ads.zzcmr;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zzawy
extends Thread {
    private boolean zza;
    private boolean zzb;
    private final Object zzc;
    private final zzawp zzd;
    private final int zze;
    private final int zzf;
    private final int zzg;
    private final int zzh;
    private final int zzi;
    private final int zzj;
    private final int zzk;
    private final int zzl;
    private final String zzm;
    private final boolean zzn;
    private final boolean zzo;
    private final boolean zzp;

    public zzawy() {
        Object object = new zzawp();
        this.zza = false;
        this.zzb = false;
        this.zzd = object;
        this.zzc = new Object();
        this.zzf = ((Long)zzbku.zzd.zze()).intValue();
        this.zzg = ((Long)zzbku.zza.zze()).intValue();
        this.zzh = ((Long)zzbku.zze.zze()).intValue();
        this.zzi = ((Long)zzbku.zzc.zze()).intValue();
        object = zzbjn.zzN;
        this.zzj = (Integer)zzbex.zzc().zzb(object);
        object = zzbjn.zzO;
        this.zzk = (Integer)zzbex.zzc().zzb(object);
        object = zzbjn.zzP;
        this.zzl = (Integer)zzbex.zzc().zzb(object);
        this.zze = ((Long)zzbku.zzf.zze()).intValue();
        object = zzbjn.zzR;
        this.zzm = (String)zzbex.zzc().zzb(object);
        object = zzbjn.zzS;
        this.zzn = (Boolean)zzbex.zzc().zzb(object);
        object = zzbjn.zzT;
        this.zzo = (Boolean)zzbex.zzc().zzb(object);
        object = zzbjn.zzU;
        this.zzp = (Boolean)zzbex.zzc().zzb(object);
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        while (true) {
            var1_1 = zzs.zzf().zze();
            if (var1_1 == null) ** GOTO lbl49
            var2_4 = (ActivityManager)var1_1.getSystemService("activity");
            var3_5 /* !! */  = (KeyguardManager)var1_1.getSystemService("keyguard");
            if (var2_4 == null || var3_5 /* !! */  == null || (var2_4 = var2_4.getRunningAppProcesses()) == null) ** GOTO lbl49
            var2_4 = var2_4.iterator();
            while (var2_4.hasNext()) {
                var4_10 = (ActivityManager.RunningAppProcessInfo)var2_4.next();
                if (Process.myPid() != var4_10.pid) continue;
                if (var4_10.importance != 100 || var3_5 /* !! */ .inKeyguardRestrictedInputMode() || (var3_5 /* !! */  = (PowerManager)var1_1.getSystemService("power")) == null || !(var5_11 = var3_5 /* !! */ .isScreenOn())) ** GOTO lbl49
            }
            ** GOTO lbl49
            {
                ** try [egrp 1[TRYBLOCK] [7, 6 : 131->154)] { 
lbl15:
                // 1 sources

                ** GOTO lbl26
lbl-1000:
                // 1 sources

                {
                    catch (Exception var3_8) {
                        com.google.android.gms.ads.internal.util.zze.zzg((String)"Error in ContentFetchTask", (Throwable)var3_8);
                        zzs.zzg().zzg(var3_8, "ContentFetchTask.run");
                        break;
                    }
lbl20:
                    // 1 sources

                    catch (InterruptedException var3_9) {
                        com.google.android.gms.ads.internal.util.zze.zzg((String)"Error in ContentFetchTask", (Throwable)var3_9);
                        break;
                    }
                    {
                        block22: {
                            block20: {
                                catch (Throwable var3_7) {
                                    zzs.zzg().zzg(var3_7, "ContentFetchTask.isInForeground");
                                    break block20;
                                }
lbl26:
                                // 1 sources

                                var2_4 = zzs.zzf().zzd();
                                if (var2_4 == null) {
                                    com.google.android.gms.ads.internal.util.zze.zzd((String)"ContentFetchThread: no activity. Sleeping.");
                                    this.zzg();
                                    break block22;
                                } else {
                                    block21: {
                                        var1_1 = null;
                                        var3_5 /* !! */  = var1_1;
                                        try {
                                            if (var2_4.getWindow() == null) break block21;
                                            var3_5 /* !! */  = var1_1;
                                            if (var2_4.getWindow().getDecorView() != null) {
                                                var3_5 /* !! */  = var2_4.getWindow().getDecorView().findViewById(0x1020002);
                                            }
                                            break block21;
                                        }
                                        catch (Exception var3_6) {}
                                        zzs.zzg().zzg(var3_6, "ContentFetchTask.extractContent");
                                        com.google.android.gms.ads.internal.util.zze.zzd((String)"Failed getting root view of activity. Content not extracted.");
                                        var3_5 /* !! */  = var1_1;
                                    }
                                    if (var3_5 /* !! */  != null) {
                                        var1_1 = new zzawu(this, (View)var3_5 /* !! */ );
                                        var3_5 /* !! */ .post((Runnable)var1_1);
                                    }
                                }
                                break block22;
                            }
                            com.google.android.gms.ads.internal.util.zze.zzd((String)"ContentFetchTask: sleeping");
                            this.zzg();
                        }
                        Thread.sleep(this.zze * 1000);
                        break;
                    }
                }
            }
            var3_5 /* !! */  = this.zzc;
            synchronized (var3_5 /* !! */ ) {
                while (true) {
                    if (!(var5_11 = this.zzb)) break;
                    try {
                        com.google.android.gms.ads.internal.util.zze.zzd((String)"ContentFetchTask: waiting");
                        this.zzc.wait();
                        continue;
                    }
                    catch (InterruptedException var1_3) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zza() {
        Object object = this.zzc;
        synchronized (object) {
            if (this.zza) {
                com.google.android.gms.ads.internal.util.zze.zzd((String)"Content hash thread already started, quiting...");
                return;
            }
            this.zza = true;
        }
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzb(View view) {
        try {
            zzawo zzawo2 = new zzawo(this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, this.zzo);
            Context context = zzs.zzf().zze();
            if (context != null && !TextUtils.isEmpty((CharSequence)this.zzm)) {
                Resources resources = context.getResources();
                Object object = zzbjn.zzQ;
                object = (String)view.getTag(resources.getIdentifier((String)zzbex.zzc().zzb(object), "id", context.getPackageName()));
                if (object != null && ((String)object).equals(this.zzm)) {
                    return;
                }
            }
            view = this.zzc(view, zzawo2);
            zzawo2.zzk();
            if (view.zza == 0 && view.zzb == 0) {
                return;
            }
            if (view.zzb == 0 && zzawo2.zzo() == 0) {
                return;
            }
            if (view.zzb == 0 && this.zzd.zzb(zzawo2)) {
                return;
            }
            this.zzd.zzd(zzawo2);
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            zzs.zzg().zzg(exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    final zzawx zzc(View view, zzawo zzawo2) {
        if (view == null) {
            return new zzawx(this, 0, 0);
        }
        boolean bl = view.getGlobalVisibleRect(new Rect());
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                zzawo2.zzi(charSequence.toString(), bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzawx(this, 1, 0);
            }
            return new zzawx(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzcmr)) {
            view = (WebView)view;
            if (!PlatformVersion.isAtLeastKitKat()) {
                return new zzawx(this, 0, 0);
            }
            zzawo2.zzg();
            view.post((Runnable)new zzaww(this, zzawo2, (WebView)view, bl));
            return new zzawx(this, 0, 1);
        }
        if (view instanceof ViewGroup) {
            view = (ViewGroup)view;
            int n2 = 0;
            int n3 = 0;
            for (int i2 = 0; i2 < view.getChildCount(); ++i2) {
                zzawx zzawx2 = this.zzc(view.getChildAt(i2), zzawo2);
                n2 += zzawx2.zza;
                n3 += zzawx2.zzb;
            }
            return new zzawx(this, n2, n3);
        }
        return new zzawx(this, 0, 0);
    }

    final void zzd(zzawo zzawo2, WebView webView, String string2, boolean bl) {
        zzawo2.zzf();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                Object object = new JSONObject(string2);
                String string3 = object.optString("text");
                if (!this.zzn && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    string2 = webView.getTitle();
                    int n2 = String.valueOf(string2).length();
                    int n3 = String.valueOf(string3).length();
                    object = new StringBuilder(n2 + 1 + n3);
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("\n");
                    ((StringBuilder)object).append(string3);
                    zzawo2.zzh(((StringBuilder)object).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzawo2.zzh(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzawo2.zza()) {
                this.zzd.zzc(zzawo2);
            }
            return;
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.util.zze.zze((String)"Failed to get webview content.", (Throwable)throwable);
            zzs.zzg().zzg(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.zze.zzd((String)"Json string may be malformed.");
            return;
        }
    }

    public final zzawo zze() {
        return this.zzd.zza(this.zzp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf() {
        Object object = this.zzc;
        synchronized (object) {
            this.zzb = false;
            this.zzc.notifyAll();
            com.google.android.gms.ads.internal.util.zze.zzd((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzg() {
        Object object = this.zzc;
        synchronized (object) {
            this.zzb = true;
            StringBuilder stringBuilder = new StringBuilder(42);
            stringBuilder.append("ContentFetchThread: paused, mPause = ");
            stringBuilder.append(true);
            com.google.android.gms.ads.internal.util.zze.zzd((String)stringBuilder.toString());
            return;
        }
    }

    public final boolean zzh() {
        return this.zzb;
    }
}

