/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.games.video.zzb;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class VideoConfiguration
extends AbstractSafeParcelable {
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new zzb();
    public static final int NUM_CAPTURE_MODE = 2;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int QUALITY_LEVEL_XHD = 2;
    private final int zzmg;
    private final int zzmk;
    private final boolean zzml;
    private final boolean zzmm;
    private final boolean zzmn;

    public VideoConfiguration(int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        Preconditions.checkArgument(VideoConfiguration.isValidQualityLevel(n2, false));
        Preconditions.checkArgument(VideoConfiguration.isValidCaptureMode(n3, false));
        this.zzmk = n2;
        this.zzmg = n3;
        this.zzml = bl;
        this.zzmm = bl2;
        this.zzmn = bl3;
    }

    public static boolean isValidCaptureMode(int n2, boolean bl) {
        if (n2 != -1) {
            if (n2 != 0) {
                if (n2 != 1) {
                    return false;
                }
            } else {
                return true;
            }
        }
        return bl;
    }

    public static boolean isValidQualityLevel(int n2, boolean bl) {
        if (n2 != -1) {
            boolean bl2;
            bl = bl2 = true;
            if (n2 != 0) {
                bl = bl2;
                if (n2 != 1) {
                    bl = bl2;
                    if (n2 != 2) {
                        bl = bl2;
                        if (n2 != 3) {
                            return false;
                        }
                    }
                }
            }
        }
        return bl;
    }

    public final boolean getCameraEnabled() {
        return this.zzmm;
    }

    public final int getCaptureMode() {
        return this.zzmg;
    }

    public final boolean getMicEnabled() {
        return this.zzmn;
    }

    public final int getQualityLevel() {
        return this.zzmk;
    }

    public final void writeToParcel(Parcel parcel, int n2) {
        n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.getQualityLevel());
        SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.getCaptureMode());
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)7, (boolean)this.zzml);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)8, (boolean)this.getCameraEnabled());
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)9, (boolean)this.getMicEnabled());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    public static final class Builder {
        private int zzmg;
        private int zzmk;
        private boolean zzml;
        private boolean zzmm;
        private boolean zzmn;

        public Builder(int n2, int n3) {
            this.zzmk = n2;
            this.zzmg = n3;
            this.zzmm = true;
            this.zzmn = true;
            this.zzml = true;
        }

        public final VideoConfiguration build() {
            return new VideoConfiguration(this.zzmk, this.zzmg, this.zzml, this.zzmm, this.zzmn);
        }

        public final Builder setCameraEnabled(boolean bl) {
            this.zzmm = bl;
            return this;
        }

        public final Builder setCaptureMode(int n2) {
            this.zzmg = n2;
            return this;
        }

        public final Builder setMicEnabled(boolean bl) {
            this.zzmn = bl;
            return this;
        }

        public final Builder setQualityLevel(int n2) {
            this.zzmk = n2;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ValidCaptureModes {
    }
}

