/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Intent;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.games.AnnotatedData;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.tasks.Task;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface SnapshotsClient {
    public static final int DISPLAY_LIMIT_NONE = -1;
    public static final String EXTRA_SNAPSHOT_METADATA = "com.google.android.gms.games.SNAPSHOT_METADATA";
    public static final String EXTRA_SNAPSHOT_NEW = "com.google.android.gms.games.SNAPSHOT_NEW";
    public static final int RESOLUTION_POLICY_HIGHEST_PROGRESS = 4;
    public static final int RESOLUTION_POLICY_LAST_KNOWN_GOOD = 2;
    public static final int RESOLUTION_POLICY_LONGEST_PLAYTIME = 1;
    public static final int RESOLUTION_POLICY_MANUAL = -1;
    public static final int RESOLUTION_POLICY_MOST_RECENTLY_MODIFIED = 3;

    public Task<SnapshotMetadata> commitAndClose(Snapshot var1, SnapshotMetadataChange var2);

    public Task<String> delete(SnapshotMetadata var1);

    public Task<Void> discardAndClose(Snapshot var1);

    public Task<Integer> getMaxCoverImageSize();

    public Task<Integer> getMaxDataSize();

    public Task<Intent> getSelectSnapshotIntent(String var1, boolean var2, boolean var3, int var4);

    public Task<AnnotatedData<SnapshotMetadataBuffer>> load(boolean var1);

    public Task<DataOrConflict<Snapshot>> open(SnapshotMetadata var1);

    public Task<DataOrConflict<Snapshot>> open(SnapshotMetadata var1, int var2);

    public Task<DataOrConflict<Snapshot>> open(String var1, boolean var2);

    public Task<DataOrConflict<Snapshot>> open(String var1, boolean var2, int var3);

    public Task<DataOrConflict<Snapshot>> resolveConflict(String var1, Snapshot var2);

    public Task<DataOrConflict<Snapshot>> resolveConflict(String var1, String var2, SnapshotMetadataChange var3, SnapshotContents var4);

    public static final class DataOrConflict<T> {
        private final T data;
        private final SnapshotConflict zzcf;

        public DataOrConflict(T t2, SnapshotConflict snapshotConflict) {
            this.data = t2;
            this.zzcf = snapshotConflict;
        }

        public final SnapshotConflict getConflict() {
            if (this.isConflict()) {
                return this.zzcf;
            }
            throw new IllegalStateException("getConflict called when there is no conflict.");
        }

        public final T getData() {
            if (!this.isConflict()) {
                return this.data;
            }
            throw new IllegalStateException("getData called when there is a conflict.");
        }

        public final boolean isConflict() {
            return this.zzcf != null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResolutionPolicy {
    }

    public static final class SnapshotConflict {
        private final Snapshot zzcg;
        private final String zzch;
        private final Snapshot zzci;
        private final SnapshotContents zzcj;

        public SnapshotConflict(Snapshot snapshot, String string2, Snapshot snapshot2, SnapshotContents snapshotContents) {
            this.zzcg = snapshot;
            this.zzch = string2;
            this.zzci = snapshot2;
            this.zzcj = snapshotContents;
        }

        public final String getConflictId() {
            return this.zzch;
        }

        public final Snapshot getConflictingSnapshot() {
            return this.zzci;
        }

        public final SnapshotContents getResolutionSnapshotContents() {
            return this.zzcj;
        }

        public final Snapshot getSnapshot() {
            return this.zzcg;
        }
    }

    public static final class SnapshotContentUnavailableApiException
    extends ApiException {
        protected final SnapshotMetadata metadata;

        public SnapshotContentUnavailableApiException(Status status, SnapshotMetadata snapshotMetadata) {
            super(status);
            this.metadata = snapshotMetadata;
        }

        public final SnapshotMetadata getSnapshotMetadata() {
            return this.metadata;
        }
    }
}

