/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.internal.drive.zzaw;

public class ExecutionOptions {
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    private final String zzan;
    private final boolean zzao;
    private final int zzap;

    public ExecutionOptions(String string2, boolean bl, int n2) {
        this.zzan = string2;
        this.zzao = bl;
        this.zzap = n2;
    }

    public static boolean zza(int n2) {
        return n2 == 1;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            if (object == this) {
                return true;
            }
            object = (ExecutionOptions)object;
            if (Objects.equal((Object)this.zzan, (Object)((ExecutionOptions)object).zzan) && this.zzap == ((ExecutionOptions)object).zzap && this.zzao == ((ExecutionOptions)object).zzao) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzan, this.zzap, this.zzao});
    }

    @Deprecated
    public final void zza(GoogleApiClient googleApiClient) {
        this.zza((zzaw)googleApiClient.getClient(Drive.CLIENT_KEY));
    }

    public final void zza(zzaw zzaw2) {
        if (this.zzao && !zzaw2.zzah()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public final String zzl() {
        return this.zzan;
    }

    public final boolean zzm() {
        return this.zzao;
    }

    public final int zzn() {
        return this.zzap;
    }

    public static class Builder {
        protected String zzaq;
        protected boolean zzar;
        protected int zzas = 0;

        public ExecutionOptions build() {
            this.zzo();
            return new ExecutionOptions(this.zzaq, this.zzar, this.zzas);
        }

        public Builder setConflictStrategy(int n2) {
            boolean bl;
            boolean bl2 = bl = true;
            if (n2 != 0) {
                bl2 = bl;
                if (n2 != 1) {
                    bl2 = false;
                }
            }
            if (bl2) {
                this.zzas = n2;
                return this;
            }
            StringBuilder stringBuilder = new StringBuilder(53);
            stringBuilder.append("Unrecognized value for conflict strategy: ");
            stringBuilder.append(n2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.zzar = bl;
            return this;
        }

        public Builder setTrackingTag(String string2) {
            boolean bl = !TextUtils.isEmpty((CharSequence)string2) && string2.length() <= 65536;
            if (bl) {
                this.zzaq = string2;
                return this;
            }
            throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
        }

        protected final void zzo() {
            if (this.zzas == 1 && !this.zzar) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }
    }
}

