/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.wrappers.Wrappers;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class ConnectionTracker {
    private static final Object zzb = new Object();
    @Nullable
    private static volatile ConnectionTracker zzc;
    public ConcurrentHashMap<ServiceConnection, ServiceConnection> zza = new ConcurrentHashMap();

    private ConnectionTracker() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConnectionTracker getInstance() {
        Object object;
        if (zzc == null) {
            object = zzb;
            synchronized (object) {
                if (zzc == null) {
                    ConnectionTracker connectionTracker;
                    zzc = connectionTracker = new ConnectionTracker();
                }
            }
        }
        object = zzc;
        Preconditions.checkNotNull(object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zzb(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n2, boolean bl) {
        block8: {
            ComponentName componentName = intent.getComponent();
            if (componentName != null) {
                String string3 = componentName.getPackageName();
                "com.google.android.gms".equals(string3);
                try {
                    int n3 = Wrappers.packageManager((Context)context).getApplicationInfo((String)string3, (int)0).flags;
                    if ((n3 & 0x200000) == 0) break block8;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                    break block8;
                }
                Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
                return false;
            }
        }
        if (!ConnectionTracker.zzc(serviceConnection)) {
            return context.bindService(intent, serviceConnection, n2);
        }
        ServiceConnection serviceConnection2 = this.zza.putIfAbsent(serviceConnection, serviceConnection);
        if (serviceConnection2 != null && serviceConnection != serviceConnection2) {
            Log.w((String)"ConnectionTracker", (String)String.format("Duplicate binding with the same ServiceConnection: %s, %s, %s.", serviceConnection, string2, intent.getAction()));
        }
        try {
            bl = context.bindService(intent, serviceConnection, n2);
            if (bl) {
                return bl;
            }
            this.zza.remove(serviceConnection, serviceConnection);
            return false;
        }
        catch (Throwable throwable) {
            this.zza.remove(serviceConnection, serviceConnection);
            throw throwable;
        }
    }

    private static boolean zzc(ServiceConnection serviceConnection) {
        return !(serviceConnection instanceof zzr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void zzd(Context context, ServiceConnection serviceConnection) {
        try {
            context.unbindService(serviceConnection);
            return;
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException runtimeException) {
            return;
        }
    }

    public boolean bindService(Context context, Intent intent, ServiceConnection serviceConnection, int n2) {
        return this.zzb(context, context.getClass().getName(), intent, serviceConnection, n2, true);
    }

    public void unbindService(Context context, ServiceConnection serviceConnection) {
        if (ConnectionTracker.zzc(serviceConnection) && this.zza.containsKey(serviceConnection)) {
            try {
                ConnectionTracker.zzd(context, this.zza.get(serviceConnection));
                return;
            }
            finally {
                this.zza.remove(serviceConnection);
            }
        }
        ConnectionTracker.zzd(context, serviceConnection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unbindServiceSafe(Context context, ServiceConnection serviceConnection) {
        try {
            this.unbindService(context, serviceConnection);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n2) {
        return this.zzb(context, string2, intent, serviceConnection, n2, true);
    }
}

