/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.UnsupportedApiCallException;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zabc;
import com.google.android.gms.common.api.internal.zabd;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabf;
import com.google.android.gms.common.api.internal.zabg;
import com.google.android.gms.common.api.internal.zabh;
import com.google.android.gms.common.api.internal.zabj;
import com.google.android.gms.common.api.internal.zabq;
import com.google.android.gms.common.api.internal.zabr;
import com.google.android.gms.common.api.internal.zabu;
import com.google.android.gms.common.api.internal.zabv;
import com.google.android.gms.common.api.internal.zace;
import com.google.android.gms.common.api.internal.zach;
import com.google.android.gms.common.api.internal.zad;
import com.google.android.gms.common.api.internal.zae;
import com.google.android.gms.common.api.internal.zaf;
import com.google.android.gms.common.api.internal.zag;
import com.google.android.gms.common.api.internal.zah;
import com.google.android.gms.common.api.internal.zaj;
import com.google.android.gms.common.api.internal.zap;
import com.google.android.gms.common.api.internal.zav;
import com.google.android.gms.common.api.internal.zay;
import com.google.android.gms.common.api.internal.zaz;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.RootTelemetryConfigManager;
import com.google.android.gms.common.internal.RootTelemetryConfiguration;
import com.google.android.gms.common.internal.service.zaq;
import com.google.android.gms.common.internal.service.zar;
import com.google.android.gms.common.internal.zaaa;
import com.google.android.gms.common.internal.zaac;
import com.google.android.gms.common.internal.zao;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.internal.base.zas;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public class GoogleApiManager
implements Handler.Callback {
    public static final Status zaa = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zab = new Status(4, "The user must be signed in to make this API call.");
    private static final Object zag = new Object();
    private static GoogleApiManager zaj;
    private long zac = 5000L;
    private long zad = 120000L;
    private long zae = 10000L;
    private boolean zaf = false;
    private zaaa zah;
    private zaac zai;
    private final Context zak;
    private final GoogleApiAvailability zal;
    private final com.google.android.gms.common.internal.zaj zam;
    private final AtomicInteger zan = new AtomicInteger(1);
    private final AtomicInteger zao = new AtomicInteger(0);
    private final Map<ApiKey<?>, zaa<?>> zap = new ConcurrentHashMap(5, 0.75f, 1);
    private zay zaq = null;
    private final Set<ApiKey<?>> zar = new ArraySet();
    private final Set<ApiKey<?>> zas = new ArraySet();
    @NotOnlyInitialized
    private final Handler zat;
    private volatile boolean zau = true;

    private GoogleApiManager(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.zak = context;
        this.zat = new zas(looper, (Handler.Callback)this);
        this.zal = googleApiAvailability;
        this.zam = new com.google.android.gms.common.internal.zaj((GoogleApiAvailabilityLight)googleApiAvailability);
        if (DeviceProperties.isAuto((Context)context)) {
            this.zau = false;
        }
        context = this.zat;
        context.sendMessage(context.obtainMessage(6));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void reportSignOut() {
        Object object = zag;
        synchronized (object) {
            if (zaj != null) {
                GoogleApiManager googleApiManager = zaj;
                googleApiManager.zao.incrementAndGet();
                googleApiManager.zat.sendMessageAtFrontOfQueue(googleApiManager.zat.obtainMessage(10));
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GoogleApiManager zaa() {
        Object object = zag;
        synchronized (object) {
            Preconditions.checkNotNull(zaj, "Must guarantee manager is non-null before using getInstance");
            return zaj;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GoogleApiManager zaa(Context object) {
        Object object2 = zag;
        synchronized (object2) {
            GoogleApiManager googleApiManager;
            if (zaj != null) return zaj;
            HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
            handlerThread.start();
            handlerThread = handlerThread.getLooper();
            zaj = googleApiManager = new GoogleApiManager(object.getApplicationContext(), (Looper)handlerThread, GoogleApiAvailability.getInstance());
            return zaj;
        }
    }

    private final <T> void zaa(TaskCompletionSource<T> task2, int n2, GoogleApi<?> zabr2) {
        if (n2 != 0 && (zabr2 = zabr.zaa((GoogleApiManager)this, (int)n2, zabr2.getApiKey())) != null) {
            task2 = task2.getTask();
            Handler handler = this.zat;
            handler.getClass();
            task2.addOnCompleteListener(zabc.zaa((Handler)handler), (OnCompleteListener)zabr2);
        }
    }

    static /* synthetic */ boolean zaa(GoogleApiManager googleApiManager, boolean bl) {
        googleApiManager.zaf = true;
        return true;
    }

    private static Status zab(ApiKey<?> object, ConnectionResult connectionResult) {
        String string2 = object.zaa();
        object = String.valueOf(connectionResult);
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(string2).length() + 63 + String.valueOf(object).length());
        stringBuilder.append("API: ");
        stringBuilder.append(string2);
        stringBuilder.append(" is not available on this device. Connection failed with: ");
        stringBuilder.append((String)object);
        return new Status(connectionResult, stringBuilder.toString());
    }

    private final zaa<?> zac(GoogleApi<?> googleApi) {
        zaa<?> zaa2;
        ApiKey<?> apiKey = googleApi.getApiKey();
        zaa<?> zaa3 = zaa2 = this.zap.get(apiKey);
        if (zaa2 == null) {
            zaa3 = new zaa(googleApi);
            this.zap.put(apiKey, zaa3);
        }
        if (zaa3.zak()) {
            this.zas.add(apiKey);
        }
        zaa3.zai();
        return zaa3;
    }

    private final void zag() {
        zaaa zaaa2 = this.zah;
        if (zaaa2 != null) {
            if (zaaa2.zaa() > 0 || this.zad()) {
                this.zah().zaa(zaaa2);
            }
            this.zah = null;
        }
    }

    private final zaac zah() {
        if (this.zai == null) {
            this.zai = new zaq(this.zak);
        }
        return this.zai;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean handleMessage(Message var1_1) {
        var2_2 = var1_1.what;
        var3_3 = 300000L;
        block0 : switch (var2_2) {
            default: {
                var2_2 = var1_1.what;
                var1_1 = new StringBuilder(31);
                var1_1.append("Unknown message id: ");
                var1_1.append(var2_2);
                Log.w((String)"GoogleApiManager", (String)var1_1.toString());
                return false;
            }
            case 19: {
                this.zaf = false;
                break;
            }
            case 18: {
                var1_1 = (zabq)var1_1.obj;
                if (var1_1.zac == 0L) {
                    var1_1 = new zaaa(var1_1.zab, Arrays.asList(new zao[]{var1_1.zaa}));
                    this.zah().zaa((zaaa)var1_1);
                    break;
                }
                var5_4 /* !! */  = this.zah;
                if (var5_4 /* !! */  != null) {
                    var5_4 /* !! */  = var5_4 /* !! */ .zab();
                    if (this.zah.zaa() == var1_1.zab && (var5_4 /* !! */  == null || var5_4 /* !! */ .size() < var1_1.zad)) {
                        this.zah.zaa(var1_1.zaa);
                    } else {
                        this.zat.removeMessages(17);
                        this.zag();
                    }
                }
                if (this.zah != null) break;
                var5_4 /* !! */  = new ArrayList();
                var5_4 /* !! */ .add(var1_1.zaa);
                this.zah = new zaaa(var1_1.zab, (List<zao>)var5_4 /* !! */ );
                var5_4 /* !! */  = this.zat;
                var5_4 /* !! */ .sendMessageDelayed(var5_4 /* !! */ .obtainMessage(17), var1_1.zac);
                break;
            }
            case 17: {
                this.zag();
                break;
            }
            case 16: {
                var1_1 = (zab)var1_1.obj;
                if (!this.zap.containsKey(com.google.android.gms.common.api.internal.GoogleApiManager$zab.zaa((zab)var1_1))) break;
                com.google.android.gms.common.api.internal.GoogleApiManager$zaa.zab(this.zap.get(com.google.android.gms.common.api.internal.GoogleApiManager$zab.zaa((zab)var1_1)), (zab)var1_1);
                break;
            }
            case 15: {
                var1_1 = (zab)var1_1.obj;
                if (!this.zap.containsKey(com.google.android.gms.common.api.internal.GoogleApiManager$zab.zaa((zab)var1_1))) break;
                com.google.android.gms.common.api.internal.GoogleApiManager$zaa.zaa(this.zap.get(com.google.android.gms.common.api.internal.GoogleApiManager$zab.zaa((zab)var1_1)), (zab)var1_1);
                break;
            }
            case 14: {
                var5_5 = (zaz)var1_1.obj;
                var1_1 = var5_5.zaa();
                if (!this.zap.containsKey(var1_1)) {
                    var5_5.zab().setResult((Object)false);
                    break;
                }
                var6_12 = com.google.android.gms.common.api.internal.GoogleApiManager$zaa.zaa(this.zap.get(var1_1), false);
                var5_5.zab().setResult((Object)var6_12);
                break;
            }
            case 12: {
                if (!this.zap.containsKey(var1_1.obj)) break;
                this.zap.get(var1_1.obj).zah();
                break;
            }
            case 11: {
                if (!this.zap.containsKey(var1_1.obj)) break;
                this.zap.get(var1_1.obj).zag();
                break;
            }
            case 10: {
                for (Object var5_6 : this.zas) {
                    if ((var5_6 = this.zap.remove(var5_6)) == null) continue;
                    var5_6.zaa();
                }
                this.zas.clear();
                break;
            }
            case 9: {
                if (!this.zap.containsKey(var1_1.obj)) break;
                this.zap.get(var1_1.obj).zaf();
                break;
            }
            case 7: {
                this.zac((GoogleApi)var1_1.obj);
                break;
            }
            case 6: {
                if (!(this.zak.getApplicationContext() instanceof Application)) break;
                BackgroundDetector.initialize((Application)this.zak.getApplicationContext());
                BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)new zabd(this));
                if (BackgroundDetector.getInstance().readCurrentStateIfPossible(true)) break;
                this.zae = 300000L;
                break;
            }
            case 5: {
                var2_2 = var1_1.arg1;
                var5_7 = (ConnectionResult)var1_1.obj;
                for (Object var1_1 : this.zap.values()) {
                    if (var1_1.zal() != var2_2) continue;
                    ** GOTO lbl101
                }
                var1_1 = null;
lbl101:
                // 2 sources

                if (var1_1 != null) {
                    if (var5_7.getErrorCode() == 13) {
                        var7_13 = this.zal.getErrorString(var5_7.getErrorCode());
                        var8_17 = var5_7.getErrorMessage();
                        var5_7 = new StringBuilder(String.valueOf(var7_13).length() + 69 + String.valueOf(var8_17).length());
                        var5_7.append("Error resolution was canceled by the user, original error message: ");
                        var5_7.append(var7_13);
                        var5_7.append(": ");
                        var5_7.append(var8_17);
                        com.google.android.gms.common.api.internal.GoogleApiManager$zaa.zaa((zaa)var1_1, new Status(17, var5_7.toString()));
                        break;
                    }
                    com.google.android.gms.common.api.internal.GoogleApiManager$zaa.zaa((zaa)var1_1, GoogleApiManager.zab(com.google.android.gms.common.api.internal.GoogleApiManager$zaa.zaa((zaa)var1_1), (ConnectionResult)var5_7));
                    break;
                }
                var1_1 = new StringBuilder(76);
                var1_1.append("Could not find API instance ");
                var1_1.append(var2_2);
                var1_1.append(" while trying to fail enqueued calls.");
                Log.wtf((String)"GoogleApiManager", (String)var1_1.toString(), (Throwable)new Exception());
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                var7_14 = (zabu)var1_1.obj;
                var5_8 = this.zap.get(var7_14.zac.getApiKey());
                var1_1 = var5_8;
                if (var5_8 == null) {
                    var1_1 = this.zac(var7_14.zac);
                }
                if (var1_1.zak() && this.zao.get() != var7_14.zab) {
                    var7_14.zaa.zaa(GoogleApiManager.zaa);
                    var1_1.zaa();
                    break;
                }
                var1_1.zaa(var7_14.zaa);
                break;
            }
            case 3: {
                for (Object var1_1 : this.zap.values()) {
                    var1_1.zad();
                    var1_1.zai();
                }
                break;
            }
            case 2: {
                var1_1 = (zaj)var1_1.obj;
                for (ApiKey<?> var7_15 : var1_1.zaa()) {
                    var9_19 = this.zap.get(var7_15);
                    if (var9_19 == null) {
                        var1_1.zaa(var7_15, new ConnectionResult(13), null);
                        break block0;
                    }
                    if (var9_19.zaj()) {
                        var1_1.zaa(var7_15, ConnectionResult.RESULT_SUCCESS, var9_19.zab().getEndpointPackageName());
                        continue;
                    }
                    var8_18 = var9_19.zae();
                    if (var8_18 != null) {
                        var1_1.zaa(var7_15, var8_18, null);
                        continue;
                    }
                    var9_19.zaa((zaj)var1_1);
                    var9_19.zai();
                }
                break;
            }
            case 1: {
                if (((Boolean)var1_1.obj).booleanValue()) {
                    var3_3 = 10000L;
                }
                this.zae = var3_3;
                this.zat.removeMessages(12);
                for (ApiKey var5_11 : this.zap.keySet()) {
                    var7_16 = this.zat;
                    var7_16.sendMessageDelayed(var7_16.obtainMessage(12, (Object)var5_11), this.zae);
                }
            }
        }
        return true;
    }

    final zaa zaa(ApiKey<?> apiKey) {
        return this.zap.get(apiKey);
    }

    public final <O extends Api.ApiOptions> Task<Boolean> zaa(GoogleApi<O> googleApi, ListenerHolder.ListenerKey<?> handler, int n2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zaa(taskCompletionSource, n2, googleApi);
        zag zag2 = new zag(handler, taskCompletionSource);
        handler = this.zat;
        handler.sendMessage(handler.obtainMessage(13, (Object)new zabu((com.google.android.gms.common.api.internal.zab)zag2, this.zao.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Void> zaa(GoogleApi<O> googleApi, RegisterListenerMethod<Api.AnyClient, ?> handler, UnregisterListenerMethod<Api.AnyClient, ?> zae2, Runnable runnable2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zaa(taskCompletionSource, handler.zab(), googleApi);
        zae2 = new zae(new zabv(handler, zae2, runnable2), taskCompletionSource);
        handler = this.zat;
        handler.sendMessage(handler.obtainMessage(8, (Object)new zabu((com.google.android.gms.common.api.internal.zab)zae2, this.zao.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final Task<Map<ApiKey<?>, String>> zaa(Iterable<? extends HasApiKey<?>> object) {
        object = new zaj((Iterable<? extends HasApiKey<?>>)object);
        Handler handler = this.zat;
        handler.sendMessage(handler.obtainMessage(2, object));
        return ((zaj)object).zab();
    }

    public final void zaa(GoogleApi<?> googleApi) {
        Handler handler = this.zat;
        handler.sendMessage(handler.obtainMessage(7, googleApi));
    }

    public final <O extends Api.ApiOptions> void zaa(GoogleApi<O> googleApi, int n2, BaseImplementation.ApiMethodImpl<? extends Result, Api.AnyClient> handler) {
        zaf zaf2 = new zaf(n2, handler);
        handler = this.zat;
        handler.sendMessage(handler.obtainMessage(4, (Object)new zabu((com.google.android.gms.common.api.internal.zab)zaf2, this.zao.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, ResultT> void zaa(GoogleApi<O> googleApi, int n2, TaskApiCall<Api.AnyClient, ResultT> zah2, TaskCompletionSource<ResultT> handler, StatusExceptionMapper statusExceptionMapper) {
        this.zaa((TaskCompletionSource)handler, zah2.zab(), googleApi);
        zah2 = new zah(n2, zah2, handler, statusExceptionMapper);
        handler = this.zat;
        handler.sendMessage(handler.obtainMessage(4, (Object)new zabu((com.google.android.gms.common.api.internal.zab)zah2, this.zao.get(), googleApi)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zaa(zay zay2) {
        Object object = zag;
        synchronized (object) {
            if (this.zaq != zay2) {
                this.zaq = zay2;
                this.zar.clear();
            }
            this.zar.addAll((Collection<ApiKey<?>>)zay2.zac());
            return;
        }
    }

    final void zaa(zao zao2, int n2, long l2, int n3) {
        Handler handler = this.zat;
        handler.sendMessage(handler.obtainMessage(18, (Object)new zabq(zao2, n2, l2, n3)));
    }

    final boolean zaa(ConnectionResult connectionResult, int n2) {
        return this.zal.zaa(this.zak, connectionResult, n2);
    }

    public final int zab() {
        return this.zan.getAndIncrement();
    }

    public final Task<Boolean> zab(GoogleApi<?> handler) {
        zaz zaz2 = new zaz(handler.getApiKey());
        handler = this.zat;
        handler.sendMessage(handler.obtainMessage(14, (Object)zaz2));
        return zaz2.zab().getTask();
    }

    public final void zab(ConnectionResult connectionResult, int n2) {
        if (!this.zaa(connectionResult, n2)) {
            Handler handler = this.zat;
            handler.sendMessage(handler.obtainMessage(5, n2, 0, (Object)connectionResult));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zab(zay zay2) {
        Object object = zag;
        synchronized (object) {
            if (this.zaq == zay2) {
                this.zaq = null;
                this.zar.clear();
            }
            return;
        }
    }

    public final void zac() {
        Handler handler = this.zat;
        handler.sendMessage(handler.obtainMessage(3));
    }

    final boolean zad() {
        if (this.zaf) {
            return false;
        }
        RootTelemetryConfiguration rootTelemetryConfiguration = RootTelemetryConfigManager.getInstance().getConfig();
        if (rootTelemetryConfiguration != null && !rootTelemetryConfiguration.getMethodInvocationTelemetryEnabled()) {
            return false;
        }
        int n2 = this.zam.zaa(this.zak, 203390000);
        return n2 == -1 || n2 == 0;
        {
        }
    }

    public final class zaa<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener,
    zap {
        private final Queue<com.google.android.gms.common.api.internal.zab> zab = new LinkedList<com.google.android.gms.common.api.internal.zab>();
        @NotOnlyInitialized
        private final Api.Client zac;
        private final ApiKey<O> zad;
        private final zav zae;
        private final Set<zaj> zaf = new HashSet<zaj>();
        private final Map<ListenerHolder.ListenerKey<?>, zabv> zag = new HashMap();
        private final int zah;
        private final zace zai;
        private boolean zaj;
        private final List<zab> zak = new ArrayList<zab>();
        private ConnectionResult zal = null;
        private int zam = 0;

        public zaa(GoogleApi<O> googleApi) {
            this.zac = googleApi.zaa(GoogleApiManager.this.zat.getLooper(), this);
            this.zad = googleApi.getApiKey();
            this.zae = new zav();
            this.zah = googleApi.zaa();
            if (this.zac.requiresSignIn()) {
                this.zai = googleApi.zaa(GoogleApiManager.this.zak, GoogleApiManager.this.zat);
                return;
            }
            this.zai = null;
        }

        private final Feature zaa(Feature[] featureArray) {
            if (featureArray != null && featureArray.length != 0) {
                ArrayMap arrayMap = this.zac.getAvailableFeatures();
                int n2 = 0;
                Object object = arrayMap;
                if (arrayMap == null) {
                    object = new Feature[]{};
                }
                arrayMap = new ArrayMap(((Feature[])object).length);
                for (ArrayMap arrayMap2 : object) {
                    arrayMap.put(arrayMap2.getName(), arrayMap2.getVersion());
                }
                int n3 = featureArray.length;
                for (int i2 = n2; i2 < n3; ++i2) {
                    ArrayMap arrayMap2;
                    arrayMap2 = featureArray[i2];
                    object = (Long)arrayMap.get(arrayMap2.getName());
                    if (object != null && (Long)object >= arrayMap2.getVersion()) {
                        continue;
                    }
                    return arrayMap2;
                }
            }
            return null;
        }

        static /* synthetic */ ApiKey zaa(zaa zaa2) {
            return zaa2.zad;
        }

        private final void zaa(int n2) {
            this.zad();
            this.zaj = true;
            this.zae.zaa(n2, this.zac.getLastDisconnectMessage());
            GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zat, (int)9, this.zad), GoogleApiManager.this.zac);
            GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zat, (int)11, this.zad), GoogleApiManager.this.zad);
            GoogleApiManager.this.zam.zaa();
            Iterator<zabv> iterator2 = this.zag.values().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().zac.run();
            }
        }

        private final void zaa(ConnectionResult connectionResult, Exception exception) {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            zace zace2 = this.zai;
            if (zace2 != null) {
                zace2.zaa();
            }
            this.zad();
            GoogleApiManager.this.zam.zaa();
            this.zac(connectionResult);
            if (this.zac instanceof zar) {
                GoogleApiManager.zaa(GoogleApiManager.this, true);
                GoogleApiManager.this.zat.sendMessageDelayed(GoogleApiManager.this.zat.obtainMessage(19), 300000L);
            }
            if (connectionResult.getErrorCode() == 4) {
                this.zaa(zab);
                return;
            }
            if (this.zab.isEmpty()) {
                this.zal = connectionResult;
                return;
            }
            if (exception != null) {
                Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
                this.zaa(null, exception, false);
                return;
            }
            if (!GoogleApiManager.this.zau) {
                this.zaa(this.zad(connectionResult));
                return;
            }
            this.zaa(this.zad(connectionResult), null, true);
            if (this.zab.isEmpty()) {
                return;
            }
            if (this.zab(connectionResult)) {
                return;
            }
            if (!GoogleApiManager.this.zaa(connectionResult, this.zah)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zaj = true;
                }
                if (this.zaj) {
                    GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zat, (int)9, this.zad), GoogleApiManager.this.zac);
                    return;
                }
                this.zaa(this.zad(connectionResult));
            }
        }

        private final void zaa(Status status) {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            this.zaa(status, null, false);
        }

        private final void zaa(Status object, Exception exception, boolean bl) {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            boolean bl2 = true;
            boolean bl3 = object == null;
            if (exception != null) {
                bl2 = false;
            }
            if (bl3 != bl2) {
                Iterator iterator2 = this.zab.iterator();
                while (iterator2.hasNext()) {
                    com.google.android.gms.common.api.internal.zab zab2 = (com.google.android.gms.common.api.internal.zab)iterator2.next();
                    if (bl && zab2.zaa != 2) continue;
                    if (object != null) {
                        zab2.zaa(object);
                    } else {
                        zab2.zaa(exception);
                    }
                    iterator2.remove();
                }
                return;
            }
            object = new IllegalArgumentException("Status XOR exception should be null");
            throw object;
        }

        static /* synthetic */ void zaa(zaa zaa2, int n2) {
            zaa2.zaa(n2);
        }

        static /* synthetic */ void zaa(zaa zaa2, Status status) {
            zaa2.zaa(status);
        }

        static /* synthetic */ void zaa(zaa zaa2, zab zab2) {
            zaa2.zaa(zab2);
        }

        private final void zaa(zab zab2) {
            if (!this.zak.contains(zab2)) {
                return;
            }
            if (!this.zaj) {
                if (!this.zac.isConnected()) {
                    this.zai();
                    return;
                }
                this.zap();
            }
        }

        static /* synthetic */ boolean zaa(zaa zaa2, boolean bl) {
            return zaa2.zaa(false);
        }

        private final boolean zaa(boolean bl) {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            if (this.zac.isConnected() && this.zag.size() == 0) {
                if (this.zae.zaa()) {
                    if (bl) {
                        this.zar();
                    }
                    return false;
                }
                this.zac.disconnect("Timing out service connection.");
                return true;
            }
            return false;
        }

        static /* synthetic */ void zab(zaa zaa2) {
            zaa2.zao();
        }

        static /* synthetic */ void zab(zaa zaa2, zab zab2) {
            zaa2.zab(zab2);
        }

        private final void zab(zab zab2) {
            if (this.zak.remove(zab2)) {
                GoogleApiManager.this.zat.removeMessages(15, (Object)zab2);
                GoogleApiManager.this.zat.removeMessages(16, (Object)zab2);
                zab2 = zab2.zab;
                ArrayList<com.google.android.gms.common.api.internal.zab> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zab>(this.zab.size());
                for (Object object : this.zab) {
                    Object[] objectArray;
                    if (!(object instanceof zad) || (objectArray = ((zad)object).zac(this)) == null || !ArrayUtils.contains((Object[])objectArray, (Object)zab2)) continue;
                    arrayList.add((com.google.android.gms.common.api.internal.zab)object);
                }
                ArrayList<com.google.android.gms.common.api.internal.zab> arrayList2 = arrayList;
                int n2 = arrayList2.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object;
                    object = arrayList2.get(i2);
                    this.zab.remove(object);
                    object.zaa((Exception)new UnsupportedApiCallException((Feature)zab2));
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final boolean zab(ConnectionResult connectionResult) {
            Object object = zag;
            synchronized (object) {
                if (GoogleApiManager.this.zaq != null && GoogleApiManager.this.zar.contains(this.zad)) {
                    GoogleApiManager.this.zaq.zab(connectionResult, this.zah);
                    return true;
                }
                return false;
            }
        }

        private final boolean zab(com.google.android.gms.common.api.internal.zab object) {
            if (!(object instanceof zad)) {
                this.zac((com.google.android.gms.common.api.internal.zab)object);
                return true;
            }
            zad zad2 = (zad)object;
            Feature feature = this.zaa(zad2.zac(this));
            if (feature == null) {
                this.zac((com.google.android.gms.common.api.internal.zab)object);
                return true;
            }
            String string2 = this.zac.getClass().getName();
            String string3 = feature.getName();
            long l2 = feature.getVersion();
            object = new StringBuilder(String.valueOf(string2).length() + 77 + String.valueOf(string3).length());
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" could not execute call because it requires feature (");
            ((StringBuilder)object).append(string3);
            ((StringBuilder)object).append(", ");
            ((StringBuilder)object).append(l2);
            ((StringBuilder)object).append(").");
            Log.w((String)"GoogleApiManager", (String)((StringBuilder)object).toString());
            if (GoogleApiManager.this.zau && zad2.zad(this)) {
                object = new zab(this.zad, feature, null);
                int n2 = this.zak.indexOf(object);
                if (n2 >= 0) {
                    object = this.zak.get(n2);
                    GoogleApiManager.this.zat.removeMessages(15, object);
                    GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zat, (int)15, (Object)object), GoogleApiManager.this.zac);
                } else {
                    this.zak.add((zab)object);
                    GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zat, (int)15, (Object)object), GoogleApiManager.this.zac);
                    GoogleApiManager.this.zat.sendMessageDelayed(Message.obtain((Handler)GoogleApiManager.this.zat, (int)16, (Object)object), GoogleApiManager.this.zad);
                    object = new ConnectionResult(2, null);
                    if (!this.zab((ConnectionResult)object)) {
                        GoogleApiManager.this.zaa((ConnectionResult)object, this.zah);
                    }
                }
                return false;
            }
            zad2.zaa((Exception)new UnsupportedApiCallException(feature));
            return true;
        }

        static /* synthetic */ Api.Client zac(zaa zaa2) {
            return zaa2.zac;
        }

        private final void zac(ConnectionResult connectionResult) {
            for (zaj zaj2 : this.zaf) {
                String string2 = null;
                if (Objects.equal((Object)connectionResult, (Object)ConnectionResult.RESULT_SUCCESS)) {
                    string2 = this.zac.getEndpointPackageName();
                }
                zaj2.zaa(this.zad, connectionResult, string2);
            }
            this.zaf.clear();
        }

        private final void zac(com.google.android.gms.common.api.internal.zab zab2) {
            zab2.zaa(this.zae, this.zak());
            try {
                zab2.zaa(this);
                return;
            }
            catch (Throwable throwable) {
                throw new IllegalStateException(String.format("Error in GoogleApi implementation for client %s.", this.zac.getClass().getName()), throwable);
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zac.disconnect("DeadObjectException thrown while running ApiCallRunner.");
                return;
            }
        }

        private final Status zad(ConnectionResult connectionResult) {
            return GoogleApiManager.zab(this.zad, connectionResult);
        }

        private final void zao() {
            this.zad();
            this.zac(ConnectionResult.RESULT_SUCCESS);
            this.zaq();
            Iterator<zabv> iterator2 = this.zag.values().iterator();
            while (iterator2.hasNext()) {
                zabv zabv2 = iterator2.next();
                if (this.zaa(zabv2.zaa.getRequiredFeatures()) != null) {
                    iterator2.remove();
                    continue;
                }
                try {
                    zabv2 = zabv2.zaa;
                    Api.Client client = this.zac;
                    TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
                    zabv2.registerListener((Api.AnyClient)client, taskCompletionSource);
                }
                catch (RemoteException remoteException) {
                    iterator2.remove();
                }
                catch (DeadObjectException deadObjectException) {
                    this.onConnectionSuspended(3);
                    this.zac.disconnect("DeadObjectException thrown while calling register listener method.");
                    break;
                }
            }
            this.zap();
            this.zar();
        }

        private final void zap() {
            ArrayList<com.google.android.gms.common.api.internal.zab> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zab>(this.zab);
            int n2 = arrayList.size();
            int n3 = 0;
            while (n3 < n2) {
                com.google.android.gms.common.api.internal.zab zab2 = arrayList.get(n3);
                int n4 = n3 + 1;
                if (!this.zac.isConnected()) break;
                n3 = n4;
                if (!this.zab(zab2)) continue;
                this.zab.remove(zab2);
                n3 = n4;
            }
        }

        private final void zaq() {
            if (this.zaj) {
                GoogleApiManager.this.zat.removeMessages(11, this.zad);
                GoogleApiManager.this.zat.removeMessages(9, this.zad);
                this.zaj = false;
            }
        }

        private final void zar() {
            GoogleApiManager.this.zat.removeMessages(12, this.zad);
            GoogleApiManager.this.zat.sendMessageDelayed(GoogleApiManager.this.zat.obtainMessage(12, this.zad), GoogleApiManager.this.zae);
        }

        @Override
        public final void onConnected(Bundle bundle) {
            if (Looper.myLooper() == GoogleApiManager.this.zat.getLooper()) {
                this.zao();
                return;
            }
            GoogleApiManager.this.zat.post((Runnable)new zabf(this));
        }

        @Override
        public final void onConnectionFailed(ConnectionResult connectionResult) {
            this.zaa(connectionResult, null);
        }

        @Override
        public final void onConnectionSuspended(int n2) {
            if (Looper.myLooper() == GoogleApiManager.this.zat.getLooper()) {
                this.zaa(n2);
                return;
            }
            GoogleApiManager.this.zat.post((Runnable)new zabe(this, n2));
        }

        public final void zaa() {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            this.zaa(zaa);
            this.zae.zab();
            ListenerHolder.ListenerKey[] listenerKeyArray = this.zag.keySet();
            listenerKeyArray = listenerKeyArray.toArray(new ListenerHolder.ListenerKey[0]);
            int n2 = listenerKeyArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.zaa((com.google.android.gms.common.api.internal.zab)new zag(listenerKeyArray[i2], new TaskCompletionSource()));
            }
            this.zac(new ConnectionResult(4));
            if (this.zac.isConnected()) {
                this.zac.onUserSignOut((BaseGmsClient.SignOutCallbacks)new zabg(this));
            }
        }

        public final void zaa(ConnectionResult connectionResult) {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            Api.Client client = this.zac;
            String string2 = client.getClass().getName();
            String string3 = String.valueOf(connectionResult);
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(string2).length() + 25 + String.valueOf(string3).length());
            stringBuilder.append("onSignInFailed for ");
            stringBuilder.append(string2);
            stringBuilder.append(" with ");
            stringBuilder.append(string3);
            client.disconnect(stringBuilder.toString());
            this.onConnectionFailed(connectionResult);
        }

        @Override
        public final void zaa(ConnectionResult connectionResult, Api<?> api, boolean bl) {
            if (Looper.myLooper() == GoogleApiManager.this.zat.getLooper()) {
                this.onConnectionFailed(connectionResult);
                return;
            }
            GoogleApiManager.this.zat.post((Runnable)new zabh(this, connectionResult));
        }

        public final void zaa(com.google.android.gms.common.api.internal.zab zab2) {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            if (this.zac.isConnected()) {
                if (this.zab(zab2)) {
                    this.zar();
                    return;
                }
                this.zab.add(zab2);
                return;
            }
            this.zab.add(zab2);
            zab2 = this.zal;
            if (zab2 != null && zab2.hasResolution()) {
                this.onConnectionFailed(this.zal);
                return;
            }
            this.zai();
        }

        public final void zaa(zaj zaj2) {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            this.zaf.add(zaj2);
        }

        public final Api.Client zab() {
            return this.zac;
        }

        public final Map<ListenerHolder.ListenerKey<?>, zabv> zac() {
            return this.zag;
        }

        public final void zad() {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            this.zal = null;
        }

        public final ConnectionResult zae() {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            return this.zal;
        }

        public final void zaf() {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            if (this.zaj) {
                this.zai();
            }
        }

        public final void zag() {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            if (this.zaj) {
                this.zaq();
                Status status = GoogleApiManager.this.zal.isGooglePlayServicesAvailable(GoogleApiManager.this.zak) == 18 ? new Status(21, "Connection timed out waiting for Google Play services update to complete.") : new Status(22, "API failed to connect while resuming due to an unknown error.");
                this.zaa(status);
                this.zac.disconnect("Timing out connection while resuming.");
            }
        }

        public final boolean zah() {
            return this.zaa(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void zai() {
            Preconditions.checkHandlerThread(GoogleApiManager.this.zat);
            if (this.zac.isConnected()) return;
            if (this.zac.isConnecting()) {
                return;
            }
            try {
                int n2 = GoogleApiManager.this.zam.zaa(GoogleApiManager.this.zak, this.zac);
                if (n2 != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(n2, null);
                    String string2 = this.zac.getClass().getName();
                    String string3 = String.valueOf(connectionResult);
                    int n3 = String.valueOf(string2).length();
                    n2 = String.valueOf(string3).length();
                    StringBuilder stringBuilder = new StringBuilder(n3 + 35 + n2);
                    stringBuilder.append("The service for ");
                    stringBuilder.append(string2);
                    stringBuilder.append(" is not available: ");
                    stringBuilder.append(string3);
                    Log.w((String)"GoogleApiManager", (String)stringBuilder.toString());
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.zaa(new ConnectionResult(10), illegalStateException);
                return;
            }
            zac zac2 = new zac(this.zac, this.zad);
            if (this.zac.requiresSignIn()) {
                Preconditions.checkNotNull(this.zai).zaa((zach)zac2);
            }
            try {
                this.zac.connect(zac2);
                return;
            }
            catch (SecurityException securityException) {
                this.zaa(new ConnectionResult(10), securityException);
                return;
            }
        }

        final boolean zaj() {
            return this.zac.isConnected();
        }

        public final boolean zak() {
            return this.zac.requiresSignIn();
        }

        public final int zal() {
            return this.zah;
        }

        final int zam() {
            return this.zam;
        }

        final void zan() {
            ++this.zam;
        }
    }

    private static final class zab {
        private final ApiKey<?> zaa;
        private final Feature zab;

        private zab(ApiKey<?> apiKey, Feature feature) {
            this.zaa = apiKey;
            this.zab = feature;
        }

        /* synthetic */ zab(ApiKey apiKey, Feature feature, zabd zabd2) {
            this(apiKey, feature);
        }

        static /* synthetic */ ApiKey zaa(zab zab2) {
            return zab2.zaa;
        }

        public final boolean equals(Object object) {
            if (object != null && object instanceof zab) {
                object = (zab)object;
                if (Objects.equal(this.zaa, ((zab)object).zaa) && Objects.equal((Object)this.zab, (Object)((zab)object).zab)) {
                    return true;
                }
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zaa, this.zab});
        }

        public final String toString() {
            return Objects.toStringHelper((Object)this).add("key", this.zaa).add("feature", (Object)this.zab).toString();
        }
    }

    private final class zac
    implements zach,
    BaseGmsClient.ConnectionProgressReportCallbacks {
        private final Api.Client zab;
        private final ApiKey<?> zac;
        private IAccountAccessor zad = null;
        private Set<Scope> zae = null;
        private boolean zaf = false;

        public zac(Api.Client client, ApiKey<?> apiKey) {
            this.zab = client;
            this.zac = apiKey;
        }

        static /* synthetic */ ApiKey zaa(zac zac2) {
            return zac2.zac;
        }

        private final void zaa() {
            IAccountAccessor iAccountAccessor;
            if (this.zaf && (iAccountAccessor = this.zad) != null) {
                this.zab.getRemoteService(iAccountAccessor, this.zae);
            }
        }

        static /* synthetic */ boolean zaa(zac zac2, boolean bl) {
            zac2.zaf = true;
            return true;
        }

        static /* synthetic */ Api.Client zab(zac zac2) {
            return zac2.zab;
        }

        static /* synthetic */ void zac(zac zac2) {
            zac2.zaa();
        }

        public final void onReportServiceBinding(ConnectionResult connectionResult) {
            GoogleApiManager.this.zat.post((Runnable)new zabj(this, connectionResult));
        }

        public final void zaa(ConnectionResult connectionResult) {
            zaa zaa2 = (zaa)GoogleApiManager.this.zap.get(this.zac);
            if (zaa2 != null) {
                zaa2.zaa(connectionResult);
            }
        }

        public final void zaa(IAccountAccessor iAccountAccessor, Set<Scope> set) {
            if (iAccountAccessor != null && set != null) {
                this.zad = iAccountAccessor;
                this.zae = set;
                this.zaa();
                return;
            }
            Log.wtf((String)"GoogleApiManager", (String)"Received null response from onSignInSuccess", (Throwable)new Exception());
            this.zaa(new ConnectionResult(4));
        }
    }
}

