/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiActivity;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.HasApiKey;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.ApiKey;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.NonGmsServiceBrokerClient;
import com.google.android.gms.common.api.internal.RegisterListenerMethod;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.api.internal.UnregisterListenerMethod;
import com.google.android.gms.common.api.internal.zabl;
import com.google.android.gms.common.api.internal.zace;
import com.google.android.gms.common.api.internal.zay;
import com.google.android.gms.common.api.zac;
import com.google.android.gms.common.api.zad;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public class GoogleApi<O extends Api.ApiOptions>
implements HasApiKey<O> {
    private final Context zaa;
    private final String zab;
    private final Api<O> zac;
    private final O zad;
    private final ApiKey<O> zae;
    private final Looper zaf;
    private final int zag;
    @NotOnlyInitialized
    private final GoogleApiClient zah;
    private final StatusExceptionMapper zai;
    private final GoogleApiManager zaj;

    public GoogleApi(Activity activity, Api<O> api, O o2, Settings settings) {
        Preconditions.checkNotNull(activity, "Null activity is not permitted.");
        Preconditions.checkNotNull(api, "Api must not be null.");
        Preconditions.checkNotNull(settings, "Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.zaa = activity.getApplicationContext();
        this.zab = GoogleApi.zaa(activity);
        this.zac = api;
        this.zad = o2;
        this.zaf = settings.zab;
        this.zae = ApiKey.zaa(this.zac, this.zad, (String)this.zab);
        this.zah = new zabl(this);
        this.zaj = GoogleApiManager.zaa(this.zaa);
        this.zag = this.zaj.zab();
        this.zai = settings.zaa;
        if (!(activity instanceof GoogleApiActivity) && Looper.myLooper() == Looper.getMainLooper()) {
            zay.zaa(activity, this.zaj, this.zae);
        }
        this.zaj.zaa(this);
    }

    @Deprecated
    public GoogleApi(Activity activity, Api<O> api, O o2, StatusExceptionMapper statusExceptionMapper) {
        this(activity, api, o2, new Settings.Builder().setMapper(statusExceptionMapper).setLooper(activity.getMainLooper()).build());
    }

    @Deprecated
    public GoogleApi(Context context, Api<O> api, O o2, Looper looper, StatusExceptionMapper statusExceptionMapper) {
        this(context, api, o2, new Settings.Builder().setLooper(looper).setMapper(statusExceptionMapper).build());
    }

    public GoogleApi(Context context, Api<O> api, O o2, Settings settings) {
        Preconditions.checkNotNull(context, "Null context is not permitted.");
        Preconditions.checkNotNull(api, "Api must not be null.");
        Preconditions.checkNotNull(settings, "Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.zaa = context.getApplicationContext();
        this.zab = GoogleApi.zaa(context);
        this.zac = api;
        this.zad = o2;
        this.zaf = settings.zab;
        this.zae = ApiKey.zaa(this.zac, this.zad, (String)this.zab);
        this.zah = new zabl(this);
        this.zaj = GoogleApiManager.zaa(this.zaa);
        this.zag = this.zaj.zab();
        this.zai = settings.zaa;
        this.zaj.zaa(this);
    }

    @Deprecated
    public GoogleApi(Context context, Api<O> api, O o2, StatusExceptionMapper statusExceptionMapper) {
        this(context, api, o2, new Settings.Builder().setMapper(statusExceptionMapper).build());
    }

    private final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T zaa(int n2, T t2) {
        t2.zab();
        this.zaj.zaa(this, n2, t2);
        return t2;
    }

    private final <TResult, A extends Api.AnyClient> Task<TResult> zaa(int n2, TaskApiCall<A, TResult> taskApiCall) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zaj.zaa(this, n2, taskApiCall, taskCompletionSource, this.zai);
        return taskCompletionSource.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String zaa(Object object) {
        if (!PlatformVersion.isAtLeastR()) return null;
        try {
            return (String)Context.class.getMethod("getAttributionTag", new Class[0]).invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public GoogleApiClient asGoogleApiClient() {
        return this.zah;
    }

    protected ClientSettings.Builder createClientSettingsBuilder() {
        ClientSettings.Builder builder = new ClientSettings.Builder();
        Object object = this.zad;
        object = object instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (object = ((Api.ApiOptions.HasGoogleSignInAccountOptions)object).getGoogleSignInAccount()) != null ? object.getAccount() : ((object = this.zad) instanceof Api.ApiOptions.HasAccountOptions ? ((Api.ApiOptions.HasAccountOptions)object).getAccount() : null);
        builder = builder.zaa((Account)object);
        object = this.zad;
        object = object instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (object = ((Api.ApiOptions.HasGoogleSignInAccountOptions)object).getGoogleSignInAccount()) != null ? object.getRequestedScopes() : Collections.emptySet();
        return builder.zaa((Collection<Scope>)object).zaa(this.zaa.getClass().getName()).setRealClientPackageName(this.zaa.getPackageName());
    }

    protected Task<Boolean> disconnectService() {
        return this.zaj.zab(this);
    }

    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doBestEffortWrite(T t2) {
        return this.zaa(2, t2);
    }

    public <TResult, A extends Api.AnyClient> Task<TResult> doBestEffortWrite(TaskApiCall<A, TResult> taskApiCall) {
        return this.zaa(2, taskApiCall);
    }

    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doRead(T t2) {
        return this.zaa(0, t2);
    }

    public <TResult, A extends Api.AnyClient> Task<TResult> doRead(TaskApiCall<A, TResult> taskApiCall) {
        return this.zaa(0, taskApiCall);
    }

    @Deprecated
    public <A extends Api.AnyClient, T extends RegisterListenerMethod<A, ?>, U extends UnregisterListenerMethod<A, ?>> Task<Void> doRegisterEventListener(T t2, U u2) {
        Preconditions.checkNotNull(t2);
        Preconditions.checkNotNull(u2);
        Preconditions.checkNotNull(t2.getListenerKey(), "Listener has already been released.");
        Preconditions.checkNotNull(u2.getListenerKey(), "Listener has already been released.");
        Preconditions.checkArgument(Objects.equal((Object)t2.getListenerKey(), (Object)u2.getListenerKey()), "Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.zaj.zaa(this, t2, u2, com.google.android.gms.common.api.zac.zaa);
    }

    public <A extends Api.AnyClient> Task<Void> doRegisterEventListener(RegistrationMethods<A, ?> registrationMethods) {
        Preconditions.checkNotNull(registrationMethods);
        Preconditions.checkNotNull(registrationMethods.register.getListenerKey(), "Listener has already been released.");
        Preconditions.checkNotNull(registrationMethods.zaa.getListenerKey(), "Listener has already been released.");
        return this.zaj.zaa(this, registrationMethods.register, registrationMethods.zaa, registrationMethods.zab);
    }

    public Task<Boolean> doUnregisterEventListener(ListenerHolder.ListenerKey<?> listenerKey) {
        return this.doUnregisterEventListener(listenerKey, 0);
    }

    public Task<Boolean> doUnregisterEventListener(ListenerHolder.ListenerKey<?> listenerKey, int n2) {
        Preconditions.checkNotNull(listenerKey, "Listener key cannot be null.");
        return this.zaj.zaa(this, listenerKey, n2);
    }

    public <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T doWrite(T t2) {
        return this.zaa(1, t2);
    }

    public <TResult, A extends Api.AnyClient> Task<TResult> doWrite(TaskApiCall<A, TResult> taskApiCall) {
        return this.zaa(1, taskApiCall);
    }

    @Override
    public ApiKey<O> getApiKey() {
        return this.zae;
    }

    public O getApiOptions() {
        return this.zad;
    }

    public Context getApplicationContext() {
        return this.zaa;
    }

    protected String getContextAttributionTag() {
        return this.zab;
    }

    @Deprecated
    protected String getContextFeatureId() {
        return this.zab;
    }

    public Looper getLooper() {
        return this.zaf;
    }

    public <L> ListenerHolder<L> registerListener(L l2, String string2) {
        return ListenerHolders.createListenerHolder(l2, (Looper)this.zaf, (String)string2);
    }

    public final int zaa() {
        return this.zag;
    }

    public final Api.Client zaa(Looper object, GoogleApiManager.zaa<O> object2) {
        ClientSettings clientSettings = this.createClientSettingsBuilder().build();
        object = Preconditions.checkNotNull(this.zac.zab()).buildClient(this.zaa, (Looper)object, clientSettings, this.zad, (GoogleApiClient.ConnectionCallbacks)object2, (GoogleApiClient.OnConnectionFailedListener)object2);
        object2 = this.getContextAttributionTag();
        if (object2 != null && object instanceof BaseGmsClient) {
            ((BaseGmsClient)object).setAttributionTag((String)object2);
        }
        if (object2 != null && object instanceof NonGmsServiceBrokerClient) {
            ((NonGmsServiceBrokerClient)object).zaa((String)object2);
        }
        return object;
    }

    public final zace zaa(Context context, Handler handler) {
        return new zace(context, handler, this.createClientSettingsBuilder().build());
    }

    public static class Settings {
        public static final Settings DEFAULT_SETTINGS = new Builder().build();
        public final StatusExceptionMapper zaa;
        public final Looper zab;

        private Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper) {
            this.zaa = statusExceptionMapper;
            this.zab = looper;
        }

        /* synthetic */ Settings(StatusExceptionMapper statusExceptionMapper, Account account, Looper looper, zad zad2) {
            this(statusExceptionMapper, null, looper);
        }

        public static class Builder {
            private StatusExceptionMapper zaa;
            private Looper zab;

            public Settings build() {
                if (this.zaa == null) {
                    this.zaa = new ApiExceptionMapper();
                }
                if (this.zab == null) {
                    this.zab = Looper.getMainLooper();
                }
                return new Settings(this.zaa, null, this.zab, null);
            }

            public Builder setLooper(Looper looper) {
                Preconditions.checkNotNull(looper, "Looper must not be null.");
                this.zab = looper;
                return this;
            }

            public Builder setMapper(StatusExceptionMapper statusExceptionMapper) {
                Preconditions.checkNotNull(statusExceptionMapper, "StatusExceptionMapper must not be null.");
                this.zaa = statusExceptionMapper;
                return this;
            }
        }
    }
}

