/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.base.R;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zaab;
import com.google.android.gms.common.internal.zay;
import com.google.android.gms.dynamic.RemoteCreator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int COLOR_AUTO = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    private int zaa;
    private int zab;
    private View zac;
    private View.OnClickListener zad = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SignInButton(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        attributeSet = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.SignInButton, 0, 0);
        try {
            this.zaa = attributeSet.getInt(R.styleable.SignInButton_buttonSize, 0);
            this.zab = attributeSet.getInt(R.styleable.SignInButton_colorScheme, 2);
            this.setStyle(this.zaa, this.zab);
            return;
        }
        finally {
            attributeSet.recycle();
        }
    }

    public final void onClick(View view) {
        View.OnClickListener onClickListener = this.zad;
        if (onClickListener != null && view == this.zac) {
            onClickListener.onClick((View)this);
        }
    }

    protected void onMeasure(int n2, int n3) {
        if (!true) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        super.onMeasure(n2, n3);
    }

    public final void setColorScheme(int n2) {
        this.setStyle(this.zaa, n2);
    }

    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.zac.setEnabled(bl);
    }

    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zad = onClickListener;
        onClickListener = this.zac;
        if (onClickListener != null) {
            onClickListener.setOnClickListener((View.OnClickListener)this);
        }
    }

    @Deprecated
    public final void setScopes(Scope[] scopeArray) {
        this.setStyle(this.zaa, this.zab);
    }

    public final void setSize(int n2) {
        this.setStyle(n2, this.zab);
    }

    public final void setStyle(int n2, int n3) {
        this.zaa = n2;
        this.zab = n3;
        Context context = this.getContext();
        View view = this.zac;
        if (view != null) {
            this.removeView(view);
        }
        try {
            this.zac = zay.zaa((Context)context, (int)this.zaa, (int)this.zab);
        }
        catch (RemoteCreator.RemoteCreatorException remoteCreatorException) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            n3 = this.zaa;
            n2 = this.zab;
            zaab zaab2 = new zaab(context);
            zaab2.zaa(context.getResources(), n3, n2);
            this.zac = zaab2;
        }
        this.addView(this.zac);
        this.zac.setEnabled(this.isEnabled());
        this.zac.setOnClickListener((View.OnClickListener)this);
    }

    @Deprecated
    public final void setStyle(int n2, int n3, Scope[] scopeArray) {
        this.setStyle(n2, n3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ButtonSize {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorScheme {
    }
}

