/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.zzi;
import com.google.android.gms.common.zzj;
import com.google.android.gms.common.zzl;
import com.google.android.gms.common.zzm;
import com.google.android.gms.common.zzw;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public class GoogleSignatureVerifier {
    @Nullable
    private static GoogleSignatureVerifier zza;
    private final Context zzb;
    private volatile String zzc;

    public GoogleSignatureVerifier(Context context) {
        this.zzb = context.getApplicationContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GoogleSignatureVerifier getInstance(Context context) {
        Preconditions.checkNotNull(context);
        synchronized (GoogleSignatureVerifier.class) {
            if (zza == null) {
                GoogleSignatureVerifier googleSignatureVerifier;
                zzm.zza(context);
                zza = googleSignatureVerifier = new GoogleSignatureVerifier(context);
            }
            return zza;
        }
    }

    @Nullable
    static final zzi zza(PackageInfo zzj2, zzi ... zziArray) {
        if (zzj2.signatures == null) {
            return null;
        }
        if (zzj2.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return null;
        }
        zzj2 = zzj2.signatures;
        zzj2 = new zzj(zzj2[0].toByteArray());
        for (int i2 = 0; i2 < zziArray.length; ++i2) {
            if (!zziArray[i2].equals((Object)zzj2)) continue;
            return zziArray[i2];
        }
        return null;
    }

    public static final boolean zzb(PackageInfo packageInfo, boolean bl) {
        return packageInfo != null && packageInfo.signatures != null && (packageInfo = bl ? GoogleSignatureVerifier.zza(packageInfo, zzl.zza) : GoogleSignatureVerifier.zza(packageInfo, zzl.zza[0])) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final zzw zzc(String string2, boolean bl, boolean bl2) {
        zzw zzw2;
        if (string2 == null) {
            return zzw.zzd("null pkg");
        }
        if (string2.equals(this.zzc)) return zzw.zzb();
        if (zzm.zzd()) {
            zzw2 = zzm.zzb(string2, GooglePlayServicesUtilLight.honorsDebugCertificates((Context)this.zzb), false, false);
        } else {
            PackageInfo packageInfo;
            try {
                packageInfo = this.zzb.getPackageManager().getPackageInfo(string2, 64);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if (string2.length() != 0) {
                    string2 = "no pkg ".concat(string2);
                    return zzw.zze(string2, nameNotFoundException);
                }
                string2 = new String("no pkg ");
                return zzw.zze(string2, nameNotFoundException);
            }
            bl = GooglePlayServicesUtilLight.honorsDebugCertificates((Context)this.zzb);
            if (packageInfo == null) {
                zzw2 = zzw.zzd("null pkg");
            } else if (packageInfo.signatures != null && packageInfo.signatures.length == 1) {
                zzj zzj2 = new zzj(packageInfo.signatures[0].toByteArray());
                String string3 = packageInfo.packageName;
                zzw2 = zzm.zzc(string3, (zzi)zzj2, bl, false);
                if (zzw2.zza && packageInfo.applicationInfo != null && (packageInfo.applicationInfo.flags & 2) != 0 && zzm.zzc((String)string3, (zzi)zzj2, (boolean)false, (boolean)true).zza) {
                    zzw2 = zzw.zzd("debuggable release cert app rejected");
                }
            } else {
                zzw2 = zzw.zzd("single cert required");
            }
        }
        if (!zzw2.zza) return zzw2;
        this.zzc = string2;
        return zzw2;
    }

    public boolean isGooglePublicSignedPackage(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return false;
        }
        if (GoogleSignatureVerifier.zzb(packageInfo, false)) {
            return true;
        }
        if (GoogleSignatureVerifier.zzb(packageInfo, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates((Context)this.zzb)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    public boolean isPackageGoogleSigned(String object) {
        object = this.zzc((String)object, false, false);
        ((zzw)object).zzf();
        return ((zzw)object).zza;
    }

    public boolean isUidGoogleSigned(int n2) {
        zzw zzw2;
        block4: {
            int n3;
            String[] stringArray = this.zzb.getPackageManager().getPackagesForUid(n2);
            if (stringArray != null && (n3 = stringArray.length) != 0) {
                zzw2 = null;
                for (n2 = 0; n2 < n3; ++n2) {
                    zzw2 = this.zzc(stringArray[n2], false, false);
                    if (!zzw2.zza) {
                        continue;
                    }
                    break block4;
                }
                Preconditions.checkNotNull(zzw2);
            } else {
                zzw2 = zzw.zzd("no pkgs");
            }
        }
        zzw2.zzf();
        return zzw2.zza;
    }
}

