/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.proxy;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Patterns;
import com.google.android.gms.auth.api.proxy.zza;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProxyRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<ProxyRequest> CREATOR = new zza();
    public static final int HTTP_METHOD_DELETE;
    public static final int HTTP_METHOD_GET;
    public static final int HTTP_METHOD_HEAD;
    public static final int HTTP_METHOD_OPTIONS;
    public static final int HTTP_METHOD_PATCH;
    public static final int HTTP_METHOD_POST;
    public static final int HTTP_METHOD_PUT;
    public static final int HTTP_METHOD_TRACE;
    public static final int LAST_CODE;
    public static final int VERSION_CODE = 2;
    public final byte[] body;
    public final int httpMethod;
    public final long timeoutMillis;
    public final String url;
    private final int versionCode;
    private Bundle zzby;

    static {
        HTTP_METHOD_GET = 0;
        HTTP_METHOD_POST = 1;
        HTTP_METHOD_PUT = 2;
        HTTP_METHOD_DELETE = 3;
        HTTP_METHOD_HEAD = 4;
        HTTP_METHOD_OPTIONS = 5;
        HTTP_METHOD_TRACE = 6;
        HTTP_METHOD_PATCH = 7;
        LAST_CODE = 7;
    }

    ProxyRequest(int n2, String string2, int n3, long l2, byte[] byArray, Bundle bundle) {
        this.versionCode = n2;
        this.url = string2;
        this.httpMethod = n3;
        this.timeoutMillis = l2;
        this.body = byArray;
        this.zzby = bundle;
    }

    public Map<String, String> getHeaderMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.zzby.size());
        for (String string2 : this.zzby.keySet()) {
            linkedHashMap.put(string2, this.zzby.getString(string2));
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public String toString() {
        String string2 = this.url;
        int n2 = this.httpMethod;
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(string2).length() + 42);
        stringBuilder.append("ProxyRequest[ url: ");
        stringBuilder.append(string2);
        stringBuilder.append(", method: ");
        stringBuilder.append(n2);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    public void writeToParcel(Parcel parcel, int n2) {
        n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.url, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.httpMethod);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)3, (long)this.timeoutMillis);
        SafeParcelWriter.writeByteArray((Parcel)parcel, (int)4, (byte[])this.body, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel, (int)5, (Bundle)this.zzby, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1000, (int)this.versionCode);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    public static class Builder {
        private String zzbz;
        private int zzca = HTTP_METHOD_GET;
        private long zzcb = 3000L;
        private byte[] zzcc = null;
        private Bundle zzcd = new Bundle();

        public Builder(String string2) {
            Preconditions.checkNotEmpty(string2);
            if (Patterns.WEB_URL.matcher(string2).matches()) {
                this.zzbz = string2;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(string2).length() + 51);
            stringBuilder.append("The supplied url [ ");
            stringBuilder.append(string2);
            stringBuilder.append("] is not match Patterns.WEB_URL!");
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        public ProxyRequest build() {
            if (this.zzcc == null) {
                this.zzcc = new byte[0];
            }
            return new ProxyRequest(2, this.zzbz, this.zzca, this.zzcb, this.zzcc, this.zzcd);
        }

        public Builder putHeader(String string2, String string3) {
            Preconditions.checkNotEmpty(string2, "Header name cannot be null or empty!");
            Bundle bundle = this.zzcd;
            String string4 = string3;
            if (string3 == null) {
                string4 = "";
            }
            bundle.putString(string2, string4);
            return this;
        }

        public Builder setBody(byte[] byArray) {
            this.zzcc = byArray;
            return this;
        }

        public Builder setHttpMethod(int n2) {
            boolean bl = n2 >= 0 && n2 <= LAST_CODE;
            Preconditions.checkArgument(bl, "Unrecognized http method code.");
            this.zzca = n2;
            return this;
        }

        public Builder setTimeoutMillis(long l2) {
            boolean bl = l2 >= 0L;
            Preconditions.checkArgument(bl, "The specified timeout must be non-negative.");
            this.zzcb = l2;
            return this;
        }
    }
}

