/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.identity;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.api.identity.zba;
import com.google.android.gms.auth.api.identity.zbe;
import com.google.android.gms.auth.api.identity.zbf;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BeginSignInRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<BeginSignInRequest> CREATOR = new zba();
    private final PasswordRequestOptions zba;
    private final GoogleIdTokenRequestOptions zbb;
    private final String zbc;
    private final boolean zbd;

    BeginSignInRequest(PasswordRequestOptions passwordRequestOptions, GoogleIdTokenRequestOptions googleIdTokenRequestOptions, String string2, boolean bl) {
        this.zba = Preconditions.checkNotNull(passwordRequestOptions);
        this.zbb = Preconditions.checkNotNull(googleIdTokenRequestOptions);
        this.zbc = string2;
        this.zbd = bl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder zba(BeginSignInRequest object) {
        Preconditions.checkNotNull(object);
        Builder builder = BeginSignInRequest.builder();
        builder.setGoogleIdTokenRequestOptions(((BeginSignInRequest)object).getGoogleIdTokenRequestOptions());
        builder.setPasswordRequestOptions(((BeginSignInRequest)object).getPasswordRequestOptions());
        builder.setAutoSelectEnabled(((BeginSignInRequest)object).zbd);
        object = ((BeginSignInRequest)object).zbc;
        if (object != null) {
            builder.zba((String)object);
        }
        return builder;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BeginSignInRequest)) {
            return false;
        }
        object = (BeginSignInRequest)object;
        return Objects.equal((Object)this.zba, (Object)((BeginSignInRequest)object).zba) && Objects.equal((Object)this.zbb, (Object)((BeginSignInRequest)object).zbb) && Objects.equal((Object)this.zbc, (Object)((BeginSignInRequest)object).zbc) && this.zbd == ((BeginSignInRequest)object).zbd;
    }

    public GoogleIdTokenRequestOptions getGoogleIdTokenRequestOptions() {
        return this.zbb;
    }

    public PasswordRequestOptions getPasswordRequestOptions() {
        return this.zba;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zba, this.zbb, this.zbc, this.zbd});
    }

    public boolean isAutoSelectEnabled() {
        return this.zbd;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        int n3 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)1, (Parcelable)this.getPasswordRequestOptions(), (int)n2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)2, (Parcelable)this.getGoogleIdTokenRequestOptions(), (int)n2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zbc, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)4, (boolean)this.isAutoSelectEnabled());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n3);
    }

    public static final class Builder {
        private PasswordRequestOptions zba;
        private GoogleIdTokenRequestOptions zbb;
        private String zbc;
        private boolean zbd;

        public Builder() {
            Object object = PasswordRequestOptions.builder();
            ((PasswordRequestOptions.Builder)object).setSupported(false);
            this.zba = ((PasswordRequestOptions.Builder)object).build();
            object = GoogleIdTokenRequestOptions.builder();
            ((GoogleIdTokenRequestOptions.Builder)object).setSupported(false);
            this.zbb = ((GoogleIdTokenRequestOptions.Builder)object).build();
        }

        public BeginSignInRequest build() {
            return new BeginSignInRequest(this.zba, this.zbb, this.zbc, this.zbd);
        }

        public Builder setAutoSelectEnabled(boolean bl) {
            this.zbd = bl;
            return this;
        }

        public Builder setGoogleIdTokenRequestOptions(GoogleIdTokenRequestOptions googleIdTokenRequestOptions) {
            this.zbb = Preconditions.checkNotNull(googleIdTokenRequestOptions);
            return this;
        }

        public Builder setPasswordRequestOptions(PasswordRequestOptions passwordRequestOptions) {
            this.zba = Preconditions.checkNotNull(passwordRequestOptions);
            return this;
        }

        public final Builder zba(String string2) {
            this.zbc = string2;
            return this;
        }
    }

    public static final class GoogleIdTokenRequestOptions
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<GoogleIdTokenRequestOptions> CREATOR = new zbe();
        private final boolean zba;
        private final String zbb;
        private final String zbc;
        private final boolean zbd;
        private final String zbe;
        private final List<String> zbf;

        GoogleIdTokenRequestOptions(boolean bl, String object, String string2, boolean bl2, String string3, List<String> list) {
            this.zba = bl;
            if (bl) {
                Preconditions.checkNotNull(object, "serverClientId must be provided if Google ID tokens are requested");
            }
            this.zbb = object;
            this.zbc = string2;
            this.zbd = bl2;
            object = CREATOR;
            string2 = null;
            object = string2;
            if (list != null) {
                if (list.isEmpty()) {
                    object = string2;
                } else {
                    object = new ArrayList<String>(list);
                    Collections.sort(object);
                }
            }
            this.zbf = object;
            this.zbe = string3;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object object) {
            if (!(object instanceof GoogleIdTokenRequestOptions)) {
                return false;
            }
            object = (GoogleIdTokenRequestOptions)object;
            return this.zba == ((GoogleIdTokenRequestOptions)object).zba && Objects.equal((Object)this.zbb, (Object)((GoogleIdTokenRequestOptions)object).zbb) && Objects.equal((Object)this.zbc, (Object)((GoogleIdTokenRequestOptions)object).zbc) && this.zbd == ((GoogleIdTokenRequestOptions)object).zbd && Objects.equal((Object)this.zbe, (Object)((GoogleIdTokenRequestOptions)object).zbe) && Objects.equal(this.zbf, ((GoogleIdTokenRequestOptions)object).zbf);
        }

        public boolean filterByAuthorizedAccounts() {
            return this.zbd;
        }

        public List<String> getIdTokenDepositionScopes() {
            return this.zbf;
        }

        public String getLinkedServiceId() {
            return this.zbe;
        }

        public String getNonce() {
            return this.zbc;
        }

        public String getServerClientId() {
            return this.zbb;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zba, this.zbb, this.zbc, this.zbd, this.zbe, this.zbf});
        }

        public boolean isSupported() {
            return this.zba;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
            SafeParcelWriter.writeBoolean((Parcel)parcel, (int)1, (boolean)this.isSupported());
            SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.getServerClientId(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.getNonce(), (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)parcel, (int)4, (boolean)this.filterByAuthorizedAccounts());
            SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.getLinkedServiceId(), (boolean)false);
            SafeParcelWriter.writeStringList((Parcel)parcel, (int)6, this.getIdTokenDepositionScopes(), (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
        }

        public static final class Builder {
            private boolean zba = false;
            private String zbb = null;
            private String zbc = null;
            private boolean zbd = true;
            private String zbe = null;
            private List<String> zbf = null;

            public Builder associateLinkedAccounts(String string2, List<String> list) {
                this.zbe = Preconditions.checkNotNull(string2, "linkedServiceId must be provided if you want to associate linked accounts.");
                this.zbf = list;
                return this;
            }

            public GoogleIdTokenRequestOptions build() {
                return new GoogleIdTokenRequestOptions(this.zba, this.zbb, this.zbc, this.zbd, this.zbe, this.zbf);
            }

            public Builder setFilterByAuthorizedAccounts(boolean bl) {
                this.zbd = bl;
                return this;
            }

            public Builder setNonce(String string2) {
                this.zbc = string2;
                return this;
            }

            public Builder setServerClientId(String string2) {
                this.zbb = Preconditions.checkNotEmpty(string2);
                return this;
            }

            public Builder setSupported(boolean bl) {
                this.zba = bl;
                return this;
            }
        }
    }

    public static final class PasswordRequestOptions
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<PasswordRequestOptions> CREATOR = new zbf();
        private final boolean zba;

        PasswordRequestOptions(boolean bl) {
            this.zba = bl;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object object) {
            if (!(object instanceof PasswordRequestOptions)) {
                return false;
            }
            object = (PasswordRequestOptions)object;
            return this.zba == ((PasswordRequestOptions)object).zba;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zba});
        }

        public boolean isSupported() {
            return this.zba;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
            SafeParcelWriter.writeBoolean((Parcel)parcel, (int)1, (boolean)this.isSupported());
            SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
        }

        public static final class Builder {
            private boolean zba = false;

            public PasswordRequestOptions build() {
                return new PasswordRequestOptions(this.zba);
            }

            public Builder setSupported(boolean bl) {
                this.zba = bl;
                return this;
            }
        }
    }
}

