/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.auth.api.credentials.CredentialRequest;
import com.google.android.gms.auth.api.credentials.CredentialRequestResponse;
import com.google.android.gms.auth.api.credentials.HintRequest;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Response;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.internal.auth_api.zbn;
import com.google.android.gms.tasks.Task;

public class CredentialsClient
extends GoogleApi<Auth.AuthCredentialsOptions> {
    CredentialsClient(Activity activity, Auth.AuthCredentialsOptions authCredentialsOptions) {
        super(activity, Auth.CREDENTIALS_API, authCredentialsOptions, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    CredentialsClient(Context context, Auth.AuthCredentialsOptions authCredentialsOptions) {
        super(context, Auth.CREDENTIALS_API, authCredentialsOptions, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    public Task<Void> delete(Credential credential) {
        return PendingResultUtil.toVoidTask((PendingResult)Auth.CredentialsApi.delete(this.asGoogleApiClient(), credential));
    }

    public Task<Void> disableAutoSignIn() {
        return PendingResultUtil.toVoidTask((PendingResult)Auth.CredentialsApi.disableAutoSignIn(this.asGoogleApiClient()));
    }

    public PendingIntent getHintPickerIntent(HintRequest hintRequest) {
        return zbn.zba((Context)this.getApplicationContext(), (Auth.AuthCredentialsOptions)((Auth.AuthCredentialsOptions)this.getApiOptions()), (HintRequest)hintRequest, (String)((Auth.AuthCredentialsOptions)this.getApiOptions()).zbd());
    }

    public Task<CredentialRequestResponse> request(CredentialRequest credentialRequest) {
        return PendingResultUtil.toResponseTask((PendingResult)Auth.CredentialsApi.request(this.asGoogleApiClient(), credentialRequest), (Response)new CredentialRequestResponse());
    }

    public Task<Void> save(Credential credential) {
        return PendingResultUtil.toVoidTask((PendingResult)Auth.CredentialsApi.save(this.asGoogleApiClient(), credential));
    }
}

