/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zba;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class Credential
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<Credential> CREATOR = new zba();
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    @Nonnull
    private final String zba;
    private final String zbb;
    private final Uri zbc;
    @Nonnull
    private final List<IdToken> zbd;
    private final String zbe;
    private final String zbf;
    private final String zbg;
    private final String zbh;

    Credential(String list, String string2, Uri uri, List<IdToken> list2, String string3, String string4, String string5, String string6) {
        String string7 = Preconditions.checkNotNull(list, "credential identifier cannot be null").trim();
        Preconditions.checkNotEmpty(string7, "credential identifier cannot be empty");
        if (string3 != null && TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("Password must not be empty if set");
        }
        if (string4 != null) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                list = false;
            } else {
                list = Uri.parse((String)string4);
                if (list.isAbsolute() && list.isHierarchical() && !TextUtils.isEmpty((CharSequence)list.getScheme()) && !TextUtils.isEmpty((CharSequence)list.getAuthority())) {
                    boolean bl;
                    boolean bl2 = "http".equalsIgnoreCase(list.getScheme());
                    boolean bl3 = bl = true;
                    if (!bl2) {
                        bl3 = "https".equalsIgnoreCase(list.getScheme()) ? bl : false;
                    }
                    list = bl3;
                } else {
                    list = false;
                }
            }
            if (!((Boolean)((Object)list)).booleanValue()) {
                throw new IllegalArgumentException("Account type must be a valid Http/Https URI");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string4) && !TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("Password and AccountType are mutually exclusive");
        }
        list = string2;
        if (string2 != null) {
            list = string2;
            if (TextUtils.isEmpty((CharSequence)string2.trim())) {
                list = null;
            }
        }
        this.zbb = list;
        this.zbc = uri;
        list = list2 == null ? Collections.emptyList() : Collections.unmodifiableList(list2);
        this.zbd = list;
        this.zba = string7;
        this.zbe = string3;
        this.zbf = string4;
        this.zbg = string5;
        this.zbh = string6;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        object = (Credential)object;
        return TextUtils.equals((CharSequence)this.zba, (CharSequence)((Credential)object).zba) && TextUtils.equals((CharSequence)this.zbb, (CharSequence)((Credential)object).zbb) && Objects.equal((Object)this.zbc, (Object)((Credential)object).zbc) && TextUtils.equals((CharSequence)this.zbe, (CharSequence)((Credential)object).zbe) && TextUtils.equals((CharSequence)this.zbf, (CharSequence)((Credential)object).zbf);
    }

    public String getAccountType() {
        return this.zbf;
    }

    public String getFamilyName() {
        return this.zbh;
    }

    public String getGivenName() {
        return this.zbg;
    }

    @Nonnull
    public String getId() {
        return this.zba;
    }

    @Nonnull
    public List<IdToken> getIdTokens() {
        return this.zbd;
    }

    public String getName() {
        return this.zbb;
    }

    public String getPassword() {
        return this.zbe;
    }

    public Uri getProfilePictureUri() {
        return this.zbc;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zba, this.zbb, this.zbc, this.zbe, this.zbf});
    }

    public void writeToParcel(Parcel parcel, int n2) {
        int n3 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.getName(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)3, (Parcelable)this.getProfilePictureUri(), (int)n2, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)4, this.getIdTokens(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.getPassword(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)6, (String)this.getAccountType(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)9, (String)this.getGivenName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)10, (String)this.getFamilyName(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n3);
    }

    public static class Builder {
        private final String zba;
        private String zbb;
        private Uri zbc;
        private List<IdToken> zbd;
        private String zbe;
        private String zbf;
        private String zbg;
        private String zbh;

        public Builder(Credential credential) {
            this.zba = credential.zba;
            this.zbb = credential.zbb;
            this.zbc = credential.zbc;
            this.zbd = credential.zbd;
            this.zbe = credential.zbe;
            this.zbf = credential.zbf;
            this.zbg = credential.zbg;
            this.zbh = credential.zbh;
        }

        public Builder(String string2) {
            this.zba = string2;
        }

        public Credential build() {
            return new Credential(this.zba, this.zbb, this.zbc, this.zbd, this.zbe, this.zbf, this.zbg, this.zbh);
        }

        public Builder setAccountType(String string2) {
            this.zbf = string2;
            return this;
        }

        public Builder setName(String string2) {
            this.zbb = string2;
            return this;
        }

        public Builder setPassword(String string2) {
            this.zbe = string2;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zbc = uri;
            return this;
        }
    }
}

