/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.UserRecoverableNotifiedException;
import com.google.android.gms.auth.zzd;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.Preconditions;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public final class GoogleAuthUtil
extends zzd {
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    private static final String KEY_ANDROID_PACKAGE_NAME;
    private static final String KEY_CALLER_UID;
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";

    static {
        KEY_CALLER_UID = zzd.KEY_CALLER_UID;
        KEY_ANDROID_PACKAGE_NAME = zzd.KEY_ANDROID_PACKAGE_NAME;
    }

    private GoogleAuthUtil() {
    }

    public static void clearToken(Context context, String string2) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        zzd.clearToken((Context)context, (String)string2);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, int n2, String string2) throws GoogleAuthException, IOException {
        return zzd.getAccountChangeEvents((Context)context, (int)n2, (String)string2);
    }

    public static String getAccountId(Context context, String string2) throws GoogleAuthException, IOException {
        return zzd.getAccountId((Context)context, (String)string2);
    }

    public static String getToken(Context context, Account account, String string2) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken((Context)context, (Account)account, (String)string2);
    }

    public static String getToken(Context context, Account account, String string2, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken((Context)context, (Account)account, (String)string2, (Bundle)bundle);
    }

    @Deprecated
    public static String getToken(Context context, String string2, String string3) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken((Context)context, (String)string2, (String)string3);
    }

    @Deprecated
    public static String getToken(Context context, String string2, String string3, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken((Context)context, (String)string2, (String)string3, (Bundle)bundle);
    }

    public static String getTokenWithNotification(Context context, Account account, String string2, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Bundle bundle2 = bundle;
        if (bundle == null) {
            bundle2 = new Bundle();
        }
        bundle2.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zza(context, account, string2, bundle2).zzb();
    }

    public static String getTokenWithNotification(Context context, Account account, String string2, Bundle bundle, Intent intent) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (intent != null) {
            String string3;
            block3: {
                string3 = intent.toUri(1);
                try {
                    Intent.parseUri((String)string3, (int)1);
                    string3 = bundle;
                    if (bundle != null) break block3;
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
                }
                string3 = new Bundle();
            }
            string3.putParcelable("callback_intent", (Parcelable)intent);
            string3.putBoolean("handle_notification", true);
            return GoogleAuthUtil.zza(context, account, string2, (Bundle)string3).zzb();
        }
        throw new IllegalArgumentException("Callback cannot be null.");
    }

    public static String getTokenWithNotification(Context context, Account account, String string2, Bundle bundle, String string3, Bundle bundle2) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Preconditions.checkNotEmpty(string3, "Authority cannot be empty or null.");
        Bundle bundle3 = bundle;
        if (bundle == null) {
            bundle3 = new Bundle();
        }
        bundle = bundle2;
        if (bundle2 == null) {
            bundle = new Bundle();
        }
        ContentResolver.validateSyncExtrasBundle((Bundle)bundle);
        bundle3.putString("authority", string3);
        bundle3.putBundle("sync_extras", bundle);
        bundle3.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zza(context, account, string2, bundle3).zzb();
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String string2, String string3, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        return GoogleAuthUtil.getTokenWithNotification(context, new Account(string2, GOOGLE_ACCOUNT_TYPE), string3, bundle);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String string2, String string3, Bundle bundle, Intent intent) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        return GoogleAuthUtil.getTokenWithNotification(context, new Account(string2, GOOGLE_ACCOUNT_TYPE), string3, bundle, intent);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String string2, String string3, Bundle bundle, String string4, Bundle bundle2) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        return GoogleAuthUtil.getTokenWithNotification(context, new Account(string2, GOOGLE_ACCOUNT_TYPE), string3, bundle, string4, bundle2);
    }

    @Deprecated
    public static void invalidateToken(Context context, String string2) {
        zzd.invalidateToken((Context)context, (String)string2);
    }

    public static Bundle removeAccount(Context context, Account account) throws GoogleAuthException, IOException {
        return zzd.removeAccount((Context)context, (Account)account);
    }

    public static Boolean requestGoogleAccountsAccess(Context context) throws GoogleAuthException, IOException {
        return zzd.requestGoogleAccountsAccess((Context)context);
    }

    private static TokenData zza(Context context, Account account, String string2, Bundle bundle) throws IOException, GoogleAuthException {
        Bundle bundle2 = bundle;
        if (bundle == null) {
            bundle2 = new Bundle();
        }
        try {
            account = zzd.zzb((Context)context, (Account)account, (String)string2, (Bundle)bundle2);
            GooglePlayServicesUtil.cancelAvailabilityErrorNotifications((Context)context);
            return account;
        }
        catch (UserRecoverableAuthException userRecoverableAuthException) {
            GooglePlayServicesUtil.cancelAvailabilityErrorNotifications((Context)context);
            Log.w((String)"GoogleAuthUtil", (String)"Error when getting token", (Throwable)userRecoverableAuthException);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
        catch (GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException) {
            GooglePlayServicesUtil.showErrorNotification((int)googlePlayServicesAvailabilityException.getConnectionStatusCode(), (Context)context);
            Log.w((String)"GoogleAuthUtil", (String)"Error when getting token", (Throwable)googlePlayServicesAvailabilityException);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
    }
}

