/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.search.DynamicHeightSearchAdRequest;
import com.google.android.gms.ads.search.SearchAdRequest;
import com.google.android.gms.internal.ads.zzbhp;
import com.google.android.gms.internal.ads.zzcgs;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class SearchAdView
extends ViewGroup {
    @NotOnlyInitialized
    private final zzbhp zza;

    public SearchAdView(Context context) {
        super(context);
        this.zza = new zzbhp(this);
    }

    public SearchAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zza = new zzbhp(this, attributeSet, false);
    }

    public SearchAdView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.zza = new zzbhp(this, attributeSet, false);
    }

    public void destroy() {
        this.zza.zza();
    }

    public AdListener getAdListener() {
        return this.zza.zzb();
    }

    public AdSize getAdSize() {
        return this.zza.zzc();
    }

    public String getAdUnitId() {
        return this.zza.zze();
    }

    public void loadAd(DynamicHeightSearchAdRequest dynamicHeightSearchAdRequest) {
        if (AdSize.SEARCH.equals((Object)this.getAdSize())) {
            this.zza.zzg(dynamicHeightSearchAdRequest.zza());
            return;
        }
        throw new IllegalStateException("You must use AdSize.SEARCH for a DynamicHeightSearchAdRequest");
    }

    public void loadAd(SearchAdRequest searchAdRequest) {
        this.zza.zzg(searchAdRequest.zza());
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n6 = view.getMeasuredWidth();
            int n7 = view.getMeasuredHeight();
            n2 = (n4 - n2 - n6) / 2;
            n3 = (n5 - n3 - n7) / 2;
            view.layout(n2, n3, n6 + n2, n7 + n3);
        }
    }

    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n2, n3);
            n5 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            try {
                view = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzcgs.zzg((String)"Unable to retrieve ad size.", (Throwable)nullPointerException);
                view = null;
            }
            if (view != null) {
                Context context = this.getContext();
                n5 = view.getWidthInPixels(context);
                n4 = view.getHeightInPixels(context);
            } else {
                n4 = 0;
            }
        }
        n5 = Math.max(n5, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n5, (int)n2), View.resolveSize((int)n4, (int)n3));
    }

    public void pause() {
        this.zza.zzh();
    }

    public void resume() {
        this.zza.zzj();
    }

    public void setAdListener(AdListener adListener) {
        this.zza.zzk(adListener);
    }

    public void setAdSize(AdSize adSize) {
        this.zza.zzm(adSize);
    }

    public void setAdUnitId(String string2) {
        this.zza.zzo(string2);
    }
}

