/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nativead;

import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbev;
import com.google.android.gms.internal.ads.zzbms;
import com.google.android.gms.internal.ads.zzcgs;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public final class NativeAdViewHolder {
    public static WeakHashMap<View, NativeAdViewHolder> zza = new WeakHashMap();
    @NotOnlyInitialized
    private zzbms zzb;
    private WeakReference<View> zzc;

    public NativeAdViewHolder(View view, Map<String, View> map, Map<String, View> map2) {
        Preconditions.checkNotNull(view, "ContainerView must not be null");
        if (view instanceof NativeAdView) {
            zzcgs.zzf((String)"The provided containerView is of type of NativeAdView, which cannot be usedwith NativeAdViewHolder.");
            return;
        }
        if (zza.get(view) != null) {
            zzcgs.zzf((String)"The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zza.put(view, this);
        this.zzc = new WeakReference<View>(view);
        map = NativeAdViewHolder.zza(map);
        map2 = NativeAdViewHolder.zza(map2);
        this.zzb = zzbev.zzb().zze(view, map, map2);
    }

    private static final HashMap<String, View> zza(Map<String, View> map) {
        if (map == null) {
            return new HashMap<String, View>();
        }
        return new HashMap<String, View>(map);
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzb.zzd(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzcgs.zzg((String)"Unable to call setClickConfirmingView on delegate", (Throwable)remoteException);
            return;
        }
    }

    public void setNativeAd(NativeAd weakReference) {
        Object object = ((NativeAd)((Object)weakReference)).zza();
        weakReference = this.zzc;
        weakReference = weakReference != null ? (View)weakReference.get() : null;
        if (weakReference == null) {
            zzcgs.zzi((String)"NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zza.containsKey(weakReference)) {
            zza.put((View)weakReference, this);
        }
        if ((weakReference = this.zzb) != null) {
            try {
                weakReference.zzb((IObjectWrapper)object);
                return;
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to call setNativeAd on delegate", (Throwable)remoteException);
            }
        }
    }

    public void unregisterNativeAd() {
        Object object = this.zzb;
        if (object != null) {
            try {
                object.zzc();
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to call unregisterNativeAd on delegate", (Throwable)remoteException);
            }
        }
        if ((object = (object = this.zzc) != null ? (View)((Reference)object).get() : null) != null) {
            zza.remove(object);
        }
    }
}

