/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nativead;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.nativead.AdChoicesView;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.zzb;
import com.google.android.gms.ads.nativead.zzc;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbev;
import com.google.android.gms.internal.ads.zzbex;
import com.google.android.gms.internal.ads.zzbhz;
import com.google.android.gms.internal.ads.zzbjf;
import com.google.android.gms.internal.ads.zzbjn;
import com.google.android.gms.internal.ads.zzblt;
import com.google.android.gms.internal.ads.zzblv;
import com.google.android.gms.internal.ads.zzbmm;
import com.google.android.gms.internal.ads.zzcgs;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class NativeAdView
extends FrameLayout {
    @NotOnlyInitialized
    private final FrameLayout zza;
    @NotOnlyInitialized
    private final zzbmm zzb;

    public NativeAdView(Context context) {
        super(context);
        this.zza = this.zze(context);
        this.zzb = this.zzf();
    }

    public NativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zza = this.zze(context);
        this.zzb = this.zzf();
    }

    public NativeAdView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.zza = this.zze(context);
        this.zzb = this.zzf();
    }

    public NativeAdView(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.zza = this.zze(context);
        this.zzb = this.zzf();
    }

    private final void zzd(String string2, View view) {
        zzbmm zzbmm2 = this.zzb;
        if (zzbmm2 != null) {
            try {
                zzbmm2.zzb(string2, ObjectWrapper.wrap((Object)view));
                return;
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to call setAssetView on delegate", (Throwable)remoteException);
            }
        }
    }

    private final FrameLayout zze(Context context) {
        context = new FrameLayout(context);
        context.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)context);
        return context;
    }

    @RequiresNonNull(value={"overlayFrame"})
    private final zzbmm zzf() {
        if (this.isInEditMode()) {
            return null;
        }
        return zzbev.zzb().zzd(this.zza.getContext(), (FrameLayout)this, this.zza);
    }

    public final void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n2, layoutParams);
        super.bringChildToFront((View)this.zza);
    }

    public final void bringChildToFront(View view) {
        super.bringChildToFront(view);
        FrameLayout frameLayout = this.zza;
        if (frameLayout != view) {
            super.bringChildToFront((View)frameLayout);
        }
    }

    public void destroy() {
        zzbmm zzbmm2 = this.zzb;
        if (zzbmm2 != null) {
            try {
                zzbmm2.zze();
                return;
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to destroy native ad view", (Throwable)remoteException);
            }
        }
    }

    public final boolean dispatchTouchEvent(MotionEvent motionEvent) {
        zzbjf zzbjf2 = zzbjn.zzbU;
        if (((Boolean)zzbex.zzc().zzb(zzbjf2)).booleanValue() && (zzbjf2 = this.zzb) != null) {
            try {
                zzbjf2.zzbN(ObjectWrapper.wrap((Object)motionEvent));
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to call handleTouchEvent on delegate", (Throwable)remoteException);
            }
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    public AdChoicesView getAdChoicesView() {
        View view = this.zza("3011");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    public final View getAdvertiserView() {
        return this.zza("3005");
    }

    public final View getBodyView() {
        return this.zza("3004");
    }

    public final View getCallToActionView() {
        return this.zza("3002");
    }

    public final View getHeadlineView() {
        return this.zza("3001");
    }

    public final View getIconView() {
        return this.zza("3003");
    }

    public final View getImageView() {
        return this.zza("3008");
    }

    public final MediaView getMediaView() {
        View view = this.zza("3010");
        if (view instanceof MediaView) {
            return (MediaView)view;
        }
        if (view != null) {
            zzcgs.zzd((String)"View is not an instance of MediaView");
        }
        return null;
    }

    public final View getPriceView() {
        return this.zza("3007");
    }

    public final View getStarRatingView() {
        return this.zza("3009");
    }

    public final View getStoreView() {
        return this.zza("3006");
    }

    protected void onMeasure(int n2, int n3) {
        if (!true) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        super.onMeasure(n2, n3);
    }

    public final void onVisibilityChanged(View view, int n2) {
        super.onVisibilityChanged(view, n2);
        zzbmm zzbmm2 = this.zzb;
        if (zzbmm2 != null) {
            try {
                zzbmm2.zzf(ObjectWrapper.wrap((Object)view), n2);
                return;
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to call onVisibilityChanged on delegate", (Throwable)remoteException);
            }
        }
    }

    public final void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zza);
    }

    public final void removeView(View view) {
        if (this.zza == view) {
            return;
        }
        super.removeView(view);
    }

    public void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zzd("3011", (View)adChoicesView);
    }

    public final void setAdvertiserView(View view) {
        this.zzd("3005", view);
    }

    public final void setBodyView(View view) {
        this.zzd("3004", view);
    }

    public final void setCallToActionView(View view) {
        this.zzd("3002", view);
    }

    public final void setClickConfirmingView(View view) {
        zzbmm zzbmm2 = this.zzb;
        if (zzbmm2 != null) {
            try {
                zzbmm2.zzg(ObjectWrapper.wrap((Object)view));
                return;
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to call setClickConfirmingView on delegate", (Throwable)remoteException);
            }
        }
    }

    public final void setHeadlineView(View view) {
        this.zzd("3001", view);
    }

    public final void setIconView(View view) {
        this.zzd("3003", view);
    }

    public final void setImageView(View view) {
        this.zzd("3008", view);
    }

    public final void setMediaView(MediaView mediaView) {
        this.zzd("3010", (View)mediaView);
        if (mediaView == null) {
            return;
        }
        mediaView.zza((zzblt)new zzb(this));
        mediaView.zzb((zzblv)new zzc(this));
    }

    public void setNativeAd(NativeAd nativeAd) {
        zzbmm zzbmm2 = this.zzb;
        if (zzbmm2 != null) {
            try {
                zzbmm2.zzd((IObjectWrapper)nativeAd.zza());
                return;
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to call setNativeAd on delegate", (Throwable)remoteException);
            }
        }
    }

    public final void setPriceView(View view) {
        this.zzd("3007", view);
    }

    public final void setStarRatingView(View view) {
        this.zzd("3009", view);
    }

    public final void setStoreView(View view) {
        this.zzd("3006", view);
    }

    protected final View zza(String string2) {
        block4: {
            zzbmm zzbmm2 = this.zzb;
            if (zzbmm2 != null) {
                string2 = zzbmm2.zzc(string2);
                if (string2 == null) break block4;
                try {
                    string2 = (View)ObjectWrapper.unwrap((IObjectWrapper)string2);
                    return string2;
                }
                catch (RemoteException remoteException) {
                    zzcgs.zzg((String)"Unable to call getAssetView on delegate", (Throwable)remoteException);
                }
            }
        }
        return null;
    }

    final /* synthetic */ void zzb(ImageView.ScaleType scaleType) {
        zzbmm zzbmm2 = this.zzb;
        if (zzbmm2 == null) {
            return;
        }
        if (scaleType != null) {
            try {
                zzbmm2.zzbM(ObjectWrapper.wrap((Object)scaleType));
                return;
            }
            catch (RemoteException remoteException) {
                zzcgs.zzg((String)"Unable to call setMediaViewImageScaleType on delegate", (Throwable)remoteException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzc(MediaContent mediaContent) {
        zzbmm zzbmm2 = this.zzb;
        if (zzbmm2 == null) {
            return;
        }
        try {
            if (mediaContent instanceof zzbhz) {
                zzbmm2.zzbO(((zzbhz)mediaContent).zza());
                return;
            }
            if (mediaContent == null) {
                zzbmm2.zzbO(null);
                return;
            }
            zzcgs.zzd((String)"Use MediaContent provided by NativeAd.getMediaContent");
            return;
        }
        catch (RemoteException remoteException) {
            zzcgs.zzg((String)"Unable to call setMediaContent on delegate", (Throwable)remoteException);
            return;
        }
    }
}

