/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.ads.identifier.zza;
import com.google.android.gms.ads.identifier.zzb;
import com.google.android.gms.common.BlockingServiceConnection;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.ads_identifier.zze;
import com.google.android.gms.internal.ads_identifier.zzf;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AdvertisingIdClient {
    BlockingServiceConnection zza;
    zzf zzb;
    boolean zzc;
    final Object zzd = new Object();
    zzb zze;
    final long zzf;
    private final Context zzg;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false, false);
    }

    public AdvertisingIdClient(Context context, long l2, boolean bl, boolean bl2) {
        Preconditions.checkNotNull(context);
        Context context2 = context;
        if (bl) {
            Context context3 = context.getApplicationContext();
            context2 = context;
            if (context3 != null) {
                context2 = context3;
            }
        }
        this.zzg = context2;
        this.zzc = false;
        this.zzf = l2;
    }

    public static Info getAdvertisingIdInfo(Context object) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        object = new AdvertisingIdClient((Context)object, -1L, true, false);
        try {
            long l2 = SystemClock.elapsedRealtime();
            ((AdvertisingIdClient)object).zzb(false);
            Info info = super.zzd(-1);
            ((AdvertisingIdClient)object).zzc(info, true, 0.0f, SystemClock.elapsedRealtime() - l2, "", null);
            ((AdvertisingIdClient)object).zza();
            return info;
        }
        catch (Throwable throwable) {
            try {
                ((AdvertisingIdClient)object).zzc(null, true, 0.0f, -1L, "", throwable);
                throw throwable;
            }
            catch (Throwable throwable2) {
                ((AdvertisingIdClient)object).zza();
                throw throwable2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean getIsAdIdFakeForDebugLogging(Context object) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        boolean bl;
        block18: {
            object = new AdvertisingIdClient((Context)object, -1L, false, false);
            ((AdvertisingIdClient)object).zzb(false);
            Preconditions.checkNotMainThread("Calling this from your main thread can lead to deadlock");
            // MONITORENTER : object
            if (((AdvertisingIdClient)object).zzc) break block18;
            Object object2 = ((AdvertisingIdClient)object).zzd;
            Object object3 = ((AdvertisingIdClient)object).zze;
            if (object3 != null && object3.zzb) {
                // MONITOREXIT : object2
                try {
                    ((AdvertisingIdClient)object).zzb(false);
                    if (((AdvertisingIdClient)object).zzc) break block18;
                    object2 = new IOException("AdvertisingIdClient cannot reconnect.");
                }
                catch (Exception exception) {
                    object2 = new IOException("AdvertisingIdClient cannot reconnect.", exception);
                    throw object2;
                }
                throw object2;
            }
            object3 = new IOException("AdvertisingIdClient is not connected.");
            throw object3;
        }
        Preconditions.checkNotNull(((AdvertisingIdClient)object).zza);
        Preconditions.checkNotNull(((AdvertisingIdClient)object).zzb);
        try {
            bl = ((AdvertisingIdClient)object).zzb.zzd();
            // MONITOREXIT : object
        }
        catch (RemoteException remoteException) {
            Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
            IOException iOException = new IOException("Remote exception");
            throw iOException;
        }
        try {
            super.zze();
            return bl;
        }
        finally {
            ((AdvertisingIdClient)object).zza();
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Info zzd(int n2) throws IOException {
        Preconditions.checkNotMainThread("Calling this from your main thread can lead to deadlock");
        synchronized (this) {
            Object object;
            block14: {
                if (!this.zzc) {
                    object = this.zzd;
                    synchronized (object) {
                        Object object2 = this.zze;
                        if (object2 != null && object2.zzb) {
                            // MONITOREXIT @DISABLED, blocks:[8, 9, 12, 13] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                            try {
                                this.zzb(false);
                                if (this.zzc) break block14;
                                object = new IOException("AdvertisingIdClient cannot reconnect.");
                                throw object;
                            }
                            catch (Exception exception) {
                                object = new IOException("AdvertisingIdClient cannot reconnect.", exception);
                                throw object;
                            }
                        }
                        object2 = new IOException("AdvertisingIdClient is not connected.");
                        throw object2;
                    }
                }
            }
            Preconditions.checkNotNull(this.zza);
            Preconditions.checkNotNull(this.zzb);
            try {
                object = new Info(this.zzb.zzc(), this.zzb.zze(true));
                // MONITOREXIT @DISABLED, blocks:[6, 8] lbl25 : MonitorExitStatement: MONITOREXIT : this
                this.zze();
                return object;
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                IOException iOException = new IOException("Remote exception");
                throw iOException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zze() {
        Object object = this.zzd;
        synchronized (object) {
            long l2;
            zzb zzb2 = this.zze;
            if (zzb2 != null) {
                zzb2.zza.countDown();
                try {
                    this.zze.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if ((l2 = this.zzf) > 0L) {
                this.zze = zzb2 = new zzb(this, l2);
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        this.zza();
        super.finalize();
    }

    public Info getInfo() throws IOException {
        return this.zzd(-1);
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zzb(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zza() {
        Preconditions.checkNotMainThread("Calling this from your main thread can lead to deadlock");
        synchronized (this) {
            BlockingServiceConnection blockingServiceConnection;
            if (this.zzg != null && (blockingServiceConnection = this.zza) != null) {
                try {
                    if (this.zzc) {
                        ConnectionTracker.getInstance().unbindService(this.zzg, (ServiceConnection)this.zza);
                    }
                }
                catch (Throwable throwable) {
                    Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
                }
                this.zzc = false;
                this.zzb = null;
                this.zza = null;
                return;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void zzb(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Preconditions.checkNotMainThread("Calling this from your main thread can lead to deadlock");
        synchronized (this) {
            Object object;
            block14: {
                if (this.zzc) {
                    this.zza();
                }
                Context context = this.zzg;
                try {
                    context.getPackageManager().getPackageInfo("com.android.vending", 0);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException = new GooglePlayServicesNotAvailableException(9);
                    throw googlePlayServicesNotAvailableException;
                }
                int n2 = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, 12451000);
                if (n2 != 0 && n2 != 2) {
                    IOException iOException = new IOException("Google Play services not available");
                    throw iOException;
                }
                object = new BlockingServiceConnection();
                Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
                intent.setPackage("com.google.android.gms");
                try {
                    boolean bl2 = ConnectionTracker.getInstance().bindService(context, intent, (ServiceConnection)object, 1);
                    if (!bl2) break block14;
                    object = this.zza = object;
                }
                catch (Throwable throwable) {
                    object = new IOException(throwable);
                    throw object;
                }
                try {
                    object = com.google.android.gms.internal.ads_identifier.zze.zza((IBinder)object.getServiceWithTimeout(10000L, TimeUnit.MILLISECONDS));
                    this.zzb = object;
                    this.zzc = true;
                    if (bl) {
                        this.zze();
                    }
                }
                catch (Throwable throwable) {
                    object = new IOException(throwable);
                    throw object;
                }
                catch (InterruptedException interruptedException) {
                    IOException iOException = new IOException("Interrupted exception");
                    throw iOException;
                }
                return;
            }
            object = new IOException("Connection failure");
            throw object;
        }
    }

    final boolean zzc(Info object, boolean bl, float f2, long l2, String string2, Throwable throwable) {
        if (!(Math.random() > 0.0)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            string2 = "1";
            hashMap.put("app_context", "1");
            if (object != null) {
                if (!((Info)object).isLimitAdTrackingEnabled()) {
                    string2 = "0";
                }
                hashMap.put("limit_ad_tracking", string2);
                object = ((Info)object).getId();
                if (object != null) {
                    hashMap.put("ad_id_size", Integer.toString(((String)object).length()));
                }
            }
            if (throwable != null) {
                hashMap.put("error", throwable.getClass().getName());
            }
            hashMap.put("tag", "AdvertisingIdClient");
            hashMap.put("time_spent", Long.toString(l2));
            new zza(this, hashMap).start();
            return true;
        }
        return false;
    }

    public static final class Info {
        private final String zza;
        private final boolean zzb;

        @Deprecated
        public Info(String string2, boolean bl) {
            this.zza = string2;
            this.zzb = bl;
        }

        public String getId() {
            return this.zza;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzb;
        }

        public String toString() {
            String string2 = this.zza;
            boolean bl = this.zzb;
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(string2).length() + 7);
            stringBuilder.append("{");
            stringBuilder.append(string2);
            stringBuilder.append("}");
            stringBuilder.append(bl);
            return stringBuilder.toString();
        }
    }
}

