/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.admanager.AppEventListener;
import com.google.android.gms.internal.ads.zzbcz;
import com.google.android.gms.internal.ads.zzbhp;
import com.google.android.gms.internal.ads.zzcgs;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;

public abstract class BaseAdView
extends ViewGroup {
    @NotOnlyInitialized
    protected final zzbhp zza;

    protected BaseAdView(Context context, int n2) {
        super(context);
        this.zza = new zzbhp(this, n2);
    }

    protected BaseAdView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet);
        this.zza = new zzbhp(this, attributeSet, false, n2);
    }

    protected BaseAdView(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2);
        this.zza = new zzbhp(this, attributeSet, false, n3);
    }

    protected BaseAdView(Context context, AttributeSet attributeSet, int n2, int n3, boolean bl) {
        super(context, attributeSet, n2);
        this.zza = new zzbhp(this, attributeSet, bl, n3);
    }

    protected BaseAdView(Context context, AttributeSet attributeSet, boolean bl) {
        super(context, attributeSet);
        this.zza = new zzbhp(this, attributeSet, bl);
    }

    public void destroy() {
        this.zza.zza();
    }

    public AdListener getAdListener() {
        return this.zza.zzb();
    }

    public AdSize getAdSize() {
        return this.zza.zzc();
    }

    public String getAdUnitId() {
        return this.zza.zze();
    }

    public OnPaidEventListener getOnPaidEventListener() {
        return this.zza.zzu();
    }

    public ResponseInfo getResponseInfo() {
        return this.zza.zzs();
    }

    public boolean isLoading() {
        return this.zza.zzr();
    }

    public void loadAd(AdRequest adRequest) {
        this.zza.zzg(adRequest.zza());
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n6 = view.getMeasuredWidth();
            int n7 = view.getMeasuredHeight();
            n2 = (n4 - n2 - n6) / 2;
            n3 = (n5 - n3 - n7) / 2;
            view.layout(n2, n3, n6 + n2, n7 + n3);
        }
    }

    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n2, n3);
            n5 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            try {
                view = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzcgs.zzg((String)"Unable to retrieve ad size.", (Throwable)nullPointerException);
                view = null;
            }
            if (view != null) {
                Context context = this.getContext();
                n5 = view.getWidthInPixels(context);
                n4 = view.getHeightInPixels(context);
            } else {
                n4 = 0;
            }
        }
        n5 = Math.max(n5, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n5, (int)n2), View.resolveSize((int)n4, (int)n3));
    }

    public void pause() {
        this.zza.zzh();
    }

    public void resume() {
        this.zza.zzj();
    }

    public void setAdListener(AdListener adListener) {
        this.zza.zzk(adListener);
        if (adListener == null) {
            this.zza.zzl(null);
            return;
        }
        if (adListener instanceof zzbcz) {
            this.zza.zzl((zzbcz)adListener);
        }
        if (adListener instanceof AppEventListener) {
            this.zza.zzp((AppEventListener)adListener);
        }
    }

    public void setAdSize(AdSize adSize) {
        this.zza.zzm(adSize);
    }

    public void setAdUnitId(String string2) {
        this.zza.zzo(string2);
    }

    public void setOnPaidEventListener(OnPaidEventListener onPaidEventListener) {
        this.zza.zzt(onPaidEventListener);
    }
}

