/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video.spherical;

import com.google.android.exoplayer2.util.Assertions;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class Projection {
    public static final int DRAW_MODE_TRIANGLES = 0;
    public static final int DRAW_MODE_TRIANGLES_FAN = 2;
    public static final int DRAW_MODE_TRIANGLES_STRIP = 1;
    public static final int POSITION_COORDS_PER_VERTEX = 3;
    public static final int TEXTURE_COORDS_PER_VERTEX = 2;
    public final Mesh leftMesh;
    public final Mesh rightMesh;
    public final boolean singleMesh;
    public final int stereoMode;

    public Projection(Mesh mesh, int n2) {
        this(mesh, mesh, n2);
    }

    public Projection(Mesh mesh, Mesh mesh2, int n2) {
        this.leftMesh = mesh;
        this.rightMesh = mesh2;
        this.stereoMode = n2;
        boolean bl = mesh == mesh2;
        this.singleMesh = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Projection createEquirectangular(float f2, int n2, int n3, float f3, float f4, int n4) {
        int n5 = n2;
        int n6 = n3;
        boolean bl = f2 > 0.0f;
        Assertions.checkArgument(bl);
        bl = n5 >= 1;
        Assertions.checkArgument(bl);
        bl = n6 >= 1;
        Assertions.checkArgument(bl);
        bl = f3 > 0.0f && f3 <= 180.0f;
        Assertions.checkArgument(bl);
        bl = f4 > 0.0f && f4 <= 360.0f;
        Assertions.checkArgument(bl);
        float f5 = (float)Math.toRadians(f3);
        float f6 = (float)Math.toRadians(f4);
        float f7 = f5 / (float)n5;
        f4 = f6 / (float)n6;
        int n7 = n6 + 1;
        n5 = (n7 * 2 + 2) * n5;
        float[] fArray = new float[n5 * 3];
        float[] fArray2 = new float[n5 * 2];
        n5 = 0;
        int n8 = 0;
        int n9 = 0;
        block0: while (n5 < n2) {
            f3 = n5;
            float f8 = f5 / 2.0f;
            f3 = f3 * f7 - f8;
            int n10 = n5 + 1;
            float f9 = n10;
            int n11 = 0;
            int n12 = n5;
            n5 = n10;
            while (true) {
                if (n11 >= n7) continue block0;
                n10 = n8;
                int n13 = 0;
                n8 = n9;
                n9 = n10;
                n10 = n13;
                n13 = n11;
                n11 = n7;
                while (n10 < 2) {
                    float f10 = n10 == 0 ? f3 : f9 * f7 - f8;
                    float f11 = (float)n13 * f4;
                    float f12 = f6 / 2.0f;
                    n6 = n9 + 1;
                    double d2 = f2;
                    double d3 = f11 + (float)Math.PI - f12;
                    double d4 = Math.sin(d3);
                    Double.isNaN(d2);
                    double d5 = f10;
                    fArray[n9] = -((float)(d4 * d2 * Math.cos(d5)));
                    n9 = n6 + 1;
                    d4 = Math.sin(d5);
                    Double.isNaN(d2);
                    fArray[n6] = (float)(d2 * d4);
                    n6 = n9 + 1;
                    d3 = Math.cos(d3);
                    Double.isNaN(d2);
                    fArray[n9] = (float)(d2 * d3 * Math.cos(d5));
                    n7 = n8 + 1;
                    fArray2[n8] = f11 / f6;
                    n9 = n7 + 1;
                    fArray2[n7] = (float)(n12 + n10) * f7 / f5;
                    if (n13 == 0 && n10 == 0 || n13 == n3 && n10 == 1) {
                        System.arraycopy(fArray, n6 - 3, fArray, n6, 3);
                        n8 = n6 + 3;
                        System.arraycopy(fArray2, n9 - 2, fArray2, n9, 2);
                        n9 += 2;
                    } else {
                        n8 = n6;
                    }
                    n7 = n9;
                    ++n10;
                    n6 = n3;
                    n9 = n8;
                    n8 = n7;
                }
                n10 = n9;
                n9 = n8;
                n7 = n11;
                n11 = ++n13;
                n8 = n10;
            }
            break;
        }
        return new Projection(new Mesh(new SubMesh(0, fArray, fArray2, 1)), n4);
    }

    public static Projection createEquirectangular(int n2) {
        return Projection.createEquirectangular(50.0f, 36, 72, 180.0f, 360.0f, n2);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DrawMode {
    }

    public static final class Mesh {
        private final SubMesh[] subMeshes;

        public Mesh(SubMesh ... subMeshArray) {
            this.subMeshes = subMeshArray;
        }

        public SubMesh getSubMesh(int n2) {
            return this.subMeshes[n2];
        }

        public int getSubMeshCount() {
            return this.subMeshes.length;
        }
    }

    public static final class SubMesh {
        public static final int VIDEO_TEXTURE_ID = 0;
        public final int mode;
        public final float[] textureCoords;
        public final int textureId;
        public final float[] vertices;

        public SubMesh(int n2, float[] fArray, float[] fArray2, int n3) {
            this.textureId = n2;
            boolean bl = (long)fArray.length * 2L == (long)fArray2.length * 3L;
            Assertions.checkArgument(bl);
            this.vertices = fArray;
            this.textureCoords = fArray2;
            this.mode = n3;
        }

        public int getVertexCount() {
            return this.vertices.length / 3;
        }
    }
}

