/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import android.os.Handler;
import android.view.Surface;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video._$;

public interface VideoRendererEventListener {
    public void onDroppedFrames(int var1, long var2);

    public void onRenderedFirstFrame(Surface var1);

    public void onVideoDecoderInitialized(String var1, long var2, long var4);

    public void onVideoDecoderReleased(String var1);

    public void onVideoDisabled(DecoderCounters var1);

    public void onVideoEnabled(DecoderCounters var1);

    public void onVideoFrameProcessingOffset(long var1, int var3);

    @Deprecated
    public void onVideoInputFormatChanged(Format var1);

    public void onVideoInputFormatChanged(Format var1, DecoderReuseEvaluation var2);

    public void onVideoSizeChanged(int var1, int var2, int var3, float var4);

    public static final class EventDispatcher {
        private final Handler handler;
        private final VideoRendererEventListener listener;

        public EventDispatcher(Handler object, VideoRendererEventListener videoRendererEventListener) {
            object = videoRendererEventListener != null ? Assertions.checkNotNull(object) : null;
            this.handler = object;
            this.listener = videoRendererEventListener;
        }

        public void decoderInitialized(String string2, long l2, long l3) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post((Runnable)new _$.Lambda.VideoRendererEventListener.EventDispatcher.Y232CA7hogfrRJjYu2VeUSxg0VQ(this, string2, l2, l3));
            }
        }

        public void decoderReleased(String string2) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post((Runnable)new _$.Lambda.VideoRendererEventListener.EventDispatcher.r7DF8RZ9ts5IAikfXNf1G4rlSuw(this, string2));
            }
        }

        public void disabled(DecoderCounters decoderCounters) {
            decoderCounters.ensureUpdated();
            Handler handler = this.handler;
            if (handler != null) {
                handler.post((Runnable)new _$.Lambda.VideoRendererEventListener.EventDispatcher.WrYrl2koktWBYKOQMkK_LTzobgM(this, decoderCounters));
            }
        }

        public void droppedFrames(int n2, long l2) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post((Runnable)new _$.Lambda.VideoRendererEventListener.EventDispatcher.wpJzum9Nim_WREQi3I6t6RZgGzs(this, n2, l2));
            }
        }

        public void enabled(DecoderCounters decoderCounters) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post((Runnable)new _$.Lambda.VideoRendererEventListener.EventDispatcher.Zf6ofdxzBBJ5SL288lE0HglRj8g(this, decoderCounters));
            }
        }

        public void inputFormatChanged(Format format, DecoderReuseEvaluation decoderReuseEvaluation) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post((Runnable)new _$.Lambda.VideoRendererEventListener.EventDispatcher.oz_eisA2q_FTDGJOEtiN_azfdhs(this, format, decoderReuseEvaluation));
            }
        }

        public /* synthetic */ void lambda$decoderInitialized$1$VideoRendererEventListener$EventDispatcher(String string2, long l2, long l3) {
            Util.castNonNull(this.listener).onVideoDecoderInitialized(string2, l2, l3);
        }

        public /* synthetic */ void lambda$decoderReleased$7$VideoRendererEventListener$EventDispatcher(String string2) {
            Util.castNonNull(this.listener).onVideoDecoderReleased(string2);
        }

        public /* synthetic */ void lambda$disabled$8$VideoRendererEventListener$EventDispatcher(DecoderCounters decoderCounters) {
            decoderCounters.ensureUpdated();
            Util.castNonNull(this.listener).onVideoDisabled(decoderCounters);
        }

        public /* synthetic */ void lambda$droppedFrames$3$VideoRendererEventListener$EventDispatcher(int n2, long l2) {
            Util.castNonNull(this.listener).onDroppedFrames(n2, l2);
        }

        public /* synthetic */ void lambda$enabled$0$VideoRendererEventListener$EventDispatcher(DecoderCounters decoderCounters) {
            Util.castNonNull(this.listener).onVideoEnabled(decoderCounters);
        }

        public /* synthetic */ void lambda$inputFormatChanged$2$VideoRendererEventListener$EventDispatcher(Format format, DecoderReuseEvaluation decoderReuseEvaluation) {
            Util.castNonNull(this.listener).onVideoInputFormatChanged(format, decoderReuseEvaluation);
        }

        public /* synthetic */ void lambda$renderedFirstFrame$6$VideoRendererEventListener$EventDispatcher(Surface surface) {
            Util.castNonNull(this.listener).onRenderedFirstFrame(surface);
        }

        public /* synthetic */ void lambda$reportVideoFrameProcessingOffset$4$VideoRendererEventListener$EventDispatcher(long l2, int n2) {
            Util.castNonNull(this.listener).onVideoFrameProcessingOffset(l2, n2);
        }

        public /* synthetic */ void lambda$videoSizeChanged$5$VideoRendererEventListener$EventDispatcher(int n2, int n3, int n4, float f2) {
            Util.castNonNull(this.listener).onVideoSizeChanged(n2, n3, n4, f2);
        }

        public void renderedFirstFrame(Surface surface) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post((Runnable)new _$.Lambda.VideoRendererEventListener.EventDispatcher.lvbB9ufx_EW_aRPUEgazOqCqG1o(this, surface));
            }
        }

        public void reportVideoFrameProcessingOffset(long l2, int n2) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post((Runnable)new _$.Lambda.VideoRendererEventListener.EventDispatcher.MLUD7MV_bQM2tX9qfDFRcp0NSW4(this, l2, n2));
            }
        }

        public void videoSizeChanged(int n2, int n3, int n4, float f2) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.post((Runnable)new _$.Lambda.VideoRendererEventListener.EventDispatcher.qX0rv_q0N3E3GHjBeTczrImBbkY(this, n2, n3, n4, f2));
            }
        }
    }
}

