/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.app.Activity;
import android.app.UiModeManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.SystemClock;
import android.security.NetworkSecurityPolicy;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.SparseLongArray;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.LongArray;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util._$$Lambda$Util$MRC4FgxCpRGDforKj_F0m_7VaCA;
import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class Util {
    private static final int[] CRC32_BYTES_MSBF;
    private static final int[] CRC8_BYTES_MSBF;
    public static final String DEVICE;
    public static final String DEVICE_DEBUG_INFO;
    public static final byte[] EMPTY_BYTE_ARRAY;
    private static final Pattern ESCAPED_CHARACTER_PATTERN;
    private static final String ISM_DASH_FORMAT_EXTENSION = "format=mpd-time-csf";
    private static final String ISM_HLS_FORMAT_EXTENSION = "format=m3u8-aapl";
    private static final Pattern ISM_URL_PATTERN;
    public static final String MANUFACTURER;
    public static final String MODEL;
    public static final int SDK_INT;
    private static final String TAG = "Util";
    private static final Pattern XS_DATE_TIME_PATTERN;
    private static final Pattern XS_DURATION_PATTERN;
    private static final String[] additionalIsoLanguageReplacements;
    private static final String[] isoLegacyTagReplacements;
    private static HashMap<String, String> languageTagReplacementMap;

    static {
        int n2 = "S".equals(Build.VERSION.CODENAME) ? 31 : ("R".equals(Build.VERSION.CODENAME) ? 30 : Build.VERSION.SDK_INT);
        SDK_INT = n2;
        DEVICE = Build.DEVICE;
        MANUFACTURER = Build.MANUFACTURER;
        MODEL = Build.MODEL;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DEVICE);
        stringBuilder.append(", ");
        stringBuilder.append(MODEL);
        stringBuilder.append(", ");
        stringBuilder.append(MANUFACTURER);
        stringBuilder.append(", ");
        stringBuilder.append(SDK_INT);
        DEVICE_DEBUG_INFO = stringBuilder.toString();
        EMPTY_BYTE_ARRAY = new byte[0];
        XS_DATE_TIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)([\\.,](\\d+))?([Zz]|((\\+|\\-)(\\d?\\d):?(\\d\\d)))?");
        XS_DURATION_PATTERN = Pattern.compile("^(-)?P(([0-9]*)Y)?(([0-9]*)M)?(([0-9]*)D)?(T(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?)?$");
        ESCAPED_CHARACTER_PATTERN = Pattern.compile("%([A-Fa-f0-9]{2})");
        ISM_URL_PATTERN = Pattern.compile(".*\\.isml?(?:/(manifest(.*))?)?");
        additionalIsoLanguageReplacements = new String[]{"alb", "sq", "arm", "hy", "baq", "eu", "bur", "my", "tib", "bo", "chi", "zh", "cze", "cs", "dut", "nl", "ger", "de", "gre", "el", "fre", "fr", "geo", "ka", "ice", "is", "mac", "mk", "mao", "mi", "may", "ms", "per", "fa", "rum", "ro", "scc", "hbs-srp", "slo", "sk", "wel", "cy", "id", "ms-ind", "iw", "he", "heb", "he", "ji", "yi", "in", "ms-ind", "ind", "ms-ind", "nb", "no-nob", "nob", "no-nob", "nn", "no-nno", "nno", "no-nno", "tw", "ak-twi", "twi", "ak-twi", "bs", "hbs-bos", "bos", "hbs-bos", "hr", "hbs-hrv", "hrv", "hbs-hrv", "sr", "hbs-srp", "srp", "hbs-srp", "cmn", "zh-cmn", "hak", "zh-hak", "nan", "zh-nan", "hsn", "zh-hsn"};
        isoLegacyTagReplacements = new String[]{"i-lux", "lb", "i-hak", "zh-hak", "i-navajo", "nv", "no-bok", "no-nob", "no-nyn", "no-nno", "zh-guoyu", "zh-cmn", "zh-hakka", "zh-hak", "zh-min-nan", "zh-nan", "zh-xiang", "zh-hsn"};
        CRC32_BYTES_MSBF = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};
        CRC8_BYTES_MSBF = new int[]{0, 7, 14, 9, 28, 27, 18, 21, 56, 63, 54, 49, 36, 35, 42, 45, 112, 119, 126, 121, 108, 107, 98, 101, 72, 79, 70, 65, 84, 83, 90, 93, 224, 231, 238, 233, 252, 251, 242, 245, 216, 223, 214, 209, 196, 195, 202, 205, 144, 151, 158, 153, 140, 139, 130, 133, 168, 175, 166, 161, 180, 179, 186, 189, 199, 192, 201, 206, 219, 220, 213, 210, 255, 248, 241, 246, 227, 228, 237, 234, 183, 176, 185, 190, 171, 172, 165, 162, 143, 136, 129, 134, 147, 148, 157, 154, 39, 32, 41, 46, 59, 60, 53, 50, 31, 24, 17, 22, 3, 4, 13, 10, 87, 80, 89, 94, 75, 76, 69, 66, 111, 104, 97, 102, 115, 116, 125, 122, 137, 142, 135, 128, 149, 146, 155, 156, 177, 182, 191, 184, 173, 170, 163, 164, 249, 254, 247, 240, 229, 226, 235, 236, 193, 198, 207, 200, 221, 218, 211, 212, 105, 110, 103, 96, 117, 114, 123, 124, 81, 86, 95, 88, 77, 74, 67, 68, 25, 30, 23, 16, 5, 2, 11, 12, 33, 38, 47, 40, 61, 58, 51, 52, 78, 73, 64, 71, 82, 85, 92, 91, 118, 113, 120, 127, 106, 109, 100, 99, 62, 57, 48, 55, 34, 37, 44, 43, 6, 1, 8, 15, 26, 29, 20, 19, 174, 169, 160, 167, 178, 181, 188, 187, 150, 145, 152, 159, 138, 141, 132, 131, 222, 217, 208, 215, 194, 197, 204, 203, 230, 225, 232, 239, 250, 253, 244, 243};
    }

    private Util() {
    }

    public static long addWithOverflowDefault(long l2, long l3, long l4) {
        long l5 = l2 + l3;
        if (((l2 ^ l5) & (l3 ^ l5)) < 0L) {
            return l4;
        }
        return l5;
    }

    public static boolean areEqual(Object object, Object object2) {
        boolean bl = object == null ? object2 == null : object.equals(object2);
        return bl;
    }

    public static <T extends Comparable<? super T>> int binarySearchCeil(List<? extends Comparable<? super T>> list, T t2, boolean bl, boolean bl2) {
        int n2;
        int n3 = Collections.binarySearch(list, t2);
        if (n3 < 0) {
            n3 ^= 0xFFFFFFFF;
        } else {
            n2 = list.size();
            while (++n3 < n2 && list.get(n3).compareTo(t2) == 0) {
            }
            if (bl) {
                --n3;
            }
        }
        n2 = n3;
        if (bl2) {
            n2 = Math.min(list.size() - 1, n3);
        }
        return n2;
    }

    public static int binarySearchCeil(int[] nArray, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = n3 = Arrays.binarySearch(nArray, n2);
        if (n3 < 0) {
            n2 = ~n3;
        } else {
            while (++n4 < nArray.length && nArray[n4] == n2) {
            }
            n2 = bl ? n4 - 1 : n4;
        }
        n4 = n2;
        if (bl2) {
            n4 = Math.min(nArray.length - 1, n2);
        }
        return n4;
    }

    public static int binarySearchCeil(long[] lArray, long l2, boolean bl, boolean bl2) {
        int n2;
        int n3 = n2 = Arrays.binarySearch(lArray, l2);
        if (n2 < 0) {
            n3 = ~n2;
        } else {
            while (++n3 < lArray.length && lArray[n3] == l2) {
            }
            if (bl) {
                --n3;
            }
        }
        n2 = n3;
        if (bl2) {
            n2 = Math.min(lArray.length - 1, n3);
        }
        return n2;
    }

    public static int binarySearchFloor(LongArray longArray, long l2, boolean bl, boolean bl2) {
        int n2;
        block3: {
            block2: {
                n2 = longArray.size() - 1;
                int n3 = 0;
                while (n3 <= n2) {
                    int n4 = n3 + n2 >>> 1;
                    if (longArray.get(n4) < l2) {
                        n3 = n4 + 1;
                        continue;
                    }
                    n2 = n4 - 1;
                }
                if (!bl || (n3 = n2 + 1) >= longArray.size() || longArray.get(n3) != l2) break block2;
                n2 = n3;
                break block3;
            }
            if (!bl2 || n2 != -1) break block3;
            n2 = 0;
        }
        return n2;
    }

    public static <T extends Comparable<? super T>> int binarySearchFloor(List<? extends Comparable<? super T>> list, T t2, boolean bl, boolean bl2) {
        int n2;
        int n3 = n2 = Collections.binarySearch(list, t2);
        if (n2 < 0) {
            n3 = -(n2 + 2);
        } else {
            while (--n3 >= 0 && list.get(n3).compareTo(t2) == 0) {
            }
            if (bl) {
                ++n3;
            }
        }
        n2 = n3;
        if (bl2) {
            n2 = Math.max(0, n3);
        }
        return n2;
    }

    public static int binarySearchFloor(int[] nArray, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = n3 = Arrays.binarySearch(nArray, n2);
        if (n3 < 0) {
            n2 = -(n3 + 2);
        } else {
            while (--n4 >= 0 && nArray[n4] == n2) {
            }
            n2 = bl ? n4 + 1 : n4;
        }
        n4 = n2;
        if (bl2) {
            n4 = Math.max(0, n2);
        }
        return n4;
    }

    public static int binarySearchFloor(long[] lArray, long l2, boolean bl, boolean bl2) {
        int n2;
        int n3 = n2 = Arrays.binarySearch(lArray, l2);
        if (n2 < 0) {
            n3 = -(n2 + 2);
        } else {
            while (--n3 >= 0 && lArray[n3] == l2) {
            }
            if (bl) {
                ++n3;
            }
        }
        n2 = n3;
        if (bl2) {
            n2 = Math.max(0, n3);
        }
        return n2;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T castNonNull(T t2) {
        return t2;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[] castNonNullTypeArray(T[] TArray) {
        return TArray;
    }

    public static int ceilDivide(int n2, int n3) {
        return (n2 + n3 - 1) / n3;
    }

    public static long ceilDivide(long l2, long l3) {
        return (l2 + l3 - 1L) / l3;
    }

    public static boolean checkCleartextTrafficPermitted(MediaItem ... mediaItemArray) {
        if (SDK_INT < 24) {
            return true;
        }
        for (MediaItem mediaItem : mediaItemArray) {
            if (mediaItem.playbackProperties == null) continue;
            if (Util.isTrafficRestricted(mediaItem.playbackProperties.uri)) {
                return false;
            }
            for (int i2 = 0; i2 < mediaItem.playbackProperties.subtitles.size(); ++i2) {
                if (!Util.isTrafficRestricted(((MediaItem.Subtitle)mediaItem.playbackProperties.subtitles.get((int)i2)).uri)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(DataSource dataSource) {
        if (dataSource == null) return;
        try {
            dataSource.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static int compareLong(long l2, long l3) {
        int n2 = l2 < l3 ? -1 : (l2 == l3 ? 0 : 1);
        return n2;
    }

    public static float constrainValue(float f2, float f3, float f4) {
        return Math.max(f3, Math.min(f2, f4));
    }

    public static int constrainValue(int n2, int n3, int n4) {
        return Math.max(n3, Math.min(n2, n4));
    }

    public static long constrainValue(long l2, long l3, long l4) {
        return Math.max(l3, Math.min(l2, l4));
    }

    public static boolean contains(Object[] objectArray, Object object) {
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Util.areEqual(objectArray[i2], object)) continue;
            return true;
        }
        return false;
    }

    public static int crc32(byte[] byArray, int n2, int n3, int n4) {
        while (n2 < n3) {
            n4 = CRC32_BYTES_MSBF[(n4 >>> 24 ^ byArray[n2] & 0xFF) & 0xFF] ^ n4 << 8;
            ++n2;
        }
        return n4;
    }

    public static int crc8(byte[] byArray, int n2, int n3, int n4) {
        while (n2 < n3) {
            n4 = CRC8_BYTES_MSBF[n4 ^ byArray[n2] & 0xFF];
            ++n2;
        }
        return n4;
    }

    public static Handler createHandler(Looper looper, Handler.Callback callback2) {
        return new Handler(looper, callback2);
    }

    public static Handler createHandlerForCurrentLooper() {
        return Util.createHandlerForCurrentLooper(null);
    }

    public static Handler createHandlerForCurrentLooper(Handler.Callback callback2) {
        return Util.createHandler(Assertions.checkStateNotNull(Looper.myLooper()), callback2);
    }

    public static Handler createHandlerForCurrentOrMainLooper() {
        return Util.createHandlerForCurrentOrMainLooper(null);
    }

    public static Handler createHandlerForCurrentOrMainLooper(Handler.Callback callback2) {
        return Util.createHandler(Util.getCurrentOrMainLooper(), callback2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static HashMap<String, String> createIsoLanguageReplacementMap() {
        String[] stringArray = Locale.getISOLanguages();
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length + additionalIsoLanguageReplacements.length);
        int n2 = stringArray.length;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = n3;
            if (n4 >= n2) {
                while (n5 < (stringArray = additionalIsoLanguageReplacements).length) {
                    hashMap.put(stringArray[n5], stringArray[n5 + 1]);
                    n5 += 2;
                }
                return hashMap;
            }
            String string2 = stringArray[n4];
            try {
                Object object = new Locale(string2);
                object = ((Locale)object).getISO3Language();
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    hashMap.put((String)object, string2);
                }
            }
            catch (MissingResourceException missingResourceException) {}
            ++n4;
        }
    }

    public static File createTempDirectory(Context object, String string2) throws IOException {
        object = Util.createTempFile((Context)object, string2);
        ((File)object).delete();
        ((File)object).mkdir();
        return object;
    }

    public static File createTempFile(Context context, String string2) throws IOException {
        return File.createTempFile(string2, null, Assertions.checkNotNull(context.getCacheDir()));
    }

    public static String escapeFileName(String string2) {
        int n2;
        int n3 = string2.length();
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = n5;
            if (Util.shouldEscapeCharacter(string2.charAt(n2))) {
                n6 = n5 + 1;
            }
            n5 = n6;
        }
        if (n5 == 0) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n5 * 2 + n3);
        n2 = n5;
        n5 = n4;
        while (n2 > 0) {
            char c2 = string2.charAt(n5);
            if (Util.shouldEscapeCharacter(c2)) {
                stringBuilder.append('%');
                stringBuilder.append(Integer.toHexString(c2));
                --n2;
            } else {
                stringBuilder.append(c2);
            }
            ++n5;
        }
        if (n5 < n3) {
            stringBuilder.append(string2, n5, n3);
        }
        return stringBuilder.toString();
    }

    public static Uri fixSmoothStreamingIsmManifestUri(Uri uri) {
        String string2 = Util.toLowerInvariant(uri.getPath());
        if (string2 == null) {
            return uri;
        }
        Matcher matcher = ISM_URL_PATTERN.matcher(string2);
        string2 = uri;
        if (matcher.matches()) {
            string2 = uri;
            if (matcher.group(1) == null) {
                string2 = Uri.withAppendedPath((Uri)uri, (String)"Manifest");
            }
        }
        return string2;
    }

    public static String formatInvariant(String string2, Object ... objectArray) {
        return String.format(Locale.US, string2, objectArray);
    }

    public static String fromUtf8Bytes(byte[] byArray) {
        return new String(byArray, Charsets.UTF_8);
    }

    public static String fromUtf8Bytes(byte[] byArray, int n2, int n3) {
        return new String(byArray, n2, n3, Charsets.UTF_8);
    }

    public static String getAdaptiveMimeTypeForContentType(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return null;
                }
                return "application/x-mpegURL";
            }
            return "application/vnd.ms-sstr+xml";
        }
        return "application/dash+xml";
    }

    public static int getAudioContentTypeForStreamType(int n2) {
        if (n2 != 0) {
            if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 5 && n2 != 8) {
                return 2;
            }
            return 4;
        }
        return 1;
    }

    public static int getAudioTrackChannelConfig(int n2) {
        switch (n2) {
            default: {
                return 0;
            }
            case 8: {
                n2 = SDK_INT;
                if (n2 >= 23) {
                    return 6396;
                }
                if (n2 >= 21) {
                    return 6396;
                }
                return 0;
            }
            case 7: {
                return 1276;
            }
            case 6: {
                return 252;
            }
            case 5: {
                return 220;
            }
            case 4: {
                return 204;
            }
            case 3: {
                return 28;
            }
            case 2: {
                return 12;
            }
            case 1: 
        }
        return 4;
    }

    public static int getAudioUsageForStreamType(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    int n3 = 4;
                    if (n2 != 4) {
                        n3 = 5;
                        if (n2 != 5) {
                            if (n2 != 8) {
                                return 1;
                            }
                            return 3;
                        }
                    }
                    return n3;
                }
                return 6;
            }
            return 13;
        }
        return 2;
    }

    public static int getBigEndianInt(ByteBuffer byteBuffer, int n2) {
        n2 = byteBuffer.getInt(n2);
        if (byteBuffer.order() != ByteOrder.BIG_ENDIAN) {
            n2 = Integer.reverseBytes(n2);
        }
        return n2;
    }

    public static byte[] getBytesFromHexString(String string2) {
        byte[] byArray = new byte[string2.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = i2 * 2;
            byArray[i2] = (byte)((Character.digit(string2.charAt(n2), 16) << 4) + Character.digit(string2.charAt(n2 + 1), 16));
        }
        return byArray;
    }

    public static int getCodecCountOfType(String stringArray, int n2) {
        stringArray = Util.splitCodecs((String)stringArray);
        int n3 = stringArray.length;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = n4;
            if (n2 == MimeTypes.getTrackTypeOfCodec((String)stringArray[i2])) {
                n5 = n4 + 1;
            }
            n4 = n5;
        }
        return n4;
    }

    public static String getCodecsOfType(String string2, int n2) {
        String[] stringArray = Util.splitCodecs(string2);
        int n3 = stringArray.length;
        string2 = null;
        if (n3 == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            if (n2 != MimeTypes.getTrackTypeOfCodec((String)string3)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string3);
        }
        if (stringBuilder.length() > 0) {
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public static String getCommaDelimitedSimpleClassNames(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringBuilder.append(objectArray[i2].getClass().getSimpleName());
            if (i2 >= objectArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String getCountryCode(Context object) {
        if (object != null && (object = (TelephonyManager)object.getSystemService("phone")) != null && !TextUtils.isEmpty((CharSequence)(object = object.getNetworkCountryIso()))) {
            return Util.toUpperInvariant((String)object);
        }
        return Util.toUpperInvariant(Locale.getDefault().getCountry());
    }

    public static Point getCurrentDisplayModeSize(Context context) {
        return Util.getCurrentDisplayModeSize(context, Assertions.checkNotNull((WindowManager)context.getSystemService("window")).getDefaultDisplay());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Point getCurrentDisplayModeSize(Context object, Display display) {
        int n2;
        if (SDK_INT <= 29 && display.getDisplayId() == 0 && Util.isTv((Context)object)) {
            if ("Sony".equals(MANUFACTURER) && MODEL.startsWith("BRAVIA") && object.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd")) {
                return new Point(3840, 2160);
            }
            object = SDK_INT < 28 ? Util.getSystemProperty("sys.display-size") : Util.getSystemProperty("vendor.display-size");
            if (!TextUtils.isEmpty((CharSequence)object)) {
                Object object2;
                try {
                    object2 = Util.split(((String)object).trim(), "x");
                    if (((String[])object2).length == 2) {
                        n2 = Integer.parseInt((String)object2[0]);
                        int n3 = Integer.parseInt((String)object2[1]);
                        if (n2 > 0 && n3 > 0) {
                            return new Point(n2, n3);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Invalid display size: ");
                ((StringBuilder)object2).append((String)object);
                Log.e(TAG, ((StringBuilder)object2).toString());
            }
        }
        object = new Point();
        n2 = SDK_INT;
        if (n2 >= 23) {
            Util.getDisplaySizeV23(display, (Point)object);
            return object;
        }
        if (n2 >= 17) {
            Util.getDisplaySizeV17(display, (Point)object);
            return object;
        }
        Util.getDisplaySizeV16(display, (Point)object);
        return object;
    }

    public static Looper getCurrentOrMainLooper() {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        return looper;
    }

    public static Uri getDataUriForString(String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("data:");
        stringBuilder.append(string2);
        stringBuilder.append(";base64,");
        stringBuilder.append(Base64.encodeToString((byte[])string3.getBytes(), (int)2));
        return Uri.parse((String)stringBuilder.toString());
    }

    private static void getDisplaySizeV16(Display display, Point point) {
        display.getSize(point);
    }

    private static void getDisplaySizeV17(Display display, Point point) {
        display.getRealSize(point);
    }

    private static void getDisplaySizeV23(Display display, Point point) {
        display = display.getMode();
        point.x = display.getPhysicalWidth();
        point.y = display.getPhysicalHeight();
    }

    /*
     * Unable to fully structure code
     */
    public static UUID getDrmUuid(String var0) {
        block9: {
            block7: {
                block8: {
                    var1_2 = Util.toLowerInvariant((String)var0);
                    var2_3 = var1_2.hashCode();
                    if (var2_3 == -1860423953) break block7;
                    if (var2_3 == -1400551171) break block8;
                    if (var2_3 != 790309106 || !var1_2.equals("clearkey")) ** GOTO lbl-1000
                    var2_3 = 2;
                    break block9;
                }
                if (!var1_2.equals("widevine")) ** GOTO lbl-1000
                var2_3 = 0;
                break block9;
            }
            if (var1_2.equals("playready")) {
                var2_3 = 1;
            } else lbl-1000:
            // 3 sources

            {
                var2_3 = -1;
            }
        }
        if (var2_3 != 0) {
            if (var2_3 != 1) {
                if (var2_3 != 2) {
                    try {
                        var0 = UUID.fromString((String)var0);
                        return var0;
                    }
                    catch (RuntimeException var0_1) {
                        return null;
                    }
                }
                return C.CLEARKEY_UUID;
            }
            return C.PLAYREADY_UUID;
        }
        return C.WIDEVINE_UUID;
    }

    public static int getIntegerCodeForString(String string2) {
        int n2 = string2.length();
        boolean bl = n2 <= 4;
        Assertions.checkArgument(bl);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 << 8 | string2.charAt(i2);
        }
        return n3;
    }

    public static String getLocaleLanguageTag(Locale object) {
        object = SDK_INT >= 21 ? Util.getLocaleLanguageTagV21((Locale)object) : ((Locale)object).toString();
        return object;
    }

    private static String getLocaleLanguageTagV21(Locale locale) {
        return locale.toLanguageTag();
    }

    public static long getMediaDurationForPlayoutDuration(long l2, float f2) {
        if (f2 == 1.0f) {
            return l2;
        }
        double d2 = l2;
        double d3 = f2;
        Double.isNaN(d2);
        Double.isNaN(d3);
        return Math.round(d2 * d3);
    }

    private static int getMobileNetworkType(NetworkInfo networkInfo) {
        switch (networkInfo.getSubtype()) {
            default: {
                return 6;
            }
            case 20: {
                int n2 = SDK_INT >= 29 ? 9 : 0;
                return n2;
            }
            case 18: {
                return 2;
            }
            case 13: {
                return 5;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return 4;
            }
            case 1: 
            case 2: 
        }
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getNetworkType(Context context) {
        int n2;
        int n3 = 0;
        if (context == null) {
            return 0;
        }
        if ((context = (ConnectivityManager)context.getSystemService("connectivity")) == null) {
            return 0;
        }
        try {
            context = context.getActiveNetworkInfo();
            n3 = n2 = 1;
            if (context == null) return n3;
        }
        catch (SecurityException securityException) {
            return n3;
        }
        if (!context.isConnected()) {
            return n2;
        }
        n3 = context.getType();
        if (n3 == 0) return Util.getMobileNetworkType((NetworkInfo)context);
        if (n3 == 1) return 2;
        if (n3 == 4) return Util.getMobileNetworkType((NetworkInfo)context);
        if (n3 == 5) return Util.getMobileNetworkType((NetworkInfo)context);
        if (n3 == 6) return 5;
        if (n3 == 9) return 7;
        return 8;
    }

    public static long getNowUnixTimeMs(long l2) {
        l2 = l2 == -9223372036854775807L ? System.currentTimeMillis() : (l2 += SystemClock.elapsedRealtime());
        return l2;
    }

    public static int getPcmEncoding(int n2) {
        if (n2 != 8) {
            if (n2 != 16) {
                if (n2 != 24) {
                    if (n2 != 32) {
                        return 0;
                    }
                    return 0x30000000;
                }
                return 0x20000000;
            }
            return 2;
        }
        return 3;
    }

    public static Format getPcmFormat(int n2, int n3, int n4) {
        return new Format.Builder().setSampleMimeType("audio/raw").setChannelCount(n3).setSampleRate(n4).setPcmEncoding(n2).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getPcmFrameSize(int n2, int n3) {
        if (n2 == 2) return n3 * 2;
        int n4 = n3;
        if (n2 == 3) return n4;
        if (n2 == 4) return n3 * 4;
        if (n2 == 0x10000000) return n3 * 2;
        if (n2 == 0x20000000) return n3 * 3;
        if (n2 != 0x30000000) throw new IllegalArgumentException();
        return n3 * 4;
    }

    public static long getPlayoutDurationForMediaDuration(long l2, float f2) {
        if (f2 == 1.0f) {
            return l2;
        }
        double d2 = l2;
        double d3 = f2;
        Double.isNaN(d2);
        Double.isNaN(d3);
        return Math.round(d2 / d3);
    }

    public static int getStreamTypeForAudioUsage(int n2) {
        switch (n2) {
            default: {
                return 3;
            }
            case 13: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 2: {
                return 0;
            }
            case 1: 
            case 12: 
            case 14: 
        }
        return 3;
    }

    public static String getStringForTime(StringBuilder charSequence, Formatter formatter, long l2) {
        long l3 = l2;
        if (l2 == -9223372036854775807L) {
            l3 = 0L;
        }
        String string2 = l3 < 0L ? "-" : "";
        long l4 = (Math.abs(l3) + 500L) / 1000L;
        l3 = l4 % 60L;
        l2 = l4 / 60L % 60L;
        charSequence.setLength(0);
        charSequence = (l4 /= 3600L) > 0L ? formatter.format("%s%d:%02d:%02d", string2, l4, l2, l3).toString() : formatter.format("%s%02d:%02d", string2, l2, l3).toString();
        return charSequence;
    }

    public static String[] getSystemLanguageCodes() {
        String[] stringArray = Util.getSystemLocales();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = Util.normalizeLanguageCode(stringArray[i2]);
        }
        return stringArray;
    }

    private static String[] getSystemLocales() {
        String[] stringArray = Resources.getSystem().getConfiguration();
        stringArray = SDK_INT >= 24 ? Util.getSystemLocalesV24((Configuration)stringArray) : new String[]{Util.getLocaleLanguageTag(stringArray.locale)};
        return stringArray;
    }

    private static String[] getSystemLocalesV24(Configuration configuration) {
        return Util.split(configuration.getLocales().toLanguageTags(), ",");
    }

    private static String getSystemProperty(String string2) {
        try {
            Object object = Class.forName("android.os.SystemProperties");
            object = (String)((Class)object).getMethod("get", String.class).invoke(object, string2);
            return object;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to read system property ");
            stringBuilder.append(string2);
            Log.e(TAG, stringBuilder.toString(), exception);
            return null;
        }
    }

    public static String getTrackTypeString(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 5) {
                            if (n2 != 6) {
                                if (n2 != 7) {
                                    CharSequence charSequence;
                                    if (n2 >= 10000) {
                                        charSequence = new StringBuilder();
                                        ((StringBuilder)charSequence).append("custom (");
                                        ((StringBuilder)charSequence).append(n2);
                                        ((StringBuilder)charSequence).append(")");
                                        charSequence = ((StringBuilder)charSequence).toString();
                                    } else {
                                        charSequence = "?";
                                    }
                                    return charSequence;
                                }
                                return "none";
                            }
                            return "camera motion";
                        }
                        return "metadata";
                    }
                    return "text";
                }
                return "video";
            }
            return "audio";
        }
        return "default";
    }

    public static String getUserAgent(Context object, String string2) {
        CharSequence charSequence;
        try {
            charSequence = object.getPackageName();
            object = object.getPackageManager().getPackageInfo((String)charSequence, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = "?";
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append("/");
        ((StringBuilder)charSequence).append((String)object);
        ((StringBuilder)charSequence).append(" (Linux;Android ");
        ((StringBuilder)charSequence).append(Build.VERSION.RELEASE);
        ((StringBuilder)charSequence).append(") ");
        ((StringBuilder)charSequence).append("ExoPlayerLib/2.13.3");
        return ((StringBuilder)charSequence).toString();
    }

    public static byte[] getUtf8Bytes(String string2) {
        return string2.getBytes(Charsets.UTF_8);
    }

    /*
     * Exception decompiling
     */
    public static byte[] gzip(byte[] var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int inferContentType(Uri object) {
        int n2 = (object = object.getPath()) == null ? 3 : Util.inferContentType((String)object);
        return n2;
    }

    public static int inferContentType(Uri object, String string2) {
        int n2;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            n2 = Util.inferContentType((Uri)object);
        } else {
            object = new StringBuilder();
            ((StringBuilder)object).append(".");
            ((StringBuilder)object).append(string2);
            n2 = Util.inferContentType(((StringBuilder)object).toString());
        }
        return n2;
    }

    public static int inferContentType(String object) {
        if (((String)(object = Util.toLowerInvariant((String)object))).endsWith(".mpd")) {
            return 0;
        }
        if (((String)object).endsWith(".m3u8")) {
            return 2;
        }
        if (((Matcher)(object = ISM_URL_PATTERN.matcher((CharSequence)object))).matches()) {
            if ((object = ((Matcher)object).group(2)) != null) {
                if (((String)object).contains(ISM_DASH_FORMAT_EXTENSION)) {
                    return 0;
                }
                if (((String)object).contains(ISM_HLS_FORMAT_EXTENSION)) {
                    return 2;
                }
            }
            return 1;
        }
        return 3;
    }

    public static int inferContentTypeForUriAndMimeType(Uri uri, String string2) {
        if (string2 == null) {
            return Util.inferContentType(uri);
        }
        int n2 = -1;
        int n3 = string2.hashCode();
        if (n3 != -979127466) {
            if (n3 != -156749520) {
                if (n3 == 64194685 && string2.equals("application/dash+xml")) {
                    n2 = 0;
                }
            } else if (string2.equals("application/vnd.ms-sstr+xml")) {
                n2 = 2;
            }
        } else if (string2.equals("application/x-mpegURL")) {
            n2 = 1;
        }
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return 3;
                }
                return 1;
            }
            return 2;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean inflate(ParsableByteArray parsableByteArray, ParsableByteArray parsableByteArray2, Inflater inflater) {
        if (parsableByteArray.bytesLeft() <= 0) {
            return false;
        }
        if (parsableByteArray2.capacity() < parsableByteArray.bytesLeft()) {
            parsableByteArray2.ensureCapacity(parsableByteArray.bytesLeft() * 2);
        }
        Inflater inflater2 = inflater;
        if (inflater == null) {
            inflater2 = new Inflater();
        }
        inflater2.setInput(parsableByteArray.getData(), parsableByteArray.getPosition(), parsableByteArray.bytesLeft());
        int n2 = 0;
        try {
            while (true) {
                int n3 = n2 + inflater2.inflate(parsableByteArray2.getData(), n2, parsableByteArray2.capacity() - n2);
                if (inflater2.finished()) {
                    parsableByteArray2.setLimit(n3);
                    inflater2.reset();
                    return true;
                }
                if (inflater2.needsDictionary() || inflater2.needsInput()) break;
                n2 = n3;
                if (n3 != parsableByteArray2.capacity()) continue;
                parsableByteArray2.ensureCapacity(parsableByteArray2.capacity() * 2);
                n2 = n3;
            }
            inflater2.reset();
            return false;
        }
        catch (DataFormatException dataFormatException) {
            return false;
        }
        finally {
            inflater2.reset();
        }
    }

    public static boolean isEncodingHighResolutionPcm(int n2) {
        boolean bl = n2 == 0x20000000 || n2 == 0x30000000 || n2 == 4;
        return bl;
    }

    public static boolean isEncodingLinearPcm(int n2) {
        boolean bl = n2 == 3 || n2 == 2 || n2 == 0x10000000 || n2 == 0x20000000 || n2 == 0x30000000 || n2 == 4;
        return bl;
    }

    public static boolean isLinebreak(int n2) {
        boolean bl = n2 == 10 || n2 == 13;
        return bl;
    }

    public static boolean isLocalFileUri(Uri object) {
        boolean bl = TextUtils.isEmpty((CharSequence)(object = object.getScheme())) || "file".equals(object);
        return bl;
    }

    private static boolean isTrafficRestricted(Uri uri) {
        boolean bl = "http".equals(uri.getScheme()) && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(Assertions.checkNotNull(uri.getHost()));
        return bl;
    }

    public static boolean isTv(Context context) {
        boolean bl = (context = (UiModeManager)context.getApplicationContext().getSystemService("uimode")) != null && context.getCurrentModeType() == 4;
        return bl;
    }

    static /* synthetic */ Thread lambda$newSingleThreadExecutor$0(String string2, Runnable runnable2) {
        return new Thread(runnable2, string2);
    }

    public static int linearSearch(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static int linearSearch(long[] lArray, long l2) {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (lArray[i2] != l2) continue;
            return i2;
        }
        return -1;
    }

    private static String maybeReplaceLegacyLanguageTags(String string2) {
        Object object;
        for (int i2 = 0; i2 < ((String[])(object = isoLegacyTagReplacements)).length; i2 += 2) {
            if (!string2.startsWith(object[i2])) continue;
            object = new StringBuilder();
            ((StringBuilder)object).append(isoLegacyTagReplacements[i2 + 1]);
            ((StringBuilder)object).append(string2.substring(isoLegacyTagReplacements[i2].length()));
            return ((StringBuilder)object).toString();
        }
        return string2;
    }

    public static boolean maybeRequestReadExternalStoragePermission(Activity activity, Uri ... uriArray) {
        if (SDK_INT < 23) {
            return false;
        }
        int n2 = uriArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Util.isLocalFileUri(uriArray[i2])) continue;
            return Util.requestExternalStoragePermission(activity);
        }
        return false;
    }

    public static boolean maybeRequestReadExternalStoragePermission(Activity activity, MediaItem ... mediaItemArray) {
        if (SDK_INT < 23) {
            return false;
        }
        for (MediaItem mediaItem : mediaItemArray) {
            if (mediaItem.playbackProperties == null) continue;
            if (Util.isLocalFileUri(mediaItem.playbackProperties.uri)) {
                return Util.requestExternalStoragePermission(activity);
            }
            for (int i2 = 0; i2 < mediaItem.playbackProperties.subtitles.size(); ++i2) {
                if (!Util.isLocalFileUri(((MediaItem.Subtitle)mediaItem.playbackProperties.subtitles.get((int)i2)).uri)) continue;
                return Util.requestExternalStoragePermission(activity);
            }
        }
        return false;
    }

    public static long minValue(SparseLongArray object) {
        if (object.size() != 0) {
            long l2 = Long.MAX_VALUE;
            for (int i2 = 0; i2 < object.size(); ++i2) {
                l2 = Math.min(l2, object.valueAt(i2));
            }
            return l2;
        }
        object = new NoSuchElementException();
        throw object;
    }

    public static <T> void moveItems(List<T> list, int n2, int n3, int n4) {
        ArrayDeque<T> arrayDeque = new ArrayDeque<T>();
        for (n3 = n3 - n2 - 1; n3 >= 0; --n3) {
            arrayDeque.addFirst(list.remove(n2 + n3));
        }
        list.addAll(Math.min(n4, list.size()), arrayDeque);
    }

    public static ExecutorService newSingleThreadExecutor(String string2) {
        return Executors.newSingleThreadExecutor(new _$$Lambda$Util$MRC4FgxCpRGDforKj_F0m_7VaCA(string2));
    }

    public static String normalizeLanguageCode(String charSequence) {
        CharSequence charSequence2;
        block8: {
            block7: {
                if (charSequence == null) {
                    return null;
                }
                charSequence2 = ((String)charSequence).replace('_', '-');
                CharSequence charSequence3 = charSequence;
                if (!charSequence2.isEmpty()) {
                    charSequence3 = "und".equals(charSequence2) ? charSequence : charSequence2;
                }
                String string2 = Util.toLowerInvariant(charSequence3);
                String string3 = Util.splitAtFirst(string2, "-")[0];
                if (languageTagReplacementMap == null) {
                    languageTagReplacementMap = Util.createIsoLanguageReplacementMap();
                }
                charSequence2 = languageTagReplacementMap.get(string3);
                charSequence3 = string3;
                charSequence = string2;
                if (charSequence2 != null) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append((String)charSequence2);
                    ((StringBuilder)charSequence).append(string2.substring(string3.length()));
                    charSequence = ((StringBuilder)charSequence).toString();
                    charSequence3 = charSequence2;
                }
                if ("no".equals(charSequence3) || "i".equals(charSequence3)) break block7;
                charSequence2 = charSequence;
                if (!"zh".equals(charSequence3)) break block8;
            }
            charSequence2 = Util.maybeReplaceLegacyLanguageTags((String)charSequence);
        }
        return charSequence2;
    }

    public static <T> T[] nullSafeArrayAppend(T[] TArray, T t2) {
        T[] TArray2 = Arrays.copyOf(TArray, TArray.length + 1);
        TArray2[TArray.length] = t2;
        return Util.castNonNullTypeArray(TArray2);
    }

    public static <T> T[] nullSafeArrayConcatenation(T[] TArray, T[] TArray2) {
        T[] TArray3 = Arrays.copyOf(TArray, TArray.length + TArray2.length);
        System.arraycopy(TArray2, 0, TArray3, TArray.length, TArray2.length);
        return TArray3;
    }

    public static <T> T[] nullSafeArrayCopy(T[] TArray, int n2) {
        boolean bl = n2 <= TArray.length;
        Assertions.checkArgument(bl);
        return Arrays.copyOf(TArray, n2);
    }

    public static <T> T[] nullSafeArrayCopyOfRange(T[] TArray, int n2, int n3) {
        boolean bl = true;
        boolean bl2 = n2 >= 0;
        Assertions.checkArgument(bl2);
        bl2 = n3 <= TArray.length ? bl : false;
        Assertions.checkArgument(bl2);
        return Arrays.copyOfRange(TArray, n2, n3);
    }

    public static <T> void nullSafeListToArray(List<T> list, T[] TArray) {
        boolean bl = list.size() == TArray.length;
        Assertions.checkState(bl);
        list.toArray(TArray);
    }

    public static long parseXsDateTime(String object) throws ParserException {
        Object object2 = XS_DATE_TIME_PATTERN.matcher((CharSequence)object);
        if (((Matcher)object2).matches()) {
            long l2;
            object = ((Matcher)object2).group(9);
            int n2 = 0;
            if (object != null && !((Matcher)object2).group(9).equalsIgnoreCase("Z")) {
                int n3;
                n2 = n3 = Integer.parseInt(((Matcher)object2).group(12)) * 60 + Integer.parseInt(((Matcher)object2).group(13));
                if ("-".equals(((Matcher)object2).group(11))) {
                    n2 = n3 * -1;
                }
            }
            object = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            ((Calendar)object).clear();
            ((Calendar)object).set(Integer.parseInt(((Matcher)object2).group(1)), Integer.parseInt(((Matcher)object2).group(2)) - 1, Integer.parseInt(((Matcher)object2).group(3)), Integer.parseInt(((Matcher)object2).group(4)), Integer.parseInt(((Matcher)object2).group(5)), Integer.parseInt(((Matcher)object2).group(6)));
            if (!TextUtils.isEmpty((CharSequence)((Matcher)object2).group(8))) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0.");
                stringBuilder.append(((Matcher)object2).group(8));
                ((Calendar)object).set(14, new BigDecimal(stringBuilder.toString()).movePointRight(3).intValue());
            }
            long l3 = l2 = ((Calendar)object).getTimeInMillis();
            if (n2 != 0) {
                l3 = l2 - (long)(n2 * 60000);
            }
            return l3;
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Invalid date/time format: ");
        ((StringBuilder)object2).append((String)object);
        throw new ParserException(((StringBuilder)object2).toString());
    }

    public static long parseXsDuration(String string2) {
        Matcher matcher = XS_DURATION_PATTERN.matcher(string2);
        if (matcher.matches()) {
            long l2;
            boolean bl = TextUtils.isEmpty((CharSequence)matcher.group(1));
            string2 = matcher.group(3);
            double d2 = 0.0;
            double d3 = string2 != null ? Double.parseDouble(string2) * 3.1556908E7 : 0.0;
            string2 = matcher.group(5);
            double d4 = string2 != null ? Double.parseDouble(string2) * 2629739.0 : 0.0;
            string2 = matcher.group(7);
            double d5 = string2 != null ? Double.parseDouble(string2) * 86400.0 : 0.0;
            string2 = matcher.group(10);
            double d6 = string2 != null ? 3600.0 * Double.parseDouble(string2) : 0.0;
            string2 = matcher.group(12);
            double d7 = string2 != null ? Double.parseDouble(string2) * 60.0 : 0.0;
            string2 = matcher.group(14);
            if (string2 != null) {
                d2 = Double.parseDouble(string2);
            }
            long l3 = l2 = (long)((d3 + d4 + d5 + d6 + d7 + d2) * 1000.0);
            if (true ^ bl) {
                l3 = -l2;
            }
            return l3;
        }
        return (long)(Double.parseDouble(string2) * 3600.0 * 1000.0);
    }

    public static boolean postOrRun(Handler handler, Runnable runnable2) {
        if (!handler.getLooper().getThread().isAlive()) {
            return false;
        }
        if (handler.getLooper() == Looper.myLooper()) {
            runnable2.run();
            return true;
        }
        return handler.post(runnable2);
    }

    public static boolean readBoolean(Parcel parcel) {
        boolean bl = parcel.readInt() != 0;
        return bl;
    }

    public static byte[] readExactly(DataSource object, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; i2 += n3) {
            n3 = object.read(byArray, i2, byArray.length - i2);
            if (n3 != -1) {
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Not enough data could be read: ");
            ((StringBuilder)object).append(i2);
            ((StringBuilder)object).append(" < ");
            ((StringBuilder)object).append(n2);
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
        return byArray;
    }

    public static byte[] readToEnd(DataSource dataSource) throws IOException {
        byte[] byArray = new byte[1024];
        int n2 = 0;
        int n3 = 0;
        while (n2 != -1) {
            byte[] byArray2 = byArray;
            if (n3 == byArray.length) {
                byArray2 = Arrays.copyOf(byArray, byArray.length * 2);
            }
            int n4 = dataSource.read(byArray2, n3, byArray2.length - n3);
            byArray = byArray2;
            n2 = n4;
            if (n4 == -1) continue;
            n3 += n4;
            byArray = byArray2;
            n2 = n4;
        }
        return Arrays.copyOf(byArray, n3);
    }

    public static void recursiveDelete(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Util.recursiveDelete(fileArray[i2]);
            }
        }
        file.delete();
    }

    public static <T> void removeRange(List<T> list, int n2, int n3) {
        if (n2 >= 0 && n3 <= list.size() && n2 <= n3) {
            if (n2 != n3) {
                list.subList(n2, n3).clear();
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private static boolean requestExternalStoragePermission(Activity activity) {
        if (activity.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0) {
            activity.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 0);
            return true;
        }
        return false;
    }

    public static long scaleLargeTimestamp(long l2, long l3, long l4) {
        if (l4 >= l3 && l4 % l3 == 0L) {
            return l2 / (l4 / l3);
        }
        if (l4 < l3 && l3 % l4 == 0L) {
            return l2 * (l3 / l4);
        }
        double d2 = l3;
        double d3 = l4;
        Double.isNaN(d2);
        Double.isNaN(d3);
        d3 = d2 / d3;
        d2 = l2;
        Double.isNaN(d2);
        return (long)(d2 * d3);
    }

    public static long[] scaleLargeTimestamps(List<Long> list, long l2, long l3) {
        int n2;
        long[] lArray = new long[list.size()];
        int n3 = 0;
        int n4 = 0;
        if (l3 >= l2 && l3 % l2 == 0L) {
            l2 = l3 / l2;
            for (n2 = 0; n2 < lArray.length; ++n2) {
                lArray[n2] = list.get(n2) / l2;
            }
        } else if (l3 < l2 && l2 % l3 == 0L) {
            l2 /= l3;
            for (n2 = n3; n2 < lArray.length; ++n2) {
                lArray[n2] = list.get(n2) * l2;
            }
        } else {
            double d2 = l2;
            double d3 = l3;
            Double.isNaN(d2);
            Double.isNaN(d3);
            d2 /= d3;
            for (n2 = n4; n2 < lArray.length; ++n2) {
                d3 = list.get(n2).longValue();
                Double.isNaN(d3);
                lArray[n2] = (long)(d3 * d2);
            }
        }
        return lArray;
    }

    public static void scaleLargeTimestampsInPlace(long[] lArray, long l2, long l3) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (l3 >= l2 && l3 % l2 == 0L) {
            l2 = l3 / l2;
            for (n2 = 0; n2 < lArray.length; ++n2) {
                lArray[n2] = lArray[n2] / l2;
            }
        } else if (l3 < l2 && l2 % l3 == 0L) {
            l2 /= l3;
            for (n2 = n3; n2 < lArray.length; ++n2) {
                lArray[n2] = lArray[n2] * l2;
            }
        } else {
            double d2 = l2;
            double d3 = l3;
            Double.isNaN(d2);
            Double.isNaN(d3);
            d3 = d2 / d3;
            for (n2 = n4; n2 < lArray.length; ++n2) {
                d2 = lArray[n2];
                Double.isNaN(d2);
                lArray[n2] = (long)(d2 * d3);
            }
        }
    }

    private static boolean shouldEscapeCharacter(char c2) {
        return c2 == '\"' || c2 == '%' || c2 == '*' || c2 == '/' || c2 == ':' || c2 == '<' || c2 == '\\' || c2 == '|' || c2 == '>' || c2 == '?';
    }

    public static void sneakyThrow(Throwable throwable) {
        Util.sneakyThrowInternal(throwable);
    }

    private static <T extends Throwable> void sneakyThrowInternal(Throwable throwable) throws T {
        throw throwable;
    }

    public static String[] split(String string2, String string3) {
        return string2.split(string3, -1);
    }

    public static String[] splitAtFirst(String string2, String string3) {
        return string2.split(string3, 2);
    }

    public static String[] splitCodecs(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return new String[0];
        }
        return Util.split(string2.trim(), "(\\s*,\\s*)");
    }

    public static ComponentName startForegroundService(Context context, Intent intent) {
        if (SDK_INT >= 26) {
            return context.startForegroundService(intent);
        }
        return context.startService(intent);
    }

    public static long subtractWithOverflowDefault(long l2, long l3, long l4) {
        long l5 = l2 - l3;
        if (((l2 ^ l5) & (l3 ^ l2)) < 0L) {
            return l4;
        }
        return l5;
    }

    public static boolean tableExists(SQLiteDatabase sQLiteDatabase, String string2) {
        boolean bl = true;
        if (DatabaseUtils.queryNumEntries((SQLiteDatabase)sQLiteDatabase, (String)"sqlite_master", (String)"tbl_name = ?", (String[])new String[]{string2}) <= 0L) {
            bl = false;
        }
        return bl;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuilder.append(Character.forDigit(byArray[i2] >> 4 & 0xF, 16));
            stringBuilder.append(Character.forDigit(byArray[i2] & 0xF, 16));
        }
        return stringBuilder.toString();
    }

    public static long toLong(int n2, int n3) {
        long l2 = Util.toUnsignedLong(n2);
        return Util.toUnsignedLong(n3) | l2 << 32;
    }

    public static String toLowerInvariant(String string2) {
        if (string2 != null) {
            string2 = string2.toLowerCase(Locale.US);
        }
        return string2;
    }

    public static long toUnsignedLong(int n2) {
        return (long)n2 & 0xFFFFFFFFL;
    }

    public static String toUpperInvariant(String string2) {
        if (string2 != null) {
            string2 = string2.toUpperCase(Locale.US);
        }
        return string2;
    }

    public static CharSequence truncateAscii(CharSequence charSequence, int n2) {
        if (charSequence.length() > n2) {
            charSequence = charSequence.subSequence(0, n2);
        }
        return charSequence;
    }

    public static String unescapeFileName(String string2) {
        int n2;
        int n3;
        int n4 = string2.length();
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = n6;
            if (string2.charAt(n3) == '%') {
                n2 = n6 + 1;
            }
            n6 = n2;
        }
        if (n6 == 0) {
            return string2;
        }
        n3 = n4 - n6 * 2;
        StringBuilder stringBuilder = new StringBuilder(n3);
        Matcher matcher = ESCAPED_CHARACTER_PATTERN.matcher(string2);
        n2 = n5;
        while (n6 > 0 && matcher.find()) {
            char c2 = (char)Integer.parseInt(Assertions.checkNotNull(matcher.group(1)), 16);
            stringBuilder.append(string2, n2, matcher.start());
            stringBuilder.append(c2);
            n2 = matcher.end();
            --n6;
        }
        if (n2 < n4) {
            stringBuilder.append(string2, n2, n4);
        }
        if (stringBuilder.length() != n3) {
            return null;
        }
        return stringBuilder.toString();
    }

    public static void writeBoolean(Parcel parcel, boolean bl) {
        parcel.writeInt(bl ? 1 : 0);
    }
}

