/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.os.SystemClock;
import com.google.android.exoplayer2.upstream.Loader;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.ConcurrentModificationException;

public final class SntpClient {
    public static final String DEFAULT_NTP_HOST = "time.android.com";
    private static final int NTP_LEAP_NOSYNC = 3;
    private static final int NTP_MODE_BROADCAST = 5;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_MODE_SERVER = 4;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_PORT = 123;
    private static final int NTP_STRATUM_DEATH = 0;
    private static final int NTP_STRATUM_MAX = 15;
    private static final int NTP_VERSION = 3;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;
    private static final int ORIGINATE_TIME_OFFSET = 24;
    private static final int RECEIVE_TIME_OFFSET = 32;
    private static final int TIMEOUT_MS = 10000;
    private static final int TRANSMIT_TIME_OFFSET = 40;
    private static long elapsedRealtimeOffsetMs;
    private static boolean isInitialized;
    private static final Object loaderLock;
    private static String ntpHost;
    private static final Object valueLock;

    static {
        loaderLock = new Object();
        valueLock = new Object();
        ntpHost = DEFAULT_NTP_HOST;
    }

    private SntpClient() {
    }

    static /* synthetic */ boolean access$302(boolean bl) {
        isInitialized = bl;
        return bl;
    }

    static /* synthetic */ long access$502(long l2) {
        elapsedRealtimeOffsetMs = l2;
        return l2;
    }

    private static void checkValidServerReply(byte by2, byte by3, int n2, long l2) throws IOException {
        if (by2 != 3) {
            if (by3 != 4 && by3 != 5) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("SNTP: Untrusted mode: ");
                stringBuilder.append(by3);
                throw new IOException(stringBuilder.toString());
            }
            if (n2 != 0 && n2 <= 15) {
                if (l2 != 0L) {
                    return;
                }
                throw new IOException("SNTP: Zero transmitTime");
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SNTP: Untrusted stratum: ");
            stringBuilder.append(n2);
            throw new IOException(stringBuilder.toString());
        }
        throw new IOException("SNTP: Unsynchronized server");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getElapsedRealtimeOffsetMs() {
        Object object = valueLock;
        synchronized (object) {
            if (!isInitialized) return -9223372036854775807L;
            return elapsedRealtimeOffsetMs;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getNtpHost() {
        Object object = valueLock;
        synchronized (object) {
            return ntpHost;
        }
    }

    public static void initialize(Loader loader, InitializationCallback initializationCallback) {
        if (SntpClient.isInitialized()) {
            if (initializationCallback != null) {
                initializationCallback.onInitialized();
            }
            return;
        }
        Loader loader2 = loader;
        if (loader == null) {
            loader2 = new Loader("SntpClient");
        }
        loader2.startLoading(new NtpTimeLoadable(), new NtpTimeCallback(initializationCallback), 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isInitialized() {
        Object object = valueLock;
        synchronized (object) {
            return isInitialized;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long loadNtpTimeOffsetMs() throws IOException {
        void var2_6;
        DatagramSocket datagramSocket;
        block10: {
            long l6;
            long l5;
            long l4;
            long l3;
            long l2;
            DatagramPacket datagramPacket;
            byte[] byArray;
            InetAddress inetAddress = InetAddress.getByName(SntpClient.getNtpHost());
            datagramSocket = new DatagramSocket();
            try {
                datagramSocket.setSoTimeout(10000);
                byArray = new byte[48];
                datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 123);
            }
            catch (Throwable throwable) {
                // empty catch block
                break block10;
            }
            byArray[0] = (byte)27;
            {
                l2 = System.currentTimeMillis();
                l3 = SystemClock.elapsedRealtime();
                SntpClient.writeTimestamp(byArray, 40, l2);
                datagramSocket.send(datagramPacket);
                datagramPacket = new DatagramPacket(byArray, byArray.length);
                datagramSocket.receive(datagramPacket);
                l4 = SystemClock.elapsedRealtime();
                l3 = l2 + (l4 - l3);
            }
            byte by2 = (byte)(byArray[0] >> 6 & 3);
            byte by3 = (byte)(byArray[0] & 7);
            byte by4 = byArray[1];
            {
                l5 = SntpClient.readTimestamp(byArray, 24);
                l6 = SntpClient.readTimestamp(byArray, 32);
            }
            try {
                l2 = SntpClient.readTimestamp(byArray, 40);
                SntpClient.checkValidServerReply(by2, by3, by4 & 0xFF, l2);
                l2 = (l6 - l5 + (l2 - l3)) / 2L;
                datagramSocket.close();
                return l3 + l2 - l4;
            }
            catch (Throwable throwable) {}
        }
        try {
            throw var2_6;
        }
        catch (Throwable throwable) {
            try {
                datagramSocket.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                var2_6.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static long read32(byte[] byArray, int n2) {
        int n3 = byArray[n2];
        int n4 = byArray[n2 + 1];
        int n5 = byArray[n2 + 2];
        int n6 = byArray[n2 + 3];
        n2 = n3;
        if ((n3 & 0x80) == 128) {
            n2 = (n3 & 0x7F) + 128;
        }
        n3 = n4;
        if ((n4 & 0x80) == 128) {
            n3 = (n4 & 0x7F) + 128;
        }
        n4 = n5;
        if ((n5 & 0x80) == 128) {
            n4 = (n5 & 0x7F) + 128;
        }
        n5 = n6;
        if ((n6 & 0x80) == 128) {
            n5 = (n6 & 0x7F) + 128;
        }
        return ((long)n2 << 24) + ((long)n3 << 16) + ((long)n4 << 8) + (long)n5;
    }

    private static long readTimestamp(byte[] byArray, int n2) {
        long l2 = SntpClient.read32(byArray, n2);
        long l3 = SntpClient.read32(byArray, n2 + 4);
        if (l2 == 0L && l3 == 0L) {
            return 0L;
        }
        return (l2 - 2208988800L) * 1000L + l3 * 1000L / 0x100000000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setNtpHost(String string2) {
        Object object = valueLock;
        synchronized (object) {
            if (!ntpHost.equals(string2)) {
                ntpHost = string2;
                isInitialized = false;
            }
            return;
        }
    }

    private static void writeTimestamp(byte[] byArray, int n2, long l2) {
        if (l2 == 0L) {
            Arrays.fill(byArray, n2, n2 + 8, (byte)0);
            return;
        }
        long l3 = l2 / 1000L;
        long l4 = l3 + 2208988800L;
        int n3 = n2 + 1;
        byArray[n2] = (byte)(l4 >> 24);
        int n4 = n3 + 1;
        byArray[n3] = (byte)(l4 >> 16);
        n2 = n4 + 1;
        byArray[n4] = (byte)(l4 >> 8);
        n3 = n2 + 1;
        byArray[n2] = (byte)(l4 >> 0);
        l2 = (l2 - l3 * 1000L) * 0x100000000L / 1000L;
        n2 = n3 + 1;
        byArray[n3] = (byte)(l2 >> 24);
        n3 = n2 + 1;
        byArray[n2] = (byte)(l2 >> 16);
        byArray[n3] = (byte)(l2 >> 8);
        byArray[n3 + 1] = (byte)(Math.random() * 255.0);
    }

    public static interface InitializationCallback {
        public void onInitializationFailed(IOException var1);

        public void onInitialized();
    }

    private static final class NtpTimeCallback
    implements Loader.Callback<Loader.Loadable> {
        private final InitializationCallback callback;

        public NtpTimeCallback(InitializationCallback initializationCallback) {
            this.callback = initializationCallback;
        }

        @Override
        public void onLoadCanceled(Loader.Loadable loadable, long l2, long l3, boolean bl) {
        }

        @Override
        public void onLoadCompleted(Loader.Loadable loadable, long l2, long l3) {
            if (this.callback != null) {
                if (!SntpClient.isInitialized()) {
                    this.callback.onInitializationFailed(new IOException(new ConcurrentModificationException()));
                } else {
                    this.callback.onInitialized();
                }
            }
        }

        @Override
        public Loader.LoadErrorAction onLoadError(Loader.Loadable object, long l2, long l3, IOException iOException, int n2) {
            object = this.callback;
            if (object != null) {
                object.onInitializationFailed(iOException);
            }
            return Loader.DONT_RETRY;
        }
    }

    private static final class NtpTimeLoadable
    implements Loader.Loadable {
        private NtpTimeLoadable() {
        }

        @Override
        public void cancelLoad() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void load() throws IOException {
            Object object = loaderLock;
            synchronized (object) {
                Object object2 = valueLock;
                synchronized (object2) {
                    if (isInitialized) {
                        return;
                    }
                }
                long l2 = SntpClient.loadNtpTimeOffsetMs();
                object2 = valueLock;
                synchronized (object2) {
                    SntpClient.access$502(l2);
                    SntpClient.access$302(true);
                    return;
                }
            }
        }
    }
}

