/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class NotificationUtil {
    public static final int IMPORTANCE_DEFAULT = 3;
    public static final int IMPORTANCE_HIGH = 4;
    public static final int IMPORTANCE_LOW = 2;
    public static final int IMPORTANCE_MIN = 1;
    public static final int IMPORTANCE_NONE = 0;
    public static final int IMPORTANCE_UNSPECIFIED = -1000;

    private NotificationUtil() {
    }

    @Deprecated
    public static void createNotificationChannel(Context context, String string2, int n2, int n3) {
        NotificationUtil.createNotificationChannel(context, string2, n2, 0, n3);
    }

    public static void createNotificationChannel(Context context, String string2, int n2, int n3, int n4) {
        if (Util.SDK_INT >= 26) {
            NotificationManager notificationManager = Assertions.checkNotNull((NotificationManager)context.getSystemService("notification"));
            string2 = new NotificationChannel(string2, (CharSequence)context.getString(n2), n4);
            if (n3 != 0) {
                string2.setDescription(context.getString(n3));
            }
            notificationManager.createNotificationChannel((NotificationChannel)string2);
        }
    }

    public static void setNotification(Context context, int n2, Notification notification) {
        context = Assertions.checkNotNull((NotificationManager)context.getSystemService("notification"));
        if (notification != null) {
            context.notify(n2, notification);
        } else {
            context.cancel(n2);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Importance {
    }
}

