/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.text.TextUtils;
import java.net.UnknownHostException;
import org.checkerframework.dataflow.qual.Pure;

public final class Log {
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_ERROR = 3;
    public static final int LOG_LEVEL_INFO = 1;
    public static final int LOG_LEVEL_OFF = Integer.MAX_VALUE;
    public static final int LOG_LEVEL_WARNING = 2;
    private static int logLevel = 0;
    private static boolean logStackTraces = true;

    private Log() {
    }

    @Pure
    private static String appendThrowableString(String string2, Throwable object) {
        String string3 = Log.getThrowableString((Throwable)object);
        object = string2;
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append("\n  ");
            ((StringBuilder)object).append(string3.replace("\n", "\n  "));
            ((StringBuilder)object).append('\n');
            object = ((StringBuilder)object).toString();
        }
        return object;
    }

    @Pure
    public static void d(String string2, String string3) {
        if (logLevel == 0) {
            android.util.Log.d((String)string2, (String)string3);
        }
    }

    @Pure
    public static void d(String string2, String string3, Throwable throwable) {
        Log.d(string2, Log.appendThrowableString(string3, throwable));
    }

    @Pure
    public static void e(String string2, String string3) {
        if (logLevel <= 3) {
            android.util.Log.e((String)string2, (String)string3);
        }
    }

    @Pure
    public static void e(String string2, String string3, Throwable throwable) {
        Log.e(string2, Log.appendThrowableString(string3, throwable));
    }

    @Pure
    public static int getLogLevel() {
        return logLevel;
    }

    @Pure
    public static String getThrowableString(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (Log.isCausedByUnknownHostException(throwable)) {
            return "UnknownHostException (no network)";
        }
        if (!logStackTraces) {
            return throwable.getMessage();
        }
        return android.util.Log.getStackTraceString((Throwable)throwable).trim().replace("\t", "    ");
    }

    @Pure
    public static void i(String string2, String string3) {
        if (logLevel <= 1) {
            android.util.Log.i((String)string2, (String)string3);
        }
    }

    @Pure
    public static void i(String string2, String string3, Throwable throwable) {
        Log.i(string2, Log.appendThrowableString(string3, throwable));
    }

    @Pure
    private static boolean isCausedByUnknownHostException(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof UnknownHostException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static void setLogLevel(int n2) {
        logLevel = n2;
    }

    public static void setLogStackTraces(boolean bl) {
        logStackTraces = bl;
    }

    @Pure
    public static void w(String string2, String string3) {
        if (logLevel <= 2) {
            android.util.Log.w((String)string2, (String)string3);
        }
    }

    @Pure
    public static void w(String string2, String string3, Throwable throwable) {
        Log.w(string2, Log.appendThrowableString(string3, throwable));
    }

    @Pure
    public boolean getLogStackTraces() {
        return logStackTraces;
    }
}

