/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.MutableFlags;
import com.google.android.exoplayer2.util._$;
import com.google.common.base.Supplier;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;

public final class ListenerSet<T, E extends MutableFlags> {
    private static final int MSG_ITERATION_FINISHED = 0;
    private static final int MSG_LAZY_RELEASE = 1;
    private final Clock clock;
    private final Supplier<E> eventFlagsSupplier;
    private final ArrayDeque<Runnable> flushingEvents;
    private final HandlerWrapper handler;
    private final IterationFinishedEvent<T, E> iterationFinishedEvent;
    private final CopyOnWriteArraySet<ListenerHolder<T, E>> listeners;
    private final ArrayDeque<Runnable> queuedEvents;
    private boolean released;

    public ListenerSet(Looper looper, Clock clock, Supplier<E> supplier, IterationFinishedEvent<T, E> iterationFinishedEvent) {
        this(new CopyOnWriteArraySet<ListenerHolder<T, E>>(), looper, clock, supplier, iterationFinishedEvent);
    }

    private ListenerSet(CopyOnWriteArraySet<ListenerHolder<T, E>> copyOnWriteArraySet, Looper looper, Clock clock, Supplier<E> supplier, IterationFinishedEvent<T, E> iterationFinishedEvent) {
        this.clock = clock;
        this.listeners = copyOnWriteArraySet;
        this.eventFlagsSupplier = supplier;
        this.iterationFinishedEvent = iterationFinishedEvent;
        this.flushingEvents = new ArrayDeque();
        this.queuedEvents = new ArrayDeque();
        this.handler = clock.createHandler(looper, (Handler.Callback)new _$.Lambda.ListenerSet.gt28PMFfhLXGfIVY4v7eP9kmalg(this));
    }

    private boolean handleMessage(Message object) {
        if (((Message)object).what == 0) {
            object = this.listeners.iterator();
            while (object.hasNext()) {
                ((ListenerHolder)object.next()).iterationFinished(this.eventFlagsSupplier, this.iterationFinishedEvent);
                if (!this.handler.hasMessages(0)) continue;
                break;
            }
        } else if (((Message)object).what == 1) {
            this.sendEvent(((Message)object).arg1, (Event)((Message)object).obj);
            this.release();
        }
        return true;
    }

    public static /* synthetic */ boolean lambda$gt28PMFfhLXGfIVY4v7eP9kmalg(ListenerSet listenerSet, Message message) {
        return listenerSet.handleMessage(message);
    }

    static /* synthetic */ void lambda$queueEvent$0(CopyOnWriteArraySet object, int n2, Event event) {
        object = ((CopyOnWriteArraySet)object).iterator();
        while (object.hasNext()) {
            ((ListenerHolder)object.next()).invoke(n2, event);
        }
    }

    public void add(T t2) {
        if (this.released) {
            return;
        }
        Assertions.checkNotNull(t2);
        this.listeners.add(new ListenerHolder<T, E>(t2, this.eventFlagsSupplier));
    }

    public ListenerSet<T, E> copy(Looper looper, IterationFinishedEvent<T, E> iterationFinishedEvent) {
        return new ListenerSet<T, E>(this.listeners, looper, this.clock, this.eventFlagsSupplier, iterationFinishedEvent);
    }

    public void flushEvents() {
        if (this.queuedEvents.isEmpty()) {
            return;
        }
        if (!this.handler.hasMessages(0)) {
            this.handler.obtainMessage(0).sendToTarget();
        }
        boolean bl = this.flushingEvents.isEmpty();
        this.flushingEvents.addAll(this.queuedEvents);
        this.queuedEvents.clear();
        if (bl ^ true) {
            return;
        }
        while (!this.flushingEvents.isEmpty()) {
            this.flushingEvents.peekFirst().run();
            this.flushingEvents.removeFirst();
        }
    }

    public void lazyRelease(int n2, Event<T> event) {
        this.handler.obtainMessage(1, n2, 0, event).sendToTarget();
    }

    public void queueEvent(int n2, Event<T> event) {
        CopyOnWriteArraySet<ListenerHolder<T, E>> copyOnWriteArraySet = new CopyOnWriteArraySet<ListenerHolder<T, E>>(this.listeners);
        this.queuedEvents.add((Runnable)new _$.Lambda.ListenerSet.Q1s2242IGqOFgK3lFhqwOk8KBXE(copyOnWriteArraySet, n2, event));
    }

    public void release() {
        Iterator<ListenerHolder<T, E>> iterator2 = this.listeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().release(this.iterationFinishedEvent);
        }
        this.listeners.clear();
        this.released = true;
    }

    public void remove(T t2) {
        for (ListenerHolder<T, E> listenerHolder : this.listeners) {
            if (!listenerHolder.listener.equals(t2)) continue;
            listenerHolder.release(this.iterationFinishedEvent);
            this.listeners.remove(listenerHolder);
        }
    }

    public void sendEvent(int n2, Event<T> event) {
        this.queueEvent(n2, event);
        this.flushEvents();
    }

    public static interface Event<T> {
        public void invoke(T var1);
    }

    public static interface IterationFinishedEvent<T, E extends MutableFlags> {
        public void invoke(T var1, E var2);
    }

    private static final class ListenerHolder<T, E extends MutableFlags> {
        private E eventsFlags;
        @Nonnull
        public final T listener;
        private boolean needsIterationFinishedEvent;
        private boolean released;

        public ListenerHolder(@Nonnull T t2, Supplier<E> supplier) {
            this.listener = t2;
            this.eventsFlags = (MutableFlags)supplier.get();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                return this.listener.equals(((ListenerHolder)object).listener);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public void invoke(int n2, Event<T> event) {
            if (!this.released) {
                if (n2 != -1) {
                    this.eventsFlags.add(n2);
                }
                this.needsIterationFinishedEvent = true;
                event.invoke(this.listener);
            }
        }

        public void iterationFinished(Supplier<E> supplier, IterationFinishedEvent<T, E> iterationFinishedEvent) {
            if (!this.released && this.needsIterationFinishedEvent) {
                E e2 = this.eventsFlags;
                this.eventsFlags = (MutableFlags)supplier.get();
                this.needsIterationFinishedEvent = false;
                iterationFinishedEvent.invoke(this.listener, e2);
            }
        }

        public void release(IterationFinishedEvent<T, E> iterationFinishedEvent) {
            this.released = true;
            if (this.needsIterationFinishedEvent) {
                iterationFinishedEvent.invoke(this.listener, this.eventsFlags);
            }
        }
    }
}

