/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.net.Uri;
import com.google.android.exoplayer2.util.MimeTypes;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;

public final class FileTypes {
    public static final int AC3 = 0;
    public static final int AC4 = 1;
    public static final int ADTS = 2;
    public static final int AMR = 3;
    private static final String EXTENSION_AAC = ".aac";
    private static final String EXTENSION_AC3 = ".ac3";
    private static final String EXTENSION_AC4 = ".ac4";
    private static final String EXTENSION_ADTS = ".adts";
    private static final String EXTENSION_AMR = ".amr";
    private static final String EXTENSION_EC3 = ".ec3";
    private static final String EXTENSION_FLAC = ".flac";
    private static final String EXTENSION_FLV = ".flv";
    private static final String EXTENSION_JPEG = ".jpeg";
    private static final String EXTENSION_JPG = ".jpg";
    private static final String EXTENSION_M2P = ".m2p";
    private static final String EXTENSION_MP3 = ".mp3";
    private static final String EXTENSION_MP4 = ".mp4";
    private static final String EXTENSION_MPEG = ".mpeg";
    private static final String EXTENSION_MPG = ".mpg";
    private static final String EXTENSION_OPUS = ".opus";
    private static final String EXTENSION_PREFIX_CMF = ".cmf";
    private static final String EXTENSION_PREFIX_M4 = ".m4";
    private static final String EXTENSION_PREFIX_MK = ".mk";
    private static final String EXTENSION_PREFIX_MP4 = ".mp4";
    private static final String EXTENSION_PREFIX_OG = ".og";
    private static final String EXTENSION_PREFIX_TS = ".ts";
    private static final String EXTENSION_PS = ".ps";
    private static final String EXTENSION_TS = ".ts";
    private static final String EXTENSION_VTT = ".vtt";
    private static final String EXTENSION_WAV = ".wav";
    private static final String EXTENSION_WAVE = ".wave";
    private static final String EXTENSION_WEBM = ".webm";
    private static final String EXTENSION_WEBVTT = ".webvtt";
    public static final int FLAC = 4;
    public static final int FLV = 5;
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final int JPEG = 14;
    public static final int MATROSKA = 6;
    public static final int MP3 = 7;
    public static final int MP4 = 8;
    public static final int OGG = 9;
    public static final int PS = 10;
    public static final int TS = 11;
    public static final int UNKNOWN = -1;
    public static final int WAV = 12;
    public static final int WEBVTT = 13;

    private FileTypes() {
    }

    public static int inferFileTypeFromMimeType(String string2) {
        int n2;
        block43: {
            if (string2 == null) {
                return -1;
            }
            string2 = MimeTypes.normalizeMimeType((String)string2);
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 2039520277: {
                    if (!string2.equals("video/x-matroska")) break;
                    n2 = 9;
                    break block43;
                }
                case 1505118770: {
                    if (!string2.equals("audio/webm")) break;
                    n2 = 12;
                    break block43;
                }
                case 1504831518: {
                    if (!string2.equals("audio/mpeg")) break;
                    n2 = 14;
                    break block43;
                }
                case 1504619009: {
                    if (!string2.equals("audio/flac")) break;
                    n2 = 7;
                    break block43;
                }
                case 1504578661: {
                    if (!string2.equals("audio/eac3")) break;
                    n2 = 1;
                    break block43;
                }
                case 1503095341: {
                    if (!string2.equals("audio/3gpp")) break;
                    n2 = 5;
                    break block43;
                }
                case 1331848029: {
                    if (!string2.equals("video/mp4")) break;
                    n2 = 15;
                    break block43;
                }
                case 187099443: {
                    if (!string2.equals("audio/wav")) break;
                    n2 = 21;
                    break block43;
                }
                case 187091926: {
                    if (!string2.equals("audio/ogg")) break;
                    n2 = 18;
                    break block43;
                }
                case 187090232: {
                    if (!string2.equals("audio/mp4")) break;
                    n2 = 16;
                    break block43;
                }
                case 187078669: {
                    if (!string2.equals("audio/amr")) break;
                    n2 = 4;
                    break block43;
                }
                case 187078297: {
                    if (!string2.equals("audio/ac4")) break;
                    n2 = 3;
                    break block43;
                }
                case 187078296: {
                    if (!string2.equals("audio/ac3")) break;
                    n2 = 0;
                    break block43;
                }
                case 13915911: {
                    if (!string2.equals("video/x-flv")) break;
                    n2 = 8;
                    break block43;
                }
                case -43467528: {
                    if (!string2.equals("application/webm")) break;
                    n2 = 13;
                    break block43;
                }
                case -387023398: {
                    if (!string2.equals("audio/x-matroska")) break;
                    n2 = 10;
                    break block43;
                }
                case -1004728940: {
                    if (!string2.equals("text/vtt")) break;
                    n2 = 22;
                    break block43;
                }
                case -1248337486: {
                    if (!string2.equals("application/mp4")) break;
                    n2 = 17;
                    break block43;
                }
                case -1487394660: {
                    if (!string2.equals("image/jpeg")) break;
                    n2 = 23;
                    break block43;
                }
                case -1606874997: {
                    if (!string2.equals("audio/amr-wb")) break;
                    n2 = 6;
                    break block43;
                }
                case -1662095187: {
                    if (!string2.equals("video/webm")) break;
                    n2 = 11;
                    break block43;
                }
                case -1662384007: {
                    if (!string2.equals("video/mp2t")) break;
                    n2 = 20;
                    break block43;
                }
                case -1662384011: {
                    if (!string2.equals("video/mp2p")) break;
                    n2 = 19;
                    break block43;
                }
                case -2123537834: {
                    if (!string2.equals("audio/eac3-joc")) break;
                    n2 = 2;
                    break block43;
                }
            }
            n2 = -1;
        }
        switch (n2) {
            default: {
                return -1;
            }
            case 23: {
                return 14;
            }
            case 22: {
                return 13;
            }
            case 21: {
                return 12;
            }
            case 20: {
                return 11;
            }
            case 19: {
                return 10;
            }
            case 18: {
                return 9;
            }
            case 15: 
            case 16: 
            case 17: {
                return 8;
            }
            case 14: {
                return 7;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 6;
            }
            case 8: {
                return 5;
            }
            case 7: {
                return 4;
            }
            case 4: 
            case 5: 
            case 6: {
                return 3;
            }
            case 3: {
                return 1;
            }
            case 0: 
            case 1: 
            case 2: 
        }
        return 0;
    }

    public static int inferFileTypeFromResponseHeaders(Map<String, List<String>> object) {
        object = (object = object.get(HEADER_CONTENT_TYPE)) != null && !object.isEmpty() ? (String)object.get(0) : null;
        return FileTypes.inferFileTypeFromMimeType((String)object);
    }

    public static int inferFileTypeFromUri(Uri object) {
        if ((object = object.getLastPathSegment()) == null) {
            return -1;
        }
        if (!((String)object).endsWith(EXTENSION_AC3) && !((String)object).endsWith(EXTENSION_EC3)) {
            if (((String)object).endsWith(EXTENSION_AC4)) {
                return 1;
            }
            if (!((String)object).endsWith(EXTENSION_ADTS) && !((String)object).endsWith(EXTENSION_AAC)) {
                if (((String)object).endsWith(EXTENSION_AMR)) {
                    return 3;
                }
                if (((String)object).endsWith(EXTENSION_FLAC)) {
                    return 4;
                }
                if (((String)object).endsWith(EXTENSION_FLV)) {
                    return 5;
                }
                if (!((String)object).startsWith(EXTENSION_PREFIX_MK, ((String)object).length() - 4) && !((String)object).endsWith(EXTENSION_WEBM)) {
                    if (((String)object).endsWith(EXTENSION_MP3)) {
                        return 7;
                    }
                    if (!(((String)object).endsWith(".mp4") || ((String)object).startsWith(EXTENSION_PREFIX_M4, ((String)object).length() - 4) || ((String)object).startsWith(".mp4", ((String)object).length() - 5) || ((String)object).startsWith(EXTENSION_PREFIX_CMF, ((String)object).length() - 5))) {
                        if (!((String)object).startsWith(EXTENSION_PREFIX_OG, ((String)object).length() - 4) && !((String)object).endsWith(EXTENSION_OPUS)) {
                            if (!(((String)object).endsWith(EXTENSION_PS) || ((String)object).endsWith(EXTENSION_MPEG) || ((String)object).endsWith(EXTENSION_MPG) || ((String)object).endsWith(EXTENSION_M2P))) {
                                if (!((String)object).endsWith(".ts") && !((String)object).startsWith(".ts", ((String)object).length() - 4)) {
                                    if (!((String)object).endsWith(EXTENSION_WAV) && !((String)object).endsWith(EXTENSION_WAVE)) {
                                        if (!((String)object).endsWith(EXTENSION_VTT) && !((String)object).endsWith(EXTENSION_WEBVTT)) {
                                            if (!((String)object).endsWith(EXTENSION_JPG) && !((String)object).endsWith(EXTENSION_JPEG)) {
                                                return -1;
                                            }
                                            return 14;
                                        }
                                        return 13;
                                    }
                                    return 12;
                                }
                                return 11;
                            }
                            return 10;
                        }
                        return 9;
                    }
                    return 8;
                }
                return 6;
            }
            return 2;
        }
        return 0;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

