/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.os.Handler;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.GlUtil;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class EGLSurfaceTexture
implements SurfaceTexture.OnFrameAvailableListener,
Runnable {
    private static final int[] EGL_CONFIG_ATTRIBUTES = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12327, 12344, 12339, 4, 12344};
    private static final int EGL_PROTECTED_CONTENT_EXT = 12992;
    private static final int EGL_SURFACE_HEIGHT = 1;
    private static final int EGL_SURFACE_WIDTH = 1;
    public static final int SECURE_MODE_NONE = 0;
    public static final int SECURE_MODE_PROTECTED_PBUFFER = 2;
    public static final int SECURE_MODE_SURFACELESS_CONTEXT = 1;
    private final TextureImageListener callback;
    private EGLContext context;
    private EGLDisplay display;
    private final Handler handler;
    private EGLSurface surface;
    private SurfaceTexture texture;
    private final int[] textureIdHolder;

    public EGLSurfaceTexture(Handler handler) {
        this(handler, null);
    }

    public EGLSurfaceTexture(Handler handler, TextureImageListener textureImageListener) {
        this.handler = handler;
        this.callback = textureImageListener;
        this.textureIdHolder = new int[1];
    }

    private static EGLConfig chooseEGLConfig(EGLDisplay eGLDisplay) {
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray = new int[1];
        boolean bl = EGL14.eglChooseConfig((EGLDisplay)eGLDisplay, (int[])EGL_CONFIG_ATTRIBUTES, (int)0, (EGLConfig[])eGLConfigArray, (int)0, (int)1, (int[])nArray, (int)0);
        if (bl && nArray[0] > 0 && eGLConfigArray[0] != null) {
            return eGLConfigArray[0];
        }
        throw new GlException(Util.formatInvariant("eglChooseConfig failed: success=%b, numConfigs[0]=%d, configs[0]=%s", bl, nArray[0], eGLConfigArray[0]));
    }

    private static EGLContext createEGLContext(EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n2) {
        int[] nArray;
        if (n2 == 0) {
            int[] nArray2 = nArray = new int[3];
            nArray[0] = 12440;
            nArray2[1] = 2;
            nArray2[2] = 12344;
        } else {
            int[] nArray3 = nArray = new int[5];
            nArray[0] = 12440;
            nArray3[1] = 2;
            nArray3[2] = 12992;
            nArray3[3] = 1;
            nArray3[4] = 12344;
        }
        eGLDisplay = EGL14.eglCreateContext((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])nArray, (int)0);
        if (eGLDisplay != null) {
            return eGLDisplay;
        }
        throw new GlException("eglCreateContext failed");
    }

    private static EGLSurface createEGLSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, EGLContext eGLContext, int n2) {
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    if (n2 != 1) break block6;
                    eGLConfig = EGL14.EGL_NO_SURFACE;
                    break block7;
                }
                if (n2 == 2) {
                    int[] nArray2 = nArray = new int[7];
                    nArray[0] = 12375;
                    nArray2[1] = 1;
                    nArray2[2] = 12374;
                    nArray2[3] = 1;
                    nArray2[4] = 12992;
                    nArray2[5] = 1;
                    nArray2[6] = 12344;
                } else {
                    int[] nArray3 = nArray = new int[5];
                    nArray[0] = 12375;
                    nArray3[1] = 1;
                    nArray3[2] = 12374;
                    nArray3[3] = 1;
                    nArray3[4] = 12344;
                }
                eGLConfig = EGL14.eglCreatePbufferSurface((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (int[])nArray, (int)0);
                if (eGLConfig == null) break block8;
            }
            if (EGL14.eglMakeCurrent((EGLDisplay)eGLDisplay, (EGLSurface)eGLConfig, (EGLSurface)eGLConfig, (EGLContext)eGLContext)) {
                return eGLConfig;
            }
            throw new GlException("eglMakeCurrent failed");
        }
        throw new GlException("eglCreatePbufferSurface failed");
    }

    private void dispatchOnFrameAvailable() {
        TextureImageListener textureImageListener = this.callback;
        if (textureImageListener != null) {
            textureImageListener.onFrameAvailable();
        }
    }

    private static void generateTextureIds(int[] nArray) {
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GlUtil.checkGlError();
    }

    private static EGLDisplay getDefaultDisplay() {
        EGLDisplay eGLDisplay = EGL14.eglGetDisplay((int)0);
        if (eGLDisplay != null) {
            int[] nArray = new int[2];
            if (EGL14.eglInitialize((EGLDisplay)eGLDisplay, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
                return eGLDisplay;
            }
            throw new GlException("eglInitialize failed");
        }
        throw new GlException("eglGetDisplay failed");
    }

    public SurfaceTexture getSurfaceTexture() {
        return Assertions.checkNotNull(this.texture);
    }

    public void init(int n2) {
        this.display = EGLSurfaceTexture.getDefaultDisplay();
        EGLConfig eGLConfig = EGLSurfaceTexture.chooseEGLConfig(this.display);
        this.context = EGLSurfaceTexture.createEGLContext(this.display, eGLConfig, n2);
        this.surface = EGLSurfaceTexture.createEGLSurface(this.display, eGLConfig, this.context, n2);
        EGLSurfaceTexture.generateTextureIds(this.textureIdHolder);
        this.texture = new SurfaceTexture(this.textureIdHolder[0]);
        this.texture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.handler.post((Runnable)this);
    }

    public void release() {
        this.handler.removeCallbacks((Runnable)this);
        try {
            if (this.texture != null) {
                this.texture.release();
                GLES20.glDeleteTextures((int)1, (int[])this.textureIdHolder, (int)0);
            }
            return;
        }
        finally {
            EGLDisplay eGLDisplay = this.display;
            if (eGLDisplay != null && !eGLDisplay.equals((Object)EGL14.EGL_NO_DISPLAY)) {
                EGL14.eglMakeCurrent((EGLDisplay)this.display, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            }
            if ((eGLDisplay = this.surface) != null && !eGLDisplay.equals((Object)EGL14.EGL_NO_SURFACE)) {
                EGL14.eglDestroySurface((EGLDisplay)this.display, (EGLSurface)this.surface);
            }
            if ((eGLDisplay = this.context) != null) {
                EGL14.eglDestroyContext((EGLDisplay)this.display, (EGLContext)eGLDisplay);
            }
            if (Util.SDK_INT >= 19) {
                EGL14.eglReleaseThread();
            }
            if ((eGLDisplay = this.display) != null && !eGLDisplay.equals((Object)EGL14.EGL_NO_DISPLAY)) {
                EGL14.eglTerminate((EGLDisplay)this.display);
            }
            this.display = null;
            this.context = null;
            this.surface = null;
            this.texture = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.dispatchOnFrameAvailable();
        SurfaceTexture surfaceTexture = this.texture;
        if (surfaceTexture == null) return;
        try {
            surfaceTexture.updateTexImage();
            return;
        }
        catch (RuntimeException runtimeException) {
            return;
        }
    }

    public static final class GlException
    extends RuntimeException {
        private GlException(String string2) {
            super(string2);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecureMode {
    }

    public static interface TextureImageListener {
        public void onFrameAvailable();
    }
}

