/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.google.android.exoplayer2.database.DatabaseIOException;
import com.google.android.exoplayer2.database.DatabaseProvider;
import com.google.android.exoplayer2.database.VersionTable;
import com.google.android.exoplayer2.upstream.cache.CachedContent;
import com.google.android.exoplayer2.upstream.cache.ContentMetadata;
import com.google.android.exoplayer2.upstream.cache.ContentMetadataMutations;
import com.google.android.exoplayer2.upstream.cache.DefaultContentMetadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.AtomicFile;
import com.google.android.exoplayer2.util.ReusableBufferedOutputStream;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class CachedContentIndex {
    static final String FILE_NAME_ATOMIC = "cached_content_index.exi";
    private static final int INCREMENTAL_METADATA_READ_LENGTH = 0xA00000;
    private final SparseArray<String> idToKey;
    private final HashMap<String, CachedContent> keyToContent;
    private final SparseBooleanArray newIds;
    private Storage previousStorage;
    private final SparseBooleanArray removedIds;
    private Storage storage;

    public CachedContentIndex(DatabaseProvider databaseProvider) {
        this(databaseProvider, null, null, false, false);
    }

    public CachedContentIndex(DatabaseProvider object, File file, byte[] byArray, boolean bl, boolean bl2) {
        boolean bl3 = object != null || file != null;
        Assertions.checkState(bl3);
        this.keyToContent = new HashMap();
        this.idToKey = new SparseArray();
        this.removedIds = new SparseBooleanArray();
        this.newIds = new SparseBooleanArray();
        LegacyStorage legacyStorage = null;
        object = object != null ? new DatabaseStorage((DatabaseProvider)object) : null;
        if (file != null) {
            legacyStorage = new LegacyStorage(new File(file, FILE_NAME_ATOMIC), byArray, bl);
        }
        if (!(object == null || legacyStorage != null && bl2)) {
            this.storage = object;
            this.previousStorage = legacyStorage;
        } else {
            this.storage = Util.castNonNull(legacyStorage);
            this.previousStorage = object;
        }
    }

    private CachedContent addNew(String string2) {
        int n2 = CachedContentIndex.getNewId(this.idToKey);
        CachedContent cachedContent = new CachedContent(n2, string2);
        this.keyToContent.put(string2, cachedContent);
        this.idToKey.put(n2, (Object)string2);
        this.newIds.put(n2, true);
        this.storage.onUpdate(cachedContent);
        return cachedContent;
    }

    public static void delete(DatabaseProvider databaseProvider, long l2) throws DatabaseIOException {
        DatabaseStorage.delete(databaseProvider, l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Cipher getCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        if (Util.SDK_INT != 18) return Cipher.getInstance("AES/CBC/PKCS5PADDING");
        try {
            return Cipher.getInstance("AES/CBC/PKCS5PADDING", "BC");
        }
        catch (Throwable throwable) {
            return Cipher.getInstance("AES/CBC/PKCS5PADDING");
        }
    }

    static int getNewId(SparseArray<String> sparseArray) {
        int n2 = sparseArray.size();
        int n3 = n2 == 0 ? 0 : sparseArray.keyAt(n2 - 1) + 1;
        int n4 = n3;
        if (n3 < 0) {
            n3 = 0;
            while (true) {
                n4 = ++n3;
                if (n3 >= n2) break;
                if (n3 == sparseArray.keyAt(n3)) continue;
                n4 = n3;
                break;
            }
        }
        return n4;
    }

    public static boolean isIndexFile(String string2) {
        return string2.startsWith(FILE_NAME_ATOMIC);
    }

    private static DefaultContentMetadata readContentMetadata(DataInputStream object) throws IOException {
        int n2 = ((DataInputStream)object).readInt();
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = ((DataInputStream)object).readUTF();
            int n3 = ((DataInputStream)object).readInt();
            if (n3 >= 0) {
                int n4 = Math.min(n3, 0xA00000);
                byte[] byArray = Util.EMPTY_BYTE_ARRAY;
                int n5 = 0;
                while (n5 != n3) {
                    int n6 = n5 + n4;
                    byArray = Arrays.copyOf(byArray, n6);
                    ((DataInputStream)object).readFully(byArray, n5, n4);
                    n4 = Math.min(n3 - n6, 0xA00000);
                    n5 = n6;
                }
                hashMap.put(string2, byArray);
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Invalid value size: ");
            ((StringBuilder)object).append(n3);
            throw new IOException(((StringBuilder)object).toString());
        }
        return new DefaultContentMetadata(hashMap);
    }

    private static void writeContentMetadata(DefaultContentMetadata object, DataOutputStream dataOutputStream) throws IOException {
        object = object.entrySet();
        dataOutputStream.writeInt(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Map.Entry)object.next();
            dataOutputStream.writeUTF((String)object2.getKey());
            object2 = (byte[])object2.getValue();
            dataOutputStream.writeInt(((Object)object2).length);
            dataOutputStream.write((byte[])object2);
        }
    }

    public void applyContentMetadataMutations(String string2, ContentMetadataMutations contentMetadataMutations) {
        if ((string2 = this.getOrAdd(string2)).applyMetadataMutations(contentMetadataMutations)) {
            this.storage.onUpdate((CachedContent)string2);
        }
    }

    public int assignIdForKey(String string2) {
        return this.getOrAdd((String)string2).id;
    }

    public CachedContent get(String string2) {
        return this.keyToContent.get(string2);
    }

    public Collection<CachedContent> getAll() {
        return Collections.unmodifiableCollection(this.keyToContent.values());
    }

    public ContentMetadata getContentMetadata(String string2) {
        string2 = (string2 = this.get(string2)) != null ? string2.getMetadata() : DefaultContentMetadata.EMPTY;
        return string2;
    }

    public String getKeyForId(int n2) {
        return (String)this.idToKey.get(n2);
    }

    public Set<String> getKeys() {
        return this.keyToContent.keySet();
    }

    public CachedContent getOrAdd(String string2) {
        CachedContent cachedContent;
        CachedContent cachedContent2 = cachedContent = this.keyToContent.get(string2);
        if (cachedContent == null) {
            cachedContent2 = this.addNew(string2);
        }
        return cachedContent2;
    }

    public void initialize(long l2) throws IOException {
        this.storage.initialize(l2);
        Storage storage = this.previousStorage;
        if (storage != null) {
            storage.initialize(l2);
        }
        if (!this.storage.exists() && (storage = this.previousStorage) != null && storage.exists()) {
            this.previousStorage.load(this.keyToContent, this.idToKey);
            this.storage.storeFully(this.keyToContent);
        } else {
            this.storage.load(this.keyToContent, this.idToKey);
        }
        storage = this.previousStorage;
        if (storage != null) {
            storage.delete();
            this.previousStorage = null;
        }
    }

    public void maybeRemove(String string2) {
        CachedContent cachedContent = this.keyToContent.get(string2);
        if (cachedContent != null && cachedContent.isEmpty() && cachedContent.isFullyUnlocked()) {
            this.keyToContent.remove(string2);
            int n2 = cachedContent.id;
            boolean bl = this.newIds.get(n2);
            this.storage.onRemove(cachedContent, bl);
            if (bl) {
                this.idToKey.remove(n2);
                this.newIds.delete(n2);
            } else {
                this.idToKey.put(n2, null);
                this.removedIds.put(n2, true);
            }
        }
    }

    public void removeEmpty() {
        Iterator iterator2 = ImmutableSet.copyOf(this.keyToContent.keySet()).iterator();
        while (iterator2.hasNext()) {
            this.maybeRemove((String)iterator2.next());
        }
    }

    public void store() throws IOException {
        this.storage.storeIncremental(this.keyToContent);
        int n2 = this.removedIds.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.idToKey.remove(this.removedIds.keyAt(i2));
        }
        this.removedIds.clear();
        this.newIds.clear();
    }

    private static final class DatabaseStorage
    implements Storage {
        private static final String[] COLUMNS = new String[]{"id", "key", "metadata"};
        private static final String COLUMN_ID = "id";
        private static final int COLUMN_INDEX_ID = 0;
        private static final int COLUMN_INDEX_KEY = 1;
        private static final int COLUMN_INDEX_METADATA = 2;
        private static final String COLUMN_KEY = "key";
        private static final String COLUMN_METADATA = "metadata";
        private static final String TABLE_PREFIX = "ExoPlayerCacheIndex";
        private static final String TABLE_SCHEMA = "(id INTEGER PRIMARY KEY NOT NULL,key TEXT NOT NULL,metadata BLOB NOT NULL)";
        private static final int TABLE_VERSION = 1;
        private static final String WHERE_ID_EQUALS = "id = ?";
        private final DatabaseProvider databaseProvider;
        private String hexUid;
        private final SparseArray<CachedContent> pendingUpdates;
        private String tableName;

        public DatabaseStorage(DatabaseProvider databaseProvider) {
            this.databaseProvider = databaseProvider;
            this.pendingUpdates = new SparseArray();
        }

        private void addOrUpdateRow(SQLiteDatabase sQLiteDatabase, CachedContent cachedContent) throws IOException {
            Object object = new ByteArrayOutputStream();
            CachedContentIndex.writeContentMetadata(cachedContent.getMetadata(), new DataOutputStream((OutputStream)object));
            object = ((ByteArrayOutputStream)object).toByteArray();
            ContentValues contentValues = new ContentValues();
            contentValues.put(COLUMN_ID, Integer.valueOf(cachedContent.id));
            contentValues.put(COLUMN_KEY, cachedContent.key);
            contentValues.put(COLUMN_METADATA, (byte[])object);
            sQLiteDatabase.replaceOrThrow(Assertions.checkNotNull(this.tableName), null, contentValues);
        }

        public static void delete(DatabaseProvider databaseProvider, long l2) throws DatabaseIOException {
            DatabaseStorage.delete(databaseProvider, Long.toHexString(l2));
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void delete(DatabaseProvider databaseProvider, String string2) throws DatabaseIOException {
            String string3;
            try {
                string3 = DatabaseStorage.getTableName(string2);
                databaseProvider = databaseProvider.getWritableDatabase();
                databaseProvider.beginTransactionNonExclusive();
            }
            catch (SQLException sQLException) {
                throw new DatabaseIOException(sQLException);
            }
            try {
                VersionTable.removeVersion((SQLiteDatabase)databaseProvider, (int)1, (String)string2);
                DatabaseStorage.dropTable((SQLiteDatabase)databaseProvider, string3);
                databaseProvider.setTransactionSuccessful();
                return;
            }
            finally {
                databaseProvider.endTransaction();
            }
        }

        private void deleteRow(SQLiteDatabase sQLiteDatabase, int n2) {
            sQLiteDatabase.delete(Assertions.checkNotNull(this.tableName), WHERE_ID_EQUALS, new String[]{Integer.toString(n2)});
        }

        private static void dropTable(SQLiteDatabase sQLiteDatabase, String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DROP TABLE IF EXISTS ");
            stringBuilder.append(string2);
            sQLiteDatabase.execSQL(stringBuilder.toString());
        }

        private Cursor getCursor() {
            return this.databaseProvider.getReadableDatabase().query(Assertions.checkNotNull(this.tableName), COLUMNS, null, null, null, null, null);
        }

        private static String getTableName(String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(TABLE_PREFIX);
            stringBuilder.append(string2);
            return stringBuilder.toString();
        }

        private void initializeTable(SQLiteDatabase sQLiteDatabase) throws DatabaseIOException {
            VersionTable.setVersion((SQLiteDatabase)sQLiteDatabase, (int)1, (String)Assertions.checkNotNull(this.hexUid), (int)1);
            DatabaseStorage.dropTable(sQLiteDatabase, Assertions.checkNotNull(this.tableName));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CREATE TABLE ");
            stringBuilder.append(this.tableName);
            stringBuilder.append(" ");
            stringBuilder.append(TABLE_SCHEMA);
            sQLiteDatabase.execSQL(stringBuilder.toString());
        }

        @Override
        public void delete() throws DatabaseIOException {
            DatabaseStorage.delete(this.databaseProvider, Assertions.checkNotNull(this.hexUid));
        }

        @Override
        public boolean exists() throws DatabaseIOException {
            SQLiteDatabase sQLiteDatabase = this.databaseProvider.getReadableDatabase();
            String string2 = Assertions.checkNotNull(this.hexUid);
            boolean bl = true;
            if (VersionTable.getVersion((SQLiteDatabase)sQLiteDatabase, (int)1, (String)string2) == -1) {
                bl = false;
            }
            return bl;
        }

        @Override
        public void initialize(long l2) {
            this.hexUid = Long.toHexString(l2);
            this.tableName = DatabaseStorage.getTableName(this.hexUid);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void load(HashMap<String, CachedContent> var1_1, SparseArray<String> var2_2) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void onRemove(CachedContent cachedContent, boolean bl) {
            if (bl) {
                this.pendingUpdates.delete(cachedContent.id);
            } else {
                this.pendingUpdates.put(cachedContent.id, null);
            }
        }

        @Override
        public void onUpdate(CachedContent cachedContent) {
            this.pendingUpdates.put(cachedContent.id, (Object)cachedContent);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void storeFully(HashMap<String, CachedContent> object) throws IOException {
            SQLiteDatabase sQLiteDatabase;
            try {
                sQLiteDatabase = this.databaseProvider.getWritableDatabase();
                sQLiteDatabase.beginTransactionNonExclusive();
            }
            catch (SQLException sQLException) {
                DatabaseIOException databaseIOException = new DatabaseIOException(sQLException);
                throw databaseIOException;
            }
            try {
                this.initializeTable(sQLiteDatabase);
                object = ((HashMap)((Object)object)).values().iterator();
                while (object.hasNext()) {
                    this.addOrUpdateRow(sQLiteDatabase, (CachedContent)object.next());
                }
                sQLiteDatabase.setTransactionSuccessful();
                this.pendingUpdates.clear();
                return;
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void storeIncremental(HashMap<String, CachedContent> sQLiteDatabase) throws IOException {
            if (this.pendingUpdates.size() == 0) {
                return;
            }
            try {
                sQLiteDatabase = this.databaseProvider.getWritableDatabase();
                sQLiteDatabase.beginTransactionNonExclusive();
            }
            catch (SQLException sQLException) {
                DatabaseIOException databaseIOException = new DatabaseIOException(sQLException);
                throw databaseIOException;
            }
            for (int i2 = 0; i2 < this.pendingUpdates.size(); ++i2) {
                CachedContent cachedContent = (CachedContent)this.pendingUpdates.valueAt(i2);
                if (cachedContent == null) {
                    this.deleteRow(sQLiteDatabase, this.pendingUpdates.keyAt(i2));
                    continue;
                }
                this.addOrUpdateRow(sQLiteDatabase, cachedContent);
            }
            {
                catch (Throwable throwable) {
                    sQLiteDatabase.endTransaction();
                    throw throwable;
                }
                {
                    sQLiteDatabase.setTransactionSuccessful();
                    this.pendingUpdates.clear();
                }
                sQLiteDatabase.endTransaction();
                return;
            }
        }
    }

    private static class LegacyStorage
    implements Storage {
        private static final int FLAG_ENCRYPTED_INDEX = 1;
        private static final int VERSION = 2;
        private static final int VERSION_METADATA_INTRODUCED = 2;
        private final AtomicFile atomicFile;
        private ReusableBufferedOutputStream bufferedOutputStream;
        private boolean changed;
        private final Cipher cipher;
        private final boolean encrypt;
        private final SecureRandom random;
        private final SecretKeySpec secretKeySpec;

        /*
         * WARNING - void declaration
         */
        public LegacyStorage(File file, byte[] object, boolean bl) {
            Object object2;
            Object var6_9;
            block6: {
                block5: {
                    void var1_4;
                    SecretKeySpec secretKeySpec;
                    boolean bl2 = false;
                    boolean bl3 = object != null || !bl;
                    Assertions.checkState(bl3);
                    var6_9 = null;
                    if (object == null) break block5;
                    bl3 = bl2;
                    if (((byte[])object).length == 16) {
                        bl3 = true;
                    }
                    Assertions.checkArgument(bl3);
                    try {
                        object2 = CachedContentIndex.getCipher();
                        secretKeySpec = new SecretKeySpec((byte[])object, "AES");
                        object = object2;
                    }
                    catch (NoSuchPaddingException noSuchPaddingException) {
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                    object2 = secretKeySpec;
                    break block6;
                    throw new IllegalStateException((Throwable)var1_4);
                }
                Assertions.checkArgument(bl ^ true);
                object2 = object = null;
            }
            this.encrypt = bl;
            this.cipher = object;
            this.secretKeySpec = object2;
            object = var6_9;
            if (bl) {
                object = new SecureRandom();
            }
            this.random = object;
            this.atomicFile = new AtomicFile(file);
        }

        private int hashCachedContent(CachedContent cachedContent, int n2) {
            int n3 = cachedContent.id * 31 + cachedContent.key.hashCode();
            if (n2 < 2) {
                long l2 = ContentMetadata._CC.getContentLength((ContentMetadata)cachedContent.getMetadata());
                n2 = n3 * 31 + (int)(l2 ^ l2 >>> 32);
            } else {
                n2 = n3 * 31 + cachedContent.getMetadata().hashCode();
            }
            return n2;
        }

        private CachedContent readCachedContent(int n2, DataInputStream dataInputStream) throws IOException {
            int n3 = dataInputStream.readInt();
            String string2 = dataInputStream.readUTF();
            if (n2 < 2) {
                long l2 = dataInputStream.readLong();
                dataInputStream = new ContentMetadataMutations();
                ContentMetadataMutations.setContentLength((ContentMetadataMutations)dataInputStream, (long)l2);
                dataInputStream = DefaultContentMetadata.EMPTY.copyWithMutationsApplied((ContentMetadataMutations)dataInputStream);
            } else {
                dataInputStream = CachedContentIndex.readContentMetadata(dataInputStream);
            }
            return new CachedContent(n3, string2, (DefaultContentMetadata)dataInputStream);
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         */
        private boolean readFile(HashMap<String, CachedContent> hashMap, SparseArray<String> object) {
            void var1_7;
            Object object2;
            Object object3;
            block41: {
                DataInputStream dataInputStream;
                block36: {
                    Object object4;
                    block40: {
                        int n2;
                        int n3;
                        block39: {
                            block37: {
                                BufferedInputStream bufferedInputStream;
                                block38: {
                                    if (!this.atomicFile.exists()) {
                                        return true;
                                    }
                                    bufferedInputStream = new BufferedInputStream(this.atomicFile.openRead());
                                    dataInputStream = new DataInputStream(bufferedInputStream);
                                    object3 = dataInputStream;
                                    object2 = dataInputStream;
                                    n3 = dataInputStream.readInt();
                                    if (n3 < 0 || n3 > 2) break block36;
                                    object3 = dataInputStream;
                                    object2 = dataInputStream;
                                    if ((dataInputStream.readInt() & 1) == 0) break block37;
                                    object3 = dataInputStream;
                                    object2 = dataInputStream;
                                    object4 = this.cipher;
                                    if (object4 != null) break block38;
                                    Util.closeQuietly(dataInputStream);
                                    return false;
                                }
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                object4 = new byte[16];
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                dataInputStream.readFully((byte[])object4);
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                Object object5 = new IvParameterSpec((byte[])object4);
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                this.cipher.init(2, (Key)Util.castNonNull(this.secretKeySpec), (AlgorithmParameterSpec)object5);
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                object5 = new CipherInputStream(bufferedInputStream, this.cipher);
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                object4 = new DataInputStream((InputStream)object5);
                                break block39;
                                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                                }
                                catch (InvalidKeyException invalidKeyException) {
                                    // empty catch block
                                }
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                object = new Object((Throwable)((Object)hashMap));
                                object3 = dataInputStream;
                                object2 = dataInputStream;
                                throw object;
                            }
                            object4 = dataInputStream;
                            object3 = dataInputStream;
                            object2 = dataInputStream;
                            if (!this.encrypt) break block39;
                            object3 = dataInputStream;
                            object2 = dataInputStream;
                            this.changed = true;
                            object4 = dataInputStream;
                        }
                        object3 = object4;
                        object2 = object4;
                        int n4 = ((DataInputStream)object4).readInt();
                        int n5 = 0;
                        for (n2 = 0; n2 < n4; ++n2) {
                            object3 = object4;
                            object2 = object4;
                            dataInputStream = this.readCachedContent(n3, (DataInputStream)object4);
                            object3 = object4;
                            object2 = object4;
                            hashMap.put(((CachedContent)dataInputStream).key, (CachedContent)dataInputStream);
                            object3 = object4;
                            object2 = object4;
                            object.put(((CachedContent)dataInputStream).id, (Object)((CachedContent)dataInputStream).key);
                            object3 = object4;
                            object2 = object4;
                            n5 += this.hashCachedContent((CachedContent)dataInputStream, n3);
                            continue;
                        }
                        object3 = object4;
                        object2 = object4;
                        n4 = ((DataInputStream)object4).readInt();
                        object3 = object4;
                        object2 = object4;
                        try {
                            n2 = ((FilterInputStream)object4).read();
                            n2 = n2 == -1 ? 1 : 0;
                            if (n4 != n5 || n2 == 0) break block40;
                        }
                        catch (Throwable throwable) {}
                        catch (IOException iOException) {}
                        finally {
                            break block41;
                        }
                        Util.closeQuietly((Closeable)object4);
                        return true;
                    }
                    Util.closeQuietly((Closeable)object4);
                    return false;
                }
                Util.closeQuietly(dataInputStream);
                return false;
                catch (Throwable throwable) {
                    object3 = null;
                }
            }
            if (object3 != null) {
                Util.closeQuietly(object3);
            }
            throw var1_7;
            catch (IOException iOException) {
                object2 = null;
            }
            if (object2 != null) {
                Util.closeQuietly(object2);
            }
            return false;
        }

        private void writeCachedContent(CachedContent cachedContent, DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(cachedContent.id);
            dataOutputStream.writeUTF(cachedContent.key);
            CachedContentIndex.writeContentMetadata(cachedContent.getMetadata(), dataOutputStream);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeFile(HashMap<String, CachedContent> object) throws IOException {
            void var1_7;
            Object object2;
            block11: {
                DataOutputStream dataOutputStream;
                ReusableBufferedOutputStream reusableBufferedOutputStream;
                Object object3;
                try {
                    object3 = this.atomicFile.startWrite();
                    if (this.bufferedOutputStream == null) {
                        object2 = new ReusableBufferedOutputStream((OutputStream)object3);
                        this.bufferedOutputStream = object2;
                    } else {
                        this.bufferedOutputStream.reset((OutputStream)object3);
                    }
                    reusableBufferedOutputStream = this.bufferedOutputStream;
                    dataOutputStream = new DataOutputStream(reusableBufferedOutputStream);
                    object2 = dataOutputStream;
                }
                catch (Throwable throwable) {
                    object2 = null;
                    break block11;
                }
                try {
                    int n2;
                    int n3;
                    block12: {
                        dataOutputStream.writeInt(2);
                        object2 = dataOutputStream;
                        boolean bl = this.encrypt;
                        n3 = 0;
                        n2 = bl ? 1 : 0;
                        object2 = dataOutputStream;
                        dataOutputStream.writeInt(n2);
                        object3 = dataOutputStream;
                        object2 = dataOutputStream;
                        if (this.encrypt) {
                            void throwable;
                            object2 = dataOutputStream;
                            object3 = new byte[16];
                            object2 = dataOutputStream;
                            Util.castNonNull(this.random).nextBytes((byte[])object3);
                            object2 = dataOutputStream;
                            dataOutputStream.write((byte[])object3);
                            object2 = dataOutputStream;
                            object2 = dataOutputStream;
                            Object object4 = new IvParameterSpec((byte[])object3);
                            object2 = dataOutputStream;
                            try {
                                Util.castNonNull(this.cipher).init(1, (Key)Util.castNonNull(this.secretKeySpec), (AlgorithmParameterSpec)object4);
                                object2 = dataOutputStream;
                                dataOutputStream.flush();
                                object2 = dataOutputStream;
                                object2 = dataOutputStream;
                                object2 = dataOutputStream;
                                object4 = new CipherOutputStream(reusableBufferedOutputStream, this.cipher);
                                object2 = dataOutputStream;
                                object3 = new DataOutputStream((OutputStream)object4);
                                break block12;
                            }
                            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                            }
                            catch (InvalidKeyException invalidKeyException) {
                                // empty catch block
                            }
                            object2 = dataOutputStream;
                            object2 = dataOutputStream;
                            object3 = new IllegalStateException((Throwable)throwable);
                            object2 = dataOutputStream;
                            throw object3;
                        }
                    }
                    object2 = object3;
                    ((DataOutputStream)object3).writeInt(((HashMap)((Object)object)).size());
                    object2 = object3;
                    object = ((HashMap)((Object)object)).values().iterator();
                    n2 = n3;
                    while (true) {
                        object2 = object3;
                        if (!object.hasNext()) break;
                        object2 = object3;
                        dataOutputStream = (CachedContent)object.next();
                        object2 = object3;
                        this.writeCachedContent((CachedContent)dataOutputStream, (DataOutputStream)object3);
                        object2 = object3;
                        n2 += this.hashCachedContent((CachedContent)dataOutputStream, 2);
                    }
                    object2 = object3;
                    ((DataOutputStream)object3).writeInt(n2);
                    object2 = object3;
                    this.atomicFile.endWrite((OutputStream)object3);
                }
                catch (Throwable throwable) {
                    break block11;
                }
                Util.closeQuietly(null);
                return;
            }
            Util.closeQuietly(object2);
            throw var1_7;
        }

        @Override
        public void delete() {
            this.atomicFile.delete();
        }

        @Override
        public boolean exists() {
            return this.atomicFile.exists();
        }

        @Override
        public void initialize(long l2) {
        }

        @Override
        public void load(HashMap<String, CachedContent> hashMap, SparseArray<String> sparseArray) {
            Assertions.checkState(this.changed ^ true);
            if (!this.readFile(hashMap, sparseArray)) {
                hashMap.clear();
                sparseArray.clear();
                this.atomicFile.delete();
            }
        }

        @Override
        public void onRemove(CachedContent cachedContent, boolean bl) {
            this.changed = true;
        }

        @Override
        public void onUpdate(CachedContent cachedContent) {
            this.changed = true;
        }

        @Override
        public void storeFully(HashMap<String, CachedContent> hashMap) throws IOException {
            this.writeFile(hashMap);
            this.changed = false;
        }

        @Override
        public void storeIncremental(HashMap<String, CachedContent> hashMap) throws IOException {
            if (!this.changed) {
                return;
            }
            this.storeFully(hashMap);
        }
    }

    private static interface Storage {
        public void delete() throws IOException;

        public boolean exists() throws IOException;

        public void initialize(long var1);

        public void load(HashMap<String, CachedContent> var1, SparseArray<String> var2) throws IOException;

        public void onRemove(CachedContent var1, boolean var2);

        public void onUpdate(CachedContent var1);

        public void storeFully(HashMap<String, CachedContent> var1) throws IOException;

        public void storeIncremental(HashMap<String, CachedContent> var1) throws IOException;
    }
}

