/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import android.net.Uri;
import com.google.android.exoplayer2.upstream.DataSink;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.DummyDataSource;
import com.google.android.exoplayer2.upstream.FileDataSource;
import com.google.android.exoplayer2.upstream.PriorityDataSource;
import com.google.android.exoplayer2.upstream.TeeDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSink;
import com.google.android.exoplayer2.upstream.cache.CacheKeyFactory;
import com.google.android.exoplayer2.upstream.cache.CacheSpan;
import com.google.android.exoplayer2.upstream.cache.ContentMetadata;
import com.google.android.exoplayer2.upstream.cache.ContentMetadataMutations;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.PriorityTaskManager;
import com.google.android.exoplayer2.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CacheDataSource
implements DataSource {
    public static final int CACHE_IGNORED_REASON_ERROR = 0;
    public static final int CACHE_IGNORED_REASON_UNSET_LENGTH = 1;
    private static final int CACHE_NOT_IGNORED = -1;
    public static final int FLAG_BLOCK_ON_CACHE = 1;
    public static final int FLAG_IGNORE_CACHE_FOR_UNSET_LENGTH_REQUESTS = 4;
    public static final int FLAG_IGNORE_CACHE_ON_ERROR = 2;
    private static final long MIN_READ_BEFORE_CHECKING_CACHE = 102400L;
    private Uri actualUri;
    private final boolean blockOnCache;
    private long bytesRemaining;
    private final Cache cache;
    private final CacheKeyFactory cacheKeyFactory;
    private final DataSource cacheReadDataSource;
    private final DataSource cacheWriteDataSource;
    private long checkCachePosition;
    private DataSource currentDataSource;
    private boolean currentDataSpecLengthUnset;
    private CacheSpan currentHoleSpan;
    private boolean currentRequestIgnoresCache;
    private final EventListener eventListener;
    private final boolean ignoreCacheForUnsetLengthRequests;
    private final boolean ignoreCacheOnError;
    private long readPosition;
    private DataSpec requestDataSpec;
    private boolean seenCacheError;
    private long totalCachedBytesRead;
    private final DataSource upstreamDataSource;

    public CacheDataSource(Cache cache, DataSource dataSource) {
        this(cache, dataSource, 0);
    }

    public CacheDataSource(Cache cache, DataSource dataSource, int n2) {
        this(cache, dataSource, (DataSource)new FileDataSource(), (DataSink)new CacheDataSink(cache, 0x500000L), n2, null);
    }

    public CacheDataSource(Cache cache, DataSource dataSource, DataSource dataSource2, DataSink dataSink, int n2, EventListener eventListener) {
        this(cache, dataSource, dataSource2, dataSink, n2, eventListener, null);
    }

    public CacheDataSource(Cache cache, DataSource dataSource, DataSource dataSource2, DataSink dataSink, int n2, EventListener eventListener, CacheKeyFactory cacheKeyFactory) {
        this(cache, dataSource, dataSource2, dataSink, cacheKeyFactory, n2, null, 0, eventListener);
    }

    private CacheDataSource(Cache cache, DataSource dataSource, DataSource dataSource2, DataSink dataSink, CacheKeyFactory cacheKeyFactory, int n2, PriorityTaskManager priorityTaskManager, int n3, EventListener eventListener) {
        this.cache = cache;
        this.cacheReadDataSource = dataSource2;
        if (cacheKeyFactory == null) {
            cacheKeyFactory = CacheKeyFactory.DEFAULT;
        }
        this.cacheKeyFactory = cacheKeyFactory;
        boolean bl = false;
        boolean bl2 = (n2 & 1) != 0;
        this.blockOnCache = bl2;
        bl2 = (n2 & 2) != 0;
        this.ignoreCacheOnError = bl2;
        bl2 = bl;
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        this.ignoreCacheForUnsetLengthRequests = bl2;
        dataSource2 = null;
        if (dataSource != null) {
            cache = dataSource;
            if (priorityTaskManager != null) {
                cache = new PriorityDataSource(dataSource, priorityTaskManager, n3);
            }
            this.upstreamDataSource = cache;
            dataSource = dataSource2;
            if (dataSink != null) {
                dataSource = new TeeDataSource((DataSource)cache, dataSink);
            }
            this.cacheWriteDataSource = dataSource;
        } else {
            this.upstreamDataSource = DummyDataSource.INSTANCE;
            this.cacheWriteDataSource = null;
        }
        this.eventListener = eventListener;
    }

    private void closeCurrentSource() throws IOException {
        DataSource dataSource = this.currentDataSource;
        if (dataSource == null) {
            return;
        }
        try {
            dataSource.close();
            return;
        }
        finally {
            this.currentDataSource = null;
            this.currentDataSpecLengthUnset = false;
            dataSource = this.currentHoleSpan;
            if (dataSource != null) {
                this.cache.releaseHoleSpan((CacheSpan)dataSource);
                this.currentHoleSpan = null;
            }
        }
    }

    private static Uri getRedirectedUriOrDefault(Cache cache, String string2, Uri uri) {
        block0: {
            if ((cache = ContentMetadata._CC.getRedirectedUri((ContentMetadata)cache.getContentMetadata(string2))) == null) break block0;
            uri = cache;
        }
        return uri;
    }

    private void handleBeforeThrow(Throwable throwable) {
        if (this.isReadingFromCache() || throwable instanceof Cache.CacheException) {
            this.seenCacheError = true;
        }
    }

    private boolean isBypassingCache() {
        boolean bl = this.currentDataSource == this.upstreamDataSource;
        return bl;
    }

    private boolean isReadingFromCache() {
        boolean bl = this.currentDataSource == this.cacheReadDataSource;
        return bl;
    }

    private boolean isReadingFromUpstream() {
        return this.isReadingFromCache() ^ true;
    }

    private boolean isWritingToCache() {
        boolean bl = this.currentDataSource == this.cacheWriteDataSource;
        return bl;
    }

    private void notifyBytesRead() {
        EventListener eventListener = this.eventListener;
        if (eventListener != null && this.totalCachedBytesRead > 0L) {
            eventListener.onCachedBytesRead(this.cache.getCacheSpace(), this.totalCachedBytesRead);
            this.totalCachedBytesRead = 0L;
        }
    }

    private void notifyCacheIgnored(int n2) {
        EventListener eventListener = this.eventListener;
        if (eventListener != null) {
            eventListener.onCacheIgnored(n2);
        }
    }

    private void openNextSource(DataSpec dataSpec, boolean bl) throws IOException {
        long l2;
        CacheSpan cacheSpan;
        Object object;
        CacheSpan cacheSpan2;
        String string2 = Util.castNonNull(dataSpec.key);
        boolean bl2 = this.currentRequestIgnoresCache;
        Object var5_7 = null;
        if (bl2) {
            cacheSpan2 = null;
        } else if (this.blockOnCache) {
            try {
                cacheSpan2 = this.cache.startReadWrite(string2, this.readPosition, this.bytesRemaining);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        } else {
            cacheSpan2 = this.cache.startReadWriteNonBlocking(string2, this.readPosition, this.bytesRemaining);
        }
        if (cacheSpan2 == null) {
            DataSource dataSource = this.upstreamDataSource;
            object = dataSpec.buildUpon().setPosition(this.readPosition).setLength(this.bytesRemaining).build();
            cacheSpan = cacheSpan2;
            cacheSpan2 = dataSource;
        } else if (cacheSpan2.isCached) {
            object = Uri.fromFile((File)Util.castNonNull(cacheSpan2.file));
            long l3 = cacheSpan2.position;
            long l4 = this.readPosition - l3;
            long l5 = cacheSpan2.length - l4;
            long l6 = this.bytesRemaining;
            l2 = l5;
            if (l6 != -1L) {
                l2 = Math.min(l5, l6);
            }
            object = dataSpec.buildUpon().setUri((Uri)object).setUriPositionOffset(l3).setPosition(l4).setLength(l2).build();
            DataSource dataSource = this.cacheReadDataSource;
            cacheSpan = cacheSpan2;
            cacheSpan2 = dataSource;
        } else {
            if (cacheSpan2.isOpenEnded()) {
                l2 = this.bytesRemaining;
            } else {
                long l7 = cacheSpan2.length;
                long l8 = this.bytesRemaining;
                l2 = l7;
                if (l8 != -1L) {
                    l2 = Math.min(l7, l8);
                }
            }
            object = dataSpec.buildUpon().setPosition(this.readPosition).setLength(l2).build();
            DataSource dataSource = this.cacheWriteDataSource;
            if (dataSource != null) {
                cacheSpan = cacheSpan2;
                cacheSpan2 = dataSource;
            } else {
                dataSource = this.upstreamDataSource;
                this.cache.releaseHoleSpan(cacheSpan2);
                cacheSpan = null;
                cacheSpan2 = dataSource;
            }
        }
        l2 = !this.currentRequestIgnoresCache && cacheSpan2 == this.upstreamDataSource ? this.readPosition + 102400L : Long.MAX_VALUE;
        this.checkCachePosition = l2;
        if (bl) {
            Assertions.checkState(this.isBypassingCache());
            if (cacheSpan2 == this.upstreamDataSource) {
                return;
            }
            try {
                this.closeCurrentSource();
            }
            catch (Throwable throwable) {
                if (Util.castNonNull(cacheSpan).isHoleSpan()) {
                    this.cache.releaseHoleSpan(cacheSpan);
                }
                throw throwable;
            }
        }
        if (cacheSpan != null && cacheSpan.isHoleSpan()) {
            this.currentHoleSpan = cacheSpan;
        }
        this.currentDataSource = cacheSpan2;
        bl = object.length == -1L;
        this.currentDataSpecLengthUnset = bl;
        l2 = cacheSpan2.open((DataSpec)object);
        object = new ContentMetadataMutations();
        if (this.currentDataSpecLengthUnset && l2 != -1L) {
            this.bytesRemaining = l2;
            ContentMetadataMutations.setContentLength((ContentMetadataMutations)object, (long)(this.readPosition + this.bytesRemaining));
        }
        if (this.isReadingFromUpstream()) {
            this.actualUri = cacheSpan2.getUri();
            cacheSpan2 = var5_7;
            if (dataSpec.uri.equals((Object)this.actualUri) ^ true) {
                cacheSpan2 = this.actualUri;
            }
            ContentMetadataMutations.setRedirectedUri((ContentMetadataMutations)object, (Uri)cacheSpan2);
        }
        if (this.isWritingToCache()) {
            this.cache.applyContentMetadataMutations(string2, (ContentMetadataMutations)object);
        }
    }

    private void setNoBytesRemainingAndMaybeStoreLength(String string2) throws IOException {
        this.bytesRemaining = 0L;
        if (this.isWritingToCache()) {
            ContentMetadataMutations contentMetadataMutations = new ContentMetadataMutations();
            ContentMetadataMutations.setContentLength((ContentMetadataMutations)contentMetadataMutations, (long)this.readPosition);
            this.cache.applyContentMetadataMutations(string2, contentMetadataMutations);
        }
    }

    private int shouldIgnoreCacheForRequest(DataSpec dataSpec) {
        if (this.ignoreCacheOnError && this.seenCacheError) {
            return 0;
        }
        if (this.ignoreCacheForUnsetLengthRequests && dataSpec.length == -1L) {
            return 1;
        }
        return -1;
    }

    public void addTransferListener(TransferListener transferListener) {
        Assertions.checkNotNull(transferListener);
        this.cacheReadDataSource.addTransferListener(transferListener);
        this.upstreamDataSource.addTransferListener(transferListener);
    }

    public void close() throws IOException {
        this.requestDataSpec = null;
        this.actualUri = null;
        this.readPosition = 0L;
        this.notifyBytesRead();
        try {
            this.closeCurrentSource();
            return;
        }
        catch (Throwable throwable) {
            this.handleBeforeThrow(throwable);
            throw throwable;
        }
    }

    public Cache getCache() {
        return this.cache;
    }

    public CacheKeyFactory getCacheKeyFactory() {
        return this.cacheKeyFactory;
    }

    public Map<String, List<String>> getResponseHeaders() {
        Map map = this.isReadingFromUpstream() ? this.upstreamDataSource.getResponseHeaders() : Collections.emptyMap();
        return map;
    }

    public Uri getUri() {
        return this.actualUri;
    }

    public long open(DataSpec dataSpec) throws IOException {
        boolean bl;
        int n2;
        DataSpec dataSpec2;
        String string2;
        try {
            string2 = this.cacheKeyFactory.buildCacheKey(dataSpec);
            this.requestDataSpec = dataSpec2 = dataSpec.buildUpon().setKey(string2).build();
            this.actualUri = CacheDataSource.getRedirectedUriOrDefault(this.cache, string2, dataSpec2.uri);
            this.readPosition = dataSpec.position;
            n2 = this.shouldIgnoreCacheForRequest(dataSpec);
            bl = n2 != -1;
        }
        catch (Throwable throwable) {
            this.handleBeforeThrow(throwable);
            throw throwable;
        }
        this.currentRequestIgnoresCache = bl;
        if (this.currentRequestIgnoresCache) {
            this.notifyCacheIgnored(n2);
        }
        if (dataSpec.length == -1L && !this.currentRequestIgnoresCache) {
            this.bytesRemaining = ContentMetadata._CC.getContentLength((ContentMetadata)this.cache.getContentMetadata(string2));
            if (this.bytesRemaining != -1L) {
                this.bytesRemaining -= dataSpec.position;
                if (this.bytesRemaining <= 0L) {
                    dataSpec = new DataSourceException(0);
                    throw dataSpec;
                }
            }
        } else {
            this.bytesRemaining = dataSpec.length;
        }
        this.openNextSource(dataSpec2, false);
        long l2 = this.bytesRemaining;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        DataSpec dataSpec = Assertions.checkNotNull(this.requestDataSpec);
        if (n3 == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int n4;
            if (this.readPosition >= this.checkCachePosition) {
                this.openNextSource(dataSpec, true);
            }
            if ((n4 = Assertions.checkNotNull(this.currentDataSource).read(byArray, n2, n3)) != -1) {
                if (this.isReadingFromCache()) {
                    this.totalCachedBytesRead += (long)n4;
                }
                long l2 = this.readPosition;
                long l3 = n4;
                this.readPosition = l2 + l3;
                if (this.bytesRemaining == -1L) return n4;
                this.bytesRemaining -= l3;
                return n4;
            }
            if (this.currentDataSpecLengthUnset) {
                this.setNoBytesRemainingAndMaybeStoreLength(Util.castNonNull(dataSpec.key));
                return n4;
            }
            if (this.bytesRemaining <= 0L) {
                if (this.bytesRemaining != -1L) return n4;
            }
            this.closeCurrentSource();
            this.openNextSource(dataSpec, false);
            return this.read(byArray, n2, n3);
        }
        catch (Throwable throwable) {
            this.handleBeforeThrow(throwable);
            throw throwable;
        }
        catch (IOException iOException) {
            if (this.currentDataSpecLengthUnset && DataSourceException.isCausedByPositionOutOfRange((IOException)iOException)) {
                this.setNoBytesRemainingAndMaybeStoreLength(Util.castNonNull(dataSpec.key));
                return -1;
            }
            this.handleBeforeThrow(iOException);
            throw iOException;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CacheIgnoredReason {
    }

    public static interface EventListener {
        public void onCacheIgnored(int var1);

        public void onCachedBytesRead(long var1, long var3);
    }

    public static final class Factory
    implements DataSource.Factory {
        private Cache cache;
        private boolean cacheIsReadOnly;
        private CacheKeyFactory cacheKeyFactory;
        private DataSource.Factory cacheReadDataSourceFactory = new FileDataSource.Factory();
        private DataSink.Factory cacheWriteDataSinkFactory;
        private EventListener eventListener;
        private int flags;
        private DataSource.Factory upstreamDataSourceFactory;
        private int upstreamPriority;
        private PriorityTaskManager upstreamPriorityTaskManager;

        public Factory() {
            this.cacheKeyFactory = CacheKeyFactory.DEFAULT;
        }

        private CacheDataSource createDataSourceInternal(DataSource dataSource, int n2, int n3) {
            Object object;
            Cache cache = Assertions.checkNotNull(this.cache);
            object = !this.cacheIsReadOnly && dataSource != null ? ((object = this.cacheWriteDataSinkFactory) != null ? object.createDataSink() : new CacheDataSink.Factory().setCache(cache).createDataSink()) : null;
            return new CacheDataSource(cache, dataSource, this.cacheReadDataSourceFactory.createDataSource(), (DataSink)object, this.cacheKeyFactory, n2, this.upstreamPriorityTaskManager, n3, this.eventListener);
        }

        public CacheDataSource createDataSource() {
            Object object = this.upstreamDataSourceFactory;
            object = object != null ? object.createDataSource() : null;
            return this.createDataSourceInternal((DataSource)object, this.flags, this.upstreamPriority);
        }

        public CacheDataSource createDataSourceForDownloading() {
            Object object = this.upstreamDataSourceFactory;
            object = object != null ? object.createDataSource() : null;
            return this.createDataSourceInternal((DataSource)object, this.flags | 1, -1000);
        }

        public CacheDataSource createDataSourceForRemovingDownload() {
            return this.createDataSourceInternal(null, this.flags | 1, -1000);
        }

        public Cache getCache() {
            return this.cache;
        }

        public CacheKeyFactory getCacheKeyFactory() {
            return this.cacheKeyFactory;
        }

        public PriorityTaskManager getUpstreamPriorityTaskManager() {
            return this.upstreamPriorityTaskManager;
        }

        public Factory setCache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public Factory setCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
            this.cacheKeyFactory = cacheKeyFactory;
            return this;
        }

        public Factory setCacheReadDataSourceFactory(DataSource.Factory factory) {
            this.cacheReadDataSourceFactory = factory;
            return this;
        }

        public Factory setCacheWriteDataSinkFactory(DataSink.Factory factory) {
            this.cacheWriteDataSinkFactory = factory;
            boolean bl = factory == null;
            this.cacheIsReadOnly = bl;
            return this;
        }

        public Factory setEventListener(EventListener eventListener) {
            this.eventListener = eventListener;
            return this;
        }

        public Factory setFlags(int n2) {
            this.flags = n2;
            return this;
        }

        public Factory setUpstreamDataSourceFactory(DataSource.Factory factory) {
            this.upstreamDataSourceFactory = factory;
            return this;
        }

        public Factory setUpstreamPriority(int n2) {
            this.upstreamPriority = n2;
            return this;
        }

        public Factory setUpstreamPriorityTaskManager(PriorityTaskManager priorityTaskManager) {
            this.upstreamPriorityTaskManager = priorityTaskManager;
            return this;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

