/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public final class Loader
implements LoaderErrorThrower {
    private static final int ACTION_TYPE_DONT_RETRY = 2;
    private static final int ACTION_TYPE_DONT_RETRY_FATAL = 3;
    private static final int ACTION_TYPE_RETRY = 0;
    private static final int ACTION_TYPE_RETRY_AND_RESET_ERROR_COUNT = 1;
    public static final LoadErrorAction DONT_RETRY;
    public static final LoadErrorAction DONT_RETRY_FATAL;
    public static final LoadErrorAction RETRY;
    public static final LoadErrorAction RETRY_RESET_ERROR_COUNT;
    private LoadTask<? extends Loadable> currentTask;
    private final ExecutorService downloadExecutorService;
    private IOException fatalError;

    static {
        RETRY = Loader.createRetryAction(false, -9223372036854775807L);
        RETRY_RESET_ERROR_COUNT = Loader.createRetryAction(true, -9223372036854775807L);
        DONT_RETRY = new LoadErrorAction(2, -9223372036854775807L);
        DONT_RETRY_FATAL = new LoadErrorAction(3, -9223372036854775807L);
    }

    public Loader(String string2) {
        this.downloadExecutorService = Util.newSingleThreadExecutor(string2);
    }

    static /* synthetic */ LoadTask access$102(Loader loader, LoadTask loadTask) {
        loader.currentTask = loadTask;
        return loadTask;
    }

    static /* synthetic */ IOException access$202(Loader loader, IOException iOException) {
        loader.fatalError = iOException;
        return iOException;
    }

    public static LoadErrorAction createRetryAction(boolean bl, long l2) {
        return new LoadErrorAction(bl ? 1 : 0, l2);
    }

    public void cancelLoading() {
        Assertions.checkStateNotNull(this.currentTask).cancel(false);
    }

    public void clearFatalError() {
        this.fatalError = null;
    }

    public boolean hasFatalError() {
        boolean bl = this.fatalError != null;
        return bl;
    }

    public boolean isLoading() {
        boolean bl = this.currentTask != null;
        return bl;
    }

    public void maybeThrowError() throws IOException {
        this.maybeThrowError(Integer.MIN_VALUE);
    }

    public void maybeThrowError(int n2) throws IOException {
        LoadTask<? extends Loadable> loadTask = this.fatalError;
        if (loadTask == null) {
            loadTask = this.currentTask;
            if (loadTask != null) {
                int n3 = n2;
                if (n2 == Integer.MIN_VALUE) {
                    n3 = loadTask.defaultMinRetryCount;
                }
                loadTask.maybeThrowError(n3);
            }
            return;
        }
        throw loadTask;
    }

    public void release() {
        this.release(null);
    }

    public void release(ReleaseCallback releaseCallback) {
        LoadTask<? extends Loadable> loadTask = this.currentTask;
        if (loadTask != null) {
            loadTask.cancel(true);
        }
        if (releaseCallback != null) {
            this.downloadExecutorService.execute(new ReleaseTask(releaseCallback));
        }
        this.downloadExecutorService.shutdown();
    }

    public <T extends Loadable> long startLoading(T t2, Callback<T> callback2, int n2) {
        Looper looper = Assertions.checkStateNotNull(Looper.myLooper());
        this.fatalError = null;
        long l2 = SystemClock.elapsedRealtime();
        new LoadTask(this, looper, t2, callback2, n2, l2).start(0L);
        return l2;
    }

    public static interface Callback<T extends Loadable> {
        public void onLoadCanceled(T var1, long var2, long var4, boolean var6);

        public void onLoadCompleted(T var1, long var2, long var4);

        public LoadErrorAction onLoadError(T var1, long var2, long var4, IOException var6, int var7);
    }

    public static final class LoadErrorAction {
        private final long retryDelayMillis;
        private final int type;

        private LoadErrorAction(int n2, long l2) {
            this.type = n2;
            this.retryDelayMillis = l2;
        }

        public boolean isRetry() {
            boolean bl;
            int n2 = this.type;
            boolean bl2 = bl = true;
            if (n2 != 0) {
                bl2 = n2 == 1 ? bl : false;
            }
            return bl2;
        }
    }

    private final class LoadTask<T extends Loadable>
    extends Handler
    implements Runnable {
        private static final int MSG_FATAL_ERROR = 3;
        private static final int MSG_FINISH = 1;
        private static final int MSG_IO_EXCEPTION = 2;
        private static final int MSG_START = 0;
        private static final String TAG = "LoadTask";
        private Callback<T> callback;
        private boolean canceled;
        private IOException currentError;
        public final int defaultMinRetryCount;
        private int errorCount;
        private Thread executorThread;
        private final T loadable;
        private volatile boolean released;
        private final long startTimeMs;
        final /* synthetic */ Loader this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public LoadTask(Looper looper, T t2, Callback<T> callback2, int n2, long l3) {
            void var2_-1;
            this.this$0 = (Loader)l2;
            super((Looper)var2_-1);
            this.loadable = looper;
            this.callback = t2;
            this.defaultMinRetryCount = (int)callback2;
            this.startTimeMs = n2;
        }

        private void execute() {
            this.currentError = null;
            this.this$0.downloadExecutorService.execute(Assertions.checkNotNull(this.this$0.currentTask));
        }

        private void finish() {
            Loader.access$102(this.this$0, null);
        }

        private long getRetryDelayMillis() {
            return Math.min((this.errorCount - 1) * 1000, 5000);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void cancel(boolean bl) {
            this.released = bl;
            this.currentError = null;
            if (this.hasMessages(0)) {
                this.canceled = true;
                this.removeMessages(0);
                if (!bl) {
                    this.sendEmptyMessage(1);
                }
            } else {
                synchronized (this) {
                    this.canceled = true;
                    this.loadable.cancelLoad();
                    Thread thread = this.executorThread;
                    if (thread != null) {
                        thread.interrupt();
                    }
                }
            }
            if (bl) {
                this.finish();
                long l2 = SystemClock.elapsedRealtime();
                Assertions.checkNotNull(this.callback).onLoadCanceled(this.loadable, l2, l2 - this.startTimeMs, true);
                this.callback = null;
            }
        }

        public void handleMessage(Message object) {
            if (this.released) {
                return;
            }
            if (object.what == 0) {
                this.execute();
                return;
            }
            if (object.what != 3) {
                this.finish();
                long l2 = SystemClock.elapsedRealtime();
                long l3 = l2 - this.startTimeMs;
                Callback<T> callback2 = Assertions.checkNotNull(this.callback);
                if (this.canceled) {
                    callback2.onLoadCanceled(this.loadable, l2, l3, false);
                    return;
                }
                int n2 = object.what;
                if (n2 != 1) {
                    if (n2 == 2) {
                        this.currentError = (IOException)object.obj;
                        ++this.errorCount;
                        object = callback2.onLoadError(this.loadable, l2, l3, this.currentError, this.errorCount);
                        if (((LoadErrorAction)object).type == 3) {
                            Loader.access$202(this.this$0, this.currentError);
                        } else if (((LoadErrorAction)object).type != 2) {
                            if (((LoadErrorAction)object).type == 1) {
                                this.errorCount = 1;
                            }
                            l3 = ((LoadErrorAction)object).retryDelayMillis != -9223372036854775807L ? ((LoadErrorAction)object).retryDelayMillis : this.getRetryDelayMillis();
                            this.start(l3);
                        }
                    }
                } else {
                    try {
                        callback2.onLoadCompleted(this.loadable, l2, l3);
                    }
                    catch (RuntimeException runtimeException) {
                        Log.e(TAG, "Unexpected exception handling load completed", runtimeException);
                        Loader.access$202(this.this$0, new UnexpectedLoaderException(runtimeException));
                    }
                }
                return;
            }
            throw (Error)object.obj;
        }

        public void maybeThrowError(int n2) throws IOException {
            IOException iOException = this.currentError;
            if (iOException != null && this.errorCount > n2) {
                throw iOException;
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            boolean bl = !this.canceled;
            this.executorThread = Thread.currentThread();
            // MONITOREXIT : this
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("load:");
                stringBuilder.append(this.loadable.getClass().getSimpleName());
                TraceUtil.beginSection((String)stringBuilder.toString());
                this.loadable.load();
                {
                    catch (Throwable throwable) {
                        TraceUtil.endSection();
                        throw throwable;
                    }
                }
                TraceUtil.endSection();
                // MONITORENTER : this
            }
            this.executorThread = null;
            Thread.interrupted();
            // MONITOREXIT : this
            try {
                if (this.released) return;
                this.sendEmptyMessage(1);
                return;
            }
            catch (Error error) {
                Log.e(TAG, "Unexpected error loading stream", error);
                if (this.released) throw error;
                this.obtainMessage(3, error).sendToTarget();
                throw error;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.e(TAG, "OutOfMemory error loading stream", outOfMemoryError);
                if (this.released) return;
                this.obtainMessage(2, new UnexpectedLoaderException(outOfMemoryError)).sendToTarget();
                return;
            }
            catch (Exception exception) {
                Log.e(TAG, "Unexpected exception loading stream", exception);
                if (this.released) return;
                this.obtainMessage(2, new UnexpectedLoaderException(exception)).sendToTarget();
                return;
            }
            catch (IOException iOException) {
                if (this.released) return;
                this.obtainMessage(2, iOException).sendToTarget();
            }
        }

        public void start(long l2) {
            boolean bl = this.this$0.currentTask == null;
            Assertions.checkState(bl);
            Loader.access$102(this.this$0, this);
            if (l2 > 0L) {
                this.sendEmptyMessageDelayed(0, l2);
            } else {
                this.execute();
            }
        }
    }

    public static interface Loadable {
        public void cancelLoad();

        public void load() throws IOException;
    }

    public static interface ReleaseCallback {
        public void onLoaderReleased();
    }

    private static final class ReleaseTask
    implements Runnable {
        private final ReleaseCallback callback;

        public ReleaseTask(ReleaseCallback releaseCallback) {
            this.callback = releaseCallback;
        }

        @Override
        public void run() {
            this.callback.onLoaderReleased();
        }
    }

    public static final class UnexpectedLoaderException
    extends IOException {
        public UnexpectedLoaderException(Throwable throwable) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unexpected ");
            stringBuilder.append(throwable.getClass().getSimpleName());
            stringBuilder.append(": ");
            stringBuilder.append(throwable.getMessage());
            super(stringBuilder.toString(), throwable);
        }
    }
}

