/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream._$;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Predicate;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface HttpDataSource
extends DataSource {
    public static final Predicate<String> REJECT_PAYWALL_TYPES = _$.Lambda.HttpDataSource.18H_1y7mI5iaiXIofkfEy5eA6Y0.INSTANCE;

    public void clearAllRequestProperties();

    public void clearRequestProperty(String var1);

    public void close() throws HttpDataSourceException;

    public int getResponseCode();

    public Map<String, List<String>> getResponseHeaders();

    public long open(DataSpec var1) throws HttpDataSourceException;

    public int read(byte[] var1, int var2, int var3) throws HttpDataSourceException;

    public void setRequestProperty(String var1, String var2);

    public static abstract class BaseFactory
    implements Factory {
        private final RequestProperties defaultRequestProperties = new RequestProperties();

        @Override
        public final HttpDataSource createDataSource() {
            return this.createDataSourceInternal(this.defaultRequestProperties);
        }

        protected abstract HttpDataSource createDataSourceInternal(RequestProperties var1);

        @Override
        @Deprecated
        public final RequestProperties getDefaultRequestProperties() {
            return this.defaultRequestProperties;
        }

        @Override
        public final Factory setDefaultRequestProperties(Map<String, String> map) {
            this.defaultRequestProperties.clearAndSet(map);
            return this;
        }
    }

    public static final class CleartextNotPermittedException
    extends HttpDataSourceException {
        public CleartextNotPermittedException(IOException iOException, DataSpec dataSpec) {
            super("Cleartext HTTP traffic not permitted. See https://exoplayer.dev/issues/cleartext-not-permitted", iOException, dataSpec, 1);
        }
    }

    public static interface Factory
    extends DataSource.Factory {
        public HttpDataSource createDataSource();

        @Deprecated
        public RequestProperties getDefaultRequestProperties();

        public Factory setDefaultRequestProperties(Map<String, String> var1);
    }

    public static class HttpDataSourceException
    extends IOException {
        public static final int TYPE_CLOSE = 3;
        public static final int TYPE_OPEN = 1;
        public static final int TYPE_READ = 2;
        public final DataSpec dataSpec;
        public final int type;

        public HttpDataSourceException(DataSpec dataSpec, int n2) {
            this.dataSpec = dataSpec;
            this.type = n2;
        }

        public HttpDataSourceException(IOException iOException, DataSpec dataSpec, int n2) {
            super(iOException);
            this.dataSpec = dataSpec;
            this.type = n2;
        }

        public HttpDataSourceException(String string2, DataSpec dataSpec, int n2) {
            super(string2);
            this.dataSpec = dataSpec;
            this.type = n2;
        }

        public HttpDataSourceException(String string2, IOException iOException, DataSpec dataSpec, int n2) {
            super(string2, iOException);
            this.dataSpec = dataSpec;
            this.type = n2;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Type {
        }
    }

    public static final class InvalidContentTypeException
    extends HttpDataSourceException {
        public final String contentType;

        public InvalidContentTypeException(String string2, DataSpec dataSpec) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid content type: ");
            stringBuilder.append(string2);
            super(stringBuilder.toString(), dataSpec, 1);
            this.contentType = string2;
        }
    }

    public static final class InvalidResponseCodeException
    extends HttpDataSourceException {
        public final Map<String, List<String>> headerFields;
        public final byte[] responseBody;
        public final int responseCode;
        public final String responseMessage;

        @Deprecated
        public InvalidResponseCodeException(int n2, String string2, Map<String, List<String>> map, DataSpec dataSpec) {
            this(n2, string2, map, dataSpec, Util.EMPTY_BYTE_ARRAY);
        }

        public InvalidResponseCodeException(int n2, String string2, Map<String, List<String>> map, DataSpec dataSpec, byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Response code: ");
            stringBuilder.append(n2);
            super(stringBuilder.toString(), dataSpec, 1);
            this.responseCode = n2;
            this.responseMessage = string2;
            this.headerFields = map;
            this.responseBody = byArray;
        }

        @Deprecated
        public InvalidResponseCodeException(int n2, Map<String, List<String>> map, DataSpec dataSpec) {
            this(n2, null, map, dataSpec, Util.EMPTY_BYTE_ARRAY);
        }
    }

    public static final class RequestProperties {
        private final Map<String, String> requestProperties = new HashMap<String, String>();
        private Map<String, String> requestPropertiesSnapshot;

        public void clear() {
            synchronized (this) {
                this.requestPropertiesSnapshot = null;
                this.requestProperties.clear();
                return;
            }
        }

        public void clearAndSet(Map<String, String> map) {
            synchronized (this) {
                this.requestPropertiesSnapshot = null;
                this.requestProperties.clear();
                this.requestProperties.putAll(map);
                return;
            }
        }

        public Map<String, String> getSnapshot() {
            synchronized (this) {
                Map<String, String> map;
                if (this.requestPropertiesSnapshot == null) {
                    map = new Map<String, String>(this.requestProperties);
                    this.requestPropertiesSnapshot = Collections.unmodifiableMap(map);
                }
                map = this.requestPropertiesSnapshot;
                return map;
            }
        }

        public void remove(String string2) {
            synchronized (this) {
                this.requestPropertiesSnapshot = null;
                this.requestProperties.remove(string2);
                return;
            }
        }

        public void set(String string2, String string3) {
            synchronized (this) {
                this.requestPropertiesSnapshot = null;
                this.requestProperties.put(string2, string3);
                return;
            }
        }

        public void set(Map<String, String> map) {
            synchronized (this) {
                this.requestPropertiesSnapshot = null;
                this.requestProperties.putAll(map);
                return;
            }
        }
    }
}

