/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import com.google.android.exoplayer2.util.Assertions;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DataSpec {
    public static final int FLAG_ALLOW_CACHE_FRAGMENTATION = 4;
    public static final int FLAG_ALLOW_GZIP = 1;
    public static final int FLAG_DONT_CACHE_IF_LENGTH_UNKNOWN = 2;
    public static final int FLAG_MIGHT_NOT_USE_FULL_NETWORK_SPEED = 8;
    public static final int HTTP_METHOD_GET = 1;
    public static final int HTTP_METHOD_HEAD = 3;
    public static final int HTTP_METHOD_POST = 2;
    @Deprecated
    public final long absoluteStreamPosition;
    public final Object customData;
    public final int flags;
    public final byte[] httpBody;
    public final int httpMethod;
    public final Map<String, String> httpRequestHeaders;
    public final String key;
    public final long length;
    public final long position;
    public final Uri uri;
    public final long uriPositionOffset;

    public DataSpec(Uri uri) {
        this(uri, 0L, -1L);
    }

    @Deprecated
    public DataSpec(Uri uri, int n2) {
        this(uri, 0L, -1L, null, n2);
    }

    @Deprecated
    public DataSpec(Uri uri, int n2, byte[] byArray, long l2, long l3, long l4, String string2, int n3) {
        this(uri, n2, byArray, l2, l3, l4, string2, n3, Collections.emptyMap());
    }

    @Deprecated
    public DataSpec(Uri uri, int n2, byte[] byArray, long l2, long l3, long l4, String string2, int n3, Map<String, String> map) {
        this(uri, l2 - l3, n2, byArray, map, l3, l4, string2, n3, null);
    }

    private DataSpec(Uri uri, long l2, int n2, byte[] byArray, Map<String, String> map, long l3, long l4, String string2, int n3, Object object) {
        long l5 = l2 + l3;
        boolean bl = true;
        boolean bl2 = l5 >= 0L;
        Assertions.checkArgument(bl2);
        bl2 = l3 >= 0L;
        Assertions.checkArgument(bl2);
        bl2 = bl;
        if (l4 <= 0L) {
            bl2 = l4 == -1L ? bl : false;
        }
        Assertions.checkArgument(bl2);
        this.uri = uri;
        this.uriPositionOffset = l2;
        this.httpMethod = n2;
        if (byArray == null || byArray.length == 0) {
            byArray = null;
        }
        this.httpBody = byArray;
        this.httpRequestHeaders = Collections.unmodifiableMap(new HashMap<String, String>(map));
        this.position = l3;
        this.absoluteStreamPosition = l5;
        this.length = l4;
        this.key = string2;
        this.flags = n3;
        this.customData = object;
    }

    public DataSpec(Uri uri, long l2, long l3) {
        this(uri, 0L, 1, null, Collections.emptyMap(), l2, l3, null, 0, null);
    }

    @Deprecated
    public DataSpec(Uri uri, long l2, long l3, long l4, String string2, int n2) {
        this(uri, null, l2, l3, l4, string2, n2);
    }

    @Deprecated
    public DataSpec(Uri uri, long l2, long l3, String string2) {
        this(uri, l2, l2, l3, string2, 0);
    }

    @Deprecated
    public DataSpec(Uri uri, long l2, long l3, String string2, int n2) {
        this(uri, l2, l2, l3, string2, n2);
    }

    @Deprecated
    public DataSpec(Uri uri, long l2, long l3, String string2, int n2, Map<String, String> map) {
        this(uri, 1, null, l2, l2, l3, string2, n2, map);
    }

    @Deprecated
    public DataSpec(Uri uri, byte[] byArray, long l2, long l3, long l4, String string2, int n2) {
        int n3 = byArray != null ? 2 : 1;
        this(uri, n3, byArray, l2, l3, l4, string2, n2);
    }

    public static String getStringForHttpMethod(int n2) {
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 == 3) {
                    return "HEAD";
                }
                throw new IllegalStateException();
            }
            return "POST";
        }
        return "GET";
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public final String getHttpMethodString() {
        return DataSpec.getStringForHttpMethod(this.httpMethod);
    }

    public boolean isFlagSet(int n2) {
        boolean bl = (this.flags & n2) == n2;
        return bl;
    }

    public DataSpec subrange(long l2) {
        long l3 = this.length;
        long l4 = -1L;
        if (l3 != -1L) {
            l4 = l3 - l2;
        }
        return this.subrange(l2, l4);
    }

    public DataSpec subrange(long l2, long l3) {
        if (l2 == 0L && this.length == l3) {
            return this;
        }
        return new DataSpec(this.uri, this.uriPositionOffset, this.httpMethod, this.httpBody, this.httpRequestHeaders, this.position + l2, l3, this.key, this.flags, this.customData);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataSpec[");
        stringBuilder.append(this.getHttpMethodString());
        stringBuilder.append(" ");
        stringBuilder.append(this.uri);
        stringBuilder.append(", ");
        stringBuilder.append(this.position);
        stringBuilder.append(", ");
        stringBuilder.append(this.length);
        stringBuilder.append(", ");
        stringBuilder.append(this.key);
        stringBuilder.append(", ");
        stringBuilder.append(this.flags);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public DataSpec withAdditionalHeaders(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.httpRequestHeaders);
        hashMap.putAll(map);
        return new DataSpec(this.uri, this.uriPositionOffset, this.httpMethod, this.httpBody, hashMap, this.position, this.length, this.key, this.flags, this.customData);
    }

    public DataSpec withRequestHeaders(Map<String, String> map) {
        return new DataSpec(this.uri, this.uriPositionOffset, this.httpMethod, this.httpBody, map, this.position, this.length, this.key, this.flags, this.customData);
    }

    public DataSpec withUri(Uri uri) {
        return new DataSpec(uri, this.uriPositionOffset, this.httpMethod, this.httpBody, this.httpRequestHeaders, this.position, this.length, this.key, this.flags, this.customData);
    }

    public static final class Builder {
        private Object customData;
        private int flags;
        private byte[] httpBody;
        private int httpMethod;
        private Map<String, String> httpRequestHeaders;
        private String key;
        private long length;
        private long position;
        private Uri uri;
        private long uriPositionOffset;

        public Builder() {
            this.httpMethod = 1;
            this.httpRequestHeaders = Collections.emptyMap();
            this.length = -1L;
        }

        private Builder(DataSpec dataSpec) {
            this.uri = dataSpec.uri;
            this.uriPositionOffset = dataSpec.uriPositionOffset;
            this.httpMethod = dataSpec.httpMethod;
            this.httpBody = dataSpec.httpBody;
            this.httpRequestHeaders = dataSpec.httpRequestHeaders;
            this.position = dataSpec.position;
            this.length = dataSpec.length;
            this.key = dataSpec.key;
            this.flags = dataSpec.flags;
            this.customData = dataSpec.customData;
        }

        public DataSpec build() {
            Assertions.checkStateNotNull(this.uri, "The uri must be set.");
            return new DataSpec(this.uri, this.uriPositionOffset, this.httpMethod, this.httpBody, this.httpRequestHeaders, this.position, this.length, this.key, this.flags, this.customData);
        }

        public Builder setCustomData(Object object) {
            this.customData = object;
            return this;
        }

        public Builder setFlags(int n2) {
            this.flags = n2;
            return this;
        }

        public Builder setHttpBody(byte[] byArray) {
            this.httpBody = byArray;
            return this;
        }

        public Builder setHttpMethod(int n2) {
            this.httpMethod = n2;
            return this;
        }

        public Builder setHttpRequestHeaders(Map<String, String> map) {
            this.httpRequestHeaders = map;
            return this;
        }

        public Builder setKey(String string2) {
            this.key = string2;
            return this;
        }

        public Builder setLength(long l2) {
            this.length = l2;
            return this;
        }

        public Builder setPosition(long l2) {
            this.position = l2;
            return this;
        }

        public Builder setUri(Uri uri) {
            this.uri = uri;
            return this;
        }

        public Builder setUri(String string2) {
            this.uri = Uri.parse((String)string2);
            return this;
        }

        public Builder setUriPositionOffset(long l2) {
            this.uriPositionOffset = l2;
            return this;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HttpMethod {
    }
}

