/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.ui.DefaultTrackNameProvider;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TrackNameProvider;
import com.google.android.exoplayer2.ui._$$Lambda$TrackSelectionView$KrnfNB5IAmqGW_gPl4yQT3OirQ8;
import com.google.android.exoplayer2.util.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class TrackSelectionView
extends LinearLayout {
    private boolean allowAdaptiveSelections;
    private boolean allowMultipleOverrides;
    private final ComponentListener componentListener;
    private final CheckedTextView defaultView;
    private final CheckedTextView disableView;
    private final LayoutInflater inflater;
    private boolean isDisabled;
    private TrackSelectionListener listener;
    private MappingTrackSelector.MappedTrackInfo mappedTrackInfo;
    private final SparseArray<DefaultTrackSelector.SelectionOverride> overrides;
    private int rendererIndex;
    private final int selectableItemBackgroundResourceId;
    private TrackGroupArray trackGroups;
    private Comparator<TrackInfo> trackInfoComparator;
    private TrackNameProvider trackNameProvider;
    private CheckedTextView[][] trackViews;

    public TrackSelectionView(Context context) {
        this(context, null);
    }

    public TrackSelectionView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TrackSelectionView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.setOrientation(1);
        this.overrides = new SparseArray();
        this.setSaveFromParentEnabled(false);
        attributeSet = context.getTheme().obtainStyledAttributes(new int[]{16843534});
        this.selectableItemBackgroundResourceId = attributeSet.getResourceId(0, 0);
        attributeSet.recycle();
        this.inflater = LayoutInflater.from((Context)context);
        this.componentListener = new ComponentListener();
        this.trackNameProvider = new DefaultTrackNameProvider(this.getResources());
        this.trackGroups = TrackGroupArray.EMPTY;
        this.disableView = (CheckedTextView)this.inflater.inflate(17367055, (ViewGroup)this, false);
        this.disableView.setBackgroundResource(this.selectableItemBackgroundResourceId);
        this.disableView.setText(R.string.exo_track_selection_none);
        this.disableView.setEnabled(false);
        this.disableView.setFocusable(true);
        this.disableView.setOnClickListener((View.OnClickListener)this.componentListener);
        this.disableView.setVisibility(8);
        this.addView((View)this.disableView);
        this.addView(this.inflater.inflate(R.layout.exo_list_divider, (ViewGroup)this, false));
        this.defaultView = (CheckedTextView)this.inflater.inflate(17367055, (ViewGroup)this, false);
        this.defaultView.setBackgroundResource(this.selectableItemBackgroundResourceId);
        this.defaultView.setText(R.string.exo_track_selection_auto);
        this.defaultView.setEnabled(false);
        this.defaultView.setFocusable(true);
        this.defaultView.setOnClickListener((View.OnClickListener)this.componentListener);
        this.addView((View)this.defaultView);
    }

    private static int[] getTracksAdding(int[] nArray, int n2) {
        nArray = Arrays.copyOf(nArray, nArray.length + 1);
        nArray[nArray.length - 1] = n2;
        return nArray;
    }

    private static int[] getTracksRemoving(int[] nArray, int n2) {
        int[] nArray2 = new int[nArray.length - 1];
        int n3 = nArray.length;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = nArray[i2];
            int n6 = n4;
            if (n5 != n2) {
                nArray2[n4] = n5;
                n6 = n4 + 1;
            }
            n4 = n6;
        }
        return nArray2;
    }

    static /* synthetic */ int lambda$init$0(Comparator comparator, TrackInfo trackInfo, TrackInfo trackInfo2) {
        return comparator.compare(trackInfo.format, trackInfo2.format);
    }

    private void onClick(View object) {
        if (object == this.disableView) {
            this.onDisableViewClicked();
        } else if (object == this.defaultView) {
            this.onDefaultViewClicked();
        } else {
            this.onTrackViewClicked((View)object);
        }
        this.updateViewStates();
        object = this.listener;
        if (object != null) {
            object.onTrackSelectionChanged(this.getIsDisabled(), this.getOverrides());
        }
    }

    private void onDefaultViewClicked() {
        this.isDisabled = false;
        this.overrides.clear();
    }

    private void onDisableViewClicked() {
        this.isDisabled = true;
        this.overrides.clear();
    }

    private void onTrackViewClicked(View object) {
        this.isDisabled = false;
        Object object2 = (TrackInfo)Assertions.checkNotNull(object.getTag());
        int n2 = ((TrackInfo)object2).groupIndex;
        int n3 = ((TrackInfo)object2).trackIndex;
        object2 = (DefaultTrackSelector.SelectionOverride)this.overrides.get(n2);
        Assertions.checkNotNull(this.mappedTrackInfo);
        if (object2 == null) {
            if (!this.allowMultipleOverrides && this.overrides.size() > 0) {
                this.overrides.clear();
            }
            this.overrides.put(n2, (Object)new DefaultTrackSelector.SelectionOverride(n2, n3));
        } else {
            int n4 = ((DefaultTrackSelector.SelectionOverride)object2).length;
            object2 = ((DefaultTrackSelector.SelectionOverride)object2).tracks;
            boolean bl = ((CheckedTextView)object).isChecked();
            boolean bl2 = this.shouldEnableAdaptiveSelection(n2);
            boolean bl3 = bl2 || this.shouldEnableMultiGroupSelection();
            if (bl && bl3) {
                if (n4 == 1) {
                    this.overrides.remove(n2);
                } else {
                    object = TrackSelectionView.getTracksRemoving((int[])object2, n3);
                    this.overrides.put(n2, (Object)new DefaultTrackSelector.SelectionOverride(n2, (int[])object));
                }
            } else if (!bl) {
                if (bl2) {
                    object = TrackSelectionView.getTracksAdding((int[])object2, n3);
                    this.overrides.put(n2, (Object)new DefaultTrackSelector.SelectionOverride(n2, (int[])object));
                } else {
                    this.overrides.put(n2, (Object)new DefaultTrackSelector.SelectionOverride(n2, n3));
                }
            }
        }
    }

    @RequiresNonNull(value={"mappedTrackInfo"})
    private boolean shouldEnableAdaptiveSelection(int n2) {
        boolean bl = this.allowAdaptiveSelections;
        boolean bl2 = true;
        if (!bl || this.trackGroups.get((int)n2).length <= 1 || this.mappedTrackInfo.getAdaptiveSupport(this.rendererIndex, n2, false) == 0) {
            bl2 = false;
        }
        return bl2;
    }

    private boolean shouldEnableMultiGroupSelection() {
        boolean bl = this.allowMultipleOverrides;
        boolean bl2 = true;
        if (!bl || this.trackGroups.length <= 1) {
            bl2 = false;
        }
        return bl2;
    }

    private void updateViewStates() {
        this.disableView.setChecked(this.isDisabled);
        Object object = this.defaultView;
        boolean bl = !this.isDisabled && this.overrides.size() == 0;
        object.setChecked(bl);
        for (int i2 = 0; i2 < this.trackViews.length; ++i2) {
            Object object2;
            object = (DefaultTrackSelector.SelectionOverride)this.overrides.get(i2);
            for (int i3 = 0; i3 < (object2 = this.trackViews)[i2].length; ++i3) {
                if (object != null) {
                    object2 = (TrackInfo)Assertions.checkNotNull(object2[i2][i3].getTag());
                    this.trackViews[i2][i3].setChecked(((DefaultTrackSelector.SelectionOverride)object).containsTrack(object2.trackIndex));
                    continue;
                }
                object2[i2][i3].setChecked(false);
            }
        }
    }

    private void updateViews() {
        int n2;
        for (n2 = this.getChildCount() - 1; n2 >= 3; --n2) {
            this.removeViewAt(n2);
        }
        if (this.mappedTrackInfo == null) {
            this.disableView.setEnabled(false);
            this.defaultView.setEnabled(false);
            return;
        }
        this.disableView.setEnabled(true);
        this.defaultView.setEnabled(true);
        this.trackGroups = this.mappedTrackInfo.getTrackGroups(this.rendererIndex);
        this.trackViews = new CheckedTextView[this.trackGroups.length][];
        boolean bl = this.shouldEnableMultiGroupSelection();
        for (n2 = 0; n2 < this.trackGroups.length; ++n2) {
            int n3;
            Object object = this.trackGroups.get(n2);
            boolean bl2 = this.shouldEnableAdaptiveSelection(n2);
            this.trackViews[n2] = new CheckedTextView[object.length];
            TrackInfo[] trackInfoArray = new TrackInfo[object.length];
            for (n3 = 0; n3 < object.length; ++n3) {
                trackInfoArray[n3] = new TrackInfo(n2, n3, object.getFormat(n3));
            }
            object = this.trackInfoComparator;
            if (object != null) {
                Arrays.sort(trackInfoArray, object);
            }
            for (n3 = 0; n3 < trackInfoArray.length; ++n3) {
                if (n3 == 0) {
                    this.addView(this.inflater.inflate(R.layout.exo_list_divider, (ViewGroup)this, false));
                }
                int n4 = !bl2 && !bl ? 17367055 : 0x1090010;
                object = (CheckedTextView)this.inflater.inflate(n4, (ViewGroup)this, false);
                object.setBackgroundResource(this.selectableItemBackgroundResourceId);
                object.setText((CharSequence)this.trackNameProvider.getTrackName(trackInfoArray[n3].format));
                object.setTag((Object)trackInfoArray[n3]);
                if (this.mappedTrackInfo.getTrackSupport(this.rendererIndex, n2, n3) == 4) {
                    object.setFocusable(true);
                    object.setOnClickListener((View.OnClickListener)this.componentListener);
                } else {
                    object.setFocusable(false);
                    object.setEnabled(false);
                }
                this.trackViews[n2][n3] = object;
                this.addView((View)object);
            }
        }
        this.updateViewStates();
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    public List<DefaultTrackSelector.SelectionOverride> getOverrides() {
        ArrayList<DefaultTrackSelector.SelectionOverride> arrayList = new ArrayList<DefaultTrackSelector.SelectionOverride>(this.overrides.size());
        for (int i2 = 0; i2 < this.overrides.size(); ++i2) {
            arrayList.add((DefaultTrackSelector.SelectionOverride)this.overrides.valueAt(i2));
        }
        return arrayList;
    }

    public void init(MappingTrackSelector.MappedTrackInfo object, int n2, boolean bl, List<DefaultTrackSelector.SelectionOverride> list, Comparator<Format> comparator, TrackSelectionListener trackSelectionListener) {
        this.mappedTrackInfo = object;
        this.rendererIndex = n2;
        this.isDisabled = bl;
        object = comparator == null ? null : new _$$Lambda$TrackSelectionView$KrnfNB5IAmqGW_gPl4yQT3OirQ8(comparator);
        this.trackInfoComparator = object;
        this.listener = trackSelectionListener;
        n2 = this.allowMultipleOverrides ? list.size() : Math.min(list.size(), 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            object = list.get(i2);
            this.overrides.put(object.groupIndex, object);
        }
        this.updateViews();
    }

    protected void onMeasure(int n2, int n3) {
        if (!true) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        super.onMeasure(n2, n3);
    }

    public void setAllowAdaptiveSelections(boolean bl) {
        if (this.allowAdaptiveSelections != bl) {
            this.allowAdaptiveSelections = bl;
            this.updateViews();
        }
    }

    public void setAllowMultipleOverrides(boolean bl) {
        if (this.allowMultipleOverrides != bl) {
            this.allowMultipleOverrides = bl;
            if (!bl && this.overrides.size() > 1) {
                for (int i2 = this.overrides.size() - 1; i2 > 0; --i2) {
                    this.overrides.remove(i2);
                }
            }
            this.updateViews();
        }
    }

    public void setShowDisableOption(boolean bl) {
        CheckedTextView checkedTextView = this.disableView;
        int n2 = bl ? 0 : 8;
        checkedTextView.setVisibility(n2);
    }

    public void setTrackNameProvider(TrackNameProvider trackNameProvider) {
        this.trackNameProvider = Assertions.checkNotNull(trackNameProvider);
        this.updateViews();
    }

    private class ComponentListener
    implements View.OnClickListener {
        private ComponentListener() {
        }

        public void onClick(View view) {
            TrackSelectionView.this.onClick(view);
        }
    }

    private static final class TrackInfo {
        public final Format format;
        public final int groupIndex;
        public final int trackIndex;

        public TrackInfo(int n2, int n3, Format format) {
            this.groupIndex = n2;
            this.trackIndex = n3;
            this.format = format;
        }
    }

    public static interface TrackSelectionListener {
        public void onTrackSelectionChanged(boolean var1, List<DefaultTrackSelector.SelectionOverride> var2);
    }
}

