/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.content.res.Resources;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.RelativeSizeSpan;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.accessibility.CaptioningManager;
import android.widget.FrameLayout;
import com.google.android.exoplayer2.text.CaptionStyleCompat;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.ui.CanvasSubtitleOutput;
import com.google.android.exoplayer2.ui.WebViewSubtitleOutput;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SubtitleView
extends FrameLayout
implements TextOutput {
    public static final float DEFAULT_BOTTOM_PADDING_FRACTION = 0.08f;
    public static final float DEFAULT_TEXT_SIZE_FRACTION = 0.0533f;
    public static final int VIEW_TYPE_CANVAS = 1;
    public static final int VIEW_TYPE_WEB = 2;
    private boolean applyEmbeddedFontSizes = true;
    private boolean applyEmbeddedStyles = true;
    private float bottomPaddingFraction = 0.08f;
    private List<Cue> cues = Collections.emptyList();
    private float defaultTextSize = 0.0533f;
    private int defaultTextSizeType = 0;
    private View innerSubtitleView;
    private Output output;
    private CaptionStyleCompat style = CaptionStyleCompat.DEFAULT;
    private int viewType;

    public SubtitleView(Context context) {
        this(context, null);
    }

    public SubtitleView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        context = new CanvasSubtitleOutput(context, attributeSet);
        this.output = context;
        this.innerSubtitleView = context;
        this.addView(this.innerSubtitleView);
        this.viewType = 1;
    }

    private List<Cue> getCuesWithStylingPreferencesApplied() {
        if (this.applyEmbeddedStyles && this.applyEmbeddedFontSizes) {
            return this.cues;
        }
        ArrayList<Cue> arrayList = new ArrayList<Cue>(this.cues.size());
        for (int i2 = 0; i2 < this.cues.size(); ++i2) {
            arrayList.add(this.removeEmbeddedStyling(this.cues.get(i2)));
        }
        return arrayList;
    }

    private float getUserCaptionFontScale() {
        float f2;
        int n2 = Util.SDK_INT;
        float f3 = f2 = 1.0f;
        if (n2 >= 19) {
            if (this.isInEditMode()) {
                f3 = f2;
            } else {
                CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
                f3 = f2;
                if (captioningManager != null) {
                    f3 = f2;
                    if (captioningManager.isEnabled()) {
                        f3 = captioningManager.getFontScale();
                    }
                }
            }
        }
        return f3;
    }

    private CaptionStyleCompat getUserCaptionStyle() {
        if (Util.SDK_INT >= 19 && !this.isInEditMode()) {
            Object object = (CaptioningManager)this.getContext().getSystemService("captioning");
            object = object != null && object.isEnabled() ? CaptionStyleCompat.createFromCaptionStyle(object.getUserStyle()) : CaptionStyleCompat.DEFAULT;
            return object;
        }
        return CaptionStyleCompat.DEFAULT;
    }

    private Cue removeEmbeddedStyling(Cue object) {
        AbsoluteSizeSpan[] absoluteSizeSpanArray = ((Cue)object).text;
        if (!this.applyEmbeddedStyles) {
            object = ((Cue)object).buildUpon().setTextSize(-3.4028235E38f, Integer.MIN_VALUE).clearWindowColor();
            if (absoluteSizeSpanArray != null) {
                ((Cue.Builder)object).setText(absoluteSizeSpanArray.toString());
            }
            return ((Cue.Builder)object).build();
        }
        Cue cue = object;
        if (!this.applyEmbeddedFontSizes) {
            if (absoluteSizeSpanArray == null) {
                return object;
            }
            object = ((Cue)object).buildUpon().setTextSize(-3.4028235E38f, Integer.MIN_VALUE);
            if (absoluteSizeSpanArray instanceof Spanned) {
                cue = SpannableString.valueOf((CharSequence)absoluteSizeSpanArray);
                int n2 = cue.length();
                int n3 = 0;
                absoluteSizeSpanArray = (AbsoluteSizeSpan[])cue.getSpans(0, n2, AbsoluteSizeSpan.class);
                int n4 = absoluteSizeSpanArray.length;
                for (n2 = 0; n2 < n4; ++n2) {
                    cue.removeSpan(absoluteSizeSpanArray[n2]);
                }
                absoluteSizeSpanArray = (RelativeSizeSpan[])cue.getSpans(0, cue.length(), RelativeSizeSpan.class);
                n4 = absoluteSizeSpanArray.length;
                for (n2 = n3; n2 < n4; ++n2) {
                    cue.removeSpan(absoluteSizeSpanArray[n2]);
                }
                ((Cue.Builder)object).setText((CharSequence)((Object)cue));
            }
            cue = ((Cue.Builder)object).build();
        }
        return cue;
    }

    private void setTextSize(int n2, float f2) {
        this.defaultTextSizeType = n2;
        this.defaultTextSize = f2;
        this.updateOutput();
    }

    private <T extends View> void setView(T t2) {
        this.removeView(this.innerSubtitleView);
        View view = this.innerSubtitleView;
        if (view instanceof WebViewSubtitleOutput) {
            ((WebViewSubtitleOutput)view).destroy();
        }
        this.innerSubtitleView = t2;
        this.output = (Output)t2;
        this.addView(t2);
    }

    private void updateOutput() {
        this.output.update(this.getCuesWithStylingPreferencesApplied(), this.style, this.defaultTextSize, this.defaultTextSizeType, this.bottomPaddingFraction);
    }

    public void onCues(List<Cue> list) {
        this.setCues(list);
    }

    protected void onMeasure(int n2, int n3) {
        if (!true) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        super.onMeasure(n2, n3);
    }

    public void setApplyEmbeddedFontSizes(boolean bl) {
        this.applyEmbeddedFontSizes = bl;
        this.updateOutput();
    }

    public void setApplyEmbeddedStyles(boolean bl) {
        this.applyEmbeddedStyles = bl;
        this.updateOutput();
    }

    public void setBottomPaddingFraction(float f2) {
        this.bottomPaddingFraction = f2;
        this.updateOutput();
    }

    public void setCues(List<Cue> list) {
        if (list == null) {
            list = Collections.emptyList();
        }
        this.cues = list;
        this.updateOutput();
    }

    public void setFixedTextSize(int n2, float f2) {
        Context context = this.getContext();
        context = context == null ? Resources.getSystem() : context.getResources();
        this.setTextSize(2, TypedValue.applyDimension((int)n2, (float)f2, (DisplayMetrics)context.getDisplayMetrics()));
    }

    public void setFractionalTextSize(float f2) {
        this.setFractionalTextSize(f2, false);
    }

    public void setFractionalTextSize(float f2, boolean bl) {
        this.setTextSize(bl ? 1 : 0, f2);
    }

    public void setStyle(CaptionStyleCompat captionStyleCompat) {
        this.style = captionStyleCompat;
        this.updateOutput();
    }

    public void setUserDefaultStyle() {
        this.setStyle(this.getUserCaptionStyle());
    }

    public void setUserDefaultTextSize() {
        this.setFractionalTextSize(this.getUserCaptionFontScale() * 0.0533f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setViewType(int n2) {
        if (this.viewType == n2) {
            return;
        }
        if (n2 != 1) {
            if (n2 != 2) throw new IllegalArgumentException();
            this.setView(new WebViewSubtitleOutput(this.getContext()));
        } else {
            this.setView(new CanvasSubtitleOutput(this.getContext()));
        }
        this.viewType = n2;
    }

    static interface Output {
        public void update(List<Cue> var1, CaptionStyleCompat var2, float var3, int var4, float var5);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ViewType {
    }
}

