/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import com.google.android.exoplayer2.text.CaptionStyleCompat;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class SubtitlePainter {
    private static final float INNER_PADDING_RATIO = 0.125f;
    private static final String TAG = "SubtitlePainter";
    private int backgroundColor;
    private final Paint bitmapPaint;
    private Rect bitmapRect;
    private float bottomPaddingFraction;
    private Bitmap cueBitmap;
    private float cueBitmapHeight;
    private float cueLine;
    private int cueLineAnchor;
    private int cueLineType;
    private float cuePosition;
    private int cuePositionAnchor;
    private float cueSize;
    private CharSequence cueText;
    private Layout.Alignment cueTextAlignment;
    private float cueTextSizePx;
    private float defaultTextSizePx;
    private int edgeColor;
    private StaticLayout edgeLayout;
    private int edgeType;
    private int foregroundColor;
    private final float outlineWidth;
    private int parentBottom;
    private int parentLeft;
    private int parentRight;
    private int parentTop;
    private final float shadowOffset;
    private final float shadowRadius;
    private final float spacingAdd;
    private final float spacingMult;
    private StaticLayout textLayout;
    private int textLeft;
    private int textPaddingX;
    private final TextPaint textPaint;
    private int textTop;
    private int windowColor;
    private final Paint windowPaint;

    public SubtitlePainter(Context context) {
        float f2;
        TypedArray typedArray = context.obtainStyledAttributes(null, new int[]{16843287, 16843288}, 0, 0);
        this.spacingAdd = typedArray.getDimensionPixelSize(0, 0);
        this.spacingMult = typedArray.getFloat(1, 1.0f);
        typedArray.recycle();
        this.outlineWidth = f2 = (float)Math.round((float)context.getResources().getDisplayMetrics().densityDpi * 2.0f / 160.0f);
        this.shadowRadius = f2;
        this.shadowOffset = f2;
        this.textPaint = new TextPaint();
        this.textPaint.setAntiAlias(true);
        this.textPaint.setSubpixelText(true);
        this.windowPaint = new Paint();
        this.windowPaint.setAntiAlias(true);
        this.windowPaint.setStyle(Paint.Style.FILL);
        this.bitmapPaint = new Paint();
        this.bitmapPaint.setAntiAlias(true);
        this.bitmapPaint.setFilterBitmap(true);
    }

    private static boolean areCharSequencesEqual(CharSequence charSequence, CharSequence charSequence2) {
        boolean bl = charSequence == charSequence2 || charSequence != null && charSequence.equals(charSequence2);
        return bl;
    }

    @RequiresNonNull(value={"cueBitmap", "bitmapRect"})
    private void drawBitmapLayout(Canvas canvas) {
        canvas.drawBitmap(this.cueBitmap, null, this.bitmapRect, this.bitmapPaint);
    }

    private void drawLayout(Canvas canvas, boolean bl) {
        if (bl) {
            this.drawTextLayout(canvas);
        } else {
            Assertions.checkNotNull(this.bitmapRect);
            Assertions.checkNotNull(this.cueBitmap);
            this.drawBitmapLayout(canvas);
        }
    }

    private void drawTextLayout(Canvas canvas) {
        StaticLayout staticLayout = this.textLayout;
        StaticLayout staticLayout2 = this.edgeLayout;
        if (staticLayout != null && staticLayout2 != null) {
            int n2 = canvas.save();
            canvas.translate((float)this.textLeft, (float)this.textTop);
            if (Color.alpha((int)this.windowColor) > 0) {
                this.windowPaint.setColor(this.windowColor);
                canvas.drawRect((float)(-this.textPaddingX), 0.0f, (float)(staticLayout.getWidth() + this.textPaddingX), (float)staticLayout.getHeight(), this.windowPaint);
            }
            int n3 = this.edgeType;
            boolean bl = true;
            if (n3 == 1) {
                this.textPaint.setStrokeJoin(Paint.Join.ROUND);
                this.textPaint.setStrokeWidth(this.outlineWidth);
                this.textPaint.setColor(this.edgeColor);
                this.textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
                staticLayout2.draw(canvas);
            } else if (n3 == 2) {
                TextPaint textPaint = this.textPaint;
                float f2 = this.shadowRadius;
                float f3 = this.shadowOffset;
                textPaint.setShadowLayer(f2, f3, f3, this.edgeColor);
            } else if (n3 == 3 || n3 == 4) {
                if (this.edgeType != 3) {
                    bl = false;
                }
                int n4 = -1;
                n3 = bl ? -1 : this.edgeColor;
                if (bl) {
                    n4 = this.edgeColor;
                }
                float f4 = this.shadowRadius / 2.0f;
                this.textPaint.setColor(this.foregroundColor);
                this.textPaint.setStyle(Paint.Style.FILL);
                TextPaint textPaint = this.textPaint;
                float f5 = this.shadowRadius;
                float f6 = -f4;
                textPaint.setShadowLayer(f5, f6, f6, n3);
                staticLayout2.draw(canvas);
                this.textPaint.setShadowLayer(this.shadowRadius, f4, f4, n4);
            }
            this.textPaint.setColor(this.foregroundColor);
            this.textPaint.setStyle(Paint.Style.FILL);
            staticLayout.draw(canvas);
            this.textPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            canvas.restoreToCount(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequiresNonNull(value={"cueBitmap"})
    private void setupBitmapLayout() {
        float f2;
        int n2;
        int n3;
        int n4;
        int n5;
        block9: {
            float f3;
            block8: {
                block7: {
                    block6: {
                        float f4;
                        block5: {
                            block4: {
                                Bitmap bitmap = this.cueBitmap;
                                n5 = this.parentRight;
                                n4 = this.parentLeft;
                                n3 = this.parentBottom;
                                n2 = this.parentTop;
                                f2 = n4;
                                float f5 = n5 - n4;
                                f4 = f2 + this.cuePosition * f5;
                                f3 = n2;
                                f2 = n3 - n2;
                                f3 += this.cueLine * f2;
                                n2 = Math.round(f5 * this.cueSize);
                                f5 = this.cueBitmapHeight;
                                n5 = f5 != -3.4028235E38f ? Math.round(f2 * f5) : Math.round((float)n2 * ((float)bitmap.getHeight() / (float)bitmap.getWidth()));
                                n3 = this.cuePositionAnchor;
                                if (n3 != 2) break block4;
                                f2 = n2;
                                break block5;
                            }
                            f2 = f4;
                            if (n3 != 1) break block6;
                            f2 = n2 / 2;
                        }
                        f2 = f4 - f2;
                    }
                    n3 = Math.round(f2);
                    n4 = this.cueLineAnchor;
                    if (n4 != 2) break block7;
                    f2 = n5;
                    break block8;
                }
                f2 = f3;
                if (n4 != 1) break block9;
                f2 = n5 / 2;
            }
            f2 = f3 - f2;
        }
        n4 = Math.round(f2);
        this.bitmapRect = new Rect(n3, n4, n2 + n3, n5 + n4);
    }

    /*
     * Unable to fully structure code
     */
    @RequiresNonNull(value={"cueText"})
    private void setupTextLayout() {
        block25: {
            block24: {
                block20: {
                    block23: {
                        block22: {
                            block21: {
                                var1_1 = this.cueText;
                                var1_1 = var1_1 instanceof SpannableStringBuilder != false ? (SpannableStringBuilder)var1_1 : new SpannableStringBuilder(var1_1);
                                var2_2 = this.parentRight - this.parentLeft;
                                var3_3 = this.parentBottom - this.parentTop;
                                this.textPaint.setTextSize(this.defaultTextSizePx);
                                var4_4 = (int)(this.defaultTextSizePx * 0.125f + 0.5f);
                                var5_5 = var4_4 * 2;
                                var6_6 = var2_2 - var5_5;
                                var7_7 = this.cueSize;
                                var8_8 = var6_6;
                                if (var7_7 != -3.4028235E38f) {
                                    var8_8 = (int)((float)var6_6 * var7_7);
                                }
                                if ((var6_6 = var8_8) <= 0) {
                                    Log.w("SubtitlePainter", "Skipped drawing subtitle cue (insufficient space)");
                                    return;
                                }
                                var7_7 = this.cueTextSizePx;
                                if (var7_7 > 0.0f) {
                                    var1_1.setSpan(new AbsoluteSizeSpan((int)var7_7), 0, var1_1.length(), 0xFF0000);
                                }
                                var9_9 = new SpannableStringBuilder(var1_1);
                                if (this.edgeType == 1) {
                                    var10_10 = (Layout.Alignment)var9_9.getSpans(0, var9_9.length(), ForegroundColorSpan.class);
                                    var11_11 = ((Layout.Alignment)var10_10).length;
                                    for (var8_8 = 0; var8_8 < var11_11; ++var8_8) {
                                        var9_9.removeSpan((Object)var10_10[var8_8]);
                                    }
                                }
                                if (Color.alpha((int)this.backgroundColor) > 0) {
                                    var8_8 = this.edgeType;
                                    if (var8_8 != 0 && var8_8 != 2) {
                                        var9_9.setSpan((Object)new BackgroundColorSpan(this.backgroundColor), 0, var9_9.length(), 0xFF0000);
                                    } else {
                                        var1_1.setSpan(new BackgroundColorSpan(this.backgroundColor), 0, var1_1.length(), 0xFF0000);
                                    }
                                }
                                var10_10 = var12_12 = this.cueTextAlignment;
                                if (var12_12 == null) {
                                    var10_10 = Layout.Alignment.ALIGN_CENTER;
                                }
                                this.textLayout = new StaticLayout(var1_1, this.textPaint, var6_6, var10_10, this.spacingMult, this.spacingAdd, true);
                                var13_13 = this.textLayout.getHeight();
                                var14_14 = this.textLayout.getLineCount();
                                var8_8 = 0;
                                for (var11_11 = 0; var11_11 < var14_14; ++var11_11) {
                                    var8_8 = Math.max((int)Math.ceil(this.textLayout.getLineWidth(var11_11)), var8_8);
                                }
                                if (this.cueSize != -3.4028235E38f && var8_8 < var6_6) {
                                    var8_8 = var6_6;
                                }
                                var6_6 = var8_8 + var5_5;
                                var7_7 = this.cuePosition;
                                if (var7_7 != -3.4028235E38f) {
                                    var8_8 = Math.round((float)var2_2 * var7_7) + this.parentLeft;
                                    var11_11 = this.cuePositionAnchor;
                                    if (var11_11 != 1) {
                                        if (var11_11 == 2) {
                                            var8_8 -= var6_6;
                                        }
                                    } else {
                                        var8_8 = (var8_8 * 2 - var6_6) / 2;
                                    }
                                    var11_11 = Math.max(var8_8, this.parentLeft);
                                    var8_8 = Math.min(var6_6 + var11_11, this.parentRight);
                                } else {
                                    var11_11 = (var2_2 - var6_6) / 2 + this.parentLeft;
                                    var8_8 = var11_11 + var6_6;
                                }
                                var2_2 = var8_8 - var11_11;
                                if (var2_2 <= 0) {
                                    Log.w("SubtitlePainter", "Skipped drawing subtitle cue (invalid horizontal positioning)");
                                    return;
                                }
                                var7_7 = this.cueLine;
                                if (var7_7 == -3.4028235E38f) break block20;
                                if (this.cueLineType != 0) break block21;
                                var6_6 = Math.round((float)var3_3 * var7_7) + this.parentTop;
                                var3_3 = this.cueLineAnchor;
                                if (var3_3 == 2) ** GOTO lbl80
                                var8_8 = var6_6;
                                if (var3_3 == 1) {
                                    var8_8 = (var6_6 * 2 - var13_13) / 2;
                                }
                                break block22;
                            }
                            var8_8 = this.textLayout.getLineBottom(0) - this.textLayout.getLineTop(0);
                            var7_7 = this.cueLine;
                            if (var7_7 >= 0.0f) {
                                var8_8 = Math.round(var7_7 * (float)var8_8) + this.parentTop;
                            } else {
                                var6_6 = Math.round((var7_7 + 1.0f) * (float)var8_8) + this.parentBottom;
lbl80:
                                // 2 sources

                                var8_8 = var6_6 - var13_13;
                            }
                        }
                        if (var8_8 + var13_13 <= (var6_6 = this.parentBottom)) break block23;
                        var6_6 -= var13_13;
                        break block24;
                    }
                    var13_13 = this.parentTop;
                    var6_6 = var8_8;
                    if (var8_8 >= var13_13) break block24;
                    var8_8 = var13_13;
                    break block25;
                }
                var6_6 = this.parentBottom - var13_13 - (int)((float)var3_3 * this.bottomPaddingFraction);
            }
            var8_8 = var6_6;
        }
        this.textLayout = new StaticLayout(var1_1, this.textPaint, var2_2, var10_10, this.spacingMult, this.spacingAdd, true);
        this.edgeLayout = new StaticLayout((CharSequence)var9_9, this.textPaint, var2_2, var10_10, this.spacingMult, this.spacingAdd, true);
        this.textLeft = var11_11;
        this.textTop = var8_8;
        this.textPaddingX = var4_4;
    }

    public void draw(Cue cue, CaptionStyleCompat captionStyleCompat, float f2, float f3, float f4, Canvas canvas, int n2, int n3, int n4, int n5) {
        boolean bl = cue.bitmap == null;
        int n6 = -16777216;
        if (bl) {
            if (TextUtils.isEmpty((CharSequence)cue.text)) {
                return;
            }
            n6 = cue.windowColorSet ? cue.windowColor : captionStyleCompat.windowColor;
        }
        if (SubtitlePainter.areCharSequencesEqual(this.cueText, cue.text) && Util.areEqual(this.cueTextAlignment, cue.textAlignment) && this.cueBitmap == cue.bitmap && this.cueLine == cue.line && this.cueLineType == cue.lineType && Util.areEqual(this.cueLineAnchor, cue.lineAnchor) && this.cuePosition == cue.position && Util.areEqual(this.cuePositionAnchor, cue.positionAnchor) && this.cueSize == cue.size && this.cueBitmapHeight == cue.bitmapHeight && this.foregroundColor == captionStyleCompat.foregroundColor && this.backgroundColor == captionStyleCompat.backgroundColor && this.windowColor == n6 && this.edgeType == captionStyleCompat.edgeType && this.edgeColor == captionStyleCompat.edgeColor && Util.areEqual(this.textPaint.getTypeface(), captionStyleCompat.typeface) && this.defaultTextSizePx == f2 && this.cueTextSizePx == f3 && this.bottomPaddingFraction == f4 && this.parentLeft == n2 && this.parentTop == n3 && this.parentRight == n4 && this.parentBottom == n5) {
            this.drawLayout(canvas, bl);
            return;
        }
        this.cueText = cue.text;
        this.cueTextAlignment = cue.textAlignment;
        this.cueBitmap = cue.bitmap;
        this.cueLine = cue.line;
        this.cueLineType = cue.lineType;
        this.cueLineAnchor = cue.lineAnchor;
        this.cuePosition = cue.position;
        this.cuePositionAnchor = cue.positionAnchor;
        this.cueSize = cue.size;
        this.cueBitmapHeight = cue.bitmapHeight;
        this.foregroundColor = captionStyleCompat.foregroundColor;
        this.backgroundColor = captionStyleCompat.backgroundColor;
        this.windowColor = n6;
        this.edgeType = captionStyleCompat.edgeType;
        this.edgeColor = captionStyleCompat.edgeColor;
        this.textPaint.setTypeface(captionStyleCompat.typeface);
        this.defaultTextSizePx = f2;
        this.cueTextSizePx = f3;
        this.bottomPaddingFraction = f4;
        this.parentLeft = n2;
        this.parentTop = n3;
        this.parentRight = n4;
        this.parentBottom = n5;
        if (bl) {
            Assertions.checkNotNull(this.cueText);
            this.setupTextLayout();
        } else {
            Assertions.checkNotNull(this.cueBitmap);
            this.setupBitmapLayout();
        }
        this.drawLayout(canvas, bl);
    }
}

